DROP TABLE account_category;

CREATE TABLE `account_category` (
  `account_cat_id` int(10) NOT NULL AUTO_INCREMENT,
  `account_cat_name` varchar(100) NOT NULL,
  `account_cat_desc` varchar(100) NOT NULL,
  `account_category_code` varchar(100) NOT NULL,
  `account_category_bal_type` varchar(100) NOT NULL,
  PRIMARY KEY (`account_cat_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO account_category VALUES("1","FIXED ASSET","","102000","D");
INSERT INTO account_category VALUES("2","CURRENT ASSET","","101000","D");
INSERT INTO account_category VALUES("3","LIABILITY","","200000","C");
INSERT INTO account_category VALUES("4","OWNERS EQUITY","","300000","C");
INSERT INTO account_category VALUES("6","EXPENSES","","500000","D");
INSERT INTO account_category VALUES("7","INCOME","","400000","C");



DROP TABLE account_opening_balances;

CREATE TABLE `account_opening_balances` (
  `opening_balance_id` int(10) NOT NULL AUTO_INCREMENT,
  `date_recorded` date NOT NULL,
  `account_id` int(10) NOT NULL,
  `comments` longtext NOT NULL,
  `amount` varchar(100) NOT NULL,
  `datetime_recorded` datetime NOT NULL,
  `status` int(10) NOT NULL,
  `recorded_by` int(10) NOT NULL,
  `acc_action` varchar(10) NOT NULL,
  `financial_year_id` int(11) NOT NULL,
  PRIMARY KEY (`opening_balance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE account_type;

CREATE TABLE `account_type` (
  `account_type_id` int(10) NOT NULL AUTO_INCREMENT,
  `pre_main_account_cat_id` int(11) NOT NULL,
  `main_account_cat_id` int(100) NOT NULL,
  `account_cat_id` int(10) NOT NULL,
  `account_type_name` varchar(100) NOT NULL,
  `account_type_desc` varchar(100) NOT NULL,
  `account_code` varchar(20) NOT NULL,
  `account_uniq_code` varchar(100) NOT NULL,
  `sub_account_code` varchar(50) NOT NULL,
  `main_account_code` varchar(50) NOT NULL,
  `balance_type` varchar(5) NOT NULL,
  PRIMARY KEY (`account_type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;

INSERT INTO account_type VALUES("1","1","2","2","Benki","","101101","1","1","101100","D");
INSERT INTO account_type VALUES("4","10","11","1","Mali za Chama","","102201","1","1","102200","D");
INSERT INTO account_type VALUES("6","11","42","3","Hisa","","104101","1","1","104100","C");
INSERT INTO account_type VALUES("15","5","26","7","Riba Za Mikopo - Maendeleo","","201101","1","1","201100","C");
INSERT INTO account_type VALUES("16","5","26","7","Riba Za Mikopo - Dharura","","201102","2","2","201100","C");
INSERT INTO account_type VALUES("17","1","40","2","CASH","","101154","4","4","101150","D");
INSERT INTO account_type VALUES("18","1","2","2","CRDB BANK","","101105","5","5","101100","D");
INSERT INTO account_type VALUES("19","1","2","2","NMB","","101106","6","6","101100","D");
INSERT INTO account_type VALUES("21","6","36","6","Transport on city","","301602","2","2","301600","D");
INSERT INTO account_type VALUES("22","6","36","6","Salary","","301603","3","3","301600","D");
INSERT INTO account_type VALUES("23","6","36","6","NSSF exp","","301607","7","7","301600","D");
INSERT INTO account_type VALUES("25","6","36","6","Water and Electricity","","301601","1","1","301600","D");
INSERT INTO account_type VALUES("26","5","27","7","Processing fee","","201967","767","767","201200","C");
INSERT INTO account_type VALUES("27","5","27","7","Penalty","","299434","98234","98234","201200","C");



DROP TABLE account_type_copy;

CREATE TABLE `account_type_copy` (
  `account_type_id` int(10) NOT NULL AUTO_INCREMENT,
  `pre_main_account_cat_id` int(11) NOT NULL,
  `main_account_cat_id` int(100) NOT NULL,
  `account_cat_id` int(10) NOT NULL,
  `account_type_name` varchar(100) NOT NULL,
  `account_type_desc` varchar(100) NOT NULL,
  `account_code` varchar(20) NOT NULL,
  `account_uniq_code` varchar(100) NOT NULL,
  `sub_account_code` varchar(50) NOT NULL,
  `main_account_code` varchar(50) NOT NULL,
  `balance_type` varchar(5) NOT NULL,
  PRIMARY KEY (`account_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE account_type_old;

CREATE TABLE `account_type_old` (
  `account_type_id` int(10) NOT NULL AUTO_INCREMENT,
  `account_cat_id` int(10) NOT NULL,
  `account_type_name` varchar(100) NOT NULL,
  `account_type_desc` varchar(100) NOT NULL,
  `account_code` varchar(20) NOT NULL,
  `balance_type` varchar(5) NOT NULL,
  PRIMARY KEY (`account_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE applied_loans;

CREATE TABLE `applied_loans` (
  `applied_loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_ref_no` varchar(200) NOT NULL,
  `member_id` int(100) NOT NULL,
  `group_id` int(11) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `date_applied` date NOT NULL,
  `loan_type_id` int(10) NOT NULL,
  `loan_product_id` int(11) NOT NULL,
  `amount_applied` varchar(50) NOT NULL,
  `cash_collateral_amount` varchar(100) NOT NULL,
  `cash_collateral_perc` varchar(100) NOT NULL,
  `interest_rate` varchar(50) NOT NULL,
  `loan_intr_mode` varchar(2) NOT NULL,
  `interest_rate_per_schedule` varchar(11) NOT NULL,
  `interest_amount` varchar(100) NOT NULL,
  `interest_amount_per_schedule` varchar(100) NOT NULL,
  `ttl_interest_amount` varchar(100) NOT NULL,
  `repay_interest_installment` varchar(100) NOT NULL,
  `repay_principle_installment` varchar(100) NOT NULL,
  `app_prnc_mor_period` varchar(10) NOT NULL,
  `app_intr_mor_period` varchar(10) NOT NULL,
  `amount_approved` varchar(10) NOT NULL,
  `repay_amount` varchar(100) NOT NULL,
  `guarantor1` int(11) NOT NULL,
  `guarantor2` int(11) NOT NULL,
  `guarantor3` int(11) NOT NULL,
  `procc_mode` varchar(20) NOT NULL,
  `procc_type` varchar(20) NOT NULL,
  `procc_rate` varchar(100) NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `ttl_proc_fees` varchar(100) NOT NULL,
  `ins_mode` varchar(50) NOT NULL,
  `insurance_rate` varchar(50) NOT NULL,
  `ins_type` varchar(50) NOT NULL,
  `insurance_amount` varchar(50) NOT NULL,
  `ttl_insurance` varchar(50) NOT NULL,
  `loan_security_fund_rate` varchar(50) NOT NULL,
  `loan_security_fund_amount` varchar(50) NOT NULL,
  `penalty_rate` varchar(50) NOT NULL,
  `calc_mode` varchar(10) NOT NULL,
  `repayment_schedule` varchar(100) NOT NULL,
  `repayment_period` int(15) NOT NULL,
  `repay_date` varchar(100) NOT NULL,
  `repay_day` varchar(100) NOT NULL,
  `grace_period` int(11) NOT NULL,
  `start_repayment_date` date NOT NULL,
  `end_repayment_date` date NOT NULL,
  `date_recorded` datetime NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(10) NOT NULL DEFAULT '1000000',
  `date_approved` date NOT NULL,
  `datetime_approved` datetime NOT NULL,
  `approval_reason` longtext NOT NULL,
  `verify_status` int(11) NOT NULL,
  `verify_by` int(11) NOT NULL,
  `verify_date` date NOT NULL,
  `datetime_verified` datetime NOT NULL,
  `verify_comments` varchar(300) NOT NULL,
  `paid_status` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `amount_paid` varchar(100) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `paid_reason` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  `api_ConversationID` varchar(400) NOT NULL,
  `loan_officer_id` int(11) NOT NULL,
  `officer_perc_comm` varchar(100) NOT NULL,
  `comm_amnt` varchar(100) NOT NULL,
  `memorandum_loan` varchar(5) NOT NULL,
  `memorandum_tranch_amount` varchar(100) NOT NULL,
  `memorandum_total_amount` varchar(100) NOT NULL,
  `top_up_loan_id` int(11) NOT NULL,
  `top_up_id` int(11) NOT NULL,
  `reschedule_id` int(11) NOT NULL,
  `reschedule_loan_id` int(11) NOT NULL,
  `loan_account_credited` int(11) NOT NULL,
  `loan_account_debited` int(11) NOT NULL,
  PRIMARY KEY (`applied_loan_id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;

INSERT INTO applied_loans VALUES("1","DVLP-INVST01","12","0","","2024-10-02","1","0","300000","0","","1","M","1","3000","3000","36000","3000","25000","","","300000","336000","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-10-31","2025-09-26","2024-10-02 11:39:01","100","1","100","2024-10-02","0000-00-00 00:00:00","","1","1","2024-10-02","0000-00-00 00:00:00","","1","2024-10-02","300000","17","0000-00-00 00:00:00","100","","7","123","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("2","DVLP-INVST02","22","0","","2024-09-30","1","0","9000000","0","","1","M","1","90000","90000","2160000","90000","375000","","","9000000","11160000","0","0","0","","","","","","","","","","","","0","","R","Monthly","24","","","0","2024-10-31","2026-09-21","2024-10-02 11:46:22","100","1","100","2024-09-30","0000-00-00 00:00:00","","1","1","2024-09-30","0000-00-00 00:00:00","","1","2024-09-30","9000000","17","0000-00-00 00:00:00","100","","7","123","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("3","DVLP-INVST03","27","0","","2024-09-30","1","0","665000","0","","12","M","12","79800","79800","957600","79800","55416.666666667","","","665000","1622600","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-10-31","2025-09-26","2024-10-02 11:48:37","100","1","100","2024-09-30","0000-00-00 00:00:00","","1","1","2024-09-30","0000-00-00 00:00:00","","1","2024-09-30","665000","17","0000-00-00 00:00:00","100","","7","123","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("4","DVLP-INVST04","29","0","","2024-09-30","1","0","600000","0","","12","M","12","72000","72000","864000","72000","50000","","","600000","1464000","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-10-31","2025-09-26","2024-10-02 11:50:26","100","1","100","2024-09-30","0000-00-00 00:00:00","","1","1","2024-09-30","0000-00-00 00:00:00","","1","2024-09-30","600000","17","0000-00-00 00:00:00","100","","7","123","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("5","DVLP-LN5","31","0","","2024-09-30","1","0","133000","0","","12","M","12","15960","15960","191520","15960","11083.333333333","","","133000","324520","0","0","0","","","","","","","","","","","","","","R","Monthly","12","","","0","2024-10-30","2025-09-25","2024-10-02 11:53:11","100","1","100","2024-09-30","2024-10-02 11:54:28","approved","1","100","2024-09-30","2024-10-02 11:53:45","verified","1","2024-09-30","133000.00","17","2024-10-02 11:56:34","100","","7","123","0","","","","0","0","0","0","","0","","0","","","0","0","0","0","0","0","0");
INSERT INTO applied_loans VALUES("6","DVLP-INVST06","3","0","","2024-09-03","1","0","60000","0","","1","M","1","600","600","7200","600","5000","","","60000","67200","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-10-02","2025-08-28","2024-10-02 12:03:34","100","1","100","2024-09-03","0000-00-00 00:00:00","","1","1","2024-09-03","0000-00-00 00:00:00","","1","2024-09-03","60000","2","0000-00-00 00:00:00","100","","9","54454","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","2","2");
INSERT INTO applied_loans VALUES("7","DVLP-INVST07","1","0","","2024-09-06","1","0","5000000","0","","1","M","1","50000","50000","600000","50000","416666.66666667","","","5000000","5600000","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-10-02","2025-08-28","2024-10-02 12:03:48","100","1","100","2024-09-06","0000-00-00 00:00:00","","1","1","2024-09-06","0000-00-00 00:00:00","","1","2024-09-06","5000000","17","0000-00-00 00:00:00","100","","7","12356","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("8","DVLP-INVST08","6","0","","2024-09-27","1","0","400000","0","","1","M","1","4000","4000","48000","4000","33333.333333333","","","400000","448000","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-11-02","2025-09-28","2024-10-02 12:09:58","100","1","100","2024-09-27","0000-00-00 00:00:00","","1","1","2024-09-27","0000-00-00 00:00:00","","1","2024-09-27","400000","17","0000-00-00 00:00:00","100","","7","7654","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("9","MWD-INVST09","8","0","","2024-09-27","3","0","200000","0","","1","M","1","2000","2000","12000","2000","33333.333333333","","","200000","212000","0","0","0","","","","","","","","","","","","0","","R","Monthly","6","","","0","2024-10-30","2025-03-29","2024-10-02 12:12:30","100","1","100","2024-09-27","0000-00-00 00:00:00","","1","1","2024-09-27","0000-00-00 00:00:00","","1","2024-09-27","200000","17","0000-00-00 00:00:00","100","","7","34345","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("10","DVLP-INVST10","13","0","","2024-09-27","1","0","7000000","0","","1","M","1","70000","70000","2520000","70000","194444.44444444","","","7000000","9520000","0","0","0","","","","","","","","","","","","0","","R","Monthly","36","","","0","2024-10-30","2027-09-15","2024-10-02 12:14:08","100","1","100","2024-09-27","0000-00-00 00:00:00","","1","1","2024-09-27","0000-00-00 00:00:00","","1","2024-09-27","7000000","17","0000-00-00 00:00:00","100","","7","454545","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("11","DVLP-INVST11","18","0","","2024-09-27","1","0","400000","0","","1","M","1","4000","4000","48000","4000","33333.333333333","","","400000","448000","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-10-30","2025-09-25","2024-10-02 12:15:41","100","1","100","2024-09-27","0000-00-00 00:00:00","","1","1","2024-09-27","0000-00-00 00:00:00","","1","2024-09-27","400000","17","0000-00-00 00:00:00","100","","9","7654","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("12","DVLP-INVST12","7","0","","2024-09-02","1","0","15000000","0","","1","M","1","150000","150000","7200000","150000","312500","","","15000000","22200000","0","0","0","","","","","","","","","","","","0","","R","Monthly","48","","","0","2024-09-30","2028-08-10","2024-10-02 12:17:10","100","1","100","2024-09-02","0000-00-00 00:00:00","","1","1","2024-09-02","0000-00-00 00:00:00","","1","2024-09-02","15000000","18","0000-00-00 00:00:00","100","","3","45678","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","18","2");
INSERT INTO applied_loans VALUES("13","DVLP-INVST13","5","0","","2024-09-02","1","0","10000000","0","","1","M","1","100000","100000","3600000","100000","277777.77777778","","","10000000","13600000","0","0","0","","","","","","","","","","","","0","","R","Monthly","36","","","0","2024-09-30","2027-08-16","2024-10-02 12:17:11","100","1","100","2024-09-02","0000-00-00 00:00:00","","1","1","2024-09-02","0000-00-00 00:00:00","","1","2024-09-02","10000000","18","0000-00-00 00:00:00","100","","3","000036","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","18","2");
INSERT INTO applied_loans VALUES("14","DVLP-INVST14","16","0","","2024-09-02","1","0","1000000","0","","1","M","1","10000","10000","120000","10000","83333.333333333","","","1000000","1120000","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-09-30","2025-08-26","2024-10-02 12:20:01","100","1","100","2024-09-02","0000-00-00 00:00:00","","1","1","2024-09-02","0000-00-00 00:00:00","","1","2024-09-02","1000000","18","0000-00-00 00:00:00","100","","3","3456789","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","18","2");
INSERT INTO applied_loans VALUES("15","DVLP-INVST15","19","0","","2024-09-02","1","0","5000000","0","","1","M","1","50000","50000","600000","50000","416666.66666667","","","5000000","5600000","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-10-31","2025-09-26","2024-10-02 12:21:39","100","1","100","2024-09-02","0000-00-00 00:00:00","","1","1","2024-09-02","0000-00-00 00:00:00","","1","2024-09-02","5000000","18","0000-00-00 00:00:00","100","","7","456789","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","18","2");
INSERT INTO applied_loans VALUES("16","DVLP-INVST16","21","0","","2024-09-02","1","0","700000","0","","1","M","1","7000","7000","42000","7000","116666.66666667","","","700000","742000","0","0","0","","","","","","","","","","","","0","","R","Monthly","6","","","0","2024-09-30","2025-02-27","2024-10-02 12:22:27","100","1","100","2024-09-02","0000-00-00 00:00:00","","1","1","2024-09-02","0000-00-00 00:00:00","","1","2024-09-02","700000","18","0000-00-00 00:00:00","100","","3","345678","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","18","2");
INSERT INTO applied_loans VALUES("17","DVLP-INVST17","20","0","","2024-09-02","1","0","2000000","0","","1","M","1","20000","20000","240000","20000","166666.66666667","","","2000000","2240000","0","0","0","","","","","","","","","","","","0","","R","Monthly","12","","","0","2024-09-30","2025-08-26","2024-10-02 12:25:23","100","1","100","2024-09-02","0000-00-00 00:00:00","","1","1","2024-09-02","0000-00-00 00:00:00","","1","2024-09-02","2000000","18","0000-00-00 00:00:00","100","","3","78904","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","18","2");
INSERT INTO applied_loans VALUES("18","MWD-LN18","26","0","","2024-09-02","3","0","500000","0","","1","M","1","5000","5000","15000","5000","166666.66666667","","","500000","515000","0","0","0","","","","","","","","","","","","0","","R","Monthly","3","","","0","2024-10-02","2024-12-01","2024-10-02 12:25:49","100","1","100","2024-09-02","2024-10-02 13:15:55","approved","1","100","2024-09-02","2024-10-02 13:13:20","verified","1","2024-09-02","300000.00","17","2024-10-02 13:18:58","100","","7","222","0","","","","0","0","0","0","","0","","0","","","0","0","0","0","0","0","0");
INSERT INTO applied_loans VALUES("19","DVLP-INVST19","25","0","","2024-09-02","1","0","5000000","0","","1","M","1","50000","50000","1200000","50000","208333.33333333","","","5000000","6200000","0","0","0","","","","","","","","","","","","0","","R","Monthly","24","","","0","2024-09-30","2026-08-21","2024-10-02 12:27:28","100","1","100","2024-09-02","0000-00-00 00:00:00","","1","1","2024-09-02","0000-00-00 00:00:00","","1","2024-09-02","5000000","18","0000-00-00 00:00:00","100","","3","87346788","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","18","2");
INSERT INTO applied_loans VALUES("20","DVLP-LN20","13","0","","2025-02-17","1","0","1000000","","","1","M","1","10000","10000","120000","10000","83333.333333333","","","1000000","1120000","0","0","0","","","","","0","","","","","","","","","R","Monthly","12","","","0","2025-03-19","2026-02-12","2025-02-17 15:39:01","100","1","100","2025-02-17","2025-02-17 15:40:22","Approved","1","100","2025-02-17","2025-02-17 15:39:59","Verified","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","0","0","0","0","0","0","0");
INSERT INTO applied_loans VALUES("21","DVLP-LN21","24","0","","2025-02-17","1","0","400000","","","1","M","1","4000","4000","48000","4000","33333.333333333","","","400000","448000","0","0","0","","","","","0","","","","","","","","","R","Monthly","12","","","0","2025-03-19","2026-02-12","2025-02-17 15:51:19","100","0","1000000","0000-00-00","0000-00-00 00:00:00","","0","100","2025-02-17","2025-02-17 15:52:32","Verified","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","0","0","0","0","0","0","0");
INSERT INTO applied_loans VALUES("22","4557-LN22","10","0","","2025-02-19","4","0","1500000","0","","3.5","Y","0.072916666","52500","2187.5","56875","2187.5","57692.307692308","","","1500000","1556875","0","0","0","","","","","","","","","","","","","","R","Weekly","26","","","0","2025-03-21","2025-09-12","2025-02-19 13:37:45","100","1","100","2025-02-19","2025-02-19 13:38:50","Approved","1","100","2025-02-19","2025-02-19 13:38:30","Verified","1","2025-02-19","1500000.00","17","2025-02-19 13:39:39","100","","7","5111111","0","","","","0","0","0","0","","0","","0","","","0","0","0","0","0","0","0");
INSERT INTO applied_loans VALUES("23","4557-INVST23","30","0","","2025-02-19","4","0","1500000","0","","42","Y","0.875","630000","26250","682500","26250","57692.307692308","","","1500000","2182500","0","0","0","","","","","","","","","","","","0","","R","Weekly","26","","","0","2025-02-19","2025-08-13","2025-02-19 13:42:15","100","1","100","2025-02-19","0000-00-00 00:00:00","","1","1","2025-02-19","0000-00-00 00:00:00","","1","2025-02-19","1500000","17","0000-00-00 00:00:00","100","","7","89777654","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("24","4557-INVST24","10","0","","2025-02-19","4","0","1500000","0","","42","Y","3.5","630000","52500","315000","52500","250000","","","1500000","1815000","0","0","0","","","","","","","","","","","","0","","R","Monthly","6","","","0","2025-02-19","2025-07-19","2025-02-19 13:44:32","100","1","100","2025-02-19","0000-00-00 00:00:00","","1","1","2025-02-19","0000-00-00 00:00:00","","1","2025-02-19","1500000","17","0000-00-00 00:00:00","100","","7","TR4445","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("25","4557-INVST25","10","0","","2025-02-19","4","0","1500000","0","","42","Y","0.875","630000","26250","682500","26250","57692.307692308","","","1500000","2182500","0","0","0","","","","","","","","","","","","0","","R","Weekly","26","","","0","2025-02-19","2025-08-13","2025-02-19 13:49:49","100","1","100","2025-02-19","0000-00-00 00:00:00","","1","1","2025-02-19","0000-00-00 00:00:00","","1","2025-02-19","1500000","17","0000-00-00 00:00:00","100","","7","3634544","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("26","786-INVST26","15","0","","2024-12-02","5","0","1500000","0","","42","Y","3.5","630000","52500","315000","52500","250000","","","1500000","1815000","0","0","0","","","","","","","","","","","","0","","R","Monthly","6","","","0","2025-01-02","2025-06-01","2025-02-19 14:21:43","100","1","100","2024-12-02","0000-00-00 00:00:00","","1","1","2024-12-02","0000-00-00 00:00:00","","1","2024-12-02","1500000","17","0000-00-00 00:00:00","100","","7","nm6","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("27","564324-INVST27","5","0","","2024-10-01","6","0","1500000","0","","3.5","M","3.5","52500","52500","315000","52500","250000","","","1500000","1815000","0","0","0","","","","","","","","","","","","0","","R","Monthly","6","","","0","2024-11-01","2025-03-31","2025-02-24 16:23:33","100","1","100","2024-10-01","0000-00-00 00:00:00","","1","1","2024-10-01","0000-00-00 00:00:00","","1","2024-10-01","1500000","19","0000-00-00 00:00:00","100","","9","67tyf","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","19","2");
INSERT INTO applied_loans VALUES("28","564324-LN28","29","0","","2024-09-01","6","0","1500000","0","","3.5","M","3.5","52500","52500","315000","52500","250000","","","1500000","1815000","0","0","0","","","","","","","","","","","","","","R","Monthly","6","","","0","2024-10-02","2025-03-01","2025-02-24 16:30:43","100","1","100","2024-09-01","2025-02-24 16:33:18","Approved","1","100","2024-09-01","2025-02-24 16:31:13","Verified","1","2024-09-02","1350000.00","19","2025-02-24 16:35:07","100","","9","PV068","0","","","","0","0","0","0","","0","","0","","","0","0","0","0","0","0","0");
INSERT INTO applied_loans VALUES("29","564324-LN29","10","0","","2024-02-29","6","0","1500000","0","","42","Y","3.5","630000","52500","315000","52500","250000","","","1500000","1815000","0","0","0","","","","","","","","","","","","","","R","Monthly","6","","","0","2024-03-31","2024-08-28","2025-02-28 15:41:35","100","1","100","2024-02-29","2025-02-28 15:47:42","Approved","1","100","2024-02-29","2025-02-28 15:45:08","Verified","1","2024-03-01","1350000.00","19","2025-02-28 15:49:04","100","","9","ghtde34","0","","","","0","0","0","0","","0","","0","","","0","0","0","0","0","0","0");
INSERT INTO applied_loans VALUES("30","786-LN30","4","0","","2024-03-03","5","0","1500000","","","42","Y","3.5","630000","52500","315000","52500","250000","","","1500000","1815000","0","0","0","","","","","","","","","","","","","","R","Monthly","6","","","0","1970-01-01","1970-05-31","2025-03-03 14:36:40","100","0","1000000","0000-00-00","0000-00-00 00:00:00","","1","100","2024-03-03","2025-03-18 17:44:11","verfied","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","146","","","","","0","0","0","0","0","0","0");
INSERT INTO applied_loans VALUES("31","TY6-LN31","33","0","","2025-01-01","7","0","1500000","0","","42","Y","3.5","630000","52500","315000","52500","250000","","","1500000","1815000","0","0","0","","","","","","","","","","","","","","R","Monthly","6","","","0","2025-02-01","2025-07-01","2025-03-09 12:08:00","100","1","100","2025-01-01","2025-03-09 12:34:51","approved","1","100","2025-01-01","2025-03-09 12:23:27","verfied","1","2025-01-02","1350000.00","17","2025-03-09 12:36:17","100","","7","899898s","0","","","","0","0","0","0","","0","","0","","","0","0","0","0","0","0","0");
INSERT INTO applied_loans VALUES("32","DVLP-INVST32","18","0","","2025-03-17","1","0","1000000","0","","1","M","1","10000","10000","60000","10000","166666.66666667","","","1000000","1060000","0","0","0","","","","","","","","","","","","0","","R","Monthly","6","","","0","2025-03-24","2025-08-21","2025-03-17 20:59:45","100","1","100","2025-03-17","0000-00-00 00:00:00","","1","1","2025-03-17","0000-00-00 00:00:00","","1","2025-03-17","1000000","17","0000-00-00 00:00:00","100","","7","4356op","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","17","2");
INSERT INTO applied_loans VALUES("33","DVLP-INVST33","1","0","","2025-03-01","1","0","1000000","0","","1","M","1","10000","10000","60000","10000","166666.66666667","","","1000000","1060000","0","0","0","","","","","","","","","","","","0","","S","Monthly","6","","","0","2025-03-31","2025-08-28","2025-03-31 05:42:46","100","1","100","2025-03-01","0000-00-00 00:00:00","","1","1","2025-03-01","0000-00-00 00:00:00","","1","2025-03-01","1000000","19","0000-00-00 00:00:00","100","","7","uiui78","0","","","","0","0","0","0","","0","","","","","","0","0","0","0","19","2");



DROP TABLE applied_loans2;

CREATE TABLE `applied_loans2` (
  `applied_loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `date_applied` date NOT NULL,
  `loan_type_id` int(10) NOT NULL,
  `amount_applied` varchar(50) NOT NULL,
  `cash_collateral_amount` varchar(100) NOT NULL,
  `cash_collateral_perc` varchar(100) NOT NULL,
  `interest_rate` varchar(50) NOT NULL,
  `interest_amount` varchar(100) NOT NULL,
  `repay_interest_installment` varchar(100) NOT NULL,
  `repay_principle_installment` varchar(100) NOT NULL,
  `amount_approved` varchar(10) NOT NULL,
  `repay_amount` varchar(100) NOT NULL,
  `guarantor1` int(11) NOT NULL,
  `guarantor2` int(11) NOT NULL,
  `guarantor3` int(11) NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `repayment_schedule` varchar(100) NOT NULL,
  `repayment_period` varchar(15) NOT NULL,
  `repay_date` varchar(100) NOT NULL,
  `repay_day` varchar(100) NOT NULL,
  `grace_period` int(11) NOT NULL,
  `start_repayment_date` date NOT NULL,
  `end_repayment_date` date NOT NULL,
  `date_recorded` datetime NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(10) NOT NULL DEFAULT '1000000',
  `date_approved` date NOT NULL,
  `approval_reason` longtext NOT NULL,
  `paid_status` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `amount_paid` varchar(100) NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `paid_reason` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  PRIMARY KEY (`applied_loan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE applied_loans_old;

CREATE TABLE `applied_loans_old` (
  `applied_loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_ref_no` varchar(200) NOT NULL,
  `member_id` int(100) NOT NULL,
  `group_id` int(11) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `date_applied` date NOT NULL,
  `loan_type_id` int(10) NOT NULL,
  `loan_product_id` int(11) NOT NULL,
  `amount_applied` varchar(50) NOT NULL,
  `cash_collateral_amount` varchar(100) NOT NULL,
  `cash_collateral_perc` varchar(100) NOT NULL,
  `interest_rate` varchar(50) NOT NULL,
  `interest_rate_per_schedule` varchar(11) NOT NULL,
  `interest_amount` varchar(100) NOT NULL,
  `interest_amount_per_schedule` varchar(100) NOT NULL,
  `ttl_interest_amount` varchar(100) NOT NULL,
  `repay_interest_installment` varchar(100) NOT NULL,
  `repay_principle_installment` varchar(100) NOT NULL,
  `amount_approved` varchar(10) NOT NULL,
  `repay_amount` varchar(100) NOT NULL,
  `guarantor1` int(11) NOT NULL,
  `guarantor2` int(11) NOT NULL,
  `guarantor3` int(11) NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `ttl_proc_fees` varchar(100) NOT NULL,
  `repayment_schedule` varchar(100) NOT NULL,
  `repayment_period` int(15) NOT NULL,
  `repay_date` varchar(100) NOT NULL,
  `repay_day` varchar(100) NOT NULL,
  `grace_period` int(11) NOT NULL,
  `start_repayment_date` date NOT NULL,
  `end_repayment_date` date NOT NULL,
  `date_recorded` datetime NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(10) NOT NULL DEFAULT '1000000',
  `date_approved` date NOT NULL,
  `approval_reason` longtext NOT NULL,
  `paid_status` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `amount_paid` varchar(100) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `paid_reason` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  `api_ConversationID` varchar(400) NOT NULL,
  PRIMARY KEY (`applied_loan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE approved_expense_requisition;

CREATE TABLE `approved_expense_requisition` (
  `approved_expense_id` int(10) NOT NULL AUTO_INCREMENT,
  `expense_requisition_id` int(11) NOT NULL,
  `date_approved` date NOT NULL,
  `approve_user_id` int(11) NOT NULL,
  `approve_description` longtext NOT NULL,
  `amount_approved` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `approval_status` int(11) NOT NULL DEFAULT '1',
  `type` varchar(1) NOT NULL,
  `status2` int(11) NOT NULL,
  PRIMARY KEY (`approved_expense_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE approved_fund_requisition;

CREATE TABLE `approved_fund_requisition` (
  `approved_fund_id` int(10) NOT NULL AUTO_INCREMENT,
  `fund_requisition_id` int(11) NOT NULL,
  `date_approved` date NOT NULL,
  `approve_user_id` int(11) NOT NULL,
  `description` longtext NOT NULL,
  `amount_approved` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `approval_status` int(11) NOT NULL DEFAULT '1',
  `type` varchar(1) NOT NULL,
  `status2` int(11) NOT NULL,
  PRIMARY KEY (`approved_fund_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE audit_trails;

CREATE TABLE `audit_trails` (
  `audit_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `date_of_event` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `action` longtext NOT NULL,
  `sub_module_id` int(11) NOT NULL,
  PRIMARY KEY (`audit_id`)
) ENGINE=MyISAM AUTO_INCREMENT=273 DEFAULT CHARSET=latin1;

INSERT INTO audit_trails VALUES("1","100","2024-10-02 14:07:00","Logged out of the system","135");
INSERT INTO audit_trails VALUES("2","100","2024-10-02 14:10:15","Logged into the system","135");
INSERT INTO audit_trails VALUES("3","100","2024-10-02 14:10:40","Logged into the system","135");
INSERT INTO audit_trails VALUES("4","100","2024-10-02 14:12:23","Registered Customer PROSPER JOSEPH SAKU into the system","79");
INSERT INTO audit_trails VALUES("5","100","2024-10-02 14:13:21","Registered Customer CHRISTINA  ASAA KIMARO  into the system","79");
INSERT INTO audit_trails VALUES("6","100","2024-10-02 14:13:53","Registered Customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("7","100","2024-10-02 14:14:14","Update photo details for customer PROSPER JOSEPH SAKU","79");
INSERT INTO audit_trails VALUES("8","100","2024-10-02 14:14:54","Update photo details for customer ALLY  SALIM MRUTU","79");
INSERT INTO audit_trails VALUES("9","100","2024-10-02 14:15:11","Update photo details for customer PROSPER JOSEPH SAKU","79");
INSERT INTO audit_trails VALUES("10","100","2024-10-02 14:15:11","Update photo details for customer ALLY  SALIM MRUTU","79");
INSERT INTO audit_trails VALUES("11","100","2024-10-02 14:15:42","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("12","100","2024-10-02 14:15:54","Registered Customer JESCA CHARLES THOMAS into the system","79");
INSERT INTO audit_trails VALUES("13","100","2024-10-02 14:15:57","Registered Customer NOLLO TIMOTH TIMOTH into the system","79");
INSERT INTO audit_trails VALUES("14","100","2024-10-02 14:16:25","Logged into the system","135");
INSERT INTO audit_trails VALUES("15","100","2024-10-02 14:17:12","Registered Customer DERICK KIBU DENIS into the system","79");
INSERT INTO audit_trails VALUES("16","100","2024-10-02 14:17:35","Update photo details for customer DERICK KIBU DENIS","79");
INSERT INTO audit_trails VALUES("17","100","2024-10-02 14:18:24","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("18","100","2024-10-02 14:18:32","Registered Customer WILLARD OSWALD KISHARU into the system","79");
INSERT INTO audit_trails VALUES("19","100","2024-10-02 14:19:08","Updated details of customer JESCA CHARLES THOMAS into the system","79");
INSERT INTO audit_trails VALUES("20","100","2024-10-02 14:19:34","Registered Customer PIUS KISAKA TOBILAX into the system","79");
INSERT INTO audit_trails VALUES("21","100","2024-10-02 14:19:48","Registered Customer SIKUKUU KIMARO  URASSA into the system","79");
INSERT INTO audit_trails VALUES("22","100","2024-10-02 14:19:52","Update photo details for customer PIUS KISAKA TOBILAX","79");
INSERT INTO audit_trails VALUES("23","100","2024-10-02 14:20:14","Update photo details for customer PROSPER JOSEPH SAKU","79");
INSERT INTO audit_trails VALUES("24","100","2024-10-02 14:20:16","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("25","100","2024-10-02 14:20:34","Registered Customer VICENT KIGOSI GIGANTE into the system","79");
INSERT INTO audit_trails VALUES("26","100","2024-10-02 14:20:40","Update photo details for customer WILLARD OSWALD KISHARU","79");
INSERT INTO audit_trails VALUES("27","100","2024-10-02 14:20:50","Registered Customer PROSPER P MUSHI into the system","79");
INSERT INTO audit_trails VALUES("28","100","2024-10-02 14:21:19","Registered Customer CHRISTINE ROBERT MUSHI into the system","79");
INSERT INTO audit_trails VALUES("29","100","2024-10-02 14:21:27","Update photo details for customer PROSPER P MUSHI","79");
INSERT INTO audit_trails VALUES("30","100","2024-10-02 14:21:29","Registered Customer ROAN KIBU MALIA into the system","79");
INSERT INTO audit_trails VALUES("31","100","2024-10-02 14:21:36","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("32","100","2024-10-02 14:21:52","Registered Customer JOHN  CHARLES THOMAS into the system","79");
INSERT INTO audit_trails VALUES("33","100","2024-10-02 14:21:55","Update photo details for customer ROAN KIBU MALIA","79");
INSERT INTO audit_trails VALUES("34","100","2024-10-02 14:22:17","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("35","100","2024-10-02 14:22:33","Registered Customer DANIEL  P URASSA into the system","79");
INSERT INTO audit_trails VALUES("36","100","2024-10-02 14:22:36","Registered Customer GAUDANCE LAURANCE LICHACHI into the system","79");
INSERT INTO audit_trails VALUES("37","100","2024-10-02 14:22:48","Update photo details for customer PROSPER P MUSHI","79");
INSERT INTO audit_trails VALUES("38","100","2024-10-02 14:23:12","Registered Customer ELIAS NEYMAR JUNIOR into the system","79");
INSERT INTO audit_trails VALUES("39","100","2024-10-02 14:23:36","Registered Customer SABA NAEL KIBU into the system","79");
INSERT INTO audit_trails VALUES("40","100","2024-10-02 14:23:44","Registered Customer JOSEPH M KIMARO  into the system","79");
INSERT INTO audit_trails VALUES("41","100","2024-10-02 14:23:48","Registered Customer SHABANI MALOGO MANENO into the system","79");
INSERT INTO audit_trails VALUES("42","100","2024-10-02 14:24:01","Update photo details for customer SABA NAEL KIBU","79");
INSERT INTO audit_trails VALUES("43","100","2024-10-02 14:24:23","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("44","100","2024-10-02 14:24:48","Registered Customer OMEGA THOMSON SEYONGWE into the system","79");
INSERT INTO audit_trails VALUES("45","100","2024-10-02 14:24:57","Registered Customer JESCA JONAS MALLYA into the system","79");
INSERT INTO audit_trails VALUES("46","100","2024-10-02 14:24:59","Registered Customer KHALID MAX AUCHO into the system","79");
INSERT INTO audit_trails VALUES("47","100","2024-10-02 14:25:05","Registered Customer DEBORAH CHARLES SHAYO into the system","79");
INSERT INTO audit_trails VALUES("48","100","2024-10-02 14:25:59","Registered Customer VICENT  MASAWE MASAWE into the system","79");
INSERT INTO audit_trails VALUES("49","100","2024-10-02 14:26:13","Updated details of customer CHRISTINE ROBERT MUSHI into the system","79");
INSERT INTO audit_trails VALUES("50","100","2024-10-02 14:26:59","Registered Customer ANNETE  CLOUTAS DJUING into the system","79");
INSERT INTO audit_trails VALUES("51","100","2024-10-02 14:26:59","Update photo details for customer PROSPER P MUSHI","79");
INSERT INTO audit_trails VALUES("52","100","2024-10-02 14:28:15","Updated details of customer ANNETE  CLOUTAS DJUING into the system","79");
INSERT INTO audit_trails VALUES("53","100","2024-10-02 14:28:41","Registered Customer NOELLA ERNEST MSUYA into the system","79");
INSERT INTO audit_trails VALUES("54","100","2024-10-02 14:29:25","Update photo details for customer PROSPER P MUSHI","79");
INSERT INTO audit_trails VALUES("55","100","2024-10-02 14:29:27","Registered Customer DIANA ROSE CHARLES SHAYO into the system","79");
INSERT INTO audit_trails VALUES("56","100","2024-10-02 14:30:43","Update photo details for customer PROSPER P MUSHI","79");
INSERT INTO audit_trails VALUES("57","100","2024-10-02 14:31:10","Registered Customer NOREEN ERNEST MSUYA into the system","79");
INSERT INTO audit_trails VALUES("58","100","2024-10-02 14:33:31","Registered Customer EVANCE  CHARLES THOMAS into the system","79");
INSERT INTO audit_trails VALUES("59","100","2024-10-02 14:33:31","Registered Customer DAMAS KIWELU MAUA into the system","79");
INSERT INTO audit_trails VALUES("60","100","2024-10-02 14:34:49","Updated details of customer DAMAS KIWELU MAUA into the system","79");
INSERT INTO audit_trails VALUES("61","100","2024-10-02 14:36:35","Update photo details for customer DAMAS KIWELU MAUA","79");
INSERT INTO audit_trails VALUES("62","100","2024-10-02 14:37:05","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("63","100","2024-10-02 14:37:14","Update photo details for customer PROSPER JOSEPH SAKU","79");
INSERT INTO audit_trails VALUES("64","100","2024-10-02 14:38:48","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("65","100","2024-10-02 14:39:01","Recorded Investment : DEVELOPMENT LOANS, of amount  : 300,000.00, for client : CHRISTINE ROBERT MUSHI. Investment ID : DVLP-INVST01","200");
INSERT INTO audit_trails VALUES("66","100","2024-10-02 14:40:36","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("67","100","2024-10-02 14:46:22","Recorded Investment : DEVELOPMENT LOANS, of amount  : 9,000,000.00, for client : JESCA JONAS MALLYA. Investment ID : DVLP-INVST02","200");
INSERT INTO audit_trails VALUES("68","100","2024-10-02 14:48:37","Recorded Investment : DEVELOPMENT LOANS, of amount  : 665,000.00, for client : NOELLA ERNEST MSUYA. Investment ID : DVLP-INVST03","200");
INSERT INTO audit_trails VALUES("69","100","2024-10-02 14:50:26","Recorded Investment : DEVELOPMENT LOANS, of amount  : 600,000.00, for client : NOREEN ERNEST MSUYA. Investment ID : DVLP-INVST04","200");
INSERT INTO audit_trails VALUES("70","100","2024-10-02 14:51:00","Logged into the system","135");
INSERT INTO audit_trails VALUES("71","100","2024-10-02 14:53:11","Applied loan type : DEVELOPMENT LOANS, of amount  : 133,000.00, for client : DAMAS KIWELU MAUA. Loan ID : DVLP-LN5","112");
INSERT INTO audit_trails VALUES("72","100","2024-10-02 14:53:45","Verified Loan Type : DEVELOPMENT LOANS, of amount  : 133,000.00, for client : DAMAS KIWELU MAUA. Loan ID : DVLP-LN5","177");
INSERT INTO audit_trails VALUES("73","100","2024-10-02 14:54:28","Approved loan type : DEVELOPMENT LOANS, of amount  : 133,000.00, for client : DAMAS KIWELU MAUA. Loan ID : DVLP-LN5","113");
INSERT INTO audit_trails VALUES("74","100","2024-10-02 14:55:50","Logged into the system","135");
INSERT INTO audit_trails VALUES("75","100","2024-10-02 14:56:34","Disbursed loan type : DEVELOPMENT LOANS, of amount  : 133,000.00, for client : DAMAS KIWELU MAUA. Loan ID : DVLP-LN5","114");
INSERT INTO audit_trails VALUES("76","100","2024-10-02 14:58:45","Deleted other receipt","176");
INSERT INTO audit_trails VALUES("77","100","2024-10-02 14:59:09","Deleted other receipt","176");
INSERT INTO audit_trails VALUES("78","100","2024-10-02 15:03:34","Recorded Investment : DEVELOPMENT LOANS, of amount  : 60,000.00, for client : ALLY  SALIM MRUTU. Investment ID : DVLP-INVST06","200");
INSERT INTO audit_trails VALUES("79","100","2024-10-02 15:03:48","Recorded Investment : DEVELOPMENT LOANS, of amount  : 5,000,000.00, for client : PROSPER JOSEPH SAKU. Investment ID : DVLP-INVST07","200");
INSERT INTO audit_trails VALUES("80","100","2024-10-02 15:09:58","Recorded Investment : DEVELOPMENT LOANS, of amount  : 400,000.00, for client : DERICK KIBU DENIS. Investment ID : DVLP-INVST08","200");
INSERT INTO audit_trails VALUES("81","100","2024-10-02 15:12:30","Recorded Investment : MKOPO WA DHARURA, of amount  : 200,000.00, for client : PIUS KISAKA TOBILAX. Investment ID : MWD-INVST09","200");
INSERT INTO audit_trails VALUES("82","100","2024-10-02 15:14:08","Recorded Investment : DEVELOPMENT LOANS, of amount  : 7,000,000.00, for client : ROAN KIBU MALIA. Investment ID : DVLP-INVST10","200");
INSERT INTO audit_trails VALUES("83","100","2024-10-02 15:15:41","Recorded Investment : DEVELOPMENT LOANS, of amount  : 400,000.00, for client : SABA NAEL KIBU. Investment ID : DVLP-INVST11","200");
INSERT INTO audit_trails VALUES("84","100","2024-10-02 15:17:10","Recorded Investment : DEVELOPMENT LOANS, of amount  : 15,000,000.00, for client : WILLARD OSWALD KISHARU. Investment ID : DVLP-INVST12","200");
INSERT INTO audit_trails VALUES("85","100","2024-10-02 15:17:11","Recorded Investment : DEVELOPMENT LOANS, of amount  : 10,000,000.00, for client : NOLLO TIMOTH TIMOTH. Investment ID : DVLP-INVST13","200");
INSERT INTO audit_trails VALUES("86","100","2024-10-02 15:20:01","Recorded Investment : DEVELOPMENT LOANS, of amount  : 1,000,000.00, for client : GAUDANCE LAURANCE LICHACHI. Investment ID : DVLP-INVST14","200");
INSERT INTO audit_trails VALUES("87","100","2024-10-02 15:21:39","Recorded Investment : DEVELOPMENT LOANS, of amount  : 5,000,000.00, for client : JOSEPH M KIMARO . Investment ID : DVLP-INVST15","200");
INSERT INTO audit_trails VALUES("88","100","2024-10-02 15:22:27","Recorded Investment : DEVELOPMENT LOANS, of amount  : 700,000.00, for client : OMEGA THOMSON SEYONGWE. Investment ID : DVLP-INVST16","200");
INSERT INTO audit_trails VALUES("89","100","2024-10-02 15:23:41","Attached Documents to Loan Ref No : DVLP-INVST15","114");
INSERT INTO audit_trails VALUES("90","100","2024-10-02 15:25:23","Recorded Investment : DEVELOPMENT LOANS, of amount  : 2,000,000.00, for client : SHABANI MALOGO MANENO. Investment ID : DVLP-INVST17","200");
INSERT INTO audit_trails VALUES("91","100","2024-10-02 15:25:49","Applied loan type : MKOPO WA DHARURA, of amount  : 500,000.00, for client : ANNETE  CLOUTAS DJUING. Loan ID : MWD-LN18","112");
INSERT INTO audit_trails VALUES("92","100","2024-10-02 15:27:28","Recorded Investment : DEVELOPMENT LOANS, of amount  : 5,000,000.00, for client : VICENT  MASAWE MASAWE. Investment ID : DVLP-INVST19","200");
INSERT INTO audit_trails VALUES("93","100","2024-10-02 16:13:20","Verified Loan Type : MKOPO WA DHARURA, of amount  : 500,000.00, for client : ANNETE  CLOUTAS DJUING. Loan ID : MWD-LN18","177");
INSERT INTO audit_trails VALUES("94","100","2024-10-02 16:15:55","Approved loan type : MKOPO WA DHARURA, of amount  : 500,000.00, for client : ANNETE  CLOUTAS DJUING. Loan ID : MWD-LN18","113");
INSERT INTO audit_trails VALUES("95","100","2024-10-02 16:17:52","Updated the loan approved loan type : MKOPO WA DHARURA, of amount  : 500,000.00, for client : ANNETE  CLOUTAS DJUING. Loan ID : MWD-LN18","113");
INSERT INTO audit_trails VALUES("96","100","2024-10-02 16:18:58","Disbursed loan type : MKOPO WA DHARURA, of amount  : 300,000.00, for client : ANNETE  CLOUTAS DJUING. Loan ID : MWD-LN18","114");
INSERT INTO audit_trails VALUES("97","100","2024-10-03 13:11:17","Logged into the system","135");
INSERT INTO audit_trails VALUES("98","100","2024-10-03 13:25:05","Logged into the system","135");
INSERT INTO audit_trails VALUES("99","100","2024-10-03 13:52:36","Logged into the system","135");
INSERT INTO audit_trails VALUES("100","100","2024-10-03 16:40:26","Logged into the system","135");
INSERT INTO audit_trails VALUES("101","100","2024-10-03 13:41:03","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("102","100","2024-10-03 13:44:04","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("103","100","2024-10-03 17:56:47","Logged into the system","135");
INSERT INTO audit_trails VALUES("104","100","2024-10-03 18:41:48","Logged into the system","135");
INSERT INTO audit_trails VALUES("105","100","2024-10-03 18:43:24","Logged out of the system","135");
INSERT INTO audit_trails VALUES("106","0","2024-10-03 18:43:34","Logged out of the system","135");
INSERT INTO audit_trails VALUES("107","100","2024-10-03 18:46:13","Logged into the system","135");
INSERT INTO audit_trails VALUES("108","100","2024-10-04 15:51:36","Logged into the system","135");
INSERT INTO audit_trails VALUES("109","100","2024-10-06 03:50:28","Logged into the system","135");
INSERT INTO audit_trails VALUES("110","100","2024-10-06 03:52:19","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("111","100","2024-10-06 03:52:43","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("112","100","2024-10-08 02:38:19","Logged into the system","135");
INSERT INTO audit_trails VALUES("113","100","2024-10-08 03:45:39","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("114","100","2024-10-08 16:26:06","Logged into the system","135");
INSERT INTO audit_trails VALUES("115","100","2024-10-10 10:49:40","Logged into the system","135");
INSERT INTO audit_trails VALUES("116","100","2024-11-16 11:47:45","Logged into the system","135");
INSERT INTO audit_trails VALUES("117","100","2024-11-16 16:49:02","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("118","100","2024-11-16 16:55:43","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("119","100","2024-11-17 10:57:16","Logged into the system","135");
INSERT INTO audit_trails VALUES("120","100","2024-11-17 15:00:52","Logged into the system","135");
INSERT INTO audit_trails VALUES("121","100","2024-11-17 12:04:44","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("122","100","2024-11-18 12:11:59","Logged into the system","135");
INSERT INTO audit_trails VALUES("123","100","2024-11-18 12:14:49","Logged into the system","135");
INSERT INTO audit_trails VALUES("124","100","2024-11-18 12:15:08","Logged into the system","135");
INSERT INTO audit_trails VALUES("125","100","2024-11-18 12:46:21","Logged into the system","135");
INSERT INTO audit_trails VALUES("126","100","2024-11-18 12:55:38","Logged into the system","135");
INSERT INTO audit_trails VALUES("127","100","2024-11-18 12:56:17","Logged out of the system","135");
INSERT INTO audit_trails VALUES("128","100","2024-11-18 14:06:31","Logged into the system","135");
INSERT INTO audit_trails VALUES("129","100","2024-11-18 17:27:19","Logged into the system","135");
INSERT INTO audit_trails VALUES("130","100","2024-11-18 17:35:47","Deleted other receipt","176");
INSERT INTO audit_trails VALUES("131","100","2024-11-18 17:36:01","Deleted other receipt","176");
INSERT INTO audit_trails VALUES("132","100","2024-11-19 11:18:42","Logged into the system","135");
INSERT INTO audit_trails VALUES("133","100","2024-11-22 14:55:48","Logged into the system","135");
INSERT INTO audit_trails VALUES("134","100","2024-11-22 15:00:33","Logged out of the system","135");
INSERT INTO audit_trails VALUES("135","100","2024-11-22 15:00:58","Logged into the system","135");
INSERT INTO audit_trails VALUES("136","100","2024-11-25 19:09:18","Logged into the system","135");
INSERT INTO audit_trails VALUES("137","100","2024-11-25 19:16:48","Logged into the system","135");
INSERT INTO audit_trails VALUES("138","100","2024-11-25 19:20:06","Exited Customer : ALLY  SALIM MRUTU from the organization","136");
INSERT INTO audit_trails VALUES("139","100","2024-11-25 19:26:03","Registered Customer HUMPHREY BRUNO MERINYO into the system","136");
INSERT INTO audit_trails VALUES("140","100","2024-12-22 14:32:51","Logged into the system","135");
INSERT INTO audit_trails VALUES("141","100","2024-12-22 14:34:41","Logged out of the system","135");
INSERT INTO audit_trails VALUES("142","100","2024-12-22 14:51:46","Logged into the system","135");
INSERT INTO audit_trails VALUES("143","100","2024-12-31 14:45:41","Logged into the system","135");
INSERT INTO audit_trails VALUES("144","100","2024-12-31 14:55:51","Logged into the system","135");
INSERT INTO audit_trails VALUES("145","100","2024-12-31 14:56:08","Logged into the system","135");
INSERT INTO audit_trails VALUES("146","100","2025-01-03 16:54:05","Logged into the system","135");
INSERT INTO audit_trails VALUES("147","100","2025-01-28 17:35:14","Logged into the system","135");
INSERT INTO audit_trails VALUES("148","100","2025-01-29 02:52:22","Logged into the system","135");
INSERT INTO audit_trails VALUES("149","100","2025-01-30 13:04:50","Logged into the system","135");
INSERT INTO audit_trails VALUES("150","100","2025-02-09 17:35:47","Logged into the system","135");
INSERT INTO audit_trails VALUES("151","100","2025-02-15 23:52:16","Logged into the system","135");
INSERT INTO audit_trails VALUES("152","100","2025-02-17 18:26:36","Logged into the system","135");
INSERT INTO audit_trails VALUES("153","100","2025-02-17 18:39:01","Applied loan type : DEVELOPMENT LOANS, of amount  : 1,000,000.00, for client : ROAN KIBU MALIA. Loan ID : DVLP-LN20","112");
INSERT INTO audit_trails VALUES("154","100","2025-02-17 18:39:59","Verified Loan Type : DEVELOPMENT LOANS, of amount  : 1,000,000.00, for client : ROAN KIBU MALIA. Loan ID : DVLP-LN20","177");
INSERT INTO audit_trails VALUES("155","100","2025-02-17 18:40:22","Approved loan type : DEVELOPMENT LOANS, of amount  : 1,000,000.00, for client : ROAN KIBU MALIA. Loan ID : DVLP-LN20","113");
INSERT INTO audit_trails VALUES("156","100","2025-02-17 18:51:19","Applied loan type : DEVELOPMENT LOANS, of amount  : 400,000.00, for client : DEBORAH CHARLES SHAYO. Loan ID : DVLP-LN21","112");
INSERT INTO audit_trails VALUES("157","100","2025-02-17 18:52:32","Verified Loan Type : DEVELOPMENT LOANS, of amount  : 400,000.00, for client : DEBORAH CHARLES SHAYO. Loan ID : DVLP-LN21","177");
INSERT INTO audit_trails VALUES("158","100","2025-02-19 15:31:34","Logged into the system","135");
INSERT INTO audit_trails VALUES("159","100","2025-02-19 16:37:45","Applied loan type : Jazz Microfinance, of amount  : 1,500,000.00, for client : VICENT KIGOSI GIGANTE. Loan ID : 4557-LN22","112");
INSERT INTO audit_trails VALUES("160","100","2025-02-19 16:38:30","Verified Loan Type : Jazz Microfinance, of amount  : 1,500,000.00, for client : VICENT KIGOSI GIGANTE. Loan ID : 4557-LN22","177");
INSERT INTO audit_trails VALUES("161","100","2025-02-19 16:38:50","Approved loan type : Jazz Microfinance, of amount  : 1,500,000.00, for client : VICENT KIGOSI GIGANTE. Loan ID : 4557-LN22","113");
INSERT INTO audit_trails VALUES("162","100","2025-02-19 16:39:39","Disbursed loan type : Jazz Microfinance, of amount  : 1,500,000.00, for client : VICENT KIGOSI GIGANTE. Loan ID : 4557-LN22","114");
INSERT INTO audit_trails VALUES("163","100","2025-02-19 16:42:15","Recorded Investment : Jazz Microfinance, of amount  : 1,500,000.00, for client : EVANCE  CHARLES THOMAS. Investment ID : 4557-INVST23","200");
INSERT INTO audit_trails VALUES("164","100","2025-02-19 16:44:32","Recorded Investment : Jazz Microfinance, of amount  : 1,500,000.00, for client : VICENT KIGOSI GIGANTE. Investment ID : 4557-INVST24","200");
INSERT INTO audit_trails VALUES("165","100","2025-02-19 16:49:49","Recorded Investment : Jazz Microfinance, of amount  : 1,500,000.00, for client : VICENT KIGOSI GIGANTE. Investment ID : 4557-INVST25","200");
INSERT INTO audit_trails VALUES("166","100","2025-02-19 17:21:43","Recorded Investment : jazz loan, of amount  : 1,500,000.00, for client : DANIEL  P URASSA. Investment ID : 786-INVST26","200");
INSERT INTO audit_trails VALUES("167","100","2025-02-20 11:34:04","Logged into the system","135");
INSERT INTO audit_trails VALUES("168","100","2025-02-24 19:09:24","Logged into the system","135");
INSERT INTO audit_trails VALUES("169","100","2025-02-24 19:23:33","Recorded Investment : foesight loan, of amount  : 1,500,000.00, for client : NOLLO TIMOTH TIMOTH. Investment ID : 564324-INVST27","200");
INSERT INTO audit_trails VALUES("170","100","2025-02-24 19:30:43","Applied loan type : foesight loan, of amount  : 1,500,000.00, for client : NOREEN ERNEST MSUYA. Loan ID : 564324-LN28","112");
INSERT INTO audit_trails VALUES("171","100","2025-02-24 19:31:13","Verified Loan Type : foesight loan, of amount  : 1,500,000.00, for client : NOREEN ERNEST MSUYA. Loan ID : 564324-LN28","177");
INSERT INTO audit_trails VALUES("172","100","2025-02-24 19:33:18","Approved loan type : foesight loan, of amount  : 1,500,000.00, for client : NOREEN ERNEST MSUYA. Loan ID : 564324-LN28","113");
INSERT INTO audit_trails VALUES("173","100","2025-02-24 19:35:07","Disbursed loan type : foesight loan, of amount  : 1,350,000.00, for client : NOREEN ERNEST MSUYA. Loan ID : 564324-LN28","114");
INSERT INTO audit_trails VALUES("174","100","2025-02-28 18:31:56","Logged into the system","135");
INSERT INTO audit_trails VALUES("175","100","2025-02-28 18:41:35","Applied loan type : foresight loan, of amount  : 1,500,000.00, for client : VICENT KIGOSI GIGANTE. Loan ID : 564324-LN29","112");
INSERT INTO audit_trails VALUES("176","100","2025-02-28 18:45:08","Verified Loan Type : foresight loan, of amount  : 1,500,000.00, for client : VICENT KIGOSI GIGANTE. Loan ID : 564324-LN29","177");
INSERT INTO audit_trails VALUES("177","100","2025-02-28 18:47:42","Approved loan type : foresight loan, of amount  : 1,500,000.00, for client : VICENT KIGOSI GIGANTE. Loan ID : 564324-LN29","113");
INSERT INTO audit_trails VALUES("178","100","2025-02-28 18:49:04","Disbursed loan type : foresight loan, of amount  : 1,350,000.00, for client : VICENT KIGOSI GIGANTE. Loan ID : 564324-LN29","114");
INSERT INTO audit_trails VALUES("179","100","2025-03-03 17:23:04","Logged into the system","135");
INSERT INTO audit_trails VALUES("180","100","2025-03-03 17:36:40","Applied loan type : jazz loan, of amount  : 1,500,000.00, for client : JESCA CHARLES THOMAS. Loan ID : 786-LN30","112");
INSERT INTO audit_trails VALUES("181","100","2025-03-03 16:01:23","Logged into the system","135");
INSERT INTO audit_trails VALUES("182","100","2025-03-03 16:10:25","Logged into the system","135");
INSERT INTO audit_trails VALUES("183","100","2025-03-03 16:51:16","Logged out of the system","135");
INSERT INTO audit_trails VALUES("184","100","2025-03-03 16:51:21","Logged into the system","135");
INSERT INTO audit_trails VALUES("185","100","2025-03-07 11:54:57","Logged into the system","135");
INSERT INTO audit_trails VALUES("186","100","2025-03-07 12:49:04","Logged out of the system","135");
INSERT INTO audit_trails VALUES("187","100","2025-03-07 12:49:12","Logged into the system","135");
INSERT INTO audit_trails VALUES("188","100","2025-03-07 13:05:03","Logged out of the system","135");
INSERT INTO audit_trails VALUES("189","100","2025-03-07 13:05:06","Logged into the system","135");
INSERT INTO audit_trails VALUES("190","100","2025-03-07 13:36:45","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("191","100","2025-03-07 13:36:52","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("192","100","2025-03-09 11:45:43","Logged into the system","135");
INSERT INTO audit_trails VALUES("193","100","2025-03-09 11:52:10","Registered Customer LAWIN LEWIN LIWIN into the system","79");
INSERT INTO audit_trails VALUES("194","100","2025-03-09 00:00:00","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("195","100","2025-03-09 00:00:00","Applied loan type : LAWI, of amount  : 1,500,000.00, for client : LAWIN LEWIN LIWIN. Loan ID : TY6-LN31","112");
INSERT INTO audit_trails VALUES("196","100","2025-03-09 12:15:36","Verified Loan Type : LAWI, of amount  : 1,500,000.00, for client : LAWIN LEWIN LIWIN. Loan ID : TY6-LN31","177");
INSERT INTO audit_trails VALUES("197","100","2025-03-09 12:23:27","Verified Loan Type : LAWI, of amount  : 1,500,000.00, for client : LAWIN LEWIN LIWIN. Loan ID : TY6-LN31","177");
INSERT INTO audit_trails VALUES("198","100","2025-03-09 12:34:51","Approved loan type : LAWI, of amount  : 1,500,000.00, for client : LAWIN LEWIN LIWIN. Loan ID : TY6-LN31","113");
INSERT INTO audit_trails VALUES("199","100","2025-03-09 12:36:17","Disbursed loan type : LAWI, of amount  : 1,350,000.00, for client : LAWIN LEWIN LIWIN. Loan ID : TY6-LN31","114");
INSERT INTO audit_trails VALUES("200","100","2025-03-09 16:34:22","Logged into the system","135");
INSERT INTO audit_trails VALUES("201","100","2025-03-09 16:35:36","Logged out of the system","135");
INSERT INTO audit_trails VALUES("202","100","2025-03-09 16:35:40","Logged into the system","135");
INSERT INTO audit_trails VALUES("203","100","2025-03-09 16:36:54","Logged out of the system","135");
INSERT INTO audit_trails VALUES("204","100","2025-03-09 16:37:00","Logged into the system","135");
INSERT INTO audit_trails VALUES("205","100","2025-03-09 16:41:06","Logged out of the system","135");
INSERT INTO audit_trails VALUES("206","100","2025-03-09 16:41:11","Logged into the system","135");
INSERT INTO audit_trails VALUES("207","100","2025-03-09 16:42:59","Logged out of the system","135");
INSERT INTO audit_trails VALUES("208","100","2025-03-09 16:43:06","Logged into the system","135");
INSERT INTO audit_trails VALUES("209","100","2025-03-10 10:00:11","Logged into the system","135");
INSERT INTO audit_trails VALUES("210","100","2025-03-13 11:06:26","Logged into the system","135");
INSERT INTO audit_trails VALUES("211","100","2025-03-13 14:39:14","Logged into the system","135");
INSERT INTO audit_trails VALUES("212","100","2025-03-18 10:49:13","Logged into the system","135");
INSERT INTO audit_trails VALUES("213","100","2025-03-18 10:49:16","Logged into the system","135");
INSERT INTO audit_trails VALUES("214","100","2025-03-18 12:00:46","Registered Customer LULU LULU LULU into the system","79");
INSERT INTO audit_trails VALUES("215","100","2025-03-18 17:44:11","Verified Loan Type : jazz loan, of amount  : 1,500,000.00, for client : JESCA CHARLES THOMAS. Loan ID : 786-LN30","177");
INSERT INTO audit_trails VALUES("216","100","2025-03-21 23:18:06","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("217","100","2025-03-21 00:00:00","Deleted guarator","112");
INSERT INTO audit_trails VALUES("218","100","2025-03-21 23:29:13","Logged into the system","135");
INSERT INTO audit_trails VALUES("219","100","2025-03-21 23:40:56","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("220","100","2025-03-21 23:40:58","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("221","100","2025-03-22 00:12:54","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("222","100","2025-03-22 00:23:13","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("223","100","2025-03-22 00:23:32","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("224","100","2025-03-22 01:41:43","Update photo details for customer ALLY  SALIM MRUTU","79");
INSERT INTO audit_trails VALUES("225","100","2025-03-22 01:41:55","Update photo details for customer ALLY  SALIM MRUTU","79");
INSERT INTO audit_trails VALUES("226","100","2025-03-17 20:38:10","Logged into the system","135");
INSERT INTO audit_trails VALUES("227","100","2025-03-17 20:44:24","Update photo details for customer LAWIN LEWIN LIWIN","79");
INSERT INTO audit_trails VALUES("228","100","2025-03-17 00:00:00","Recorded Investment : DEVELOPMENT LOANS, of amount  : 1,000,000.00, for client : SABA NAEL KIBU. Investment ID : DVLP-INVST32","200");
INSERT INTO audit_trails VALUES("229","100","2025-03-31 04:47:47","Logged into the system","135");
INSERT INTO audit_trails VALUES("230","100","2025-03-31 00:00:00","Deleted chart of account Akiba za kukombolea maFungu from the system","0");
INSERT INTO audit_trails VALUES("231","100","2025-03-31 00:00:00","Deleted chart of account Mfuko wa elimu from the system","0");
INSERT INTO audit_trails VALUES("232","100","2025-03-31 00:00:00","Deleted chart of account Akiba ya kukombolea madeni from the system","0");
INSERT INTO audit_trails VALUES("233","100","2025-03-31 00:00:00","Deleted chart of account Malimbikizo ya faida from the system","0");
INSERT INTO audit_trails VALUES("234","100","2025-03-31 00:00:00","Deleted chart of account Interest on Savings  from the system","0");
INSERT INTO audit_trails VALUES("235","100","2025-03-31 00:00:00","Deleted chart of account Kodi iliyolipwa zaidi from the system","0");
INSERT INTO audit_trails VALUES("236","100","2025-03-31 00:00:00","Deleted chart of account Wadai wengine from the system","0");
INSERT INTO audit_trails VALUES("237","100","2025-03-31 00:00:00","Deleted chart of account Wadaiwa wengine from the system","0");
INSERT INTO audit_trails VALUES("238","100","2025-03-31 00:00:00","Deleted chart of account Board members allowances from the system","0");
INSERT INTO audit_trails VALUES("239","100","2025-03-31 00:00:00","Recorded Investment : DEVELOPMENT LOANS, of amount  : 1,000,000.00, for client : PROSPER JOSEPH SAKU. Investment ID : DVLP-INVST33","200");
INSERT INTO audit_trails VALUES("240","100","2025-03-31 10:09:10","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("241","100","2025-03-31 11:22:20","Updated Sub Module Details","8");
INSERT INTO audit_trails VALUES("242","100","2025-03-31 12:42:37","Registered Customer MICHOMA PETER PETER into the system","209");
INSERT INTO audit_trails VALUES("243","100","2025-03-31 12:45:21","Registered Customer MICHOMA PETER KUKU into the system","209");
INSERT INTO audit_trails VALUES("244","100","2025-03-31 13:10:19","Registered Customer LULU HASSAN MICHOMA into the system","209");
INSERT INTO audit_trails VALUES("245","100","2025-03-31 13:44:49","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("246","100","2025-03-31 20:33:08","Logged into the system","135");
INSERT INTO audit_trails VALUES("247","100","2025-03-31 20:28:39","Logged into the system","135");
INSERT INTO audit_trails VALUES("248","100","2025-03-31 20:47:52","Registered Customer NALIA ALIA MALIA into the system","79");
INSERT INTO audit_trails VALUES("249","100","2025-04-01 03:01:16","Logged into the system","135");
INSERT INTO audit_trails VALUES("250","100","2025-04-01 03:03:06","Update photo details for customer ALLY  SALIM MRUTU","79");
INSERT INTO audit_trails VALUES("251","100","2025-04-01 03:04:10","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("252","100","2025-04-01 03:58:49","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("253","100","2025-04-01 03:59:47","Update photo details for customer ALLY  SALIM MRUTU","79");
INSERT INTO audit_trails VALUES("254","100","2025-04-01 04:00:09","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("255","100","2025-04-05 22:32:49","Update photo details for customer ALLY  SALIM MRUTU","79");
INSERT INTO audit_trails VALUES("256","100","2025-04-05 22:38:08","Update photo details for customer ALLY  SALIM MRUTU","79");
INSERT INTO audit_trails VALUES("257","100","2025-04-05 00:00:00","Updated details of customer  into the system","79");
INSERT INTO audit_trails VALUES("258","100","2025-04-05 23:27:46","Update photo details for customer ALLY  SALIM MRUTU","79");
INSERT INTO audit_trails VALUES("259","100","2025-04-06 00:07:39","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("260","100","2025-04-06 00:51:44","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("261","100","2025-04-06 00:52:49","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("262","100","2025-04-06 00:53:43","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("263","100","2025-04-06 00:53:55","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("264","100","2025-04-06 01:00:13","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("265","100","2025-04-06 06:44:58","Logged into the system","135");
INSERT INTO audit_trails VALUES("266","100","2025-04-06 07:40:10","Registered Customer COLLLINS  MICHOMA MOKAYA into the system","79");
INSERT INTO audit_trails VALUES("267","100","2025-04-06 07:51:11","Update photo details for customer COLLLINS  MICHOMA MOKAYA","79");
INSERT INTO audit_trails VALUES("268","100","2025-04-06 08:41:40","Created a user group Loan Officer","7");
INSERT INTO audit_trails VALUES("269","100","2025-04-06 00:00:00","Updated loan application loan type : jazz loan of amount  :  for client : JESCA CHARLES THOMAS. Loan ID : 786-LN30","112");
INSERT INTO audit_trails VALUES("270","100","2025-04-06 12:39:36","Updated details of customer ALLY  SALIM MRUTU into the system","79");
INSERT INTO audit_trails VALUES("271","100","2025-04-06 12:42:51","Registered Customer OZARK STARSHIP KINDLE into the system","79");
INSERT INTO audit_trails VALUES("272","100","2025-04-06 12:44:57","Updated details of customer OZARK STARSHIP KINDLE into the system","79");



DROP TABLE backups;

CREATE TABLE `backups` (
  `backup_id` int(11) NOT NULL AUTO_INCREMENT,
  `file_name` mediumtext NOT NULL,
  `date_backup` datetime NOT NULL,
  PRIMARY KEY (`backup_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO backups VALUES("1","fingrow_backup_1743933292.sql","2025-04-06 12:54:50");



DROP TABLE bank_branches;

CREATE TABLE `bank_branches` (
  `Branch_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Bank_ID` int(20) DEFAULT NULL,
  `Branch_Name` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `Branch_Code` varchar(100) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`Branch_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=563 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO bank_branches VALUES("1","2","Cooperative House","");
INSERT INTO bank_branches VALUES("3","0","Moi Avenue Branch","");
INSERT INTO bank_branches VALUES("4","1","Moi Avenue Branch","");
INSERT INTO bank_branches VALUES("5","3","Nation House","");
INSERT INTO bank_branches VALUES("6","10","Buruburu","");
INSERT INTO bank_branches VALUES("7","10","Busia","");
INSERT INTO bank_branches VALUES("8","10","Card Centre","");
INSERT INTO bank_branches VALUES("9","10","Chuka","");
INSERT INTO bank_branches VALUES("10","10","Eastleigh","");
INSERT INTO bank_branches VALUES("11","10","Eldoret","");
INSERT INTO bank_branches VALUES("12","10","Embu","");
INSERT INTO bank_branches VALUES("13","10","Enterprise Road Nairobi","");
INSERT INTO bank_branches VALUES("14","10","Garisa","");
INSERT INTO bank_branches VALUES("15","10","Gikomba","");
INSERT INTO bank_branches VALUES("16","10","Gilgil","");
INSERT INTO bank_branches VALUES("17","10","Githunguri","");
INSERT INTO bank_branches VALUES("18","10","Githurai","");
INSERT INTO bank_branches VALUES("19","10","Haile Selasia","");
INSERT INTO bank_branches VALUES("20","10","Head Office","");
INSERT INTO bank_branches VALUES("21","10","Homabei","");
INSERT INTO bank_branches VALUES("22","10","Hurlingam","");
INSERT INTO bank_branches VALUES("23","10","Juja","");
INSERT INTO bank_branches VALUES("24","10","Kapsabet","");
INSERT INTO bank_branches VALUES("25","10","Karen","");
INSERT INTO bank_branches VALUES("26","10","Kariobangi","");
INSERT INTO bank_branches VALUES("27","10","Kawangware","");
INSERT INTO bank_branches VALUES("28","10","Kericho","");
INSERT INTO bank_branches VALUES("29","10","Kilifi","");
INSERT INTO bank_branches VALUES("30","10","Kiriaini","");
INSERT INTO bank_branches VALUES("31","10","Kiriaini Murang\'a","");
INSERT INTO bank_branches VALUES("32","10","Kisii","");
INSERT INTO bank_branches VALUES("33","10","Kisumu","");
INSERT INTO bank_branches VALUES("34","10","Kitui","");
INSERT INTO bank_branches VALUES("35","10","Limuru","");
INSERT INTO bank_branches VALUES("36","10","Machakos","");
INSERT INTO bank_branches VALUES("37","10","Makupa","");
INSERT INTO bank_branches VALUES("38","10","Malindi","");
INSERT INTO bank_branches VALUES("39","10","Meru","");
INSERT INTO bank_branches VALUES("40","10","Migori","");
INSERT INTO bank_branches VALUES("41","10","Moi Avenue Nairobi","");
INSERT INTO bank_branches VALUES("42","10","Mumias","");
INSERT INTO bank_branches VALUES("43","10","Murang\'a","");
INSERT INTO bank_branches VALUES("44","10","Muthaiga","");
INSERT INTO bank_branches VALUES("45","10","Nafex","");
INSERT INTO bank_branches VALUES("46","10","Nairobi West","");
INSERT INTO bank_branches VALUES("47","10","Nakumatt Meru","");
INSERT INTO bank_branches VALUES("48","10","Nakuru East","");
INSERT INTO bank_branches VALUES("49","10","Nanyuki","");
INSERT INTO bank_branches VALUES("50","10","Narok","");
INSERT INTO bank_branches VALUES("51","10","Ngong","");
INSERT INTO bank_branches VALUES("52","10","Nkurumah Road","");
INSERT INTO bank_branches VALUES("53","10","Nyamira","");
INSERT INTO bank_branches VALUES("54","10","Nyeri","");
INSERT INTO bank_branches VALUES("55","10","Othaya","");
INSERT INTO bank_branches VALUES("56","10","Pangani","");
INSERT INTO bank_branches VALUES("57","10","Parklands","");
INSERT INTO bank_branches VALUES("58","10","Plaza Business Centre","");
INSERT INTO bank_branches VALUES("59","10","Plaza Premier","");
INSERT INTO bank_branches VALUES("60","10","Port Mombasa","");
INSERT INTO bank_branches VALUES("61","10","Queens Way House","");
INSERT INTO bank_branches VALUES("62","10","River road","");
INSERT INTO bank_branches VALUES("63","10","Ruaraka","");
INSERT INTO bank_branches VALUES("64","10","South C","");
INSERT INTO bank_branches VALUES("65","10","Thika","");
INSERT INTO bank_branches VALUES("66","10","Voi","");
INSERT INTO bank_branches VALUES("67","10","Webuye","");
INSERT INTO bank_branches VALUES("68","10","West Gate","");
INSERT INTO bank_branches VALUES("69","10","West lands","");
INSERT INTO bank_branches VALUES("70","10","Wote","");
INSERT INTO bank_branches VALUES("71","10","Wundanyi","");
INSERT INTO bank_branches VALUES("72","3","Bungoma","");
INSERT INTO bank_branches VALUES("73","3","Chuka","");
INSERT INTO bank_branches VALUES("74","3","Community","");
INSERT INTO bank_branches VALUES("75","3","Community Corporate","");
INSERT INTO bank_branches VALUES("76","3","Digo Road Mombasa","");
INSERT INTO bank_branches VALUES("77","3","Eldoret","");
INSERT INTO bank_branches VALUES("78","3","Embu","");
INSERT INTO bank_branches VALUES("79","3","Four ways Towers","");
INSERT INTO bank_branches VALUES("80","3","Four ways Towers Corporate","");
INSERT INTO bank_branches VALUES("81","3","Garissa","");
INSERT INTO bank_branches VALUES("82","3","Gikomba","");
INSERT INTO bank_branches VALUES("83","3","Harambee Avenue","");
INSERT INTO bank_branches VALUES("84","3","Head Office","");
INSERT INTO bank_branches VALUES("85","3","Isiolo","");
INSERT INTO bank_branches VALUES("86","3","Kagio","");
INSERT INTO bank_branches VALUES("87","3","Kakamega","");
INSERT INTO bank_branches VALUES("88","3","Kangari","");
INSERT INTO bank_branches VALUES("89","3","Kangema","");
INSERT INTO bank_branches VALUES("90","3","Kapsabet","");
INSERT INTO bank_branches VALUES("91","3","Karatina","");
INSERT INTO bank_branches VALUES("92","3","Kariobangi","");
INSERT INTO bank_branches VALUES("93","3","Kawangware","");
INSERT INTO bank_branches VALUES("94","3","Kenpipe Plaza","");
INSERT INTO bank_branches VALUES("95","3","Kikuyu","");
INSERT INTO bank_branches VALUES("96","3","Kimathi Street","");
INSERT INTO bank_branches VALUES("97","3","Kiriaini","");
INSERT INTO bank_branches VALUES("98","3","Kisii","");
INSERT INTO bank_branches VALUES("99","3","Kisumu","");
INSERT INTO bank_branches VALUES("100","3","kitale","");
INSERT INTO bank_branches VALUES("101","3","KNUT House","");
INSERT INTO bank_branches VALUES("102","3","Machakos","");
INSERT INTO bank_branches VALUES("103","3","Malindi","");
INSERT INTO bank_branches VALUES("104","3","Mama Ngina Street","");
INSERT INTO bank_branches VALUES("105","3","Matuu","");
INSERT INTO bank_branches VALUES("106","3","Maua","");
INSERT INTO bank_branches VALUES("107","3","Meru","");
INSERT INTO bank_branches VALUES("108","3","Moi Avenue Corporate","");
INSERT INTO bank_branches VALUES("109","3","Molo","");
INSERT INTO bank_branches VALUES("110","3","Mombasa","");
INSERT INTO bank_branches VALUES("111","3","Murang\'a","");
INSERT INTO bank_branches VALUES("112","3","Murarandia","");
INSERT INTO bank_branches VALUES("113","3","Mwea","");
INSERT INTO bank_branches VALUES("114","3","Mwingi","");
INSERT INTO bank_branches VALUES("115","3","Naivasha","");
INSERT INTO bank_branches VALUES("116","3","Nakuru Gate House","");
INSERT INTO bank_branches VALUES("117","3","Nakuru Kenyatta Avenue","");
INSERT INTO bank_branches VALUES("118","3","Nanyuki","");
INSERT INTO bank_branches VALUES("119","3","Narok","");
INSERT INTO bank_branches VALUES("120","3","Nkubu","");
INSERT INTO bank_branches VALUES("121","3","Nyahururu","");
INSERT INTO bank_branches VALUES("122","3","Nyeri","");
INSERT INTO bank_branches VALUES("123","3","Ol Kalou","");
INSERT INTO bank_branches VALUES("124","3","Ongata Rongai","");
INSERT INTO bank_branches VALUES("125","3","Othaya","");
INSERT INTO bank_branches VALUES("126","3","Thika","");
INSERT INTO bank_branches VALUES("127","3","Thika Kenyatta Highway","");
INSERT INTO bank_branches VALUES("128","3","Tom Mboya Street","");
INSERT INTO bank_branches VALUES("129","3","Ukunda","");
INSERT INTO bank_branches VALUES("130","3","Westlands","");
INSERT INTO bank_branches VALUES("131","6","Eldoret","");
INSERT INTO bank_branches VALUES("132","6","ICEA Building","");
INSERT INTO bank_branches VALUES("133","6","Industrial Area","");
INSERT INTO bank_branches VALUES("134","6","Kisumu","");
INSERT INTO bank_branches VALUES("135","6","Meru","");
INSERT INTO bank_branches VALUES("136","6","Mombasa","");
INSERT INTO bank_branches VALUES("137","6","Westlands","");
INSERT INTO bank_branches VALUES("138","7","Head Office Nairobi","");
INSERT INTO bank_branches VALUES("139","7","Mombasa","");
INSERT INTO bank_branches VALUES("140","7","Uhuru Highway","");
INSERT INTO bank_branches VALUES("141","7","Westlands","");
INSERT INTO bank_branches VALUES("142","8","Digo Road Mombasa","");
INSERT INTO bank_branches VALUES("143","8","Head Office","");
INSERT INTO bank_branches VALUES("144","8","Industrial Area","");
INSERT INTO bank_branches VALUES("145","8","Kisumu","");
INSERT INTO bank_branches VALUES("146","8","Sarit Centre","");
INSERT INTO bank_branches VALUES("147","8","Thika","");
INSERT INTO bank_branches VALUES("148","9","Industrial Area","");
INSERT INTO bank_branches VALUES("149","9","Mombasa","");
INSERT INTO bank_branches VALUES("150","9","Nairobi","");
INSERT INTO bank_branches VALUES("151","9","Westlands","");
INSERT INTO bank_branches VALUES("152","11","Head Office","");
INSERT INTO bank_branches VALUES("153","11","Heritage Centre Naivasha","");
INSERT INTO bank_branches VALUES("154","9","International House","");
INSERT INTO bank_branches VALUES("155","11","Mombasa","");
INSERT INTO bank_branches VALUES("156","11","Upper Hill Medical Centre","");
INSERT INTO bank_branches VALUES("157","12","Head Office Riverside","");
INSERT INTO bank_branches VALUES("158","12","Hulingam","");
INSERT INTO bank_branches VALUES("159","12","Village Market","");
INSERT INTO bank_branches VALUES("160","13","Mombasa","");
INSERT INTO bank_branches VALUES("161","13","Upper Hill  Nairobi","");
INSERT INTO bank_branches VALUES("162","14","Unit House koinange Street","");
INSERT INTO bank_branches VALUES("163","15","Mombasa","");
INSERT INTO bank_branches VALUES("164","15","Mombasa","");
INSERT INTO bank_branches VALUES("165","16","Corner House Nyeri","");
INSERT INTO bank_branches VALUES("166","16","Embu","");
INSERT INTO bank_branches VALUES("167","16","Harambee Avenue","");
INSERT INTO bank_branches VALUES("168","16","Isiolo","");
INSERT INTO bank_branches VALUES("169","16","Koinange Street","");
INSERT INTO bank_branches VALUES("170","16","Maua","");
INSERT INTO bank_branches VALUES("171","16","Meru","");
INSERT INTO bank_branches VALUES("172","16","Murang\'a","");
INSERT INTO bank_branches VALUES("173","16","Nkurumah Road MSA","");
INSERT INTO bank_branches VALUES("174","16","Nyeri","");
INSERT INTO bank_branches VALUES("175","16","Thika","");
INSERT INTO bank_branches VALUES("176","17","Kisii","");
INSERT INTO bank_branches VALUES("177","17","Kisumu","");
INSERT INTO bank_branches VALUES("178","17","Nairobi","");
INSERT INTO bank_branches VALUES("179","17","Nakuru","");
INSERT INTO bank_branches VALUES("180","18","Head Office","");
INSERT INTO bank_branches VALUES("181","18","loita Street","");
INSERT INTO bank_branches VALUES("182","19","Capital Centre","");
INSERT INTO bank_branches VALUES("183","19","Head Office","");
INSERT INTO bank_branches VALUES("184","19","Kisumu","");
INSERT INTO bank_branches VALUES("185","19","Moi Avenue","");
INSERT INTO bank_branches VALUES("186","19","Mombasa","");
INSERT INTO bank_branches VALUES("187","19","Parklands","");
INSERT INTO bank_branches VALUES("188","19","Tomboya","");
INSERT INTO bank_branches VALUES("189","19","West Gate","");
INSERT INTO bank_branches VALUES("190","20","Eastleigh","");
INSERT INTO bank_branches VALUES("191","20","Head Office","");
INSERT INTO bank_branches VALUES("192","20","Mombasa","");
INSERT INTO bank_branches VALUES("193","20","Nairobi","");
INSERT INTO bank_branches VALUES("194","21","Chambers","");
INSERT INTO bank_branches VALUES("195","21","Eldoret","");
INSERT INTO bank_branches VALUES("196","21","Fedha Towers","");
INSERT INTO bank_branches VALUES("197","21","Head Office","");
INSERT INTO bank_branches VALUES("198","21","Kisumu","");
INSERT INTO bank_branches VALUES("199","21","Moi Avenue Nairobi","");
INSERT INTO bank_branches VALUES("200","21","Mombasa","");
INSERT INTO bank_branches VALUES("201","21","plaza 2000 Nairobi","");
INSERT INTO bank_branches VALUES("202","21","Thika","");
INSERT INTO bank_branches VALUES("203","21","Westminster","");
INSERT INTO bank_branches VALUES("204","22","HQ Nairobi","");
INSERT INTO bank_branches VALUES("205","22","loita Street","");
INSERT INTO bank_branches VALUES("206","22","Mombasa","");
INSERT INTO bank_branches VALUES("207","22","Westlands","");
INSERT INTO bank_branches VALUES("208","23","Bungoma","");
INSERT INTO bank_branches VALUES("209","23","Cargen House","");
INSERT INTO bank_branches VALUES("210","23","Eldoret","");
INSERT INTO bank_branches VALUES("211","23","Embu","");
INSERT INTO bank_branches VALUES("212","23","Four ways Towers","");
INSERT INTO bank_branches VALUES("213","23","Four ways Towers Corporate","");
INSERT INTO bank_branches VALUES("214","23","Gatundu","");
INSERT INTO bank_branches VALUES("215","23","Gikomba","");
INSERT INTO bank_branches VALUES("216","23","Githunguri","");
INSERT INTO bank_branches VALUES("217","23","Head Office","");
INSERT INTO bank_branches VALUES("218","23","Kangari","");
INSERT INTO bank_branches VALUES("219","23","Kapsabet","");
INSERT INTO bank_branches VALUES("220","23","kenyatta Avenue","");
INSERT INTO bank_branches VALUES("221","23","Kerugoya","");
INSERT INTO bank_branches VALUES("222","23","Kiambuu","");
INSERT INTO bank_branches VALUES("223","23","Kiriaini","");
INSERT INTO bank_branches VALUES("224","23","Kisii","");
INSERT INTO bank_branches VALUES("225","23","Kisumu","");
INSERT INTO bank_branches VALUES("226","23","kitale","");
INSERT INTO bank_branches VALUES("227","23","KTDA plaza","");
INSERT INTO bank_branches VALUES("228","23","KTDA plaza corporate","");
INSERT INTO bank_branches VALUES("229","23","Limuru","");
INSERT INTO bank_branches VALUES("230","23","Machakos","");
INSERT INTO bank_branches VALUES("231","23","Molo","");
INSERT INTO bank_branches VALUES("232","23","Mombasa","");
INSERT INTO bank_branches VALUES("233","23","Murang\'a","");
INSERT INTO bank_branches VALUES("234","23","Nakuru Finance House","");
INSERT INTO bank_branches VALUES("235","23","Nakuru Njoro House","");
INSERT INTO bank_branches VALUES("236","23","Othaya","");
INSERT INTO bank_branches VALUES("237","23","sonalux house","");
INSERT INTO bank_branches VALUES("238","23","Thika","");
INSERT INTO bank_branches VALUES("239","24","Head Office","");
INSERT INTO bank_branches VALUES("240","24","Industrial Area","");
INSERT INTO bank_branches VALUES("241","25","Head Office","");
INSERT INTO bank_branches VALUES("242","25","Industrial Area","");
INSERT INTO bank_branches VALUES("243","25","Kisumu","");
INSERT INTO bank_branches VALUES("244","25","Mombasa","");
INSERT INTO bank_branches VALUES("245","23","Nakuru","");
INSERT INTO bank_branches VALUES("246","25","Westlands Ukay House","");
INSERT INTO bank_branches VALUES("247","26","Industrial Area","");
INSERT INTO bank_branches VALUES("248","26","Kimathi Street","");
INSERT INTO bank_branches VALUES("249","26","Kisumu","");
INSERT INTO bank_branches VALUES("250","26","Mombasa","");
INSERT INTO bank_branches VALUES("251","26","Shretta House Nairobi","");
INSERT INTO bank_branches VALUES("252","26","Westlands","");
INSERT INTO bank_branches VALUES("253","27","Eldoret","");
INSERT INTO bank_branches VALUES("254","27","Head Office","");
INSERT INTO bank_branches VALUES("255","27","Kisumu","");
INSERT INTO bank_branches VALUES("256","27","Moi Avenue","");
INSERT INTO bank_branches VALUES("257","27","Mombasa","");
INSERT INTO bank_branches VALUES("258","27","Westlands","");
INSERT INTO bank_branches VALUES("259","28","kenyatta Avenue","");
INSERT INTO bank_branches VALUES("260","28","Kimathi Street","");
INSERT INTO bank_branches VALUES("261","28","Kisumu","");
INSERT INTO bank_branches VALUES("262","28","Koinange Street","");
INSERT INTO bank_branches VALUES("263","28","Malindi","");
INSERT INTO bank_branches VALUES("264","28","Mombasa","");
INSERT INTO bank_branches VALUES("265","29","Head Office","");
INSERT INTO bank_branches VALUES("266","29","Industrial Area","");
INSERT INTO bank_branches VALUES("267","29","Mombasa","");
INSERT INTO bank_branches VALUES("268","29","westlands","");
INSERT INTO bank_branches VALUES("269","30","Diani","");
INSERT INTO bank_branches VALUES("270","30","HQ Nairobi","");
INSERT INTO bank_branches VALUES("271","30","Kimathi Street","");
INSERT INTO bank_branches VALUES("272","30","Malindi","");
INSERT INTO bank_branches VALUES("273","30","Mombasa","");
INSERT INTO bank_branches VALUES("274","30","Parklands","");
INSERT INTO bank_branches VALUES("275","30","Upper Hill  Nairobi","");
INSERT INTO bank_branches VALUES("276","31","Biashara Street nairobi","");
INSERT INTO bank_branches VALUES("277","31","Head Office","");
INSERT INTO bank_branches VALUES("278","31","Industrial Area","");
INSERT INTO bank_branches VALUES("279","31","Karen road","");
INSERT INTO bank_branches VALUES("280","31","kenyatta Avenue","");
INSERT INTO bank_branches VALUES("281","31","Kisumu","");
INSERT INTO bank_branches VALUES("282","31","Mombasa","");
INSERT INTO bank_branches VALUES("283","31","Ngong Avenue","");
INSERT INTO bank_branches VALUES("284","31","Sarit Centre","");
INSERT INTO bank_branches VALUES("285","32","Bungoma","");
INSERT INTO bank_branches VALUES("286","32","Buruburu","");
INSERT INTO bank_branches VALUES("287","32","Eldoret","");
INSERT INTO bank_branches VALUES("288","32","Embu","");
INSERT INTO bank_branches VALUES("289","32","Head Office","");
INSERT INTO bank_branches VALUES("290","32","Isiolo","");
INSERT INTO bank_branches VALUES("291","32","Kajiado","");
INSERT INTO bank_branches VALUES("292","32","kenyatta Avenue","");
INSERT INTO bank_branches VALUES("293","32","Kibwezi","");
INSERT INTO bank_branches VALUES("294","32","Kisumu","");
INSERT INTO bank_branches VALUES("295","32","Kitale","");
INSERT INTO bank_branches VALUES("296","32","Kongowea Mombasa","");
INSERT INTO bank_branches VALUES("297","32","Machakos","");
INSERT INTO bank_branches VALUES("298","32","Meru","");
INSERT INTO bank_branches VALUES("299","32","Mombasa","");
INSERT INTO bank_branches VALUES("300","32","Mtwapa","");
INSERT INTO bank_branches VALUES("301","32","Naivasha","");
INSERT INTO bank_branches VALUES("302","32","Nakuru","");
INSERT INTO bank_branches VALUES("303","32","Nyahururu","");
INSERT INTO bank_branches VALUES("304","32","Nyeri","");
INSERT INTO bank_branches VALUES("305","32","Thika","");
INSERT INTO bank_branches VALUES("306","33","Headquarters","");
INSERT INTO bank_branches VALUES("307","33","kenyatta Avenue","");
INSERT INTO bank_branches VALUES("308","33","Milimani Road Nairobi","");
INSERT INTO bank_branches VALUES("309","33","mombasa","");
INSERT INTO bank_branches VALUES("310","36","Eldoret","");
INSERT INTO bank_branches VALUES("311","36","Head Quarters","");
INSERT INTO bank_branches VALUES("312","36","Koinange Street","");
INSERT INTO bank_branches VALUES("313","36","Nakuru","");
INSERT INTO bank_branches VALUES("314","36","Kisumu","");
INSERT INTO bank_branches VALUES("315","37","Head office","");
INSERT INTO bank_branches VALUES("316","37","Paramount","");
INSERT INTO bank_branches VALUES("317","37","Westlands","");
INSERT INTO bank_branches VALUES("318","35","City Centre","");
INSERT INTO bank_branches VALUES("319","35","Head Office","");
INSERT INTO bank_branches VALUES("320","35","Junction","");
INSERT INTO bank_branches VALUES("321","35","Mombasa Harbor","");
INSERT INTO bank_branches VALUES("322","35","Nakuru","");
INSERT INTO bank_branches VALUES("323","35","NIC House","");
INSERT INTO bank_branches VALUES("324","35","NIC House Masaba","");
INSERT INTO bank_branches VALUES("325","35","Westlands,The Mall","");
INSERT INTO bank_branches VALUES("326","2","Athiriver","");
INSERT INTO bank_branches VALUES("327","2","Bungoma","");
INSERT INTO bank_branches VALUES("328","2","Cannon House","");
INSERT INTO bank_branches VALUES("329","2","Chuka","");
INSERT INTO bank_branches VALUES("330","2","City Hall","");
INSERT INTO bank_branches VALUES("331","2","Digo Road","");
INSERT INTO bank_branches VALUES("332","2","Eldoret","");
INSERT INTO bank_branches VALUES("333","2","Embu","");
INSERT INTO bank_branches VALUES("334","2","Githurai","");
INSERT INTO bank_branches VALUES("335","2","Head office","");
INSERT INTO bank_branches VALUES("336","2","Homabay","");
INSERT INTO bank_branches VALUES("337","2","Industrial Area","");
INSERT INTO bank_branches VALUES("338","2","kakamega","");
INSERT INTO bank_branches VALUES("339","2","Karatina","");
INSERT INTO bank_branches VALUES("340","2","Kariobangi","");
INSERT INTO bank_branches VALUES("341","2","Kawangware","");
INSERT INTO bank_branches VALUES("342","2","Kericho","");
INSERT INTO bank_branches VALUES("343","2","Kerugoya","");
INSERT INTO bank_branches VALUES("344","2","Kiambu","");
INSERT INTO bank_branches VALUES("345","2","Kimathi Street","");
INSERT INTO bank_branches VALUES("346","2","Kisii","");
INSERT INTO bank_branches VALUES("347","2","Kisumu","");
INSERT INTO bank_branches VALUES("348","2","Kitale","");
INSERT INTO bank_branches VALUES("349","2","Machakos","");
INSERT INTO bank_branches VALUES("350","2","Meru","");
INSERT INTO bank_branches VALUES("351","2","Mombasa","");
INSERT INTO bank_branches VALUES("352","2","Mumias","");
INSERT INTO bank_branches VALUES("353","2","Murang\'a","");
INSERT INTO bank_branches VALUES("354","2","Nacico Plaza","");
INSERT INTO bank_branches VALUES("355","2","Nairobi Business Centre","");
INSERT INTO bank_branches VALUES("356","2","Nakuru","");
INSERT INTO bank_branches VALUES("357","2","Nyahururu","");
INSERT INTO bank_branches VALUES("358","2","Nyeri","");
INSERT INTO bank_branches VALUES("359","2","Staff Training Centre","");
INSERT INTO bank_branches VALUES("360","2","Stima Plaza","");
INSERT INTO bank_branches VALUES("361","2","Thika","");
INSERT INTO bank_branches VALUES("362","2","Ukulima","");
INSERT INTO bank_branches VALUES("363","2","University Way","");
INSERT INTO bank_branches VALUES("364","42","Westlands","");
INSERT INTO bank_branches VALUES("365","35","Prestige Plaza","");
INSERT INTO bank_branches VALUES("366","42","Harambee Avenue","");
INSERT INTO bank_branches VALUES("367","46","Fedha Towers","");
INSERT INTO bank_branches VALUES("368","41","Kenyatta Avenue","");
INSERT INTO bank_branches VALUES("369","1","University way","");
INSERT INTO bank_branches VALUES("370","42","Yaya Centre","");
INSERT INTO bank_branches VALUES("371","34","Harambee Avenue","");
INSERT INTO bank_branches VALUES("372","42","Kenyatta Avenue","");
INSERT INTO bank_branches VALUES("466","49","KIKOMBAA","");
INSERT INTO bank_branches VALUES("431","49","Haille Selasie rd","");
INSERT INTO bank_branches VALUES("375","48","Equity","");
INSERT INTO bank_branches VALUES("376","47","Branch","");
INSERT INTO bank_branches VALUES("377","48","Harambee Avenue","");
INSERT INTO bank_branches VALUES("378","49","Kiserian  ","");
INSERT INTO bank_branches VALUES("379","49","Naivasha","");
INSERT INTO bank_branches VALUES("380","49","Narok","");
INSERT INTO bank_branches VALUES("381","49","Mobile Banking","");
INSERT INTO bank_branches VALUES("382","49","Indusrial Area","");
INSERT INTO bank_branches VALUES("383","49","Likoni","");
INSERT INTO bank_branches VALUES("384","49","Kajiado","");
INSERT INTO bank_branches VALUES("385","49","Murang\'a","");
INSERT INTO bank_branches VALUES("386","49","kwale","");
INSERT INTO bank_branches VALUES("387","49","Nairobi","");
INSERT INTO bank_branches VALUES("388","49","Moi Avenue","");
INSERT INTO bank_branches VALUES("389","49","Gateway Park","");
INSERT INTO bank_branches VALUES("390","49","Moi\'s Bridge","");
INSERT INTO bank_branches VALUES("391","49","Eastleigh","");
INSERT INTO bank_branches VALUES("394","49","Biashara Street","");
INSERT INTO bank_branches VALUES("433","52","South C","");
INSERT INTO bank_branches VALUES("395","49","JOGOO ROAD","");
INSERT INTO bank_branches VALUES("396","49","MOMBASA ROAD","");
INSERT INTO bank_branches VALUES("397","49","KAYOLE","");
INSERT INTO bank_branches VALUES("398","49","RIVER ROAD","");
INSERT INTO bank_branches VALUES("399","49","JKIA","");
INSERT INTO bank_branches VALUES("400","49","NAKURU TOWN","");
INSERT INTO bank_branches VALUES("401","49","KITENGELA","");
INSERT INTO bank_branches VALUES("402","49","INDUSTRIAL AREA","");
INSERT INTO bank_branches VALUES("403","49","SYOKIMAU","");
INSERT INTO bank_branches VALUES("404","49","BUNGOMA","");
INSERT INTO bank_branches VALUES("405","50","Biashara","");
INSERT INTO bank_branches VALUES("406","49","LIKONI ROAD","");
INSERT INTO bank_branches VALUES("407","49","KARIOBANGI","");
INSERT INTO bank_branches VALUES("408","49","KENCOM","");
INSERT INTO bank_branches VALUES("409","49","UTAWALA","");
INSERT INTO bank_branches VALUES("410","49","LUNGALUNGA","");
INSERT INTO bank_branches VALUES("411","49","DONHOLM","");
INSERT INTO bank_branches VALUES("412","49","Gate mall syokimau","");
INSERT INTO bank_branches VALUES("413","49","kilgoris town","");
INSERT INTO bank_branches VALUES("414","49","kencom house","");
INSERT INTO bank_branches VALUES("415","49","KIPANDE","");
INSERT INTO bank_branches VALUES("416","49","AIRPORT BRANCH","");
INSERT INTO bank_branches VALUES("417","49","Malindi","");
INSERT INTO bank_branches VALUES("418","50","CLEARED","");
INSERT INTO bank_branches VALUES("419","49","KISII WEST","");
INSERT INTO bank_branches VALUES("393","49","Kakamega","");
INSERT INTO bank_branches VALUES("421","49","WEBUYE","");
INSERT INTO bank_branches VALUES("422","49","KAPSABET","");
INSERT INTO bank_branches VALUES("423","49","MUMIAS","");
INSERT INTO bank_branches VALUES("424","49","KISUMU","");
INSERT INTO bank_branches VALUES("425","49","BUDALANGI","");
INSERT INTO bank_branches VALUES("426","49","KAKUMA","");
INSERT INTO bank_branches VALUES("427","50","fcb","");
INSERT INTO bank_branches VALUES("429","49","Taveta ","");
INSERT INTO bank_branches VALUES("430","51","MPESA","");
INSERT INTO bank_branches VALUES("434","49","Afya house","");
INSERT INTO bank_branches VALUES("435","49","Gateway branch","");
INSERT INTO bank_branches VALUES("436","49","Ngong Road","");
INSERT INTO bank_branches VALUES("437","49","Machakos","");
INSERT INTO bank_branches VALUES("438","49","Isiolo","");
INSERT INTO bank_branches VALUES("439","49","Nyeri","");
INSERT INTO bank_branches VALUES("440","49","Eldoret","");
INSERT INTO bank_branches VALUES("441","49","kcb mombasa","");
INSERT INTO bank_branches VALUES("442","49","kcb malindi","");
INSERT INTO bank_branches VALUES("443","49","kcb kisii","");
INSERT INTO bank_branches VALUES("444","49","kcb bungoma","");
INSERT INTO bank_branches VALUES("445","49","Flamingo Nakuru","");
INSERT INTO bank_branches VALUES("446","49","Garissa Town ","");
INSERT INTO bank_branches VALUES("447","53","","");
INSERT INTO bank_branches VALUES("448","54","1280487348","");
INSERT INTO bank_branches VALUES("449","54","1280655410","");
INSERT INTO bank_branches VALUES("450","53","1280486864","");
INSERT INTO bank_branches VALUES("451","53","1280175605","");
INSERT INTO bank_branches VALUES("452","53","1280444924","");
INSERT INTO bank_branches VALUES("453","53","1280625287","");
INSERT INTO bank_branches VALUES("454","53","1275054080","");
INSERT INTO bank_branches VALUES("455","55","1280799226","");
INSERT INTO bank_branches VALUES("456","56","1276795548","");
INSERT INTO bank_branches VALUES("457","57","1280628588","");
INSERT INTO bank_branches VALUES("458","57","1260392155","");
INSERT INTO bank_branches VALUES("459","58","1276998953","");
INSERT INTO bank_branches VALUES("460","49","MSA RD","");
INSERT INTO bank_branches VALUES("463","52","NOT APPLICABLE","");
INSERT INTO bank_branches VALUES("462","59","","");
INSERT INTO bank_branches VALUES("464","60","","");
INSERT INTO bank_branches VALUES("487","61","Branch","");
INSERT INTO bank_branches VALUES("467","49","JUJA","");
INSERT INTO bank_branches VALUES("468","49","JUJA","");
INSERT INTO bank_branches VALUES("469","62","FOSA ACCOUNT","");
INSERT INTO bank_branches VALUES("470","49","KITALE","");
INSERT INTO bank_branches VALUES("471","63","BANK NAME","");
INSERT INTO bank_branches VALUES("472","64","MPESA","");
INSERT INTO bank_branches VALUES("473","65","MPESA","");
INSERT INTO bank_branches VALUES("474","66","MPESA","");
INSERT INTO bank_branches VALUES("475","67","MPESA","");
INSERT INTO bank_branches VALUES("476","68","MPESA","");
INSERT INTO bank_branches VALUES("477","69","MPESA","");
INSERT INTO bank_branches VALUES("478","70","MPESA","");
INSERT INTO bank_branches VALUES("479","71","MPESA","");
INSERT INTO bank_branches VALUES("480","72","MPESA","");
INSERT INTO bank_branches VALUES("481","73","MPESA","");
INSERT INTO bank_branches VALUES("482","74","MPESA","");
INSERT INTO bank_branches VALUES("483","75","MPESA","");
INSERT INTO bank_branches VALUES("484","76","MPESA","");
INSERT INTO bank_branches VALUES("485","77","MPESA","");
INSERT INTO bank_branches VALUES("486","49","MAKADARA","");
INSERT INTO bank_branches VALUES("488","49","Kerugoya","");
INSERT INTO bank_branches VALUES("489","49","RUMURUTI","");
INSERT INTO bank_branches VALUES("490","49","ISIOLO","");
INSERT INTO bank_branches VALUES("491","49","MURANGA","");
INSERT INTO bank_branches VALUES("492","49","EMBU","");
INSERT INTO bank_branches VALUES("493","49","KITUI","");
INSERT INTO bank_branches VALUES("494","49","NANYUKI","");
INSERT INTO bank_branches VALUES("495","49","MERU","");
INSERT INTO bank_branches VALUES("496","49","GARISSA","");
INSERT INTO bank_branches VALUES("497","49","MANDERA","");
INSERT INTO bank_branches VALUES("498","49","LAMU","");
INSERT INTO bank_branches VALUES("499","49","MARSABIT","");
INSERT INTO bank_branches VALUES("500","49","TALA","-");
INSERT INTO bank_branches VALUES("501","49","GIKOMBA","-");
INSERT INTO bank_branches VALUES("502","49","MATUU","-");
INSERT INTO bank_branches VALUES("503","49","CHUKA","-");
INSERT INTO bank_branches VALUES("504","49","Mwingi","-");
INSERT INTO bank_branches VALUES("505","49","MERTI","-");
INSERT INTO bank_branches VALUES("506","49","BRANCH","");
INSERT INTO bank_branches VALUES("507","49","MAMA LUCY","");
INSERT INTO bank_branches VALUES("508","49","RUARAKA","");
INSERT INTO bank_branches VALUES("509","49","BURU BURU","");
INSERT INTO bank_branches VALUES("510","49","RELIEVER","");
INSERT INTO bank_branches VALUES("511","49","MAUA ","");
INSERT INTO bank_branches VALUES("512","49","WOTE","");
INSERT INTO bank_branches VALUES("513","49","MASII","");
INSERT INTO bank_branches VALUES("514","49","MUTOMO","");
INSERT INTO bank_branches VALUES("515","49","EMALI","");
INSERT INTO bank_branches VALUES("516","49","MAKINDU","");
INSERT INTO bank_branches VALUES("517","49","LOITOKTOK","");
INSERT INTO bank_branches VALUES("518","49","KIBWEZI","");
INSERT INTO bank_branches VALUES("519","49","KANGEMI","");
INSERT INTO bank_branches VALUES("520","49","SHOW PAVILLION","");
INSERT INTO bank_branches VALUES("521","49","KNH","");
INSERT INTO bank_branches VALUES("522","49","CONTRUST HOUSE","");
INSERT INTO bank_branches VALUES("523","49","WESTLANDS","");
INSERT INTO bank_branches VALUES("524","49","LEISAMIS","");
INSERT INTO bank_branches VALUES("525","49","NORTH HORR","");
INSERT INTO bank_branches VALUES("526","49","MAIKONI","");
INSERT INTO bank_branches VALUES("527","49","RONGAI","");
INSERT INTO bank_branches VALUES("528","49","DADAAD","");
INSERT INTO bank_branches VALUES("529","49","WAJIR ","");
INSERT INTO bank_branches VALUES("530","49","SOLOLO","");
INSERT INTO bank_branches VALUES("531","49","MOYALE","");
INSERT INTO bank_branches VALUES("532","78","BRANCH","");
INSERT INTO bank_branches VALUES("533","49","MPESA","");
INSERT INTO bank_branches VALUES("534","49","MANDERA","");
INSERT INTO bank_branches VALUES("535","49","KAWANGWARE","");
INSERT INTO bank_branches VALUES("536","49","CAPITAL HILL BRANCH","");
INSERT INTO bank_branches VALUES("537","49","KCB -MASHIRIKI","");
INSERT INTO bank_branches VALUES("538","34","HOSPITAL BRANCH","");
INSERT INTO bank_branches VALUES("539","79","HOSPITAL BRANCH","");
INSERT INTO bank_branches VALUES("540","80","Bank Name","");
INSERT INTO bank_branches VALUES("541","81","KCB BANK","");
INSERT INTO bank_branches VALUES("542","82","KCB BANK","");
INSERT INTO bank_branches VALUES("543","81","FCB BANK","");
INSERT INTO bank_branches VALUES("544","83","KCB BANK","");
INSERT INTO bank_branches VALUES("545","84","KCB BANK","");
INSERT INTO bank_branches VALUES("546","81","NATION SACCO","");
INSERT INTO bank_branches VALUES("547","85","NATION SACCO","");
INSERT INTO bank_branches VALUES("548","86","NATION SACCO","");
INSERT INTO bank_branches VALUES("549","87","NATION SACCO","");
INSERT INTO bank_branches VALUES("550","88","NATION SACCO","");
INSERT INTO bank_branches VALUES("551","89","BANK ACC.","");
INSERT INTO bank_branches VALUES("552","90","01116919020900","");
INSERT INTO bank_branches VALUES("553","90","01116706020901","");
INSERT INTO bank_branches VALUES("554","90","01116212741300","");
INSERT INTO bank_branches VALUES("555","90","01116706588000","");
INSERT INTO bank_branches VALUES("556","90","01109706679300","");
INSERT INTO bank_branches VALUES("557","90","01109842458200","");
INSERT INTO bank_branches VALUES("558","90","01116842132500","");
INSERT INTO bank_branches VALUES("559","90","01116918982700","");
INSERT INTO bank_branches VALUES("560","90","01116706757700","");
INSERT INTO bank_branches VALUES("561","91","CITY HALL","");
INSERT INTO bank_branches VALUES("562","79","MANDERA","");



DROP TABLE bank_transfer;

CREATE TABLE `bank_transfer` (
  `bank_transfer_id` int(10) NOT NULL AUTO_INCREMENT,
  `bank_transfer_code_id` int(11) NOT NULL,
  `exp_amount_received` varchar(100) NOT NULL,
  `bank_to_id` int(11) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  `sub_exp_desc` varchar(200) NOT NULL,
  PRIMARY KEY (`bank_transfer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO bank_transfer VALUES("4","3","5600000","20","18","54444sfgttt");



DROP TABLE bank_transfer_code;

CREATE TABLE `bank_transfer_code` (
  `bank_transfer_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_description` longtext NOT NULL,
  `exp_currency` int(11) NOT NULL,
  `exp_curr_rate` int(11) NOT NULL,
  `expense_receipt_no` varchar(100) NOT NULL,
  `expense_date` date NOT NULL,
  `expense_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expense_status` int(11) NOT NULL,
  `expense_recorded_by` int(11) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `our_bank_account_id` int(11) NOT NULL,
  `amount_credited` varchar(100) NOT NULL,
  `exp_voucher_no` varchar(100) NOT NULL,
  `exp_status` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `financial_year_id` int(11) NOT NULL,
  `exp_submitted_status` int(11) NOT NULL,
  PRIMARY KEY (`bank_transfer_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO bank_transfer_code VALUES("3","c ","7","1","c","2024-10-06","0000-00-00 00:00:00","0","100","17","19","5600000","BT0003","0","0","1","0");



DROP TABLE banks;

CREATE TABLE `banks` (
  `Bank_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Bank_Name` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `Bank_Initial` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`Bank_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO banks VALUES("2"," Absa Bank Tanzania","");
INSERT INTO banks VALUES("3"," Access Bank Tanzania","");
INSERT INTO banks VALUES("4"," Akiba Commercial Bank","");
INSERT INTO banks VALUES("5"," Amana Bank","");
INSERT INTO banks VALUES("6"," Azania Bank","");
INSERT INTO banks VALUES("7"," Bank of Africa Tanzania Limited","");
INSERT INTO banks VALUES("8"," Bank of Baroda Tanzania Limited","");
INSERT INTO banks VALUES("9"," Bank of India (Tanzania)","");
INSERT INTO banks VALUES("10"," Canara Bank Tanzania Limited","");
INSERT INTO banks VALUES("11"," China Dasheng Bank Limited","");
INSERT INTO banks VALUES("12"," Citibank Tanzania","");
INSERT INTO banks VALUES("13"," CRDB Bank","");
INSERT INTO banks VALUES("14"," DCB Commercial Bank","");
INSERT INTO banks VALUES("15"," Diamond Trust Bank Tanzania","");
INSERT INTO banks VALUES("16"," Ecobank Tanzania","");
INSERT INTO banks VALUES("17"," Equity Bank (Tanzania)","");
INSERT INTO banks VALUES("18"," Exim Bank (Tanzania)","");
INSERT INTO banks VALUES("19"," GTBank Tanzania","");
INSERT INTO banks VALUES("20"," Habib African Bank","");
INSERT INTO banks VALUES("21"," I&M Bank (Tanzania)","");
INSERT INTO banks VALUES("22"," ICBank Tanzania","");
INSERT INTO banks VALUES("23"," KCB Bank Tanzania","");
INSERT INTO banks VALUES("24"," Letshego Bank Tanzania","");
INSERT INTO banks VALUES("25"," Mkombozi Commercial Bank","");
INSERT INTO banks VALUES("26"," Mwalimu Commercial Bank","");
INSERT INTO banks VALUES("27"," National Bank of Commerce (Tanzania)","");
INSERT INTO banks VALUES("28"," National Microfinance Bank","");
INSERT INTO banks VALUES("29"," NCBA Bank Tanzania","");
INSERT INTO banks VALUES("30"," People\'s Bank of Zanzibar","");
INSERT INTO banks VALUES("31"," Stanbic Bank Tanzania Limited","");
INSERT INTO banks VALUES("32"," Standard Chartered Bank Tanzania","");
INSERT INTO banks VALUES("33"," Tanzania Commercial Bank","");
INSERT INTO banks VALUES("34"," UBA Bank Tanzania","");
INSERT INTO banks VALUES("35"," Mwanga Hakika Bank","");



DROP TABLE branch;

CREATE TABLE `branch` (
  `branch_id` int(10) NOT NULL AUTO_INCREMENT,
  `branch_name` varchar(100) NOT NULL,
  `contact_person` varchar(100) NOT NULL,
  `other_description` longtext NOT NULL,
  `email_address` varchar(100) NOT NULL,
  PRIMARY KEY (`branch_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO branch VALUES("1","Head Quarters","-","","");
INSERT INTO branch VALUES("2","Kisumu","-","","");



DROP TABLE budget;

CREATE TABLE `budget` (
  `budget_id` int(10) NOT NULL AUTO_INCREMENT,
  `budget_code_id` int(11) NOT NULL,
  `budget_amount` varchar(100) NOT NULL,
  `budget_month` varchar(50) NOT NULL,
  `imported_budget_id` int(11) NOT NULL,
  PRIMARY KEY (`budget_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE budget_code;

CREATE TABLE `budget_code` (
  `budget_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_description` varchar(100) NOT NULL,
  `currency` int(11) NOT NULL,
  `curr_rate` int(11) NOT NULL,
  `budget_receipt_no` varchar(100) NOT NULL,
  `budget_date` date NOT NULL,
  `budget_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `budget_year` varchar(100) NOT NULL,
  `budget_recorded_by` int(11) NOT NULL,
  `budget_account` int(11) NOT NULL,
  `imported_budget_id` int(11) NOT NULL,
  PRIMARY KEY (`budget_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE canceled_expenses_code;

CREATE TABLE `canceled_expenses_code` (
  `expense_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_description` longtext NOT NULL,
  `currency` int(11) NOT NULL,
  `curr_rate` int(11) NOT NULL,
  `expense_receipt_no` varchar(100) NOT NULL,
  `expense_date` date NOT NULL,
  `expense_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expense_status` int(11) NOT NULL,
  `expense_recorded_by` int(11) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `our_bank_account_id` int(11) NOT NULL,
  `amount_credited` varchar(100) NOT NULL,
  `mop_id` int(11) NOT NULL,
  `exp_voucher_no` varchar(100) NOT NULL,
  `exp_payee` varchar(300) NOT NULL,
  `exp_status` int(11) NOT NULL,
  `exp_approved_by` int(11) NOT NULL,
  `exp_datetime_approved` datetime NOT NULL,
  `exp_date_approved` date NOT NULL,
  `exp_approval_comment` longtext NOT NULL,
  PRIMARY KEY (`expense_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE canceled_loans;

CREATE TABLE `canceled_loans` (
  `applied_loan_id` int(11) NOT NULL,
  `loan_ref_no` varchar(200) NOT NULL,
  `member_id` int(100) NOT NULL,
  `group_id` int(11) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `date_applied` date NOT NULL,
  `loan_type_id` int(10) NOT NULL,
  `loan_product_id` int(11) NOT NULL,
  `amount_applied` varchar(50) NOT NULL,
  `cash_collateral_amount` varchar(100) NOT NULL,
  `cash_collateral_perc` varchar(100) NOT NULL,
  `interest_rate` varchar(50) NOT NULL,
  `loan_intr_mode` varchar(2) NOT NULL,
  `interest_rate_per_schedule` varchar(11) NOT NULL,
  `interest_amount` varchar(100) NOT NULL,
  `interest_amount_per_schedule` varchar(100) NOT NULL,
  `ttl_interest_amount` varchar(100) NOT NULL,
  `repay_interest_installment` varchar(100) NOT NULL,
  `repay_principle_installment` varchar(100) NOT NULL,
  `app_prnc_mor_period` varchar(10) NOT NULL,
  `app_intr_mor_period` varchar(10) NOT NULL,
  `amount_approved` varchar(10) NOT NULL,
  `repay_amount` varchar(100) NOT NULL,
  `guarantor1` int(11) NOT NULL,
  `guarantor2` int(11) NOT NULL,
  `guarantor3` int(11) NOT NULL,
  `procc_mode` varchar(20) NOT NULL,
  `procc_type` varchar(20) NOT NULL,
  `procc_rate` varchar(100) NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `ttl_proc_fees` varchar(100) NOT NULL,
  `ins_mode` varchar(50) NOT NULL,
  `insurance_rate` varchar(50) NOT NULL,
  `ins_type` varchar(50) NOT NULL,
  `insurance_amount` varchar(50) NOT NULL,
  `ttl_insurance` varchar(50) NOT NULL,
  `loan_security_fund_rate` varchar(50) NOT NULL,
  `loan_security_fund_amount` varchar(50) NOT NULL,
  `penalty_rate` varchar(50) NOT NULL,
  `calc_mode` varchar(10) NOT NULL,
  `repayment_schedule` varchar(100) NOT NULL,
  `repayment_period` int(15) NOT NULL,
  `repay_date` varchar(100) NOT NULL,
  `repay_day` varchar(100) NOT NULL,
  `grace_period` int(11) NOT NULL,
  `start_repayment_date` date NOT NULL,
  `end_repayment_date` date NOT NULL,
  `date_recorded` datetime NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(10) NOT NULL DEFAULT '1000000',
  `date_approved` date NOT NULL,
  `datetime_approved` datetime NOT NULL,
  `approval_reason` longtext NOT NULL,
  `verify_status` int(11) NOT NULL,
  `verify_by` int(11) NOT NULL,
  `verify_date` date NOT NULL,
  `datetime_verified` datetime NOT NULL,
  `verify_comments` varchar(400) NOT NULL,
  `paid_status` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `amount_paid` varchar(100) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `paid_reason` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  `api_ConversationID` varchar(400) NOT NULL,
  `loan_officer_id` int(11) NOT NULL,
  `officer_perc_comm` varchar(100) NOT NULL,
  `comm_amnt` varchar(100) NOT NULL,
  `memorandum_loan` varchar(5) NOT NULL,
  `memorandum_tranch_amount` varchar(100) NOT NULL,
  `memorandum_total_amount` varchar(100) NOT NULL,
  `top_up_loan_id` int(11) NOT NULL,
  `top_up_id` int(11) NOT NULL,
  `reschedule_id` int(11) NOT NULL,
  `reschedule_loan_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE canceled_loans_code;

CREATE TABLE `canceled_loans_code` (
  `canceled_loans_code_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `loan_id` int(10) NOT NULL,
  `date_canceled` date NOT NULL,
  `cancel_reasons` longtext COLLATE latin1_general_ci NOT NULL,
  `canceled_by` int(10) NOT NULL,
  `written_off` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `written_off_status` int(11) NOT NULL,
  `amount_written_off` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `written_off_approved_by` int(11) NOT NULL,
  `written_off_datetime_approved` datetime NOT NULL,
  `written_off_date_approved` date NOT NULL,
  `approval_comments` mediumtext COLLATE latin1_general_ci NOT NULL,
  `account_debited` int(11) NOT NULL,
  `account_credited` int(11) NOT NULL,
  `waiver` varchar(11) COLLATE latin1_general_ci NOT NULL,
  `waiver_status` int(11) NOT NULL,
  `amount_waived` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `waiver_approved_by` int(11) NOT NULL,
  `waiver_datetime_approved` datetime NOT NULL,
  `waiver_date_approved` date NOT NULL,
  `waiver_approval_comments` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `principle_waived` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `debit_principle_waived_account_id` int(11) NOT NULL,
  `interest_waived` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `debit_interest_waived_account_id` int(11) NOT NULL,
  `penalty_waived` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `debit_penalty_waived_account_id` int(11) NOT NULL,
  `waiver_credit_account_id` int(11) NOT NULL,
  PRIMARY KEY (`canceled_loans_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;




DROP TABLE canceled_loans_copy;

CREATE TABLE `canceled_loans_copy` (
  `applied_loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_ref_no` varchar(200) NOT NULL,
  `member_id` int(100) NOT NULL,
  `group_id` int(11) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `date_applied` date NOT NULL,
  `loan_type_id` int(10) NOT NULL,
  `loan_product_id` int(11) NOT NULL,
  `amount_applied` varchar(50) NOT NULL,
  `cash_collateral_amount` varchar(100) NOT NULL,
  `cash_collateral_perc` varchar(100) NOT NULL,
  `interest_rate` varchar(50) NOT NULL,
  `loan_intr_mode` varchar(2) NOT NULL,
  `interest_rate_per_schedule` varchar(11) NOT NULL,
  `interest_amount` varchar(100) NOT NULL,
  `interest_amount_per_schedule` varchar(100) NOT NULL,
  `ttl_interest_amount` varchar(100) NOT NULL,
  `repay_interest_installment` varchar(100) NOT NULL,
  `repay_principle_installment` varchar(100) NOT NULL,
  `amount_approved` varchar(10) NOT NULL,
  `repay_amount` varchar(100) NOT NULL,
  `guarantor1` int(11) NOT NULL,
  `guarantor2` int(11) NOT NULL,
  `guarantor3` int(11) NOT NULL,
  `procc_mode` varchar(20) NOT NULL,
  `procc_type` varchar(20) NOT NULL,
  `procc_rate` varchar(100) NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `ttl_proc_fees` varchar(100) NOT NULL,
  `ins_mode` varchar(50) NOT NULL,
  `insurance_rate` varchar(50) NOT NULL,
  `ins_type` varchar(50) NOT NULL,
  `insurance_amount` varchar(50) NOT NULL,
  `ttl_insurance` varchar(50) NOT NULL,
  `loan_security_fund_rate` varchar(50) NOT NULL,
  `loan_security_fund_amount` varchar(50) NOT NULL,
  `penalty_rate` varchar(50) NOT NULL,
  `calc_mode` varchar(10) NOT NULL,
  `repayment_schedule` varchar(100) NOT NULL,
  `repayment_period` int(15) NOT NULL,
  `repay_date` varchar(100) NOT NULL,
  `repay_day` varchar(100) NOT NULL,
  `grace_period` int(11) NOT NULL,
  `start_repayment_date` date NOT NULL,
  `end_repayment_date` date NOT NULL,
  `date_recorded` datetime NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(10) NOT NULL DEFAULT '1000000',
  `date_approved` date NOT NULL,
  `approval_reason` longtext NOT NULL,
  `paid_status` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `amount_paid` varchar(100) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `paid_reason` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  `api_ConversationID` varchar(400) NOT NULL,
  `loan_officer_id` int(11) NOT NULL,
  `officer_perc_comm` varchar(100) NOT NULL,
  `comm_amnt` varchar(100) NOT NULL,
  `memorandum_loan` varchar(100) NOT NULL,
  `memorandum_tranch_amount` varchar(100) NOT NULL,
  `memorandum_total_amount` varchar(100) NOT NULL,
  PRIMARY KEY (`applied_loan_id`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=latin1;

INSERT INTO canceled_loans_copy VALUES("3","SLD-LN03","2","0","","2021-11-18","1","0","3000","0","","0","M","0","0","0","0","0","3000","3000","3000","0","0","0","U","Percentage","8","240","240","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-03","2021-12-03","2021-12-09 11:12:26","139","0","0","0000-00-00","0","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("4","SLD-LN04","3","0","","2021-11-17","1","0","5000","","","0","M","0","0","0","0","0","5000","5000","5000","0","0","0","U","Percentage","8","400","400","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-02","2021-12-02","2021-12-09 11:19:55","139","0","0","0000-00-00","0","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("5","SLD-LN05","4","0","","2021-11-18","1","0","5000","0","","0","M","0","0","0","0","0","5000","5000","5000","0","0","0","U","Percentage","8","400","400","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-03","2021-12-03","2021-12-09 11:23:25","139","0","0","0000-00-00","0","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("7","SLD-LN07","5","0","","2021-11-17","1","0","10000","0","","0","M","0","0","0","0","0","10000","10000","10000","0","0","0","U","Percentage","8","800","800","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-02","2021-12-02","2021-12-09 11:53:39","139","0","0","0000-00-00","0","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("8","SLD-LN08","6","0","","2021-11-17","1","0","8000","0","","0","M","0","0","0","0","0","8000","8000","8000","0","0","0","U","Percentage","8","640","640","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-02","2021-12-02","2021-12-09 11:58:47","139","0","0","0000-00-00","0","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("9","SLD-LN09","7","0","","2021-11-17","1","0","3000","0","","0","M","0","0","0","0","0","3000","3000","3000","0","0","0","U","Percentage","8","240","240","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-02","2021-12-02","2021-12-09 12:04:35","139","0","0","0000-00-00","0","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("10","SLD-LN10","9","0","","2021-11-17","1","0","3000","0","","0","M","0","0","0","0","0","3000","3000","3000","0","0","0","U","Percentage","8","240","240","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-02","2021-12-02","2021-12-09 12:12:57","139","0","0","0000-00-00","0","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("11","SLD-LN11","17","0","","2021-11-16","1","0","4000","0","","0","M","0","0","0","0","0","4000","4000","4000","0","0","0","U","Percentage","8","320","320","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-01","2021-12-01","2021-12-09 13:40:51","139","0","0","0000-00-00","0","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("13","SLD-LN13","19","0","","2021-12-08","1","0","10000","","","0","M","0","0","0","0","0","10000","10000","10000","0","0","0","U","Percentage","8","800","800","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-23","2021-12-23","2021-12-10 11:54:39","139","0","0","0000-00-00","0","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("18","SLD-LN18","22","0","","2021-12-14","1","0","5000","0","","0","M","0","0","0","0","0","5000","","5000","0","0","0","U","Percentage","8","400","400","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-29","2021-12-29","2021-12-14 12:13:27","139","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("20","SAL-LN20","15","0","","2021-12-03","3","0","250000","0","","3","M","3","7500","7500","7500","7500","250000","","257500","0","0","0","U","Percentage","3","7500","7500","U","1.5","Percentage","3750","","0","0","10","S","Monthly","1","","","30","2022-01-02","2022-01-02","2021-12-15 17:15:59","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("29","SLD-LN29","10","0","","2021-12-14","1","0","10000","","","0","M","0","0","0","0","0","10000","10000","10000","0","0","0","U","Percentage","8","800","800","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-29","2021-12-29","2021-12-16 16:11:32","138","1","135","2021-12-14","confirmed details ok","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("31","SLD-LN31","17","0","","2021-12-14","1","0","6000","","","0","M","0","0","0","0","0","6000","6000","6000","0","0","0","U","Percentage","8","480","480","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-29","2021-12-29","2021-12-17 08:25:58","138","1","135","2021-12-14","confirmed details ok","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("34","SAL-LN34","32","0","","2021-12-17","3","0","50000","0","","3","M","3","1500","1500","7500","1500","10000","","57500","0","0","0","U","Percentage","3","1500","1500","U","1.5","Percentage","750","","0","0","10","S","Monthly","5","","","30","2022-01-16","2022-05-16","2021-12-22 14:51:11","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("36","SLD-LN36","16","0","","2021-12-06","1","0","5000","0","","0","M","0","0","0","0","0","5000","","5000","0","0","0","U","Percentage","8","400","400","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-21","2021-12-21","2021-12-22 14:57:53","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("37","SLD-LN37","3","0","","2021-12-08","1","0","9000","0","","0","M","0","0","0","0","0","9000","","9000","0","0","0","U","Percentage","8","720","720","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2021-12-23","2021-12-23","2021-12-22 15:01:04","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("49","SAL-LN49","38","0","","2021-12-21","3","0","100000","0","","3","M","3","3000","3000","36000","3000","8333.3333333333","","136000","0","0","0","U","Percentage","3","3000","3000","U","1.5","Percentage","1500","","0","0","10","S","Monthly","12","","","30","2022-01-20","2022-12-16","2021-12-30 09:59:05","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("70","SAL-LN70","42","0","","2022-01-07","3","0","100000","0","","3","M","3","3000","3000","36000","3000","8333.3333333333","","136000","0","0","0","U","Percentage","3","3000","3000","U","1.5","Percentage","1500","","0","0","10","S","Monthly","12","","","30","2022-02-06","2023-01-02","2022-01-08 12:14:06","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("73","SAL-LN73","43","0","","2022-01-07","3","0","100000","0","","3","M","3","3000","3000","36000","3000","8333.3333333333","","136000","0","0","0","U","Percentage","3","3000","3000","U","1.5","Percentage","1500","","0","0","10","S","Monthly","12","","","30","2022-02-06","2023-01-02","2022-01-08 21:09:24","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("75","SAL-LN75","7","0","","2022-01-06","3","0","30000","0","","3","M","3","900","900","10800","900","2500","","40800","0","0","0","U","Percentage","3","900","900","U","1.5","Percentage","450","","0","0","10","S","Monthly","12","","","30","2022-02-05","2023-01-01","2022-01-10 09:36:52","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("76","-LN76","0","0","","0000-00-00","0","0","","0","","","","","0","","","","","","0","0","0","0","","","","","","","","","","","","0","","","","0","","","0","1970-01-01","1970-01-01","2022-01-10 09:49:34","139","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("80","SAL-LN80","22","0","","2022-01-04","3","0","15000","0","","3","M","3","450","450","1350","450","5000","","16350","0","0","0","U","Percentage","3","450","450","U","1.5","Percentage","225","","0","0","10","S","Monthly","3","","","30","2022-02-03","2022-04-04","2022-01-10 10:11:15","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("81","SAL-LN81","43","0","","2022-01-07","3","0","80000","0","","3","M","3","2400","2400","28800","2400","6666.6666666667","","108800","0","0","0","U","Percentage","3","2400","2400","U","1.5","Percentage","1200","","0","0","10","S","Monthly","12","","","30","2022-02-06","2023-01-02","2022-01-10 10:13:45","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("86","SAL-LN86","47","0","","2022-01-11","3","0","1300000","0","","3","M","3","39000","39000","117000","39000","433333.33333333","","1417000","0","0","0","U","Percentage","3","39000","39000","U","1.5","Percentage","19500","","0","0","10","S","Monthly","3","","","30","2022-02-10","2022-04-11","2022-01-11 17:13:19","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("87","SAL-LN87","46","0","","2022-01-04","3","0","10000","0","","3","M","3","300","300","600","300","5000","","10600","0","0","0","U","Percentage","3","300","300","U","1.5","Percentage","150","","0","0","10","S","Monthly","2","","","30","2022-02-03","2022-03-05","2022-01-11 17:27:44","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("88","-LN88","0","0","","0000-00-00","0","0","","0","","","","","0","","","","","","0","0","0","0","","","","","","","","","","","","0","","","","0","","","0","1970-01-01","1970-01-01","2022-01-12 08:16:58","139","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("104","SAL-LN104","35","0","","2022-01-17","3","0","60000","0","","3","M","3","1800","1800","14400","1800","7500","","74400","0","0","0","U","Percentage","3","1800","1800","U","1.5","Percentage","900","","0","0","10","S","Monthly","8","","","30","2022-02-16","2022-09-14","2022-01-18 13:59:26","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("105","SLD-LN105","16","0","","2022-01-17","1","0","5000","0","","0","M","0","0","0","0","0","5000","","5000","0","0","0","U","Percentage","8","400","400","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2022-02-01","2022-02-01","2022-01-18 15:12:16","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("106","SLD-LN106","2","0","","2022-01-17","1","0","3000","0","","0","M","0","0","0","0","0","3000","","3000","0","0","0","U","Percentage","8","240","240","U","0","Percentage","0","","0","0","0","S","Monthly","1","","","15","2022-02-01","2022-02-01","2022-01-18 15:14:39","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("117","-LN117","0","0","","0000-00-00","0","0","","0","","","","","0","","","","","","0","0","0","0","","","","","","","","","","","","0","","","","0","","","0","1970-01-01","1970-01-01","2022-01-20 12:54:27","139","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("118","BLE-LN118","31","0","","2021-12-10","792","0","900000","0","","4","M","4","36000","36000","432000","36000","75000","900000","1332000","0","0","0","U","Percentage","3","27000","27000","U","0","Percentage","0","","","0","10","S","Monthly","12","","","30","2022-01-20","2022-12-16","2022-01-20 13:49:42","138","0","0","0000-00-00","0","1","2021-12-21","873000.00","3","2022-01-20 16:30:31","136","","3","","0","","","","0","0","0","0","","138","","0","","","");
INSERT INTO canceled_loans_copy VALUES("122","SAL-LN122","17","0","","2022-01-13","3","0","50000","0","","3","M","3","1500","1500","18000","1500","4166.6666666667","","68000","0","0","0","U","Percentage","3","1500","1500","U","1.5","Percentage","750","","0","0","10","S","Monthly","12","","","30","2022-02-12","2023-01-08","2022-01-25 10:46:04","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","138","","","","","");
INSERT INTO canceled_loans_copy VALUES("139","SAL-LN139","58","0","","2022-01-18","3","0","30000","0","","3","M","3","900","900","10800","900","2500","","40800","0","0","0","U","Percentage","3","900","900","U","1.5","Percentage","450","","0","0","10","S","Monthly","12","","","30","2022-02-17","2023-01-13","2022-02-14 11:15:56","139","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("152","-LN152","0","0","","0000-00-00","0","0","","0","","","","","0","","","","","","0","0","0","0","","","","","","","","","","","","0","","","","0","","","0","1970-01-01","1970-01-01","2022-02-16 12:45:39","138","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","0","","","","","");
INSERT INTO canceled_loans_copy VALUES("156","BLE-LN156","73","0","","2022-02-19","792","0","252000","","","3","M","3","7560","7560","136080","7560","14000","","388080","0","0","0","","","","","","","","","","","","","","S","Monthly","18","","","0","1970-01-01","1971-05-26","2022-02-19 10:21:41","139","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("157","SAL-LN157","47","0","","2022-02-19","3","0","750000","0","","3","M","3","22500","22500","67500","22500","250000","","817500","0","0","0","U","Percentage","3","22500","22500","U","1.5","Percentage","11250","","0","0","10","S","Monthly","3","","","30","2022-03-21","2022-05-20","2022-02-21 13:25:27","139","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","139","","","","","");
INSERT INTO canceled_loans_copy VALUES("165","BLE-LN165","78","0","","2022-02-25","792","0","56000","","","3","M","3","1680","1680","20160","1680","4666.6666666667","","76160","0","0","0","","","","","","","","","","","","","","S","Monthly","12","","","0","0000-00-00","0000-00-00","2022-03-03 13:10:53","141","0","1000000","0000-00-00","","0","0000-00-00","","0","0000-00-00 00:00:00","0","","0","","0","","","","0","0","0","0","","141","","","NO","","0");



DROP TABLE canceled_loans_old;

CREATE TABLE `canceled_loans_old` (
  `applied_loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_ref_no` varchar(200) NOT NULL,
  `member_id` int(100) NOT NULL,
  `group_id` int(11) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `date_applied` date NOT NULL,
  `loan_type_id` int(10) NOT NULL,
  `loan_product_id` int(11) NOT NULL,
  `amount_applied` varchar(50) NOT NULL,
  `cash_collateral_amount` varchar(100) NOT NULL,
  `cash_collateral_perc` varchar(100) NOT NULL,
  `interest_rate` varchar(50) NOT NULL,
  `interest_amount` varchar(100) NOT NULL,
  `repay_interest_installment` varchar(100) NOT NULL,
  `repay_principle_installment` varchar(100) NOT NULL,
  `amount_approved` varchar(10) NOT NULL,
  `repay_amount` varchar(100) NOT NULL,
  `guarantor1` int(11) NOT NULL,
  `guarantor2` int(11) NOT NULL,
  `guarantor3` int(11) NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `repayment_schedule` varchar(100) NOT NULL,
  `repayment_period` varchar(15) NOT NULL,
  `repay_date` varchar(100) NOT NULL,
  `repay_day` varchar(100) NOT NULL,
  `grace_period` int(11) NOT NULL,
  `start_repayment_date` date NOT NULL,
  `end_repayment_date` date NOT NULL,
  `date_recorded` datetime NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(10) NOT NULL DEFAULT '1000000',
  `date_approved` date NOT NULL,
  `approval_reason` longtext NOT NULL,
  `paid_status` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `amount_paid` varchar(100) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `paid_reason` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  PRIMARY KEY (`applied_loan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE canceled_loans_old2;

CREATE TABLE `canceled_loans_old2` (
  `applied_loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_ref_no` varchar(200) NOT NULL,
  `member_id` int(100) NOT NULL,
  `group_id` int(11) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `date_applied` date NOT NULL,
  `loan_type_id` int(10) NOT NULL,
  `loan_product_id` int(11) NOT NULL,
  `amount_applied` varchar(50) NOT NULL,
  `cash_collateral_amount` varchar(100) NOT NULL,
  `cash_collateral_perc` varchar(100) NOT NULL,
  `interest_rate` varchar(50) NOT NULL,
  `interest_rate_per_schedule` varchar(11) NOT NULL,
  `interest_amount` varchar(100) NOT NULL,
  `interest_amount_per_schedule` varchar(100) NOT NULL,
  `ttl_interest_amount` varchar(100) NOT NULL,
  `repay_interest_installment` varchar(100) NOT NULL,
  `repay_principle_installment` varchar(100) NOT NULL,
  `amount_approved` varchar(10) NOT NULL,
  `repay_amount` varchar(100) NOT NULL,
  `guarantor1` int(11) NOT NULL,
  `guarantor2` int(11) NOT NULL,
  `guarantor3` int(11) NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `ttl_proc_fees` varchar(100) NOT NULL,
  `repayment_schedule` varchar(100) NOT NULL,
  `repayment_period` int(15) NOT NULL,
  `repay_date` varchar(100) NOT NULL,
  `repay_day` varchar(100) NOT NULL,
  `grace_period` int(11) NOT NULL,
  `start_repayment_date` date NOT NULL,
  `end_repayment_date` date NOT NULL,
  `date_recorded` datetime NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(10) NOT NULL DEFAULT '1000000',
  `date_approved` date NOT NULL,
  `approval_reason` longtext NOT NULL,
  `paid_status` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `amount_paid` varchar(100) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `paid_reason` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  `api_ConversationID` varchar(400) NOT NULL,
  PRIMARY KEY (`applied_loan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE canceled_loans_old3;

CREATE TABLE `canceled_loans_old3` (
  `applied_loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_ref_no` varchar(200) NOT NULL,
  `member_id` int(100) NOT NULL,
  `group_id` int(11) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `date_applied` date NOT NULL,
  `loan_type_id` int(10) NOT NULL,
  `loan_product_id` int(11) NOT NULL,
  `amount_applied` varchar(50) NOT NULL,
  `cash_collateral_amount` varchar(100) NOT NULL,
  `cash_collateral_perc` varchar(100) NOT NULL,
  `interest_rate` varchar(50) NOT NULL,
  `interest_rate_per_schedule` varchar(11) NOT NULL,
  `interest_amount` varchar(100) NOT NULL,
  `interest_amount_per_schedule` varchar(100) NOT NULL,
  `ttl_interest_amount` varchar(100) NOT NULL,
  `repay_interest_installment` varchar(100) NOT NULL,
  `repay_principle_installment` varchar(100) NOT NULL,
  `amount_approved` varchar(10) NOT NULL,
  `repay_amount` varchar(100) NOT NULL,
  `guarantor1` int(11) NOT NULL,
  `guarantor2` int(11) NOT NULL,
  `guarantor3` int(11) NOT NULL,
  `procc_mode` varchar(20) NOT NULL,
  `procc_type` varchar(20) NOT NULL,
  `procc_rate` varchar(100) NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `ttl_proc_fees` varchar(100) NOT NULL,
  `ins_mode` varchar(50) NOT NULL,
  `insurance_rate` varchar(50) NOT NULL,
  `ins_type` varchar(50) NOT NULL,
  `insurance_amount` varchar(50) NOT NULL,
  `ttl_insurance` varchar(50) NOT NULL,
  `loan_security_fund_rate` varchar(50) NOT NULL,
  `loan_security_fund_amount` varchar(50) NOT NULL,
  `penalty_rate` varchar(50) NOT NULL,
  `calc_mode` varchar(10) NOT NULL,
  `repayment_schedule` varchar(100) NOT NULL,
  `repayment_period` int(15) NOT NULL,
  `repay_date` varchar(100) NOT NULL,
  `repay_day` varchar(100) NOT NULL,
  `grace_period` int(11) NOT NULL,
  `start_repayment_date` date NOT NULL,
  `end_repayment_date` date NOT NULL,
  `date_recorded` datetime NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(10) NOT NULL DEFAULT '1000000',
  `date_approved` date NOT NULL,
  `approval_reason` longtext NOT NULL,
  `paid_status` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `amount_paid` varchar(100) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `paid_reason` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  `api_ConversationID` varchar(400) NOT NULL,
  PRIMARY KEY (`applied_loan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE canceled_supplier_payment_code;

CREATE TABLE `canceled_supplier_payment_code` (
  `canceled_supplier_payment_code` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `supplier_payment_code_id` int(10) NOT NULL,
  `date_canceled` date NOT NULL,
  `cancel_reasons` longtext COLLATE latin1_general_ci NOT NULL,
  `canceled_by` int(10) NOT NULL,
  `written_off` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `written_off_status` int(11) NOT NULL,
  `amount_written_off` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `written_off_approved_by` int(11) NOT NULL,
  `written_off_datetime_approved` datetime NOT NULL,
  `written_off_date_approved` date NOT NULL,
  `approval_comments` mediumtext COLLATE latin1_general_ci NOT NULL,
  `account_debited` int(11) NOT NULL,
  `account_credited` int(11) NOT NULL,
  PRIMARY KEY (`canceled_supplier_payment_code`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO canceled_supplier_payment_code VALUES("3","81","2022-11-14","payment allocation revised","137","","0","","0","0000-00-00 00:00:00","0000-00-00","","0","0");



DROP TABLE chart_transaction_statement;

CREATE TABLE `chart_transaction_statement` (
  `chart_trans_statement_id` int(11) NOT NULL AUTO_INCREMENT,
  `imported_statement_code_id` int(11) NOT NULL,
  `chart_transaction_id` int(11) NOT NULL,
  `chart_transaction_date` date NOT NULL,
  `chart_transaction_ref_no` varchar(300) NOT NULL,
  `chart_transaction_memo` longtext NOT NULL,
  `chart_trans_debit` varchar(300) NOT NULL,
  `chart_trans_credit` varchar(100) NOT NULL,
  PRIMARY KEY (`chart_trans_statement_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE chart_transactions;

CREATE TABLE `chart_transactions` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `transaction_section` varchar(200) NOT NULL,
  `memo` longtext NOT NULL,
  `amount` varchar(100) NOT NULL,
  `debit` varchar(100) NOT NULL,
  `credit` varchar(100) NOT NULL,
  `currency` int(10) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `transaction_date` date NOT NULL,
  `l_day` varchar(10) NOT NULL,
  `l_month` varchar(10) NOT NULL,
  `l_year` varchar(10) NOT NULL,
  `transaction_datetime_recorded` datetime NOT NULL,
  `transaction_code` varchar(100) NOT NULL,
  `closing_status` int(11) NOT NULL,
  `closing_date` date NOT NULL,
  `transaction_status` int(11) NOT NULL,
  `transaction_status1` int(11) NOT NULL,
  `transaction_status2` int(11) NOT NULL,
  `transaction_user_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `department_code` varchar(10) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `financial_year_id` int(11) NOT NULL,
  `customer_invoice_code_id` int(11) NOT NULL,
  `customer_invoice_id` int(11) NOT NULL,
  `customer_payment_code_id` int(11) NOT NULL,
  `customer_payment_id` int(11) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `supplier_invoice_code_id` int(11) NOT NULL,
  `supplier_invoice_id` int(11) NOT NULL,
  `supplier_payment_code_id` int(11) NOT NULL,
  `supplier_payment_id` int(11) NOT NULL,
  `receipt_code_id` int(11) NOT NULL,
  `receipt_id` int(11) NOT NULL,
  `receipt_transaction_type_id` int(11) NOT NULL,
  `member_id` int(11) NOT NULL,
  `expenses_code_id` int(11) NOT NULL,
  `expenses_id` int(11) NOT NULL,
  `general_journal_id` int(11) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `loan_repayment_id` int(11) NOT NULL,
  `disbursed_loan_id` int(11) NOT NULL,
  `bank_transfer_code_id` int(11) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=latin1;

INSERT INTO chart_transactions VALUES("1","6","OTHER-RECPT","Payment Received For Shares received from <a href=\"home.php?receipt_payments&sales_id=29&sub_module_id=176\">02001 ALLY  SALIM MRUTU Ref No : 000546, Receipt No :000546 </a><i>(shares)</i>","560000","","560000","7","1","2024-10-08","","","","0000-00-00 00:00:00","cr-recpt72","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","29","72","1","3","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("2","17","OTHER-RECPT","Payment Received From <a href=\"home.php?receipt_payments&sales_id=29&sub_module_id=176\">02001 ALLY  SALIM MRUTU Ref No : 000546, Receipt No :000546 </a><i>(ggggggggggggg)</i>","560000","560000","","7","1","2024-10-08","","","","0000-00-00 00:00:00","dr-recpt29","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","29","0","1","3","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("3","6","OTHER-PYMNT","Payment Made For Shares To <a href=\"home.php?receipt_payments&sales_id=30&sub_module_id=176\">02001 ALLY  SALIM MRUTU Ref No : 00546, Receipt No :00546 </a><i>(withdrawal of shares)</i>","-200000","200000","","7","1","2024-10-08","","","","0000-00-00 00:00:00","cr-recpt73","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","30","73","1","3","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("4","17","OTHER-PYMNT","Payment Made To <a href=\"home.php?receipt_payments&sales_id=30&sub_module_id=176\">02001 ALLY  SALIM MRUTU Ref No : 00546, Voucher No :00546 </a><i>(food)</i>","-200000","","200000","7","1","2024-10-08","","","","0000-00-00 00:00:00","dr-recpt30","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","30","0","1","3","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("5","19","LOANREP","Loan repayment for the loan . Loan Ref No. MWD-LN18 received from customer ANNETE  CLOUTAS DJUING","-166944.52","166944.52","","7","1","2024-10-10","10","10","2024","2024-10-10 10:50:44","drlnrep18","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("6","2","LOANREP","Principle repayment for the loan . Loan Ref No. MWD-LN18 whose due date was 2024-10-02 received from customer ANNETE  CLOUTAS DJUING","-166527.85","","166527.85","7","1","2024-10-10","10","10","2024","2024-10-10 10:50:44","crprncrep8","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("7","16","LOANREP","Interest repayment for the loan . Loan Ref No. MWD-LN18 whose due date was 2024-10-02 received from customer ANNETE  CLOUTAS DJUING","-416.67","","416.67","7","1","2024-10-10","10","10","2024","2024-10-10 10:50:44","crintrep8","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("8","10","OTHER-RECPT","Payment Received For Savings received from <a href=\"home.php?receipt_payments&sales_id=31&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : 9, Receipt No :9 </a><i>(ddd)</i>","670000","","670000","7","1","2024-11-16","","","","0000-00-00 00:00:00","cr-recpt74","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","31","74","2","26","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("9","18","OTHER-RECPT","Payment Received From <a href=\"home.php?receipt_payments&sales_id=31&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : 9, Receipt No :9 </a><i>(h)</i>","670000","670000","","7","1","2024-11-16","","","","0000-00-00 00:00:00","dr-recpt31","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","31","0","2","26","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("10","10","OTHER-RECPT","Payment Received For Savings received from <a href=\"home.php?receipt_payments&sales_id=32&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : nnn, Receipt No :nnn </a><i>(nn)</i>","50000","","50000","7","1","2024-11-18","","","","0000-00-00 00:00:00","cr-recpt75","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","32","75","2","26","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("11","6","OTHER-RECPT","Payment Received For Shares received from <a href=\"home.php?receipt_payments&sales_id=32&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : nnn, Receipt No :nnn </a><i>(mm)</i>","50000","","50000","7","1","2024-11-18","","","","0000-00-00 00:00:00","cr-recpt76","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","32","76","1","26","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("12","8","OTHER-RECPT","Payment Received For Deposit received from <a href=\"home.php?receipt_payments&sales_id=32&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : nnn, Receipt No :nnn </a><i>(mmm)</i>","50000","","50000","7","1","2024-11-18","","","","0000-00-00 00:00:00","cr-recpt77","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","32","77","3","26","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("13","18","OTHER-RECPT","Payment Received From <a href=\"home.php?receipt_payments&sales_id=32&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : nnn, Receipt No :nnn </a><i>(mm)</i>","150000","150000","","7","1","2024-11-18","","","","0000-00-00 00:00:00","dr-recpt32","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","32","0","3","26","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("14","7","OTHER-RECPT","Payment Received For Savings received from <a href=\"home.php?receipt_payments&sales_id=35&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : LJKL, Receipt No :LJKL </a><i>(SHARE)</i>","500000","","500000","7","1","2024-12-31","","","","0000-00-00 00:00:00","cr-recpt78","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","35","78","2","26","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("15","6","OTHER-RECPT","Payment Received For Shares received from <a href=\"home.php?receipt_payments&sales_id=35&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : LJKL, Receipt No :LJKL </a><i>(SHARE)</i>","200000","","200000","7","1","2024-12-31","","","","0000-00-00 00:00:00","cr-recpt79","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","35","79","1","26","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("16","19","OTHER-RECPT","Payment Received From <a href=\"home.php?receipt_payments&sales_id=35&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : LJKL, Receipt No :LJKL </a><i>(DEPOSIT)</i>","700000","700000","","7","1","2024-12-31","","","","0000-00-00 00:00:00","dr-recpt35","0","0000-00-00","0","0","0","100","5","","0","1","0","0","0","0","0","0","0","0","0","35","0","1","26","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("17","17","LN-DISB","Disbursement Of Loan Type  Jazz Microfinance 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=22&sub_module_id=116\">Loan Ref No 4557-LN22</a>","1500000.00","","1500000.00","7","1","2025-02-19","","","","0000-00-00 00:00:00","cr-or22","0","0000-00-00","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","22","0");
INSERT INTO chart_transactions VALUES("18","2","LN-DISB","Disbursement Of Loan Type  Jazz Microfinance 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=22&sub_module_id=116\">Loan Ref No 4557-LN22</a>","1500000.00","1500000.00","","7","1","2025-02-19","","","","0000-00-00 00:00:00","dr-or22","0","0000-00-00","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","22","0");
INSERT INTO chart_transactions VALUES("19","2","LN-DISB","Disbursement Of Loan Type  Jazz Microfinance 
To Member EVANCE  CHARLES THOMAS <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=23&sub_module_id=116\">Loan Ref No 4557-INVST23</a>","1500000","1500000","","7","1","2025-02-19","19","02","2025","0000-00-00 00:00:00","dr-or23","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","23","0");
INSERT INTO chart_transactions VALUES("20","17","LN-DISB","Disbursement Of Loan Type  Jazz Microfinance 
To Member EVANCE  CHARLES THOMAS <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=23&sub_module_id=116\">Loan Ref No 4557-INVST23</a>","-1500000","","1500000","7","1","2025-02-19","19","02","2025","0000-00-00 00:00:00","cr-or23","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","23","0");
INSERT INTO chart_transactions VALUES("21","2","LN-DISB","Disbursement Of Loan Type  Jazz Microfinance 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=24&sub_module_id=116\">Loan Ref No 4557-INVST24</a>","1500000","1500000","","7","1","2025-02-19","19","02","2025","0000-00-00 00:00:00","dr-or24","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","24","0");
INSERT INTO chart_transactions VALUES("22","17","LN-DISB","Disbursement Of Loan Type  Jazz Microfinance 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=24&sub_module_id=116\">Loan Ref No 4557-INVST24</a>","-1500000","","1500000","7","1","2025-02-19","19","02","2025","0000-00-00 00:00:00","cr-or24","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","24","0");
INSERT INTO chart_transactions VALUES("23","2","LN-DISB","Disbursement Of Loan Type  Jazz Microfinance 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=25&sub_module_id=116\">Loan Ref No 4557-INVST25</a>","1500000","1500000","","7","1","2025-02-19","19","02","2025","0000-00-00 00:00:00","dr-or25","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","25","0");
INSERT INTO chart_transactions VALUES("24","17","LN-DISB","Disbursement Of Loan Type  Jazz Microfinance 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=25&sub_module_id=116\">Loan Ref No 4557-INVST25</a>","-1500000","","1500000","7","1","2025-02-19","19","02","2025","0000-00-00 00:00:00","cr-or25","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","25","0");
INSERT INTO chart_transactions VALUES("25","0","OTHR-REV","Revenue on Processing fee recovered from <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=26&sub_module_id=116\">loan ref 786-INVST26</a>","-4.0745362639427E-10","","-4.0745362639427E-10","7","1","2024-12-02","02","12","2024","0000-00-00 00:00:00","cr-or26-1000002","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("26","2","OTHR-REV","Revenue on Processing fee recovered from <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=26&sub_module_id=116\">loan ref 786-INVST26</a>","","","","7","1","2024-12-02","02","12","2024","0000-00-00 00:00:00","dr-or26-1000002","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("27","2","LN-DISB","Disbursement Of Loan Type  jazz loan 
To Member DANIEL  P URASSA <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=26&sub_module_id=116\">Loan Ref No 786-INVST26</a>","1500000","1500000","","7","1","2024-12-02","02","12","2024","0000-00-00 00:00:00","dr-or26","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","26","0");
INSERT INTO chart_transactions VALUES("28","17","LN-DISB","Disbursement Of Loan Type  jazz loan 
To Member DANIEL  P URASSA <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=26&sub_module_id=116\">Loan Ref No 786-INVST26</a>","-1500000","","1500000","7","1","2024-12-02","02","12","2024","0000-00-00 00:00:00","cr-or26","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","26","0");
INSERT INTO chart_transactions VALUES("29","0","OTHR-REV","Revenue on Processing fee recovered from <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=27&sub_module_id=116\">loan ref 564324-INVST27</a>","9.837094694376E-10","","9.837094694376E-10","7","1","2024-10-01","01","10","2024","0000-00-00 00:00:00","cr-or27-1000003","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("30","2","OTHR-REV","Revenue on Processing fee recovered from <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=27&sub_module_id=116\">loan ref 564324-INVST27</a>","","","","7","1","2024-10-01","01","10","2024","0000-00-00 00:00:00","dr-or27-1000003","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("31","2","LN-DISB","Disbursement Of Loan Type  foesight loan 
To Member NOLLO TIMOTH TIMOTH <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=27&sub_module_id=116\">Loan Ref No 564324-INVST27</a>","1500000","1500000","","7","1","2024-10-01","01","10","2024","0000-00-00 00:00:00","dr-or27","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","27","0");
INSERT INTO chart_transactions VALUES("32","19","LN-DISB","Disbursement Of Loan Type  foesight loan 
To Member NOLLO TIMOTH TIMOTH <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=27&sub_module_id=116\">Loan Ref No 564324-INVST27</a>","-1500000","","1500000","7","1","2024-10-01","01","10","2024","0000-00-00 00:00:00","cr-or27","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","27","0");
INSERT INTO chart_transactions VALUES("33","19","LN-DISB","Disbursement Of Loan Type  foesight loan 
To Member NOREEN ERNEST MSUYA <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=28&sub_module_id=116\">Loan Ref No 564324-LN28</a>","1350000.00","","1350000.00","7","1","2024-09-02","","","","0000-00-00 00:00:00","cr-or28","0","0000-00-00","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","28","0");
INSERT INTO chart_transactions VALUES("34","2","LN-DISB","Disbursement Of Loan Type  foesight loan 
To Member NOREEN ERNEST MSUYA <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=28&sub_module_id=116\">Loan Ref No 564324-LN28</a>","1350000.00","1350000.00","","7","1","2024-09-02","","","","0000-00-00 00:00:00","dr-or28","0","0000-00-00","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","28","0");
INSERT INTO chart_transactions VALUES("35","19","LN-DISB","Disbursement Of Loan Type  foresight loan 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=29&sub_module_id=116\">Loan Ref No 564324-LN29</a>","1350000.00","","1350000.00","7","1","2024-03-01","","","","0000-00-00 00:00:00","cr-or29","0","0000-00-00","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","29","0");
INSERT INTO chart_transactions VALUES("36","2","LN-DISB","Disbursement Of Loan Type  foresight loan 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=29&sub_module_id=116\">Loan Ref No 564324-LN29</a>","1350000.00","1350000.00","","7","1","2024-03-01","","","","0000-00-00 00:00:00","dr-or29","0","0000-00-00","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","29","0");
INSERT INTO chart_transactions VALUES("37","17","LN-DISB","Disbursement Of Loan Type  LAWI 
To Member LAWIN LEWIN LIWIN <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=31&sub_module_id=116\">Loan Ref No TY6-LN31</a>","1350000.00","","1350000.00","7","1","2025-01-02","","","","0000-00-00 00:00:00","cr-or31","0","0000-00-00","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","31","0");
INSERT INTO chart_transactions VALUES("38","2","LN-DISB","Disbursement Of Loan Type  LAWI 
To Member LAWIN LEWIN LIWIN <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=31&sub_module_id=116\">Loan Ref No TY6-LN31</a>","1350000.00","1350000.00","","7","1","2025-01-02","","","","0000-00-00 00:00:00","dr-or31","0","0000-00-00","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","31","0");
INSERT INTO chart_transactions VALUES("39","19","LOANREP","Loan repayment for the loan . Loan Ref No. TY6-LN31 received from customer LAWIN LEWIN LIWIN","-281502.31","281502.31","","7","1","2025-03-09","09","03","2025","2025-03-09 12:56:51","drlnrep19","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("40","2","LOANREP","Principle repayment for the loan . Loan Ref No. TY6-LN31 whose due date was 2025-02-01 received from customer LAWIN LEWIN LIWIN","-229002.31","","229002.31","7","1","2025-03-09","09","03","2025","2025-03-09 12:56:51","crprncrep9","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("41","15","LOANREP","Interest repayment for the loan . Loan Ref No. TY6-LN31 whose due date was 2025-02-01 received from customer LAWIN LEWIN LIWIN","-52500","","52500","7","1","2025-03-09","09","03","2025","2025-03-09 12:56:51","crintrep9","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("42","2","LN-DISB","Disbursement Of Loan Type  DEVELOPMENT LOANS 
To Member SABA NAEL KIBU <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=32&sub_module_id=116\">Loan Ref No DVLP-INVST32</a>","1000000","1000000","","7","1","2025-03-17","17","03","2025","0000-00-00 00:00:00","dr-or32","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","32","0");
INSERT INTO chart_transactions VALUES("43","17","LN-DISB","Disbursement Of Loan Type  DEVELOPMENT LOANS 
To Member SABA NAEL KIBU <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=32&sub_module_id=116\">Loan Ref No DVLP-INVST32</a>","-1000000","","1000000","7","1","2025-03-17","17","03","2025","0000-00-00 00:00:00","cr-or32","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","32","0");
INSERT INTO chart_transactions VALUES("44","25","EXP","Payment For Expenses To <a href=\"home.php?cancelpayroll=cancelpayroll&sales_id=6&sub_module_id=205\">NALIA LIA Ref No : 55YT, Receipt No :PM00006 </a><i>(NAULI)</i>","1000","1000","","7","1","2025-03-03","","","","0000-00-00 00:00:00","dr-exp7","0","0000-00-00","0","0","0","100","0","","0","1","0","0","0","0","0","0","0","0","0","0","0","12","0","6","7","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("45","19","EXP","Expenses Paid To <a href=\"home.php?cancelpayroll=cancelpayroll&sales_id=6&sub_module_id=205\">NALIA LIA Ref No : 55YT, Receipt No :PM00006 </a><i>(nAULI)</i>","1000","","1000","7","1","2025-03-03","","","","0000-00-00 00:00:00","cr-exp6","0","0000-00-00","0","0","0","100","0","","0","1","0","0","0","0","0","0","0","0","0","0","0","0","0","6","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("46","2","LN-DISB","Disbursement Of Loan Type  DEVELOPMENT LOANS 
To Member PROSPER JOSEPH SAKU <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=33&sub_module_id=116\">Loan Ref No DVLP-INVST33</a>","1000000","1000000","","7","1","2025-03-01","01","03","2025","0000-00-00 00:00:00","dr-or33","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","33","0");
INSERT INTO chart_transactions VALUES("47","19","LN-DISB","Disbursement Of Loan Type  DEVELOPMENT LOANS 
To Member PROSPER JOSEPH SAKU <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=33&sub_module_id=116\">Loan Ref No DVLP-INVST33</a>","-1000000","","1000000","7","1","2025-03-01","01","03","2025","0000-00-00 00:00:00","cr-or33","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","33","0");
INSERT INTO chart_transactions VALUES("48","21","JNTR","hello","5000","5000","","6","1","2025-04-08","08","04","2025","2025-04-06 12:10:09","dr-exp1","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("49","17","JNTR","hello","-5000","","5000","6","1","2025-04-08","08","04","2025","2025-04-06 12:10:09","cr-exp1","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("50","22","JNTR","i need mon","50000","50000","","6","1","2025-04-07","07","04","2025","2025-04-06 12:17:52","dr-exp2","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");
INSERT INTO chart_transactions VALUES("51","1","JNTR","i need mon","-50000","","50000","6","1","2025-04-07","07","04","2025","2025-04-06 12:17:52","cr-exp2","0","0000-00-00","0","0","0","100","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0");



DROP TABLE chart_transactions_olddd;

CREATE TABLE `chart_transactions_olddd` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `transaction_section` varchar(200) NOT NULL,
  `memo` longtext NOT NULL,
  `amount` varchar(100) NOT NULL,
  `debit` varchar(100) NOT NULL,
  `credit` varchar(100) NOT NULL,
  `currency` int(10) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `transaction_date` date NOT NULL,
  `l_day` varchar(10) NOT NULL,
  `l_month` varchar(10) NOT NULL,
  `l_year` varchar(10) NOT NULL,
  `transaction_datetime_recorded` date NOT NULL,
  `transaction_code` varchar(100) NOT NULL,
  `closing_status` int(11) NOT NULL,
  `closing_date` date NOT NULL,
  `transaction_status` int(11) NOT NULL,
  `transaction_status1` int(11) NOT NULL,
  `transaction_status2` int(11) NOT NULL,
  `transaction_user_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `department_code` varchar(10) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

INSERT INTO chart_transactions_olddd VALUES("1","56","INTR","Interest Due For the Month Of May,2024 <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=1&sub_module_id=116\">loan ID DVLP-LN1</a>","10000","","10000","7","1","2024-05-20","","","","0000-00-00","int_rev_cr1-05-2024","0","0000-00-00","0","0","0","0","0","");
INSERT INTO chart_transactions_olddd VALUES("2","122","INTR","Interest Due For the Month Of May,2024 <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=1&sub_module_id=116\">loan ID DVLP-LN1</a>","10000","10000","","7","1","2024-05-20","","","","0000-00-00","int_rev_dr1-05-2024","0","0000-00-00","0","0","0","0","0","");
INSERT INTO chart_transactions_olddd VALUES("3","56","INTR","Interest Due For the Month Of May,2024 <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=2&sub_module_id=116\">loan ID DVLP-LN2</a>","40000","","40000","7","1","2024-05-20","","","","0000-00-00","int_rev_cr2-05-2024","0","0000-00-00","0","0","0","0","0","");
INSERT INTO chart_transactions_olddd VALUES("4","122","INTR","Interest Due For the Month Of May,2024 <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=2&sub_module_id=116\">loan ID DVLP-LN2</a>","40000","40000","","7","1","2024-05-20","","","","0000-00-00","int_rev_dr2-05-2024","0","0000-00-00","0","0","0","0","0","");
INSERT INTO chart_transactions_olddd VALUES("5","3","RECPT","Received Payments From <a href=\"home.php?receipt_customer&sales_id=125&sub_module_id=176\"> Ref No : 0097, Receipt No: RCT00125 </a><i>(shares received)</i>","","","400000","7","1","2024-05-20","20","05","2024","0000-00-00","dr-recpt125","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("6","199","RECPT","Received Payments From <a href=\"home.php?receipt_customer&sales_id=125&sub_module_id=176\"> Ref No : 0097, Receipt No: RCT00125 </a><i>(shares received)</i>","","400000","","7","1","2024-05-20","20","05","2024","0000-00-00","cr-recpt126","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("7","126","EXP","VAT On Receipt Customer <a href=\"home.php?receipt_customer&sales_id=125&sub_module_id=176\"> Receipt no : RCT00125, Ref No : 0097  </a><i>(shares received)</i>","0","0","","7","1","2024-05-20","20","05","2024","0000-00-00","cr-recpt-vat126","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("8","3","RECPT","Received Payments From <a href=\"home.php?receipt_customer&sales_id=1&sub_module_id=176\"> Ref No : 0097, Receipt No: RCT00001 </a><i>(Amount received for shares)</i>","","","400000","7","1","2024-05-20","20","05","2024","0000-00-00","dr-recpt1","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("9","199","RECPT","Received Payments From <a href=\"home.php?receipt_customer&sales_id=1&sub_module_id=176\"> Ref No : 0097, Receipt No: RCT00001 </a><i>(Amount received for shares)</i>","","400000","","7","1","2024-05-20","20","05","2024","0000-00-00","cr-recpt1","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("10","126","EXP","VAT On Receipt Customer <a href=\"home.php?receipt_customer&sales_id=1&sub_module_id=176\"> Receipt no : RCT00001, Ref No : 0097  </a><i>(Amount received for shares)</i>","0","0","","7","1","2024-05-20","20","05","2024","0000-00-00","cr-recpt-vat1","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("11","3","LOANREP","Loan repayment for the loan . Loan Ref No. DVLP-LN2 received from customer JOHN  KIMWAGA","-60000","60000","","7","1","2024-05-20","20","05","2024","2024-05-20","drlnrep1","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("12","122","LOANREP","Principle repayment for the loan . Loan Ref No. DVLP-LN2 whose due date was 2024-06-19 received from customer JOHN  KIMWAGA","-20000","","20000","7","1","2024-05-20","20","05","2024","2024-05-20","crprncrep1","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("13","122","LOANREP","Interest repayment for the loan . Loan Ref No. DVLP-LN2 whose due date was 2024-06-19 received from customer JOHN  KIMWAGA","-40000","","40000","7","1","2024-05-20","20","05","2024","2024-05-20","crintrep1","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("14","3","LOANREP","Loan repayment for the loan . Loan Ref No. DVLP-LN2 received from customer JOHN  KIMWAGA","-13333.33","13333.33","","7","1","2024-05-20","20","05","2024","2024-05-20","drlnrep2","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("15","122","LOANREP","Principle repayment for the loan . Loan Ref No. DVLP-LN2 whose due date was 2024-06-19 received from customer JOHN  KIMWAGA","-13333.33","","13333.33","7","1","2024-05-20","20","05","2024","2024-05-20","crprncrep2","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("16","122","LOANREP","Interest repayment for the loan . Loan Ref No. DVLP-LN2 whose due date was 2024-06-19 received from customer JOHN  KIMWAGA","-0","","0","7","1","2024-05-20","20","05","2024","2024-05-20","crintrep2","0","0000-00-00","0","0","0","100","0","");
INSERT INTO chart_transactions_olddd VALUES("17","3","RECPT","Received Payments From <a href=\"home.php?receipt_customer&sales_id=2&sub_module_id=176\"> Ref No : 0999, Receipt No: RCT00002 </a><i>(fdfd)</i>","","","4000000","7","1","2024-05-07","07","05","2024","0000-00-00","dr-recpt2","0","0000-00-00","0","0","0","91","0","");
INSERT INTO chart_transactions_olddd VALUES("18","56","RECPT","Received Payments From <a href=\"home.php?receipt_customer&sales_id=2&sub_module_id=176\"> Ref No : 0999, Receipt No: RCT00002 </a><i>(fdfd)</i>","","4000000","","7","1","2024-05-07","07","05","2024","0000-00-00","cr-recpt2","0","0000-00-00","0","0","0","91","0","");
INSERT INTO chart_transactions_olddd VALUES("19","126","EXP","VAT On Receipt Customer <a href=\"home.php?receipt_customer&sales_id=2&sub_module_id=176\"> Receipt no : RCT00002, Ref No : 0999  </a><i>(fdfd)</i>","0","0","","7","1","2024-05-07","07","05","2024","0000-00-00","cr-recpt-vat2","0","0000-00-00","0","0","0","91","0","");



DROP TABLE cheque_received;

CREATE TABLE `cheque_received` (
  `cheque_received_id` int(10) NOT NULL AUTO_INCREMENT,
  `cheque_received_code_id` int(11) NOT NULL,
  `account_to_credit` varchar(100) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  `credit_amount` varchar(100) NOT NULL,
  `debit_amount` varchar(100) NOT NULL,
  `vat` int(11) NOT NULL,
  `vat_account` int(11) NOT NULL,
  `vat_value` varchar(100) NOT NULL,
  PRIMARY KEY (`cheque_received_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE cheque_received_code;

CREATE TABLE `cheque_received_code` (
  `cheque_received_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `trans_type` varchar(11) NOT NULL,
  `recorded_by` int(10) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `credit_amount` varchar(100) NOT NULL,
  `debit_amount` varchar(100) NOT NULL,
  `currency` int(10) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `date_recorded` date NOT NULL,
  `comments` longtext NOT NULL,
  `datetime_recorded` datetime NOT NULL,
  `mop` int(11) NOT NULL,
  `cheque_status` int(11) NOT NULL,
  `approved_by` int(11) NOT NULL,
  `date_approved` date NOT NULL,
  `datetime_approved` datetime NOT NULL,
  `approval_comments` varchar(200) NOT NULL,
  PRIMARY KEY (`cheque_received_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE code_date;

CREATE TABLE `code_date` (
  `code_date_id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL,
  `date_paid` varchar(50) NOT NULL,
  PRIMARY KEY (`code_date_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE company_contacts;

CREATE TABLE `company_contacts` (
  `contacts_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cont_person` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `phone` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `telephone` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `pin` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `email` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `fax` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `scroller` longtext COLLATE latin1_general_ci NOT NULL,
  `building` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `address` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `town` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `tax` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `start_date` date NOT NULL,
  PRIMARY KEY (`contacts_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO company_contacts VALUES("1","Computer Resources Limited","0713273752","0737353752","P051358475S","info@foresight-erp.com","www.foresight-erp.co.tz","Welcome to Centtech Microfinance Management System","Phoenix House 4th flor","PO Box 34912- 00100","Arusha -  Tanzania","0","2019-10-18");



DROP TABLE county;

CREATE TABLE `county` (
  `county_id` int(10) NOT NULL AUTO_INCREMENT,
  `county_name` varchar(300) NOT NULL,
  PRIMARY KEY (`county_id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=latin1;

INSERT INTO county VALUES("2","    Baringo County");
INSERT INTO county VALUES("3","    Bomet County");
INSERT INTO county VALUES("4","    Bungoma County");
INSERT INTO county VALUES("5","    Busia County");
INSERT INTO county VALUES("6","    Elgeyo Marakwet County");
INSERT INTO county VALUES("7","    Embu County");
INSERT INTO county VALUES("8","    Garissa County");
INSERT INTO county VALUES("9","    Homa Bay County");
INSERT INTO county VALUES("10","    Isiolo County");
INSERT INTO county VALUES("11","    Kajiado County");
INSERT INTO county VALUES("12","    Kakamega County");
INSERT INTO county VALUES("13","    Kericho County");
INSERT INTO county VALUES("14","    Kiambu County");
INSERT INTO county VALUES("15","    Kilifi County");
INSERT INTO county VALUES("16","    Kirinyaga County");
INSERT INTO county VALUES("17","    Kisii County");
INSERT INTO county VALUES("18","    Kisumu County");
INSERT INTO county VALUES("19","    Kitui County");
INSERT INTO county VALUES("20","    Kwale County");
INSERT INTO county VALUES("21","    Laikipia County");
INSERT INTO county VALUES("22","    Lamu County");
INSERT INTO county VALUES("23","    Machakos County");
INSERT INTO county VALUES("24","    Makueni County");
INSERT INTO county VALUES("25","    Mandera County");
INSERT INTO county VALUES("26","    Meru County");
INSERT INTO county VALUES("27","    Migori County");
INSERT INTO county VALUES("28","    Marsabit County");
INSERT INTO county VALUES("29","    Mombasa County");
INSERT INTO county VALUES("30","    Muranga County");
INSERT INTO county VALUES("31","    Nairobi County");
INSERT INTO county VALUES("32","    Nakuru County");
INSERT INTO county VALUES("33","    Nandi County");
INSERT INTO county VALUES("34","    Narok County");
INSERT INTO county VALUES("35","    Nyamira County");
INSERT INTO county VALUES("36","    Nyandarua County");
INSERT INTO county VALUES("37","    Nyeri County");
INSERT INTO county VALUES("38","    Samburu County");
INSERT INTO county VALUES("39","    Siaya County");
INSERT INTO county VALUES("40","    Taita Taveta County");
INSERT INTO county VALUES("41","    Tana River County");
INSERT INTO county VALUES("42","    Tharaka Nithi County");
INSERT INTO county VALUES("43","    Trans Nzoia County");
INSERT INTO county VALUES("44","    Turkana County");
INSERT INTO county VALUES("45","    Uasin Gishu County");
INSERT INTO county VALUES("46","    Vihiga County");
INSERT INTO county VALUES("47","    Wajir County");
INSERT INTO county VALUES("48","    West Pokot County");



DROP TABLE creditor_journal_credit_note;

CREATE TABLE `creditor_journal_credit_note` (
  `supplier_invoice_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL,
  `sup_invoice_description` varchar(100) NOT NULL,
  `sup_invoice_currency` int(11) NOT NULL,
  `sup_invoice_curr_rate` int(11) NOT NULL,
  `sup_invoice_receipt_no` varchar(100) NOT NULL,
  `sup_invoice_voucher_no` varchar(100) NOT NULL,
  `sup_invoice_date` date NOT NULL,
  `sup_invoice_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sup_invoice_status` int(11) NOT NULL,
  `sup_invoice_recorded_by` int(11) NOT NULL,
  `sup_invoice_account_to_debit` int(11) NOT NULL,
  `sup_invoice_amount_credited` varchar(100) NOT NULL,
  `journal_type` varchar(2) NOT NULL,
  PRIMARY KEY (`supplier_invoice_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE creditor_journal_credit_note_transaction;

CREATE TABLE `creditor_journal_credit_note_transaction` (
  `supplier_invoice_id` int(10) NOT NULL AUTO_INCREMENT,
  `supplier_invoice_vat_account` int(11) NOT NULL,
  `supplier_invoice_vat_value` varchar(100) NOT NULL,
  `supplier_invoice_vat` varchar(100) NOT NULL,
  `supplier_invoice_code_id` int(11) NOT NULL,
  `supplier_invoice_amount_received` varchar(100) NOT NULL,
  `supplier_invoice_account_to_credit` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `department_code` varchar(100) NOT NULL,
  PRIMARY KEY (`supplier_invoice_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO creditor_journal_credit_note_transaction VALUES("2","0","0","3","2","190770","21","0","");
INSERT INTO creditor_journal_credit_note_transaction VALUES("3","0","0","3","3","22492","21","0","");
INSERT INTO creditor_journal_credit_note_transaction VALUES("4","0","0","3","4","63733","96","0","");
INSERT INTO creditor_journal_credit_note_transaction VALUES("5","0","0","3","5","500000","96","0","");
INSERT INTO creditor_journal_credit_note_transaction VALUES("6","0","0","3","6","500000","96","0","");



DROP TABLE currency;

CREATE TABLE `currency` (
  `curr_id` int(10) NOT NULL AUTO_INCREMENT,
  `curr_name` varchar(100) NOT NULL,
  `exchange_rate` varchar(100) NOT NULL,
  PRIMARY KEY (`curr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO currency VALUES("2","USD","2000");
INSERT INTO currency VALUES("7","KSHS","1");
INSERT INTO currency VALUES("8","EURO","2800");



DROP TABLE currency_old;

CREATE TABLE `currency_old` (
  `curr_id` int(10) NOT NULL AUTO_INCREMENT,
  `curr_name` varchar(100) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  PRIMARY KEY (`curr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO currency_old VALUES("6","Kshs","1");
INSERT INTO currency_old VALUES("2","USD","88");
INSERT INTO currency_old VALUES("3","POUNDS","120");



DROP TABLE customer_invoice;

CREATE TABLE `customer_invoice` (
  `customer_invoice_id` int(10) NOT NULL AUTO_INCREMENT,
  `supplier_invoice_vat_account` int(11) NOT NULL,
  `supplier_invoice_vat_value` varchar(100) NOT NULL,
  `supplier_invoice_vat` varchar(100) NOT NULL,
  `customer_invoice_code_id` int(11) NOT NULL,
  `supplier_invoice_amount_received` varchar(100) NOT NULL,
  `supplier_invoice_account_to_credit` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `department_code` varchar(100) NOT NULL,
  PRIMARY KEY (`customer_invoice_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE customer_invoice_code;

CREATE TABLE `customer_invoice_code` (
  `customer_invoice_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `sup_invoice_description` varchar(100) NOT NULL,
  `sup_invoice_currency` int(11) NOT NULL,
  `sup_invoice_curr_rate` int(11) NOT NULL,
  `sup_invoice_receipt_no` varchar(100) NOT NULL,
  `sup_invoice_voucher_no` varchar(100) NOT NULL,
  `sup_invoice_date` date NOT NULL,
  `sup_invoice_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sup_invoice_status` int(11) NOT NULL,
  `sup_invoice_recorded_by` int(11) NOT NULL,
  `sup_invoice_account_to_debit` int(11) NOT NULL,
  `sup_invoice_amount_debited` varchar(100) NOT NULL,
  `journal_type` varchar(2) NOT NULL,
  PRIMARY KEY (`customer_invoice_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE customer_payments;

CREATE TABLE `customer_payments` (
  `customer_payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `sales_id` int(11) NOT NULL,
  `customer_payment_code_id` int(11) NOT NULL,
  `invoice_amount_received` varchar(100) NOT NULL,
  PRIMARY KEY (`customer_payment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE customer_payments_code;

CREATE TABLE `customer_payments_code` (
  `customer_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `sales_id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `amount_received` varchar(100) NOT NULL,
  `description` longtext NOT NULL,
  `cheque_no` varchar(10) NOT NULL,
  `pymnt_receipt_no` varchar(100) NOT NULL,
  `currency_code` varchar(100) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `mop` varchar(11) NOT NULL,
  `date_paid` date NOT NULL,
  `date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `account_id_paid_to` int(11) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  PRIMARY KEY (`customer_payment_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE customer_receipt;

CREATE TABLE `customer_receipt` (
  `customer_receipt_id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_receipt_vat_account` int(11) NOT NULL,
  `customer_receipt_vat_value` varchar(100) NOT NULL,
  `customer_receipt_vat` varchar(100) NOT NULL,
  `customer_receipt_code_id` int(11) NOT NULL,
  `customer_receipt_amount_received` varchar(100) NOT NULL,
  `customer_receipt_account_to_credit` int(11) NOT NULL,
  PRIMARY KEY (`customer_receipt_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO customer_receipt VALUES("2","0","0","3","2","105000","62");
INSERT INTO customer_receipt VALUES("3","0","0","3","2","150","130");
INSERT INTO customer_receipt VALUES("4","0","0","3","2","500","131");



DROP TABLE customer_receipt_code;

CREATE TABLE `customer_receipt_code` (
  `customer_receipt_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NOT NULL,
  `cust_receipt_description` varchar(100) NOT NULL,
  `cust_receipt_currency` int(11) NOT NULL,
  `cust_receipt_curr_rate` int(11) NOT NULL,
  `cust_receipt_no` varchar(100) NOT NULL,
  `cust_mop_id` int(11) NOT NULL,
  `cust_receipt_voucher_no` varchar(100) NOT NULL,
  `cust_receipt_date` date NOT NULL,
  `cust_receipt_datetime` datetime NOT NULL,
  `cust_receipt_status` int(11) NOT NULL,
  `cust_receipt_recorded_by` int(11) NOT NULL,
  `cust_receipt_bank_id` int(11) NOT NULL,
  `cust_receipt_account_to_debit` int(11) NOT NULL,
  `cust_receipt_amount_debited` varchar(100) NOT NULL,
  `journal_type` varchar(2) NOT NULL,
  PRIMARY KEY (`customer_receipt_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO customer_receipt_code VALUES("2","61","Being Processing , Lawyers and CRB fees payment","7","1","FT22045VJW","4","CR00002","2022-02-14","0000-00-00 00:00:00","0","136","3","3","105650","");



DROP TABLE customer_transactions;

CREATE TABLE `customer_transactions` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) NOT NULL,
  `farmer_id` int(11) NOT NULL,
  `order_code` int(10) NOT NULL,
  `transaction` longtext NOT NULL,
  `transaction_section` varchar(100) NOT NULL,
  `currency` int(11) NOT NULL,
  `curr_rate` varchar(11) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `debit` varchar(10) NOT NULL,
  `credit` varchar(10) NOT NULL,
  `transaction_date` date NOT NULL,
  `shop_id` int(11) NOT NULL,
  `status1` int(11) NOT NULL,
  `status2` int(11) NOT NULL,
  `transaction_code` varchar(100) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE customer_uploads;

CREATE TABLE `customer_uploads` (
  `customer_upload_id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_name` varchar(200) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `time_uploaded` datetime NOT NULL,
  `file_name` longtext NOT NULL,
  `file_path` longtext NOT NULL,
  `file_type` varchar(1) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `status1` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customer_upload_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO customer_uploads VALUES("1","NIDA","3","2024-10-02 11:15:42","d72e817page 2.pdf","customer_uploads/d72e817page 2.pdf","","","0","0");
INSERT INTO customer_uploads VALUES("2","cheti","6","2024-10-02 11:18:24","af19e67page 2.pdf","customer_uploads/af19e67page 2.pdf","","","0","0");
INSERT INTO customer_uploads VALUES("3","leseni","8","2024-10-02 11:20:16","e782521page 2.pdf","customer_uploads/e782521page 2.pdf","","","0","0");
INSERT INTO customer_uploads VALUES("4","","7","2024-10-02 11:21:36","04d0fc7ccxxx.pdf","customer_uploads/04d0fc7ccxxx.pdf","","","0","0");
INSERT INTO customer_uploads VALUES("5","leseni","13","2024-10-02 11:22:17","19a5b10page 2.pdf","customer_uploads/19a5b10page 2.pdf","","","0","0");
INSERT INTO customer_uploads VALUES("6","leseni","18","2024-10-02 11:24:23","38d3413page 2.pdf","customer_uploads/38d3413page 2.pdf","","","0","0");
INSERT INTO customer_uploads VALUES("7","gggggggggg","31","2024-10-02 11:37:05","5e9ceb5Driving License 2025.pdf","customer_uploads/5e9ceb5Driving License 2025.pdf","","","0","0");
INSERT INTO customer_uploads VALUES("8","ffffffff","31","2024-10-02 11:38:48","3f54d6bDriving License 2025.pdf","customer_uploads/3f54d6bDriving License 2025.pdf","","","0","0");
INSERT INTO customer_uploads VALUES("9","my system","31","2024-10-02 11:40:36","7dd5029Driving License 2025.pdf","customer_uploads/7dd5029Driving License 2025.pdf","","","0","0");
INSERT INTO customer_uploads VALUES("10","leseni","33","2025-03-09 00:00:00","fdd73fetask.jpg","customer_uploads/fdd73fetask.jpg","","","0","0");
INSERT INTO customer_uploads VALUES("11","","3","2025-04-05 00:00:00","451ee19Additional Fixes .pdf","customer_uploads/451ee19Additional Fixes .pdf","","","0","0");



DROP TABLE customers;

CREATE TABLE `customers` (
  `customer_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_name` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `sup_type` varchar(2) COLLATE latin1_general_ci NOT NULL,
  `sup_code` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `cont_person` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `country` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `postal` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `town` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `phone` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `email` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `date_reg` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `opening_balance` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `supplier_currency` int(11) NOT NULL,
  `supplier_curr_rate` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `opening_balance_date` date NOT NULL,
  `pin` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `supp_bank_id` int(11) NOT NULL,
  `supp_branch_id` int(11) NOT NULL,
  `supp_account_name` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `supp_account_no` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `customer_debit_account_id` int(11) NOT NULL,
  PRIMARY KEY (`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;




DROP TABLE daily_loan_schedule;

CREATE TABLE `daily_loan_schedule` (
  `daily_loan_schedule_id` int(10) NOT NULL AUTO_INCREMENT,
  `daily_schedule_date` date NOT NULL,
  `daily_exact_schedule_date` date NOT NULL,
  `loan_id` int(11) NOT NULL,
  `daily_interest_installment` longtext NOT NULL,
  `daily_principle_installment` varchar(100) NOT NULL,
  `reversed` int(11) NOT NULL,
  PRIMARY KEY (`daily_loan_schedule_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO daily_loan_schedule VALUES("1","2024-09-30","2024-09-30","5","15960","11083.333333333","0");
INSERT INTO daily_loan_schedule VALUES("2","2024-09-02","2024-09-02","18","5000","166666.66666667","0");
INSERT INTO daily_loan_schedule VALUES("3","2025-02-19","2025-02-19","22","2187.5","57692.307692308","0");
INSERT INTO daily_loan_schedule VALUES("4","2024-09-02","2024-09-02","28","52500","250000","0");
INSERT INTO daily_loan_schedule VALUES("5","2024-03-01","2024-03-01","29","52500","250000","0");
INSERT INTO daily_loan_schedule VALUES("6","2025-01-02","2025-01-02","31","52500","250000","0");



DROP TABLE debtors_journal;

CREATE TABLE `debtors_journal` (
  `debtors_journal_id` int(10) NOT NULL AUTO_INCREMENT,
  `debtors_journal_code_id` int(11) NOT NULL,
  `amount_debited` varchar(100) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  PRIMARY KEY (`debtors_journal_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE debtors_journal_code;

CREATE TABLE `debtors_journal_code` (
  `debtors_journal_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NOT NULL,
  `debtors_journal_description` varchar(100) NOT NULL,
  `debtors_journal_curreny` int(11) NOT NULL,
  `debtors_journal_curr_rate` int(11) NOT NULL,
  `debtors_journal_receipt_no` varchar(100) NOT NULL,
  `debtors_journal_voucher_no` varchar(100) NOT NULL,
  `debtors_journal_date` date NOT NULL,
  `debtors_journal_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `debtors_journal_status` int(11) NOT NULL,
  `debtors_journal_recorded_by` int(11) NOT NULL,
  `debtors_journal_account_to_credit` int(11) NOT NULL,
  `debtors_journal_amount_credited` varchar(100) NOT NULL,
  `debtors_journal_type` varchar(2) NOT NULL,
  PRIMARY KEY (`debtors_journal_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE disb_date_interest;

CREATE TABLE `disb_date_interest` (
  `disb_date_interest_id` int(10) NOT NULL AUTO_INCREMENT,
  `disb_date_loan_id` varchar(100) NOT NULL,
  `disb_date_interest_amount` varchar(100) NOT NULL,
  `disb_date_principle_amount` varchar(100) NOT NULL,
  `disb_date_interest_status` int(11) NOT NULL,
  `reversed` int(11) NOT NULL,
  PRIMARY KEY (`disb_date_interest_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO disb_date_interest VALUES("1","5","15960","11083.333333333","0","0");
INSERT INTO disb_date_interest VALUES("2","18","5000","166666.66666667","0","0");
INSERT INTO disb_date_interest VALUES("3","22","2187.5","57692.307692308","0","0");
INSERT INTO disb_date_interest VALUES("4","28","52500","250000","0","0");
INSERT INTO disb_date_interest VALUES("5","29","52500","250000","0","0");
INSERT INTO disb_date_interest VALUES("6","31","52500","250000","0","0");



DROP TABLE disbursement_trenches;

CREATE TABLE `disbursement_trenches` (
  `trench_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_id` int(100) DEFAULT NULL,
  `trench_amount` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `trench_receipt_no` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `trench_mop_id` int(11) NOT NULL,
  `trench_ref_no` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `trench_our_bank` int(11) NOT NULL,
  `trench_account_credited` int(11) NOT NULL,
  `trench_api_Conversation_id` longtext COLLATE latin1_general_ci NOT NULL,
  `trench_client_bank` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `tranch_account_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `trench_account_no` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `trench_paid_date` date NOT NULL,
  `trench_paid_datetime` datetime NOT NULL,
  `trench_paid_by` int(11) NOT NULL,
  `trench_paid_status` int(11) NOT NULL,
  PRIMARY KEY (`trench_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO disbursement_trenches VALUES("1","5","133000","","0","","0","0","","","","","0000-00-00","0000-00-00 00:00:00","0","0");
INSERT INTO disbursement_trenches VALUES("3","18","200000","","0","","0","0","","","","","0000-00-00","0000-00-00 00:00:00","0","0");
INSERT INTO disbursement_trenches VALUES("4","18","300000","","0","","0","0","","","","","0000-00-00","0000-00-00 00:00:00","0","0");
INSERT INTO disbursement_trenches VALUES("5","20","1000000","","0","","0","0","","","","","0000-00-00","0000-00-00 00:00:00","0","0");
INSERT INTO disbursement_trenches VALUES("6","22","1500000","","0","","0","0","","","","","0000-00-00","0000-00-00 00:00:00","0","0");
INSERT INTO disbursement_trenches VALUES("7","28","1350000","","0","","0","0","","","","","0000-00-00","0000-00-00 00:00:00","0","0");
INSERT INTO disbursement_trenches VALUES("8","29","1350000","","0","","0","0","","","","","0000-00-00","0000-00-00 00:00:00","0","0");
INSERT INTO disbursement_trenches VALUES("9","31","1350000","","0","","0","0","","","","","0000-00-00","0000-00-00 00:00:00","0","0");



DROP TABLE document;

CREATE TABLE `document` (
  `document_id` int(11) NOT NULL AUTO_INCREMENT,
  `doc_type` int(1) NOT NULL,
  `dispatch_date` date NOT NULL,
  `doc_name` varchar(100) NOT NULL,
  `deadline_date` date NOT NULL,
  `destination` varchar(100) NOT NULL,
  `comments` longtext NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `date_recorded` datetime NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(11) NOT NULL,
  PRIMARY KEY (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE document_type;

CREATE TABLE `document_type` (
  `document_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `document_type_name` varchar(200) NOT NULL,
  PRIMARY KEY (`document_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO document_type VALUES("1","National ID");
INSERT INTO document_type VALUES("2","Voter ID");
INSERT INTO document_type VALUES("3","License");
INSERT INTO document_type VALUES("4","Others");



DROP TABLE email;

CREATE TABLE `email` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_type` int(1) NOT NULL,
  `received_date` date NOT NULL,
  `conversation_type` varchar(100) NOT NULL,
  `source` varchar(100) NOT NULL,
  `comments` longtext NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `date_recorded` datetime NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(11) NOT NULL,
  PRIMARY KEY (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE employer;

CREATE TABLE `employer` (
  `employer_id` int(11) NOT NULL AUTO_INCREMENT,
  `employer_name` varchar(100) NOT NULL,
  `employer_desc` varchar(200) NOT NULL,
  PRIMARY KEY (`employer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE employment_terms;

CREATE TABLE `employment_terms` (
  `employment_term_id` int(10) NOT NULL AUTO_INCREMENT,
  `employment_term_name` varchar(300) NOT NULL,
  PRIMARY KEY (`employment_term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE expense_requisition;

CREATE TABLE `expense_requisition` (
  `expense_requisition_id` int(10) NOT NULL AUTO_INCREMENT,
  `date_requested` date NOT NULL,
  `request_user_id` int(11) NOT NULL,
  `request_description` longtext NOT NULL,
  `amount_requested` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `approval_status` int(11) NOT NULL DEFAULT '1',
  `status1` int(11) NOT NULL,
  `status2` int(11) NOT NULL,
  PRIMARY KEY (`expense_requisition_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE expenses;

CREATE TABLE `expenses` (
  `expenses_id` int(10) NOT NULL AUTO_INCREMENT,
  `expenses_vat_account` int(11) NOT NULL,
  `expenses_vat_value` varchar(100) NOT NULL,
  `expenses_vat` varchar(100) NOT NULL,
  `expense_code_id` int(11) NOT NULL,
  `expenses_description` mediumtext NOT NULL,
  `amount_received` varchar(100) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `department_code` varchar(100) NOT NULL,
  `transaction_type_id` int(11) NOT NULL,
  PRIMARY KEY (`expenses_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO expenses VALUES("1","0","","","1","","","19","0","","0");
INSERT INTO expenses VALUES("2","0","","","2","","","19","0","","0");
INSERT INTO expenses VALUES("3","0","","","3","","","19","0","","0");
INSERT INTO expenses VALUES("4","0","","","4","","","19","0","","0");
INSERT INTO expenses VALUES("5","0","","","5","","","3","0","","0");
INSERT INTO expenses VALUES("6","0","","","6","","","0","0","","0");
INSERT INTO expenses VALUES("7","0","","","6","NAULI","1000","25","0","","12");
INSERT INTO expenses VALUES("8","0","","","7","","","0","0","","0");
INSERT INTO expenses VALUES("9","0","","","8","","","21","0","","0");



DROP TABLE expenses_categories;

CREATE TABLE `expenses_categories` (
  `exp_cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_category_name` varchar(100) NOT NULL,
  `expense_category_desc` varchar(200) NOT NULL,
  PRIMARY KEY (`exp_cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE expenses_code;

CREATE TABLE `expenses_code` (
  `expense_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_description` longtext NOT NULL,
  `currency` int(11) NOT NULL,
  `curr_rate` int(11) NOT NULL,
  `expense_receipt_no` varchar(100) NOT NULL,
  `expense_date` date NOT NULL,
  `expense_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expense_status` int(11) NOT NULL,
  `expense_recorded_by` int(11) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `our_bank_account_id` int(11) NOT NULL,
  `amount_credited` varchar(100) NOT NULL,
  `mop_id` int(11) NOT NULL,
  `exp_voucher_no` varchar(100) NOT NULL,
  `exp_payee` varchar(300) NOT NULL,
  `exp_status` int(11) NOT NULL,
  `exp_approved_by` int(11) NOT NULL,
  `exp_datetime_approved` datetime NOT NULL,
  `exp_date_approved` date NOT NULL,
  `exp_approval_comment` longtext NOT NULL,
  PRIMARY KEY (`expense_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO expenses_code VALUES("1","NAULI","7","1","2022","2024-09-30","0000-00-00 00:00:00","0","100","17","19","20000","7","PM00001","CHRISTINA MUSHI","1","100","2024-10-02 14:39:27","2024-10-02","APPROVED");
INSERT INTO expenses_code VALUES("2","Nauli kwenda mjini ","7","1","12356","2024-10-02","0000-00-00 00:00:00","0","100","17","19","371000","7","PM00002","daniel","1","100","2024-10-02 14:38:24","2024-10-02","APPROVED");
INSERT INTO expenses_code VALUES("3","ggg","7","1","1566","2024-10-02","0000-00-00 00:00:00","0","100","17","19","40000","7","PM00003","daniel","1","100","2024-10-02 14:38:55","2024-10-02","APPROVED");
INSERT INTO expenses_code VALUES("4","FOOD","7","1","CASH","2024-10-02","0000-00-00 00:00:00","0","100","17","19","40000","7","PM00004","STAFF FOOD ","1","100","2024-10-02 14:34:24","2024-10-02","nn");
INSERT INTO expenses_code VALUES("5","MMM","7","1","56892","2024-10-03","0000-00-00 00:00:00","0","100","19","3","500,000","7","PM00005","daniel","0","0","0000-00-00 00:00:00","0000-00-00","");
INSERT INTO expenses_code VALUES("6","nAULI","7","1","55YT","2025-03-03","0000-00-00 00:00:00","0","100","19","3","1000","7","PM00006","NALIA LIA","1","100","0000-00-00 00:00:00","0000-00-00","approved");
INSERT INTO expenses_code VALUES("7","hii","7","1","3456","2025-04-29","0000-00-00 00:00:00","0","100","19","3","","7","PM00007","michoma","0","0","0000-00-00 00:00:00","0000-00-00","");
INSERT INTO expenses_code VALUES("8","","7","1","","0000-00-00","0000-00-00 00:00:00","0","100","0","17","45000","0","PM00008","","0","0","0000-00-00 00:00:00","0000-00-00","");



DROP TABLE expenses_code_old3;

CREATE TABLE `expenses_code_old3` (
  `expense_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_description` varchar(100) NOT NULL,
  `currency` int(11) NOT NULL,
  `curr_rate` int(11) NOT NULL,
  `expense_receipt_no` varchar(100) NOT NULL,
  `expense_date` date NOT NULL,
  `expense_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expense_status` int(11) NOT NULL,
  `expense_recorded_by` int(11) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `amount_credited` varchar(100) NOT NULL,
  PRIMARY KEY (`expense_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE expenses_transaction;

CREATE TABLE `expenses_transaction` (
  `expenses_transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `credit_account_id` int(11) NOT NULL,
  `debit_account_id` int(11) NOT NULL,
  `expenses_amount` varchar(100) NOT NULL,
  `expenses_description` longtext NOT NULL,
  `currency` int(10) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `mop` varchar(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `expenses_date` date NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `expenses_user_id` int(11) NOT NULL,
  `expenses_datetime` datetime NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`expenses_transaction_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO expenses_transaction VALUES("1","17","21","5000","hello","6","1","","","2025-04-08","","100","2025-04-06 12:10:09","0");
INSERT INTO expenses_transaction VALUES("2","1","22","50000","i need mon","6","1","","","2025-04-07","","100","2025-04-06 12:17:52","0");



DROP TABLE financial_status;

CREATE TABLE `financial_status` (
  `fin_status_id` int(10) NOT NULL AUTO_INCREMENT,
  `fin_status_name` varchar(300) NOT NULL,
  PRIMARY KEY (`fin_status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO financial_status VALUES("1","Open");
INSERT INTO financial_status VALUES("2","Closed");



DROP TABLE financial_year;

CREATE TABLE `financial_year` (
  `financial_year_id` int(10) NOT NULL AUTO_INCREMENT,
  `start_date` date NOT NULL,
  `start_day` varchar(100) NOT NULL,
  `start_month` varchar(100) NOT NULL,
  `start_year` year(4) NOT NULL,
  `end_date` date NOT NULL,
  `end_day` varchar(100) NOT NULL,
  `end_month` varchar(100) NOT NULL,
  `end_year` year(4) NOT NULL,
  `financial_year_status` int(11) NOT NULL,
  PRIMARY KEY (`financial_year_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO financial_year VALUES("1","2025-01-01","01","01","2025","2025-12-31","31","12","2025","1");



DROP TABLE fund_requisition;

CREATE TABLE `fund_requisition` (
  `fund_requisition_id` int(10) NOT NULL AUTO_INCREMENT,
  `date_requested` date NOT NULL,
  `request_user_id` int(11) NOT NULL,
  `fund_req_description` longtext NOT NULL,
  `amount_requested` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `approval_status` int(11) NOT NULL DEFAULT '1',
  `status1` int(11) NOT NULL,
  `status2` int(11) NOT NULL,
  PRIMARY KEY (`fund_requisition_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE implementation;

CREATE TABLE `implementation` (
  `implementation_id` int(10) NOT NULL AUTO_INCREMENT,
  `implementation_title` varchar(150) NOT NULL,
  `description` longtext NOT NULL,
  `user_id` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  PRIMARY KEY (`implementation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE imported_budget;

CREATE TABLE `imported_budget` (
  `imported_budget_id` int(11) NOT NULL AUTO_INCREMENT,
  `imported_budget_year` year(4) NOT NULL,
  `imported_budget_comments` varchar(300) NOT NULL,
  `imported_by` int(11) NOT NULL,
  `datetime_imported` datetime NOT NULL,
  PRIMARY KEY (`imported_budget_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO imported_budget VALUES("3","2022","Budget for 2022","100","2022-07-02 07:23:29");
INSERT INTO imported_budget VALUES("4","2023","Approved Budget","136","2023-01-30 13:12:50");



DROP TABLE imported_statement;

CREATE TABLE `imported_statement` (
  `imported_statement_id` int(11) NOT NULL AUTO_INCREMENT,
  `imported_statement_code_id` int(11) NOT NULL,
  `statement_date` date NOT NULL,
  `statement_transaction_no` varchar(300) NOT NULL,
  `imported_statement_transaction` longtext NOT NULL,
  `statement_transaction_amount_dr` varchar(300) NOT NULL,
  `statement_transaction_amount_cr` varchar(100) NOT NULL,
  PRIMARY KEY (`imported_statement_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE imported_statement_code;

CREATE TABLE `imported_statement_code` (
  `imported_statement_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `statement_date_from` date NOT NULL,
  `statement_date_to` date NOT NULL,
  `statement_imported_by` int(11) NOT NULL,
  `statement_datetime_imported` datetime NOT NULL,
  `statement_account_id` int(11) NOT NULL,
  `chart_opening_bal` varchar(100) NOT NULL,
  `chart_opening_bal_date` date NOT NULL,
  `chart_closing_bal` varchar(100) NOT NULL,
  `chart_closing_bal_date` date NOT NULL,
  `statement_opening_bal` varchar(100) NOT NULL,
  `statement_opening_bal_date` date NOT NULL,
  `statement_closing_bal` int(11) NOT NULL,
  `statement_closing_bal_date` date NOT NULL,
  `recon_status` int(11) NOT NULL,
  `recon_closed_by` int(11) NOT NULL,
  `recon_date_closed` date NOT NULL,
  PRIMARY KEY (`imported_statement_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE income_statement;

CREATE TABLE `income_statement` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `transactions` longtext NOT NULL,
  `amount` varchar(100) NOT NULL,
  `debit` varchar(100) NOT NULL,
  `credit` varchar(100) NOT NULL,
  `transaction_date` date NOT NULL,
  `subscription_month` varchar(5) NOT NULL,
  `subscription_year` year(4) NOT NULL,
  `subscription_month_year` varchar(50) NOT NULL,
  `order_code` varchar(100) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE incoming_mpesa_copy;

CREATE TABLE `incoming_mpesa_copy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `acc` varchar(225) DEFAULT NULL,
  `amount` varchar(15) DEFAULT NULL,
  `msisdn` varchar(20) DEFAULT NULL,
  `sender` varchar(255) DEFAULT NULL,
  `code` varchar(45) DEFAULT NULL,
  `till` bigint(20) DEFAULT NULL,
  `timestamp` datetime NOT NULL,
  `date_created` datetime NOT NULL,
  `status` int(11) DEFAULT '0',
  `other` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code_UNIQUE` (`code`),
  KEY `index3` (`msisdn`),
  KEY `index5` (`status`),
  KEY `index6` (`acc`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE incoming_mpesa_transactions;

CREATE TABLE `incoming_mpesa_transactions` (
  `mpesa_transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_no` varchar(100) NOT NULL,
  `transaction_type` varchar(100) NOT NULL,
  `transaction_account_no` varchar(100) NOT NULL,
  `transaction_time` datetime NOT NULL,
  `transaction_date` date NOT NULL,
  `transaction_amount` int(100) NOT NULL,
  `transaction_short_code` varchar(11) NOT NULL,
  `account_balance` int(100) NOT NULL,
  `transaction_phone_no` varchar(50) NOT NULL,
  `f_name` varchar(100) NOT NULL,
  `m_name` varchar(100) NOT NULL,
  `l_name` varchar(100) NOT NULL,
  `results_desc` longtext NOT NULL,
  PRIMARY KEY (`mpesa_transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE introduced_loan_charges;

CREATE TABLE `introduced_loan_charges` (
  `introduced_loan_charges_id` int(10) NOT NULL AUTO_INCREMENT,
  `intr_loan_charges_code_id` int(11) NOT NULL,
  `loan_product_charge_id` int(11) NOT NULL,
  `intr_charges_amount` varchar(11) NOT NULL,
  `payable` varchar(100) NOT NULL,
  `credit_account_id` int(11) NOT NULL,
  `debit_account_id` int(11) NOT NULL,
  PRIMARY KEY (`introduced_loan_charges_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE introduced_loan_charges_code;

CREATE TABLE `introduced_loan_charges_code` (
  `introduced_loan_charges_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_id` int(11) NOT NULL,
  `member_id` int(11) NOT NULL,
  `intr_charges_recorded_by` int(11) NOT NULL,
  `intr_charges_comments` longtext NOT NULL,
  `intr_charges_date` date NOT NULL,
  PRIMARY KEY (`introduced_loan_charges_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE journal_transaction;

CREATE TABLE `journal_transaction` (
  `journal_transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `credit_account_id` int(11) NOT NULL,
  `debit_account_id` int(11) NOT NULL,
  `journal_amount` varchar(100) NOT NULL,
  `journal_description` longtext NOT NULL,
  `currency` int(10) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `mop` varchar(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `journal_date` date NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `journal_user_id` int(11) NOT NULL,
  `journal_datetime` datetime NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`journal_transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE loan_application_charges;

CREATE TABLE `loan_application_charges` (
  `loan_application_charges_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_id` int(11) NOT NULL,
  `loan_type_id` int(11) NOT NULL,
  `app_loan_product_charge_id` int(11) NOT NULL,
  `app_loan_product_charge_type` varchar(100) NOT NULL,
  `app_loan_product_value` varchar(100) NOT NULL,
  `app_loan_product_value_amount` varchar(100) NOT NULL,
  `app_loan_product_mode` varchar(5) NOT NULL,
  `loan_app_prod_exp_date` date NOT NULL,
  `loan_app_prod_exp_freq` varchar(50) NOT NULL,
  PRIMARY KEY (`loan_application_charges_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;

INSERT INTO loan_application_charges VALUES("1","1","1","1000001","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges VALUES("2","2","1","1000001","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges VALUES("3","3","1","1000001","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges VALUES("4","4","1","1000001","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges VALUES("5","5","1","1000001","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges VALUES("6","6","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("7","7","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("8","8","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("9","10","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("10","11","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("11","12","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("12","13","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("13","14","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("14","15","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("15","16","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("16","17","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("17","19","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("18","20","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("19","21","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("20","26","5","1000002","Percentage","10","-4.0745362639427E-10","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("21","27","6","1000003","Percentage","10","9.837094694376E-10","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("22","27","6","1000004","Percentage","0.3","2.9511284083128E-11","I","0000-00-00","");
INSERT INTO loan_application_charges VALUES("23","28","6","1000003","Percentage","10","150000","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("24","28","6","1000004","Percentage","0.3","4500","I","0000-00-00","");
INSERT INTO loan_application_charges VALUES("25","29","6","1000003","Percentage","10","150000","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("26","29","6","1000004","Percentage","0.0","4500","I","0000-00-00","");
INSERT INTO loan_application_charges VALUES("28","31","7","1000005","Percentage","10","150000","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("29","31","7","1000006","Percentage","0.0","4500","I","0000-00-00","");
INSERT INTO loan_application_charges VALUES("30","32","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("31","33","1","1000001","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges VALUES("32","30","5","1000002","Percentage","10","150000","U","0000-00-00","");



DROP TABLE loan_application_charges_copy;

CREATE TABLE `loan_application_charges_copy` (
  `loan_application_charges_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_id` int(11) NOT NULL,
  `loan_type_id` int(11) NOT NULL,
  `app_loan_product_charge_id` int(11) NOT NULL,
  `app_loan_product_charge_type` varchar(100) NOT NULL,
  `app_loan_product_value` varchar(100) NOT NULL,
  `app_loan_product_value_amount` varchar(100) NOT NULL,
  `app_loan_product_mode` varchar(5) NOT NULL,
  `loan_app_prod_exp_date` date NOT NULL,
  `loan_app_prod_exp_freq` varchar(50) NOT NULL,
  PRIMARY KEY (`loan_application_charges_id`)
) ENGINE=InnoDB AUTO_INCREMENT=941 DEFAULT CHARSET=latin1;

INSERT INTO loan_application_charges_copy VALUES("9","17","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("10","17","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("11","17","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("12","17","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("13","1","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("14","33","1","11","Amount","55","55","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("15","32","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("16","30","1","11","Amount","51","51","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("17","28","1","11","Amount","51","51","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("18","27","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("19","26","1","11","Amount","51","51","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("21","25","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("22","24","1","11","Amount","51","51","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("23","23","1","11","Amount","55","55","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("24","22","1","11","Amount","97","97","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("25","6","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("26","21","1","11","Amount","51","51","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("27","19","1","11","Amount","75","75","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("28","14","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("29","2","1","11","Amount","55","55","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("33","42","1","11","Amount","55","55","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("35","3","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("36","4","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("37","5","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("38","7","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("39","8","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("40","9","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("41","10","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("42","11","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("43","43","1","11","Amount","55","55","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("44","41","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("49","39","1","11","Amount","102","102","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("50","40","1","11","Amount","105","105","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("67","45","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("68","45","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("69","45","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("70","45","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("71","48","1","11","Amount","102","102","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("96","47","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("97","47","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("98","47","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("99","47","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("104","46","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("105","46","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("106","46","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("107","46","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("108","44","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("109","44","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("110","44","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("111","44","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("112","51","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("113","51","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("114","51","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("115","51","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("116","50","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("117","50","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("118","50","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("119","50","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("120","54","1","11","Amount","97","97","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("122","57","1","11","Amount","13","13","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("123","56","1","11","Amount","17","17","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("124","58","1","11","Amount","22","22","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("125","59","1","11","Amount","22","22","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("127","61","1","11","Amount","35","35","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("128","62","1","11","Amount","13","13","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("129","63","1","11","Amount","13","13","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("130","60","1","11","Amount","44","44","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("131","64","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("132","65","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("134","89","1","11","Amount","55","55","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("135","91","790","7","Amount","25000","25000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("136","91","790","8","Amount","20000","20000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("137","91","790","9","Amount","10000","10000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("138","91","790","10","Amount","5000","5000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("139","97","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("140","99","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("145","105","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("146","106","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("154","101","1","11","Amount","55","55","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("155","102","1","11","Amount","2760","2760","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("156","107","1","11","Amount","55","55","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("157","108","1","11","Amount","2760","2760","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("158","109","1","11","Amount","75","75","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("159","110","1","11","Amount","51","51","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("160","111","1","11","Amount","75","75","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("161","112","1","11","Amount","51.64","51.64","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("162","113","1","11","Amount","51","51","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("163","100","1","11","Amount","44","44","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("164","98","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("165","116","1","11","Amount","97","97","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("176","68","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("177","120","792","13","Amount","5000","5000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("178","120","792","14","Amount","5000","5000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("179","120","792","15","Amount","55000","55000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("190","122","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("191","124","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("192","124","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("193","124","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("194","124","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("195","125","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("196","125","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("197","125","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("198","125","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("214","72","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("215","72","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("216","72","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("217","121","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("218","121","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("223","123","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("224","123","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("225","123","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("226","123","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("227","123","790","22","Amount","795","795","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("230","127","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("231","127","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("255","128","792","13","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("256","128","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("257","128","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("258","128","792","16","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("259","126","2","18","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("260","126","2","23","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("266","129","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("267","129","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("268","129","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("269","129","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("270","129","790","22","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("274","130","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("275","130","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("276","130","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("277","131","1","11","Amount","105","105","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("284","134","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("285","134","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("286","134","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("287","135","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("288","135","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("289","135","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("290","133","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("291","133","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("292","133","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("298","137","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("299","137","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("300","137","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("301","138","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("302","138","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("303","138","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("304","138","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("305","138","790","22","Amount","845","845","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("306","132","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("307","132","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("308","132","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("309","139","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("310","139","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("311","139","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("319","141","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("320","142","1","11","Amount","56","56","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("321","143","1","11","Amount","77","77","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("322","144","1","11","Amount","61","61","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("323","145","1","11","Amount","61","61","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("324","146","1","11","Amount","102","102","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("325","147","1","11","Amount","77","77","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("326","148","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("327","149","1","11","Amount","77","77","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("331","150","1","11","Amount","102","102","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("332","151","1","11","Amount","77","77","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("333","153","793","24","Amount","500","500","S","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("334","153","793","26","Percentage","10","1.1236625141464E-8","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("335","154","1","11","Amount","87","87","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("336","155","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("337","155","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("338","155","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("350","157","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("351","157","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("352","157","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("356","136","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("357","136","791","21","Amount","174.8","174.8","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("358","136","791","27","Percentage","10","1302168","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("364","158","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("365","158","791","21","Amount","275","275","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("366","158","791","27","Percentage","10","761500","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("367","158","791","35","Percentage","1.5","114225","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("368","158","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("381","160","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("382","160","791","21","Amount","284.5","284.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("383","160","791","27","Percentage","10","1070150","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("384","160","791","35","Percentage","1.5","160522.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("385","160","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("424","159","792","13","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("425","159","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("426","159","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("427","159","792","16","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("428","159","792","28","Percentage","10","30000","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("429","159","792","36","Percentage","3","9000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("430","159","792","41","Percentage","1.5","4500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("431","159","792","49","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("447","140","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("448","140","791","21","Amount","459.95","459.95","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("449","140","791","27","Percentage","10","398067","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("450","140","791","35","Percentage","1.5","59710.05","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("451","140","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("452","162","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("453","162","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("454","162","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("455","162","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("456","162","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("457","156","792","13","Amount","","","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("458","156","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("459","156","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("460","156","792","16","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("461","156","792","28","Percentage","10","25200","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("467","164","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("468","164","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("469","164","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("470","164","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("471","164","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("472","163","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("473","163","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("474","163","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("475","163","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("476","163","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("477","165","792","13","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("478","165","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("479","165","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("480","165","792","16","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("481","165","792","28","Percentage","10","5600","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("482","165","792","36","Percentage","3","1680","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("483","165","792","41","Percentage","1.5","840","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("484","165","792","49","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("595","1","1","32","Percentage","8","720","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("596","2","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("597","6","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("598","14","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("599","15","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("600","16","2","30","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("601","19","1","32","Percentage","8","560","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("602","21","1","32","Percentage","8","160","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("603","22","1","32","Percentage","8","960","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("604","23","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("605","24","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("606","25","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("607","26","1","32","Percentage","8","160","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("608","27","1","32","Percentage","8","640","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("609","28","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("610","30","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("611","32","1","32","Percentage","8","640","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("612","33","1","32","Percentage","8","320","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("613","35","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("614","38","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("615","39","1","32","Percentage","8","1360","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("616","40","1","32","Percentage","8","4000","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("617","41","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("618","42","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("619","43","1","32","Percentage","8","480","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("620","48","1","32","Percentage","8","1600","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("621","50","790","34","Percentage","0.5","10000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("622","52","791","35","Percentage","0.5","65000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("623","54","1","32","Percentage","8","1200","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("624","55","792","36","Percentage","3","27000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("625","56","1","32","Percentage","5","200","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("626","57","1","32","Percentage","5","150","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("627","58","1","32","Percentage","5","250","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("628","59","1","32","Percentage","5","250","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("629","60","1","32","Percentage","5","500","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("630","61","1","32","Percentage","5","400","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("631","62","1","32","Percentage","5","150","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("632","63","1","32","Percentage","5","150","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("633","64","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("634","65","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("635","66","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("636","67","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("637","68","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("638","71","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("639","72","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("640","74","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("641","77","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("642","78","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("643","79","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("644","82","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("645","83","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("646","85","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("647","89","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("648","98","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("649","99","1","32","Percentage","10","1100","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("650","100","1","32","Percentage","5","500","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("651","101","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("652","102","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("653","103","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("654","107","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("655","108","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("656","109","1","32","Percentage","8","560","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("657","110","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("658","111","1","32","Percentage","8","480","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("659","112","1","32","Percentage","8","265.36","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("660","113","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("661","114","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("662","115","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("663","116","1","32","Percentage","8","880","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("664","119","792","36","Percentage","3","12000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("665","120","792","36","Percentage","3","60000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("666","121","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("667","123","790","34","Percentage","0.5","0.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("668","124","790","34","Percentage","0.5","593216.03","S","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("669","125","790","34","Percentage","0.5","146750","S","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("670","126","2","30","Percentage","3","3600","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("671","127","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("672","128","792","36","Percentage","3","9300","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("673","129","790","34","Percentage","1.5","1.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("674","130","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("675","131","1","32","Percentage","8","2240","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("676","132","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("677","133","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("678","134","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("679","135","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("680","136","791","35","Percentage","1.5","195325.2","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("681","137","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("682","138","790","34","Percentage","1.5","1.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("683","141","1","32","Percentage","8","680","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("684","142","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("685","143","1","32","Percentage","8","552","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("686","144","1","32","Percentage","8","360","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("687","145","1","32","Percentage","8","320","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("688","146","1","32","Percentage","8","1600","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("689","147","1","32","Percentage","8","480","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("690","148","1","32","Percentage","8","792","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("691","149","1","32","Percentage","8","480","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("692","150","1","32","Percentage","8","1360","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("693","151","1","32","Percentage","8","560","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("694","153","793","37","Percentage","3","105000","S","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("695","154","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("696","155","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("697","1","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("698","2","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("699","6","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("700","14","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("701","15","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("702","16","2","39","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("703","19","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("704","21","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("705","22","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("706","23","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("707","24","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("708","25","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("709","26","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("710","27","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("711","28","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("712","30","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("713","32","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("714","33","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("715","35","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("716","38","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("717","39","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("718","40","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("719","41","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("720","42","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("721","43","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("722","48","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("723","50","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("724","52","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("725","54","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("726","55","792","41","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("727","56","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("728","57","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("729","58","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("730","59","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("731","60","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("732","61","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("733","62","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("734","63","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("735","64","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("736","65","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("737","66","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("738","67","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("739","68","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("740","71","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("741","72","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("742","74","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("743","77","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("744","78","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("745","79","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("746","82","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("747","83","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("748","85","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("749","89","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("750","98","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("751","99","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("752","100","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("753","101","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("754","102","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("755","103","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("756","107","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("757","108","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("758","109","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("759","110","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("760","111","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("761","112","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("762","113","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("763","114","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("764","115","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("765","116","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("766","119","792","41","Percentage","1.5","6000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("767","120","792","41","Percentage","1.5","30000","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("768","121","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("769","123","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("770","124","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("771","125","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("772","126","2","39","Percentage","1.5","1800","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("773","127","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("774","128","792","41","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("775","129","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("776","130","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("777","131","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("778","132","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("779","133","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("780","134","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("781","135","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("782","136","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("783","137","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("784","138","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("785","141","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("786","142","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("787","143","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("788","144","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("789","145","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("790","146","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("791","147","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("792","148","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("793","149","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("794","150","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("795","151","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("796","153","793","43","Percentage","3","105000","S","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("797","154","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("798","155","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("804","167","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("805","167","791","21","Amount","303.5","303.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("806","167","791","27","Percentage","10","1015310","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("807","167","791","35","Percentage","1.5","152296.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("808","167","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("809","166","792","13","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("810","166","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("811","166","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("812","166","792","16","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("813","166","792","28","Percentage","10","9700","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("814","166","792","36","Percentage","3","2910","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("815","166","792","41","Percentage","1.5","1455","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("816","166","792","49","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("824","168","1","32","Percentage","10","300","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("826","169","1","32","Percentage","10","300","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("827","170","3","12","Amount","150","150","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("828","170","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("829","170","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("830","170","3","31","Percentage","3","1260","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("831","170","3","45","Percentage","1.5","630","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("847","172","2","18","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("848","172","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("849","172","2","29","Percentage","10","20","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("850","172","2","30","Percentage","3","6","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("851","172","2","39","Percentage","1.5","3","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("852","173","2","18","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("853","173","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("854","173","2","29","Percentage","10","1","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("855","173","2","30","Percentage","3","0.3","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("856","173","2","39","Percentage","1.5","0.15","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("857","161","2","18","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("858","161","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("859","161","2","29","Percentage","10","52430","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("860","161","2","30","Percentage","3","15729","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("861","161","2","39","Percentage","1.5","7864.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("868","175","1","32","Percentage","10","690","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("870","176","1","32","Percentage","10","500","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("872","177","1","32","Percentage","10","1390","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("874","178","1","32","Percentage","10","400","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("876","179","1","32","Percentage","10","300","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("878","180","1","32","Percentage","10","500","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("880","181","1","32","Percentage","10","3900","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("882","182","1","32","Percentage","10","470","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("884","183","1","32","Percentage","10","2140","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("886","184","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("888","185","1","32","Percentage","10","600","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("890","186","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("892","187","1","32","Percentage","10","950","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("894","188","1","32","Percentage","10","300","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("896","189","1","32","Percentage","10","300","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("898","190","1","32","Percentage","10","600","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("900","191","1","32","Percentage","10","200","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("902","192","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("904","193","1","32","Percentage","10","590","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("906","194","1","32","Percentage","10","1100","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("907","171","3","12","Amount","150","150","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("908","171","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("909","171","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("910","171","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("911","171","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("912","174","2","18","Amount","706","706","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("913","174","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("914","174","2","29","Percentage","10","52430","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("915","174","2","30","Percentage","3","15729","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("916","174","2","39","Percentage","1.5","7864.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("917","195","2","18","Amount","706.50","706.50","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("918","195","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("919","195","2","29","Percentage","10","52430","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("920","195","2","30","Percentage","3","15729","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("921","195","2","39","Percentage","1.5","7864.5","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("923","196","1","32","Percentage","10","480","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("925","197","1","32","Percentage","10","700","I","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("926","198","3","12","Amount","150","150","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("927","198","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("928","198","3","19","Amount","180","180","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("929","198","3","31","Percentage","3","1698","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("930","198","3","45","Percentage","1.5","849","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("936","199","3","12","Amount","150","150","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("937","199","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("938","199","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("939","199","3","31","Percentage","3","1380","U","0000-00-00","");
INSERT INTO loan_application_charges_copy VALUES("940","199","3","45","Percentage","1.5","690","U","0000-00-00","");



DROP TABLE loan_application_charges_proc_charges_over_9thmarch;

CREATE TABLE `loan_application_charges_proc_charges_over_9thmarch` (
  `loan_application_charges_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_id` int(11) NOT NULL,
  `loan_type_id` int(11) NOT NULL,
  `app_loan_product_charge_id` int(11) NOT NULL,
  `app_loan_product_charge_type` varchar(100) NOT NULL,
  `app_loan_product_value` varchar(100) NOT NULL,
  `app_loan_product_value_amount` varchar(100) NOT NULL,
  `app_loan_product_mode` varchar(5) NOT NULL,
  `loan_app_prod_exp_date` date NOT NULL,
  `loan_app_prod_exp_freq` varchar(50) NOT NULL,
  PRIMARY KEY (`loan_application_charges_id`)
) ENGINE=InnoDB AUTO_INCREMENT=907 DEFAULT CHARSET=latin1;

INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("9","17","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("10","17","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("11","17","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("12","17","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("13","1","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("14","33","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("15","32","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("16","30","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("17","28","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("18","27","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("19","26","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("21","25","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("22","24","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("23","23","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("24","22","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("25","6","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("26","21","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("27","19","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("28","14","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("29","2","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("33","42","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("35","3","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("36","4","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("37","5","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("38","7","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("39","8","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("40","9","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("41","10","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("42","11","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("43","43","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("44","41","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("49","39","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("50","40","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("67","45","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("68","45","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("69","45","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("70","45","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("71","48","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("96","47","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("97","47","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("98","47","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("99","47","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("104","46","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("105","46","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("106","46","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("107","46","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("108","44","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("109","44","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("110","44","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("111","44","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("112","51","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("113","51","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("114","51","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("115","51","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("116","50","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("117","50","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("118","50","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("119","50","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("120","54","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("122","57","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("123","56","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("124","58","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("125","59","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("127","61","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("128","62","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("129","63","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("130","60","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("131","64","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("132","65","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("134","89","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("135","91","790","7","Amount","25000","25000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("136","91","790","8","Amount","20000","20000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("137","91","790","9","Amount","10000","10000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("138","91","790","10","Amount","5000","5000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("139","97","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("140","99","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("145","105","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("146","106","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("154","101","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("155","102","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("156","107","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("157","108","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("158","109","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("159","110","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("160","111","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("161","112","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("162","113","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("163","100","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("164","98","3","12","Amount","0105","0105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("165","116","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("176","68","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("177","120","792","13","Amount","5000","5000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("178","120","792","14","Amount","5000","5000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("179","120","792","15","Amount","55000","55000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("190","122","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("191","124","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("192","124","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("193","124","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("194","124","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("195","125","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("196","125","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("197","125","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("198","125","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("214","72","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("215","72","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("216","72","3","19","Amount","200","200","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("217","121","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("218","121","3","17","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("223","123","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("224","123","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("225","123","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("226","123","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("227","123","790","22","Amount","795","795","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("230","127","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("231","127","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("255","128","792","13","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("256","128","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("257","128","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("258","128","792","16","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("259","126","2","18","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("260","126","2","23","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("266","129","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("267","129","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("268","129","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("269","129","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("270","129","790","22","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("274","130","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("275","130","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("276","130","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("277","131","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("284","134","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("285","134","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("286","134","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("287","135","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("288","135","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("289","135","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("290","133","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("291","133","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("292","133","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("298","137","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("299","137","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("300","137","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("301","138","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("302","138","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("303","138","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("304","138","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("305","138","790","22","Amount","845","845","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("306","132","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("307","132","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("308","132","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("309","139","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("310","139","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("311","139","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("319","141","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("320","142","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("321","143","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("322","144","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("323","145","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("324","146","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("325","147","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("326","148","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("327","149","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("331","150","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("332","151","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("333","153","793","24","Amount","500","500","S","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("334","153","793","26","Percentage","10","1.1236625141464E-8","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("335","154","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("336","155","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("337","155","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("338","155","3","19","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("350","157","3","12","Amount","","","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("351","157","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("352","157","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("356","136","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("357","136","791","21","Amount","174.8","174.8","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("358","136","791","27","Percentage","10","1302168","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("364","158","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("365","158","791","21","Amount","275","275","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("366","158","791","27","Percentage","10","761500","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("367","158","791","35","Percentage","1.5","114225","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("368","158","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("381","160","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("382","160","791","21","Amount","284.5","284.5","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("383","160","791","27","Percentage","10","1070150","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("384","160","791","35","Percentage","1.5","160522.5","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("385","160","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("424","159","792","13","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("425","159","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("426","159","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("427","159","792","16","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("428","159","792","28","Percentage","10","30000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("429","159","792","36","Percentage","3","9000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("430","159","792","41","Percentage","1.5","4500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("431","159","792","49","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("447","140","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("448","140","791","21","Amount","459.95","459.95","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("449","140","791","27","Percentage","10","398067","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("450","140","791","35","Percentage","1.5","59710.05","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("451","140","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("452","162","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("453","162","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("454","162","3","19","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("455","162","3","31","Percentage","3","9000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("456","162","3","45","Percentage","1.5","4500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("457","156","792","13","Amount","","","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("458","156","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("459","156","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("460","156","792","16","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("461","156","792","28","Percentage","10","25200","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("467","164","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("468","164","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("469","164","3","19","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("470","164","3","31","Percentage","3","2400","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("471","164","3","45","Percentage","1.5","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("472","163","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("473","163","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("474","163","3","19","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("475","163","3","31","Percentage","3","9000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("476","163","3","45","Percentage","1.5","4500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("477","165","792","13","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("478","165","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("479","165","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("480","165","792","16","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("481","165","792","28","Percentage","10","5600","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("482","165","792","36","Percentage","3","1680","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("483","165","792","41","Percentage","1.5","840","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("484","165","792","49","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("595","1","1","32","Percentage","8","720","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("596","2","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("597","6","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("598","14","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("599","15","3","31","Percentage","3","7500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("600","16","2","30","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("601","19","1","32","Percentage","8","560","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("602","21","1","32","Percentage","8","160","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("603","22","1","32","Percentage","8","960","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("604","23","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("605","24","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("606","25","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("607","26","1","32","Percentage","8","160","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("608","27","1","32","Percentage","8","640","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("609","28","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("610","30","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("611","32","1","32","Percentage","8","640","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("612","33","1","32","Percentage","8","320","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("613","35","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("614","38","3","31","Percentage","3","4500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("615","39","1","32","Percentage","8","1360","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("616","40","1","32","Percentage","8","4000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("617","41","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("618","42","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("619","43","1","32","Percentage","8","480","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("620","48","1","32","Percentage","8","1600","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("621","50","790","34","Percentage","0.5","10000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("622","52","791","35","Percentage","0.5","65000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("623","54","1","32","Percentage","8","1200","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("624","55","792","36","Percentage","3","27000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("625","56","1","32","Percentage","5","200","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("626","57","1","32","Percentage","5","150","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("627","58","1","32","Percentage","5","250","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("628","59","1","32","Percentage","5","250","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("629","60","1","32","Percentage","5","500","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("630","61","1","32","Percentage","5","400","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("631","62","1","32","Percentage","5","150","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("632","63","1","32","Percentage","5","150","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("633","64","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("634","65","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("635","66","3","31","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("636","67","3","31","Percentage","3","2400","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("637","68","3","31","Percentage","3","3600","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("638","71","3","31","Percentage","3","2400","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("639","72","3","31","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("640","74","3","31","Percentage","3","450","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("641","77","3","31","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("642","78","3","31","Percentage","3","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("643","79","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("644","82","3","31","Percentage","3","300","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("645","83","3","31","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("646","85","3","31","Percentage","3","39000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("647","89","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("648","98","3","31","Percentage","3","1800","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("649","99","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("650","100","1","32","Percentage","5","500","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("651","101","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("652","102","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("653","103","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("654","107","1","32","Percentage","8","400","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("655","108","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("656","109","1","32","Percentage","8","560","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("657","110","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("658","111","1","32","Percentage","8","480","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("659","112","1","32","Percentage","8","265.36","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("660","113","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("661","114","3","31","Percentage","3","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("662","115","3","31","Percentage","3","540","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("663","116","1","32","Percentage","8","880","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("664","119","792","36","Percentage","3","12000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("665","120","792","36","Percentage","3","60000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("666","121","3","31","Percentage","3","1320","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("667","123","790","34","Percentage","0.5","0.5","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("668","124","790","34","Percentage","0.5","593216.03","S","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("669","125","790","34","Percentage","0.5","146750","S","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("670","126","2","30","Percentage","3","3600","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("671","127","3","31","Percentage","3","840","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("672","128","792","36","Percentage","3","9300","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("673","129","790","34","Percentage","1.5","1.5","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("674","130","3","31","Percentage","3","1350","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("675","131","1","32","Percentage","8","2240","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("676","132","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("677","133","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("678","134","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("679","135","3","31","Percentage","3","1800","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("680","136","791","35","Percentage","1.5","195325.2","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("681","137","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("682","138","790","34","Percentage","1.5","1.5","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("683","141","1","32","Percentage","8","680","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("684","142","1","32","Percentage","8","240","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("685","143","1","32","Percentage","8","552","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("686","144","1","32","Percentage","8","360","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("687","145","1","32","Percentage","8","320","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("688","146","1","32","Percentage","8","1600","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("689","147","1","32","Percentage","8","480","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("690","148","1","32","Percentage","8","792","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("691","149","1","32","Percentage","8","480","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("692","150","1","32","Percentage","8","1360","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("693","151","1","32","Percentage","8","560","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("694","153","793","37","Percentage","3","105000","S","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("695","154","1","32","Percentage","8","800","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("696","155","3","31","Percentage","3","6000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("697","1","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("698","2","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("699","6","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("700","14","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("701","15","3","45","Percentage","1.5","3750","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("702","16","2","39","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("703","19","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("704","21","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("705","22","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("706","23","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("707","24","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("708","25","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("709","26","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("710","27","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("711","28","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("712","30","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("713","32","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("714","33","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("715","35","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("716","38","3","45","Percentage","1.5","2250","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("717","39","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("718","40","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("719","41","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("720","42","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("721","43","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("722","48","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("723","50","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("724","52","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("725","54","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("726","55","792","41","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("727","56","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("728","57","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("729","58","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("730","59","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("731","60","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("732","61","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("733","62","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("734","63","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("735","64","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("736","65","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("737","66","3","45","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("738","67","3","45","Percentage","1.5","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("739","68","3","45","Percentage","1.25","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("740","71","3","45","Percentage","1.5","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("741","72","3","45","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("742","74","3","45","Percentage","1.5","225","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("743","77","3","45","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("744","78","3","45","Percentage","1.5","600","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("745","79","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("746","82","3","45","Percentage","1.5","150","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("747","83","3","45","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("748","85","3","45","Percentage","1.5","19500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("749","89","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("750","98","3","45","Percentage","1.5","900","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("751","99","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("752","100","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("753","101","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("754","102","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("755","103","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("756","107","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("757","108","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("758","109","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("759","110","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("760","111","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("761","112","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("762","113","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("763","114","3","45","Percentage","1.5","600","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("764","115","3","45","Percentage","1.5","270","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("765","116","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("766","119","792","41","Percentage","1.5","6000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("767","120","792","41","Percentage","1.5","30000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("768","121","3","45","Percentage","1.5","660","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("769","123","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("770","124","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("771","125","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("772","126","2","39","Percentage","1.5","1800","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("773","127","3","45","Percentage","1.5","420","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("774","128","792","41","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("775","129","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("776","130","3","45","Percentage","1.5","675","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("777","131","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("778","132","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("779","133","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("780","134","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("781","135","3","45","Percentage","1.5","900","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("782","136","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("783","137","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("784","138","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("785","141","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("786","142","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("787","143","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("788","144","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("789","145","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("790","146","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("791","147","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("792","148","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("793","149","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("794","150","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("795","151","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("796","153","793","43","Percentage","3","105000","S","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("797","154","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("798","155","3","45","Percentage","1.5","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("804","167","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("805","167","791","21","Amount","303.5","303.5","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("806","167","791","27","Percentage","10","1015310","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("807","167","791","35","Percentage","1.5","152296.5","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("808","167","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("809","166","792","13","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("810","166","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("811","166","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("812","166","792","16","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("813","166","792","28","Percentage","10","9700","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("814","166","792","36","Percentage","3","2910","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("815","166","792","41","Percentage","1.5","1455","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("816","166","792","49","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("823","168","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("824","168","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("825","169","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("826","169","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("827","170","3","12","Amount","150","150","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("828","170","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("829","170","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("830","170","3","31","Percentage","3","1260","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("831","170","3","45","Percentage","1.5","630","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("842","171","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("843","171","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("844","171","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("845","171","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("846","171","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("847","172","2","18","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("848","172","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("849","172","2","29","Percentage","10","20","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("850","172","2","30","Percentage","3","6","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("851","172","2","39","Percentage","1.5","3","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("852","173","2","18","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("853","173","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("854","173","2","29","Percentage","10","1","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("855","173","2","30","Percentage","3","0.3","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("856","173","2","39","Percentage","1.5","0.15","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("857","161","2","18","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("858","161","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("859","161","2","29","Percentage","10","52430","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("860","161","2","30","Percentage","3","15729","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("861","161","2","39","Percentage","1.5","7864.5","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("862","174","2","18","Amount","706","706","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("863","174","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("864","174","2","29","Percentage","10","52430","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("865","174","2","30","Percentage","3","15729","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("866","174","2","39","Percentage","1.5","7864.5","U","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("867","175","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("868","175","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("869","176","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("870","176","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("871","177","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("872","177","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("873","178","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("874","178","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("875","179","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("876","179","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("877","180","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("878","180","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("879","181","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("880","181","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("881","182","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("882","182","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("883","183","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("884","183","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("885","184","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("886","184","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("887","185","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("888","185","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("889","186","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("890","186","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("891","187","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("892","187","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("893","188","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("894","188","1","32","Percentage","10","300","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("895","189","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("896","189","1","32","Percentage","10","300","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("897","190","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("898","190","1","32","Percentage","10","600","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("899","191","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("900","191","1","32","Percentage","10","200","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("901","192","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("902","192","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("903","193","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("904","193","1","32","Percentage","10","590","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("905","194","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_proc_charges_over_9thmarch VALUES("906","194","1","32","Percentage","10","1100","I","0000-00-00","");



DROP TABLE loan_application_charges_procc_fees_updated_wrongly;

CREATE TABLE `loan_application_charges_procc_fees_updated_wrongly` (
  `loan_application_charges_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_id` int(11) NOT NULL,
  `loan_type_id` int(11) NOT NULL,
  `app_loan_product_charge_id` int(11) NOT NULL,
  `app_loan_product_charge_type` varchar(100) NOT NULL,
  `app_loan_product_value` varchar(100) NOT NULL,
  `app_loan_product_value_amount` varchar(100) NOT NULL,
  `app_loan_product_mode` varchar(5) NOT NULL,
  `loan_app_prod_exp_date` date NOT NULL,
  `loan_app_prod_exp_freq` varchar(50) NOT NULL,
  PRIMARY KEY (`loan_application_charges_id`)
) ENGINE=InnoDB AUTO_INCREMENT=907 DEFAULT CHARSET=latin1;

INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("9","17","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("10","17","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("11","17","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("12","17","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("13","1","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("14","33","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("15","32","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("16","30","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("17","28","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("18","27","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("19","26","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("21","25","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("22","24","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("23","23","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("24","22","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("25","6","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("26","21","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("27","19","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("28","14","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("29","2","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("33","42","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("35","3","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("36","4","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("37","5","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("38","7","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("39","8","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("40","9","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("41","10","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("42","11","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("43","43","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("44","41","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("49","39","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("50","40","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("67","45","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("68","45","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("69","45","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("70","45","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("71","48","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("96","47","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("97","47","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("98","47","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("99","47","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("104","46","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("105","46","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("106","46","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("107","46","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("108","44","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("109","44","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("110","44","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("111","44","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("112","51","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("113","51","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("114","51","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("115","51","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("116","50","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("117","50","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("118","50","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("119","50","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("120","54","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("122","57","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("123","56","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("124","58","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("125","59","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("127","61","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("128","62","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("129","63","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("130","60","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("131","64","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("132","65","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("134","89","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("135","91","790","7","Amount","25000","25000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("136","91","790","8","Amount","20000","20000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("137","91","790","9","Amount","10000","10000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("138","91","790","10","Amount","5000","5000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("139","97","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("140","99","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("145","105","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("146","106","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("154","101","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("155","102","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("156","107","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("157","108","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("158","109","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("159","110","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("160","111","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("161","112","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("162","113","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("163","100","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("164","98","3","12","Amount","0105","0105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("165","116","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("176","68","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("177","120","792","13","Amount","5000","5000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("178","120","792","14","Amount","5000","5000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("179","120","792","15","Amount","55000","55000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("190","122","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("191","124","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("192","124","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("193","124","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("194","124","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("195","125","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("196","125","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("197","125","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("198","125","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("214","72","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("215","72","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("216","72","3","19","Amount","200","200","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("217","121","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("218","121","3","17","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("223","123","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("224","123","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("225","123","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("226","123","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("227","123","790","22","Amount","795","795","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("230","127","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("231","127","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("255","128","792","13","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("256","128","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("257","128","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("258","128","792","16","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("259","126","2","18","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("260","126","2","23","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("266","129","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("267","129","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("268","129","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("269","129","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("270","129","790","22","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("274","130","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("275","130","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("276","130","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("277","131","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("284","134","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("285","134","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("286","134","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("287","135","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("288","135","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("289","135","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("290","133","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("291","133","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("292","133","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("298","137","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("299","137","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("300","137","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("301","138","790","7","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("302","138","790","8","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("303","138","790","9","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("304","138","790","10","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("305","138","790","22","Amount","845","845","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("306","132","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("307","132","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("308","132","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("309","139","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("310","139","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("311","139","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("319","141","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("320","142","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("321","143","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("322","144","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("323","145","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("324","146","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("325","147","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("326","148","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("327","149","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("331","150","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("332","151","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("333","153","793","24","Amount","500","500","S","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("334","153","793","26","Percentage","10","1.1236625141464E-8","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("335","154","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("336","155","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("337","155","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("338","155","3","19","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("350","157","3","12","Amount","","","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("351","157","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("352","157","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("356","136","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("357","136","791","21","Amount","174.8","174.8","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("358","136","791","27","Percentage","10","1302168","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("364","158","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("365","158","791","21","Amount","275","275","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("366","158","791","27","Percentage","10","761500","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("367","158","791","35","Percentage","1.5","114225","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("368","158","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("381","160","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("382","160","791","21","Amount","284.5","284.5","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("383","160","791","27","Percentage","10","1070150","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("384","160","791","35","Percentage","1.5","160522.5","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("385","160","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("424","159","792","13","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("425","159","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("426","159","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("427","159","792","16","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("428","159","792","28","Percentage","10","30000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("429","159","792","36","Percentage","3","9000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("430","159","792","41","Percentage","1.5","4500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("431","159","792","49","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("447","140","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("448","140","791","21","Amount","459.95","459.95","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("449","140","791","27","Percentage","10","398067","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("450","140","791","35","Percentage","1.5","59710.05","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("451","140","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("452","162","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("453","162","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("454","162","3","19","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("455","162","3","31","Percentage","3","9000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("456","162","3","45","Percentage","1.5","4500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("457","156","792","13","Amount","","","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("458","156","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("459","156","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("460","156","792","16","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("461","156","792","28","Percentage","10","25200","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("467","164","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("468","164","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("469","164","3","19","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("470","164","3","31","Percentage","3","2400","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("471","164","3","45","Percentage","1.5","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("472","163","3","12","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("473","163","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("474","163","3","19","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("475","163","3","31","Percentage","3","9000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("476","163","3","45","Percentage","1.5","4500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("477","165","792","13","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("478","165","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("479","165","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("480","165","792","16","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("481","165","792","28","Percentage","10","5600","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("482","165","792","36","Percentage","3","1680","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("483","165","792","41","Percentage","1.5","840","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("484","165","792","49","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("595","1","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("596","2","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("597","6","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("598","14","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("599","15","3","31","Percentage","3","7500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("600","16","2","30","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("601","19","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("602","21","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("603","22","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("604","23","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("605","24","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("606","25","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("607","26","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("608","27","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("609","28","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("610","30","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("611","32","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("612","33","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("613","35","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("614","38","3","31","Percentage","3","4500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("615","39","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("616","40","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("617","41","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("618","42","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("619","43","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("620","48","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("621","50","790","34","Percentage","0.5","10000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("622","52","791","35","Percentage","0.5","65000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("623","54","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("624","55","792","36","Percentage","3","27000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("625","56","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("626","57","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("627","58","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("628","59","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("629","60","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("630","61","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("631","62","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("632","63","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("633","64","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("634","65","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("635","66","3","31","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("636","67","3","31","Percentage","3","2400","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("637","68","3","31","Percentage","3","3600","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("638","71","3","31","Percentage","3","2400","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("639","72","3","31","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("640","74","3","31","Percentage","3","450","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("641","77","3","31","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("642","78","3","31","Percentage","3","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("643","79","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("644","82","3","31","Percentage","3","300","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("645","83","3","31","Percentage","3","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("646","85","3","31","Percentage","3","39000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("647","89","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("648","98","3","31","Percentage","3","1800","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("649","99","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("650","100","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("651","101","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("652","102","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("653","103","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("654","107","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("655","108","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("656","109","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("657","110","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("658","111","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("659","112","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("660","113","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("661","114","3","31","Percentage","3","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("662","115","3","31","Percentage","3","540","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("663","116","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("664","119","792","36","Percentage","3","12000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("665","120","792","36","Percentage","3","60000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("666","121","3","31","Percentage","3","1320","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("667","123","790","34","Percentage","0.5","0.5","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("668","124","790","34","Percentage","0.5","593216.03","S","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("669","125","790","34","Percentage","0.5","146750","S","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("670","126","2","30","Percentage","3","3600","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("671","127","3","31","Percentage","3","840","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("672","128","792","36","Percentage","3","9300","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("673","129","790","34","Percentage","1.5","1.5","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("674","130","3","31","Percentage","3","1350","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("675","131","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("676","132","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("677","133","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("678","134","3","31","Percentage","3","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("679","135","3","31","Percentage","3","1800","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("680","136","791","35","Percentage","1.5","195325.2","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("681","137","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("682","138","790","34","Percentage","1.5","1.5","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("683","141","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("684","142","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("685","143","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("686","144","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("687","145","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("688","146","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("689","147","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("690","148","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("691","149","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("692","150","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("693","151","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("694","153","793","37","Percentage","3","105000","S","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("695","154","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("696","155","3","31","Percentage","3","6000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("697","1","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("698","2","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("699","6","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("700","14","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("701","15","3","45","Percentage","1.5","3750","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("702","16","2","39","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("703","19","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("704","21","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("705","22","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("706","23","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("707","24","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("708","25","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("709","26","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("710","27","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("711","28","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("712","30","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("713","32","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("714","33","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("715","35","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("716","38","3","45","Percentage","1.5","2250","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("717","39","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("718","40","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("719","41","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("720","42","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("721","43","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("722","48","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("723","50","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("724","52","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("725","54","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("726","55","792","41","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("727","56","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("728","57","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("729","58","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("730","59","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("731","60","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("732","61","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("733","62","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("734","63","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("735","64","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("736","65","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("737","66","3","45","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("738","67","3","45","Percentage","1.5","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("739","68","3","45","Percentage","1.25","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("740","71","3","45","Percentage","1.5","1200","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("741","72","3","45","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("742","74","3","45","Percentage","1.5","225","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("743","77","3","45","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("744","78","3","45","Percentage","1.5","600","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("745","79","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("746","82","3","45","Percentage","1.5","150","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("747","83","3","45","Percentage","1.5","1500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("748","85","3","45","Percentage","1.5","19500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("749","89","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("750","98","3","45","Percentage","1.5","900","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("751","99","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("752","100","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("753","101","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("754","102","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("755","103","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("756","107","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("757","108","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("758","109","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("759","110","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("760","111","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("761","112","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("762","113","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("763","114","3","45","Percentage","1.5","600","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("764","115","3","45","Percentage","1.5","270","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("765","116","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("766","119","792","41","Percentage","1.5","6000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("767","120","792","41","Percentage","1.5","30000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("768","121","3","45","Percentage","1.5","660","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("769","123","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("770","124","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("771","125","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("772","126","2","39","Percentage","1.5","1800","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("773","127","3","45","Percentage","1.5","420","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("774","128","792","41","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("775","129","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("776","130","3","45","Percentage","1.5","675","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("777","131","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("778","132","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("779","133","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("780","134","3","45","Percentage","1.5","750","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("781","135","3","45","Percentage","1.5","900","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("782","136","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("783","137","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("784","138","790","48","Percentage","","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("785","141","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("786","142","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("787","143","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("788","144","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("789","145","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("790","146","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("791","147","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("792","148","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("793","149","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("794","150","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("795","151","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("796","153","793","43","Percentage","3","105000","S","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("797","154","1","0","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("798","155","3","45","Percentage","1.5","3000","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("804","167","791","20","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("805","167","791","21","Amount","303.5","303.5","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("806","167","791","27","Percentage","10","1015310","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("807","167","791","35","Percentage","1.5","152296.5","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("808","167","791","42","Percentage","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("809","166","792","13","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("810","166","792","14","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("811","166","792","15","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("812","166","792","16","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("813","166","792","28","Percentage","10","9700","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("814","166","792","36","Percentage","3","2910","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("815","166","792","41","Percentage","1.5","1455","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("816","166","792","49","Amount","700","700","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("823","168","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("824","168","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("825","169","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("826","169","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("827","170","3","12","Amount","150","150","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("828","170","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("829","170","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("830","170","3","31","Percentage","3","1260","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("831","170","3","45","Percentage","1.5","630","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("842","171","3","12","Amount","105","105","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("843","171","3","17","Amount","500","500","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("844","171","3","19","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("845","171","3","31","Percentage","3","900","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("846","171","3","45","Percentage","1.5","450","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("847","172","2","18","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("848","172","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("849","172","2","29","Percentage","10","20","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("850","172","2","30","Percentage","3","6","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("851","172","2","39","Percentage","1.5","3","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("852","173","2","18","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("853","173","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("854","173","2","29","Percentage","10","1","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("855","173","2","30","Percentage","3","0.3","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("856","173","2","39","Percentage","1.5","0.15","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("857","161","2","18","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("858","161","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("859","161","2","29","Percentage","10","52430","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("860","161","2","30","Percentage","3","15729","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("861","161","2","39","Percentage","1.5","7864.5","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("862","174","2","18","Amount","706","706","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("863","174","2","23","Amount","0","0","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("864","174","2","29","Percentage","10","52430","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("865","174","2","30","Percentage","3","15729","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("866","174","2","39","Percentage","1.5","7864.5","U","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("867","175","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("868","175","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("869","176","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("870","176","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("871","177","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("872","177","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("873","178","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("874","178","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("875","179","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("876","179","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("877","180","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("878","180","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("879","181","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("880","181","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("881","182","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("882","182","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("883","183","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("884","183","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("885","184","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("886","184","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("887","185","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("888","185","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("889","186","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("890","186","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("891","187","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("892","187","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("893","188","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("894","188","1","32","Percentage","10","300","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("895","189","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("896","189","1","32","Percentage","10","300","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("897","190","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("898","190","1","32","Percentage","10","600","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("899","191","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("900","191","1","32","Percentage","10","200","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("901","192","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("902","192","1","32","Percentage","10","1000","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("903","193","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("904","193","1","32","Percentage","10","590","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("905","194","1","11","Amount","0","0","I","0000-00-00","");
INSERT INTO loan_application_charges_procc_fees_updated_wrongly VALUES("906","194","1","32","Percentage","10","1100","I","0000-00-00","");



DROP TABLE loan_application_guarantors;

CREATE TABLE `loan_application_guarantors` (
  `loan_application_guarantor_id` int(11) NOT NULL AUTO_INCREMENT,
  `guar_id` int(11) NOT NULL,
  `guar_name` varchar(500) NOT NULL,
  `guar_phone` varchar(50) NOT NULL,
  `guar_nat_id` varchar(50) NOT NULL,
  `loan_id` int(11) NOT NULL,
  `time_uploaded` datetime NOT NULL,
  `file_name` longtext NOT NULL,
  `file_path` longtext NOT NULL,
  `file_type` varchar(1) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `status1` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`loan_application_guarantor_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO loan_application_guarantors VALUES("1","5","NOLLO TIMOTH TIMOTH","255745859621","20010523254000023","18","2024-10-02 12:27:27","d3b2230WhatsApp Image 2024-09-29 at 17.54.28.jpeg","guarantor_uploads/d3b2230WhatsApp Image 2024-09-29 at 17.54.28.jpeg","","","0","0");
INSERT INTO loan_application_guarantors VALUES("2","3","ALLY  SALIM MRUTU","255766912782","5344444444443544","20","0000-00-00 00:00:00","","","","","0","0");
INSERT INTO loan_application_guarantors VALUES("3","3","ALLY  SALIM MRUTU","255766912782","5344444444443544","30","2025-03-17 00:00:00","a3cf6b5Deployment and Maintenance Report_Reviewed(1).docx","guarantor_uploads/a3cf6b5Deployment and Maintenance Report_Reviewed(1).docx","","","0","0");



DROP TABLE loan_application_security;

CREATE TABLE `loan_application_security` (
  `loan_application_guarantor_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_security_name` varchar(500) NOT NULL,
  `loan_id` int(11) NOT NULL,
  `time_recorded` datetime NOT NULL,
  `status1` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`loan_application_guarantor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE loan_application_uploads;

CREATE TABLE `loan_application_uploads` (
  `loan_application_upload_id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_name` varchar(200) NOT NULL,
  `loan_id` int(11) NOT NULL,
  `time_uploaded` datetime NOT NULL,
  `file_name` longtext NOT NULL,
  `file_path` longtext NOT NULL,
  `file_type` varchar(1) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `status1` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`loan_application_upload_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO loan_application_uploads VALUES("1","Form ya Mkopo","6","2024-05-29 20:43:18","5b592a9Luiche Basin Amcos Limited.pdf","loan_application_uploads/5b592a9Luiche Basin Amcos Limited.pdf","","","0","0");
INSERT INTO loan_application_uploads VALUES("2","HATI GARI","15","2024-10-02 12:23:41","8291696Brochure Front Side.jpg","loan_application_uploads/8291696Brochure Front Side.jpg","","","0","0");



DROP TABLE loan_debtors_journal;

CREATE TABLE `loan_debtors_journal` (
  `loan_debtors_journal_id` int(10) NOT NULL AUTO_INCREMENT,
  `journal_date` date NOT NULL,
  `loan_from_id` int(11) NOT NULL,
  `loan_to_id` int(11) NOT NULL,
  `journal_amount` varchar(100) NOT NULL,
  `journal_comments` mediumtext NOT NULL,
  `journal_member_id` int(10) NOT NULL,
  `journal_ref_no` varchar(11) NOT NULL,
  `journal_recorded_by` int(100) NOT NULL,
  `journal_datetime_recorded` datetime NOT NULL,
  PRIMARY KEY (`loan_debtors_journal_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO loan_debtors_journal VALUES("4","2022-01-05","52","124","3415731","Being Amount Due for loan consolidated 118,643.206 - Principal 1,339,475 and Int 1,483,040and processing fees (KShs 593,216)","13","JVLoan 13m ","136","2022-02-17 12:08:44");



DROP TABLE loan_payments_code;

CREATE TABLE `loan_payments_code` (
  `loan_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_id` int(11) NOT NULL,
  `member_id` int(11) NOT NULL,
  `rep_recorded_by` int(11) NOT NULL,
  `rep_amount_received` varchar(100) NOT NULL,
  `rep_procc_fees` varchar(100) NOT NULL,
  `rep_description` longtext NOT NULL,
  `rep_receipt_no` varchar(100) NOT NULL,
  `rep_cheque_no` varchar(10) NOT NULL,
  `currency_code` varchar(100) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `rep_mop` varchar(11) NOT NULL,
  `rep_date_paid` date NOT NULL,
  `rep_date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rep_account_to_debit` int(11) NOT NULL,
  `account_paid_to` int(11) NOT NULL,
  `canceled_loan_code_id` int(11) NOT NULL,
  PRIMARY KEY (`loan_payment_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

INSERT INTO loan_payments_code VALUES("1","2","2","100","60000","","paid","00001","00766","7","1","9","2024-05-20","2024-05-20 11:50:48","3","3","0");
INSERT INTO loan_payments_code VALUES("2","2","2","100","13333.33","","cash","00002","0003","7","1","7","2024-05-20","2024-05-20 11:58:52","3","3","0");
INSERT INTO loan_payments_code VALUES("3","1","251","100","71875.8","","good in deed","00003","00456","7","1","3","2024-07-15","2024-07-15 05:42:54","3","3","0");
INSERT INTO loan_payments_code VALUES("4","1","251","100","71875.81","","fdfdf","00004","6000","7","1","3","2024-08-13","2024-08-13 15:04:35","4","0","0");
INSERT INTO loan_payments_code VALUES("5","1","251","100","71875.81","","t","00005","007655","7","1","9","2024-08-14","2024-08-14 02:12:37","3","3","0");
INSERT INTO loan_payments_code VALUES("6","1","251","100","71875.81","","v","00006","0004567","7","1","9","2024-08-14","2024-08-14 02:18:17","12","0","0");
INSERT INTO loan_payments_code VALUES("7","2","169","100","32344.11","","nnnnnnnnnn","00007","0087654","7","1","9","2024-08-14","2024-08-14 02:33:03","3","3","0");
INSERT INTO loan_payments_code VALUES("8","2","169","100","32344.11","","ttttttttttttt","00008","004567","7","1","9","2024-08-14","2024-08-14 02:36:22","3","3","0");
INSERT INTO loan_payments_code VALUES("9","1","251","100","71875.8","","y","00009","0006544","7","1","9","2024-08-14","2024-08-14 02:45:07","3","3","0");
INSERT INTO loan_payments_code VALUES("10","3","204","100","31471.82","","vcvcv","00010","00456","7","1","9","2024-08-15","2024-08-15 05:42:04","3","3","0");
INSERT INTO loan_payments_code VALUES("11","6","1","100","33430.63","","mmmmmmmm","00011","00987","7","1","9","2024-09-05","2024-09-05 04:21:22","3","3","0");
INSERT INTO loan_payments_code VALUES("12","17","22","100","215627.42","","dsdsds","00012","0000056","7","1","4","2024-09-05","2024-09-05 15:22:29","3","3","0");
INSERT INTO loan_payments_code VALUES("13","18","166","100","835765.58","","TRTRTRTRT","00013","00768","7","1","3","2024-09-05","2024-09-05 18:39:06","3","3","0");
INSERT INTO loan_payments_code VALUES("14","1","251","100","71875.8","","paid","00014","0007654","7","1","6","2024-09-13","2024-09-13 16:48:25","3","3","0");
INSERT INTO loan_payments_code VALUES("15","1","12","100","25135.62","","REJESHO","00015","123","7","1","7","2024-10-02","2024-10-02 15:00:53","19","19","0");
INSERT INTO loan_payments_code VALUES("16","2","22","100","378918.72","","REJESHO","00016","123","7","1","7","2024-10-02","2024-10-02 15:16:38","19","19","0");
INSERT INTO loan_payments_code VALUES("17","17","20","100","837854.11","","sadas","00017","3434","7","1","7","2024-10-02","2024-10-02 15:48:19","19","19","0");
INSERT INTO loan_payments_code VALUES("18","18","26","100","166944.52","","paid","00018","008765","7","1","7","2024-10-10","2024-10-10 10:50:44","19","19","0");
INSERT INTO loan_payments_code VALUES("19","31","33","100","281502.31","","return","00019","9898y","7","1","7","2025-03-09","2025-03-09 12:56:51","19","19","0");



DROP TABLE loan_products;

CREATE TABLE `loan_products` (
  `loan_product_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_product_name` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `loan_product_desc` longtext COLLATE latin1_general_ci,
  PRIMARY KEY (`loan_product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO loan_products VALUES("1","vehicle","Toyota Fielder KCG002A");



DROP TABLE loan_products_charges;

CREATE TABLE `loan_products_charges` (
  `loan_product_charge_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_type_id` int(11) NOT NULL,
  `loan_product_charge_name` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `product_charge_value_type` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `product_charge_value` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `net_rev_value` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `product_charge_mode` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `expiry_date_req` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `expiry_date_freq` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `loan_product_charge_desc` longtext COLLATE latin1_general_ci,
  `revenue_account_id` int(11) NOT NULL,
  `ex_duty` int(11) NOT NULL,
  `ex_duty_account_id` int(11) NOT NULL,
  `wht` int(11) NOT NULL,
  `wht_account_id` int(11) NOT NULL,
  PRIMARY KEY (`loan_product_charge_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1000007 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO loan_products_charges VALUES("1000001","1","","Amount","0","","U","No","Once","S","67","0","0","0","0");
INSERT INTO loan_products_charges VALUES("1000002","5","Processing fee","Percentage","10","","U","","","U","16","0","0","0","0");
INSERT INTO loan_products_charges VALUES("1000003","6","Processing fee","Percentage","10","","U","","","U","26","0","0","0","0");
INSERT INTO loan_products_charges VALUES("1000004","6","Penalty","Percentage","0.3","","I","","","I","27","0","0","0","0");
INSERT INTO loan_products_charges VALUES("1000005","7","Processing fee","Percentage","10","","U","","","U","26","0","0","0","0");
INSERT INTO loan_products_charges VALUES("1000006","7","Penalty","Percentage","0.3","","I","","","I","27","0","0","0","0");



DROP TABLE loan_products_charges_copy;

CREATE TABLE `loan_products_charges_copy` (
  `loan_product_charge_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_type_id` int(11) NOT NULL,
  `loan_product_charge_name` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `product_charge_value_type` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `product_charge_value` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `product_charge_mode` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `expiry_date_req` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `expiry_date_freq` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `loan_product_charge_desc` longtext COLLATE latin1_general_ci,
  `revenue_account_id` int(11) NOT NULL,
  PRIMARY KEY (`loan_product_charge_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;




DROP TABLE loan_refund;

CREATE TABLE `loan_refund` (
  `loan_refund_id` int(11) NOT NULL AUTO_INCREMENT,
  `refund_description` longtext NOT NULL,
  `currency` int(11) NOT NULL,
  `curr_rate` int(11) NOT NULL,
  `refund_receipt_no` varchar(100) NOT NULL,
  `refund_date` date NOT NULL,
  `refund_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `refund_status` int(11) NOT NULL,
  `refund_recorded_by` int(11) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  `our_bank_account_id` int(11) NOT NULL,
  `amount_credited` varchar(100) NOT NULL,
  `mop_id` int(11) NOT NULL,
  `refund_voucher_no` varchar(100) NOT NULL,
  `member_id` int(11) NOT NULL,
  `loan_id` int(11) NOT NULL,
  `refund_approved_by` int(11) NOT NULL,
  `refund_datetime_approved` datetime NOT NULL,
  `refund_date_approved` date NOT NULL,
  `refund_approval_comment` longtext NOT NULL,
  PRIMARY KEY (`loan_refund_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE loan_repayment;

CREATE TABLE `loan_repayment` (
  `loan_repayment_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `principle_repaid_amount` varchar(10) NOT NULL,
  `principle_credit_account_id` int(11) NOT NULL,
  `interest_paid` varchar(10) NOT NULL,
  `non_ded_charges_paid` varchar(100) NOT NULL,
  `interest_credit_account_id` int(11) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `multiple_loan_payment_code_id` int(11) NOT NULL,
  `loan_schedule_id` int(11) NOT NULL,
  `ttl_repaid_amount` varchar(100) NOT NULL,
  `date_repaid` date NOT NULL,
  `write_off` int(11) NOT NULL,
  `waiver` varchar(11) NOT NULL,
  `canceled_loan_code_id` int(11) NOT NULL,
  `rep_date_paid` date NOT NULL,
  PRIMARY KEY (`loan_repayment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO loan_repayment VALUES("1","12","24885.62","2","250","","15","1","15","0","1","","2024-10-02","0","","0","0000-00-00");
INSERT INTO loan_repayment VALUES("2","22","371418.72","2","7500","","15","2","16","0","13","","2024-10-02","0","","0","0000-00-00");
INSERT INTO loan_repayment VALUES("3","20","165904.16","2","1666.67","","15","17","17","0","313","","2024-10-02","0","","0","0000-00-00");
INSERT INTO loan_repayment VALUES("4","20","166042.41","2","1528.41","","15","17","17","0","314","","2024-10-02","0","","0","0000-00-00");
INSERT INTO loan_repayment VALUES("5","20","166180.78","2","1390.04","","15","17","17","0","315","","2024-10-02","0","","0","0000-00-00");
INSERT INTO loan_repayment VALUES("6","20","166319.26","2","1251.56","","15","17","17","0","316","","2024-10-02","0","","0","0000-00-00");
INSERT INTO loan_repayment VALUES("7","20","166457.86","2","1112.96","","15","17","17","0","317","","2024-10-02","0","","0","0000-00-00");
INSERT INTO loan_repayment VALUES("8","26","166527.85","2","416.67","","16","18","18","0","361","","2024-10-10","0","","0","0000-00-00");
INSERT INTO loan_repayment VALUES("9","33","229002.31","2","52500","","15","31","19","0","682","","2025-03-09","0","","0","0000-00-00");



DROP TABLE loan_repayment_backup_before125;

CREATE TABLE `loan_repayment_backup_before125` (
  `loan_repayment_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `principle_repaid_amount` varchar(10) NOT NULL,
  `principle_credit_account_id` int(11) NOT NULL,
  `interest_paid` varchar(10) NOT NULL,
  `non_ded_charges_paid` varchar(100) NOT NULL,
  `interest_credit_account_id` int(11) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `multiple_loan_payment_code_id` int(11) NOT NULL,
  `loan_schedule_id` int(11) NOT NULL,
  `ttl_repaid_amount` varchar(100) NOT NULL,
  `date_repaid` date NOT NULL,
  PRIMARY KEY (`loan_repayment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE loan_repayment_copy_26_09_2023;

CREATE TABLE `loan_repayment_copy_26_09_2023` (
  `loan_repayment_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `principle_repaid_amount` varchar(10) NOT NULL,
  `principle_credit_account_id` int(11) NOT NULL,
  `interest_paid` varchar(10) NOT NULL,
  `non_ded_charges_paid` varchar(100) NOT NULL,
  `interest_credit_account_id` int(11) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `multiple_loan_payment_code_id` int(11) NOT NULL,
  `loan_schedule_id` int(11) NOT NULL,
  `ttl_repaid_amount` varchar(100) NOT NULL,
  `date_repaid` date NOT NULL,
  `write_off` int(11) NOT NULL,
  `waiver` varchar(11) NOT NULL,
  `canceled_loan_code_id` int(11) NOT NULL,
  PRIMARY KEY (`loan_repayment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE loan_repayment_old;

CREATE TABLE `loan_repayment_old` (
  `loan_repayment_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `rep_subscription_month` varchar(50) NOT NULL,
  `rep_subscription_month_year` varchar(10) NOT NULL,
  `rep_subscription_year` int(5) NOT NULL,
  `ttl_repaid_amount` varchar(15) NOT NULL,
  `principle_repaid_amount` varchar(10) NOT NULL,
  `interest_paid` varchar(10) NOT NULL,
  `interest_tax` varchar(10) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `rep_date_paid` date NOT NULL,
  `rep_date_drawn` date NOT NULL,
  `rep_date_paid_recorded` datetime NOT NULL,
  `rep_paid_by` int(11) NOT NULL,
  `rep_comments` longtext NOT NULL,
  `rep_mop` int(11) NOT NULL,
  `rep_ref_no` varchar(50) NOT NULL,
  `rep_our_bank` int(11) NOT NULL,
  `rep_client_bank` varchar(100) NOT NULL,
  `rep_account_name` varchar(100) NOT NULL,
  `rep_account_no` varchar(50) NOT NULL,
  `rep_status` int(11) NOT NULL,
  `rep_status1` int(1) NOT NULL,
  `rep_status2` int(1) NOT NULL,
  `offset_mode` int(1) NOT NULL,
  `receipt_no` varchar(100) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  PRIMARY KEY (`loan_repayment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE loan_repayment_other_charges;

CREATE TABLE `loan_repayment_other_charges` (
  `loan_repayment_other_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `other_amount_repaid` varchar(100) NOT NULL,
  `rep_introduced_loan_charges_id` int(11) NOT NULL,
  `rep_loan_product_charge_id` int(11) NOT NULL,
  `other_account_credited` int(11) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `multiple_loan_payment_code_id` int(11) NOT NULL,
  `loan_repayment_other_charges_date` date NOT NULL,
  `write_off` int(11) NOT NULL,
  `waiver` varchar(10) NOT NULL,
  `canceled_loan_code_id` int(11) NOT NULL,
  `top_up_id` int(11) NOT NULL,
  PRIMARY KEY (`loan_repayment_other_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE loan_repayment_other_charges_copy2;

CREATE TABLE `loan_repayment_other_charges_copy2` (
  `loan_repayment_other_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `other_amount_repaid` varchar(100) NOT NULL,
  `rep_introduced_loan_charges_id` int(11) NOT NULL,
  `rep_loan_product_charge_id` int(11) NOT NULL,
  `other_account_credited` int(11) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `multiple_loan_payment_code_id` int(11) NOT NULL,
  `loan_repayment_other_charges_date` date NOT NULL,
  `write_off` int(11) NOT NULL,
  `waiver` varchar(10) NOT NULL,
  `canceled_loan_code_id` int(11) NOT NULL,
  `top_up_id` int(11) NOT NULL,
  PRIMARY KEY (`loan_repayment_other_id`)
) ENGINE=InnoDB AUTO_INCREMENT=560 DEFAULT CHARSET=latin1;

INSERT INTO loan_repayment_other_charges_copy2 VALUES("3","31","18600","2","28","14","55","18","0","2022-02-05","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("4","57","11263","3","28","14","128","19","0","2022-02-15","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("5","52","4534","4","28","14","119","33","0","2022-03-21","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("6","13","65000","6","35","122","52","0","26","2022-02-28","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("7","60","1480","10","29","18","126","69","0","2022-05-25","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("8","60","3108","11","29","18","126","69","0","2022-05-25","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("9","13","593216","7","34","0","124","80","0","2022-01-22","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("10","75","10914","14","28","141","159","118","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("11","75","3740","12","28","141","159","118","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("12","75","3400","9","28","141","159","118","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("13","60","3108","6","10","18","126","158","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("14","52","3587","13","28","141","119","270","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("15","125","155766","15","28","141","359","438","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("16","157","5250","60","28","141","562","653","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("17","75","3400","124","28","141","159","50905","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("18","182","1737.75","151","28","141","587","50930","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("19","173","3696","58","28","141","559","50977","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("20","177","2940","146","28","141","575","50978","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("21","108","33733.3333","112","28","141","540","50979","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("22","108","30666.6666","65","28","141","540","50979","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("23","108","11427.9","44","28","141","485","50979","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("24","108","12571.09","100","28","141","485","50979","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("26","141","14975.7333","56","28","141","553","0","320","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("27","66","407136.48","154","1016","122","431","0","321","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("28","66","407136.48","155","1016","122","431","0","322","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("29","159","9915.98333","67","28","141","544","0","325","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("30","136","1429.65","122","28","141","566","0","332","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("31","66","1475.25513","97","25","0","480","51000","0","0000-00-00","0","YES","93","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("32","66","1407.25921","41","25","0","480","51000","0","0000-00-00","0","YES","93","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("34","66","2771.03714","17","25","0","238","51003","0","0000-00-00","0","YES","96","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("35","66","12978.0624","72","25","0","239","51004","0","0000-00-00","0","YES","97","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("36","66","11798.2385","18","25","0","239","51004","0","0000-00-00","0","YES","97","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("37","66","16301.9323","75","25","0","271","51005","0","0000-00-00","0","YES","98","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("38","66","14819.9384","21","25","0","271","51005","0","0000-00-00","0","YES","98","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("39","66","13042.1282","79","25","0","343","51009","0","0000-00-00","0","YES","102","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("40","66","11856.4802","62","25","0","343","51009","0","0000-00-00","0","YES","102","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("41","66","5231.70063","80","25","0","349","51010","0","0000-00-00","0","YES","103","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("42","66","4756.09148","63","25","0","349","51010","0","0000-00-00","0","YES","103","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("43","173","4065","119","28","141","559","51014","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("44","66","165009.808","91","25","0","431","51020","0","0000-00-00","0","YES","107","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("45","66","1213.91798","35","25","0","431","51020","0","0000-00-00","0","YES","107","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("46","13","18584.2277","123","27","0","158","51021","0","0000-00-00","0","YES","108","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("47","13","24778.3974","125","27","0","167","51022","0","0000-00-00","0","YES","109","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("48","13","73604.7613","126","27","0","203","51023","0","0000-00-00","0","YES","110","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("49","13","24905.7896","127","25","0","235","51024","0","0000-00-00","0","YES","111","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("50","13","12454.2386","128","25","0","237","51025","0","0000-00-00","0","YES","112","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("51","13","12454.2385","129","25","0","245","51026","0","0000-00-00","0","YES","113","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("52","37","4664.09999","130","25","0","270","51027","0","0000-00-00","0","YES","114","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("54","13","11209.1078","132","25","0","284","51029","0","0000-00-00","0","YES","116","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("55","13","7473.58930","133","25","0","287","51030","0","0000-00-00","0","YES","117","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("56","13","24905.5589","135","25","0","348","51031","0","0000-00-00","0","YES","118","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("57","13","4983.30155","136","25","0","357","51032","0","0000-00-00","0","YES","119","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("58","13","24905.5585","137","25","0","379","51033","0","0000-00-00","0","YES","120","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("59","13","9963.86447","138","25","0","423","51034","0","0000-00-00","0","YES","121","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("60","13","12454.1473","140","25","0","436","51035","0","0000-00-00","0","YES","122","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("61","13","9963.86510","141","25","0","482","51036","0","0000-00-00","0","YES","123","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("62","13","24905.5581","142","25","0","484","51037","0","0000-00-00","0","YES","124","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("63","13","19924.9940","145","25","0","569","51038","0","0000-00-00","0","YES","125","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("64","13","4983.30351","147","25","0","578","51039","0","0000-00-00","0","YES","126","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("65","13","3738.16279","148","25","0","581","51040","0","0000-00-00","0","YES","127","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("68","66","2771.03714","17","25","0","238888","51047","0","0000-00-00","0","YES","132","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("69","66","12978.0624","72","25","0","239999","51048","0","0000-00-00","0","YES","133","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("70","66","11798.2385","18","25","0","239999","51048","0","0000-00-00","0","YES","133","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("71","66","16301.9323","75","25","0","2712222","51049","0","0000-00-00","0","YES","134","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("72","66","14819.9384","21","25","0","2712222","51049","0","0000-00-00","0","YES","134","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("73","66","9714.657857","61","27","0","140","51050","0","0000-00-00","0","YES","135","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("74","6666666","13042.1282","79","25","0","343333333","51051","0","0000-00-00","0","YES","136","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("75","66666666","11856.4802","62","25","0","343333333","51051","0","0000-00-00","0","YES","136","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("77","13","24778.3974","125","27","0","1677777","51053","0","0000-00-00","0","YES","138","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("78","13","73604.7613","126","27","0","203444","51054","0","0000-00-00","0","YES","139","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("79","1399999","24905.7896","127","25","0","235888888","51055","0","0000-00-00","0","YES","140","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("82","37","4664.09999","130","25","0","270","51058","0","0000-00-00","0","YES","143","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("83","1333333","11209.1078","132","25","0","28444444","51059","0","0000-00-00","0","YES","144","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("84","13","7473.58930","133","25","0","2878888","51060","0","0000-00-00","0","YES","145","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("85","148","4947.27333","139","28","141","427","0","354","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("86","52","12650","108","28","141","500","0","359","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("87","52","11500","53","28","141","500","0","359","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("88","52","12261.964","101","28","141","486","0","360","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("89","52","15750","45","28","141","486","0","360","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("90","52","18715.4531","94","28","141","470","0","360","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("91","52","22154.531","38","28","141","470","0","360","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("92","52","13800","85","28","141","377","0","360","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("93","52","23000","29","28","141","377","0","360","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("94","66","31779.1","70","27","0","136","51067","0","0000-00-00","0","YES","146","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("95","66","31779.1","16","27","0","136","51067","0","0000-00-00","0","YES","146","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("96","66","277.101857","71","25","0","238","51068","0","0000-00-00","0","YES","147","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("97","13","14944.5","131","25","0","276","51069","0","0000-00-00","0","YES","148","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("98","167","127600","115","25","122","547","0","366","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("99","167","116000","66","25","122","547","0","366","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("100","97","3740","74","28","141","246","0","368","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("101","97","3400","20","28","141","246","0","368","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("102","97","17696.8018","110","28","141","502","0","368","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("103","97","16088.0016","55","28","141","502","0","368","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("104","97","9200","150","28","141","584","0","368","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("105","97","19572.181","102","28","141","487","0","368","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("106","97","26894.71","46","28","141","487","0","368","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("107","157","5250","121","28","141","562","51115","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("108","159","10907.5816","113","28","141","544","0","385","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("109","149","15314.6666","143","28","141","556","0","387","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("110","75","7140","458","28","141","159","0","423","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("111","75","3400","329","28","141","159","0","423","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("112","148","989.413666","518","28","141","427","0","434","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("113","173","7801.5","566","28","141","847","0","436","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("114","216","18861.15","556","28","141","785","0","437","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("115","216","17146.5","479","28","141","785","0","437","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("116","159","10791.984","392","28","141","544","0","385","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("117","159","1079.199406","505","28","141","544","0","385","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("118","159","1187.119346","591","28","141","544","0","385","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("119","75","3400","533","28","141","159","0","385","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("120","221","48510","543","28","141","781","0","445","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("121","221","23100","467","28","141","781","0","445","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("122","202","20993.621","598","28","141","761","0","446","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("123","202","19085.11","512","28","141","761","0","446","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("124","202","17350.1","385","28","141","761","0","446","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("125","181","22050","152","28","141","588","0","447","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("127","201","13022.5","358","28","141","686","0","448","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("128","201","12457.225","535","28","141","686","0","449","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("130","195","1110.9","377","28","141","663","0","449","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("132","195","11109","324","28","141","663","0","449","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("133","195","1221.99","450","28","141","663","0","449","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("134","195","1344.189","525","28","141","663","0","449","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("135","201","11324.75","461","28","141","686","0","448","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("136","203","12475.53","546","28","141","691","0","466","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("137","203","11341.77","470","28","141","691","0","466","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("138","203","10310.7","359","28","141","691","0","466","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("139","188","1103","583","28","141","637","51311","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("140","188","5775","373","28","141","637","51311","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("141","188","5250","321","28","141","637","51311","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("142","148","4200","599","28","141","894","0","477","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("143","203","10312","546","28","141","691","51357","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("144","196","55495.394","532","28","141","662","0","484","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("145","196","21198.54","457","28","141","662","0","484","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("146","196","19271.4","376","28","141","662","0","484","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("147","126","10534.26","541","28","141","375","0","485","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("148","126","9576.60000","466","28","141","375","0","485","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("149","126","8706.00000","338","28","141","375","0","485","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("150","126","25300","84","28","141","375","0","485","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("151","126","23000","28","28","141","375","0","485","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("152","126","11588.13","624","28","141","375","0","485","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("153","109","20718.1130","627","28","141","501","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("154","109","18834.6482","544","28","141","501","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("155","109","17122.4074","468","28","141","501","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("156","109","15565.8249","366","28","141","501","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("157","109","5334.08333","109","28","141","501","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("158","109","4849.16666","54","28","141","501","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("159","109","17682.9690","558","28","141","279","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("160","109","16075.4263","480","28","141","279","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("161","109","14614.0239","332","28","141","279","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("162","109","34329.8399","76","28","141","279","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("163","109","47594.3999","22","28","141","279","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("164","109","19588.1","641","28","141","279","0","491","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("165","247","702.8","688","49","141","973","0","495","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("166","169","205905.7","592","29","18","545","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("167","169","187187","506","29","18","545","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("168","169","170170","393","29","18","545","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("169","169","84700","114","29","18","545","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("170","169","77000","68","29","18","545","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("171","169","231276.223","522","29","18","561","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("172","169","210251.112","446","29","18","561","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("173","169","191137.375","352","29","18","561","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("174","169","95136.25","120","29","18","561","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("175","169","86487.5","59","29","18","561","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("176","169","254403.84","612","29","18","561","0","498","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("177","232","6461.4","686","28","141","895","0","501","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("178","232","5874","600","28","141","895","0","501","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("179","154","19166.6666","380","28","141","747","0","513","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("180","154","40249.9666","584","28","141","747","0","513","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("181","173","4581.5","651","28","141","847","0","514","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("182","244","33000","678","28","141","965","0","515","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("183","31","28275.98","144","28","141","568","0","523","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("184","236","55414.3","700","28","141","902","0","524","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("185","236","57761","614","28","141","902","0","524","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("186","148","1088.34800","605","28","141","427","0","525","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("187","148","4947.26666","343","28","141","427","0","525","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("188","239","11627.77","618","28","141","911","0","539","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("189","239","12790.53","707","28","141","911","0","539","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("190","154","38702.0366","753","28","141","747","0","545","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("191","154","44274.9633","670","28","141","747","0","545","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("192","224","7463.83","733","28","141","786","0","546","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("193","224","6784.47","649","28","141","786","0","546","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("194","224","6167.7","564","28","141","786","0","546","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("195","224","5607","485","28","141","786","0","546","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("196","202","13092.98","685","28","141","761","0","550","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("197","11","1600.85333","723","29","0","982","51431","0","0000-00-00","0","YES","159","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("198","148","2549.13","773","28","141","427","0","576","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("199","202","1331.297","766","28","141","761","51475","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("200","202","13093.7","766","28","141","761","51475","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("201","90","150000","542","28","141","776","51493","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("202","90","72134.1","625","28","141","776","51494","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("203","90","27865.9","542","28","141","776","51494","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("204","90","123518.39","625","28","141","776","51495","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("205","231","8066.06","760","28","141","1022","0","583","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("206","247","5000","790","49","141","973","0","588","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("207","247","15751.69","780","28","141","973","0","588","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("208","247","14319.72","689","28","141","973","0","588","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("209","196","45000","699","28","141","662","51504","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("210","231","16132.1234","833","28","0","1022","51510","0","0000-00-00","0","YES","160","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("211","148","2664.64","773","28","141","427","0","612","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("213","247","11633.49","870","28","141","1159","0","654","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("214","247","16031.61","884","28","141","973","0","654","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("215","248","2252.06933","703","29","0","978","51626","0","0000-00-00","0","YES","168","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("216","256","229.101833","879","28","0","1092","51627","0","0000-00-00","0","YES","169","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("217","256","2290.31833","838","28","0","1092","51627","0","0000-00-00","0","YES","169","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("218","71","655","864","29","0","195","51628","0","0000-00-00","0","YES","170","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("219","71","441.963","863","29","0","820","51629","0","0000-00-00","0","YES","171","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("220","71","787.188","867","29","0","635","51630","0","0000-00-00","0","YES","172","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("221","71","771.606010","860","29","0","326","51631","0","0000-00-00","0","YES","173","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("222","71","104.869100","818","29","0","326","51631","0","0000-00-00","0","YES","173","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("223","71","95.3810005","739","29","0","326","51631","0","0000-00-00","0","YES","173","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("224","71","86.755455","655","29","0","326","51631","0","0000-00-00","0","YES","173","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("225","71","78.91405","570","29","0","326","51631","0","0000-00-00","0","YES","173","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("226","71","71.7855","489","29","0","326","51631","0","0000-00-00","0","YES","173","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("227","71","65.305","334","29","0","326","51631","0","0000-00-00","0","YES","173","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("228","71","656.05","134","29","0","326","51631","0","0000-00-00","0","YES","173","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("229","148","4947.33","881","28","141","427","0","670","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("230","247","10434.69","884","28","141","973","0","676","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("231","141","150935.4","901","28","0","916","51709","0","0000-00-00","0","YES","175","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("232","141","137214","857","28","0","916","51709","0","0000-00-00","0","YES","175","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("233","261","4650","907","28","141","1143","0","697","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("234","11","1775.12133","900","29","0","1106","51721","0","0000-00-00","0","YES","180","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("235","231","10470","923","28","141","1022","0","710","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("236","159","20086.605","883","28","0","900","51732","0","0000-00-00","0","YES","181","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("237","159","62999.2200","897","28","0","912","51733","0","0000-00-00","0","YES","182","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("238","159","57272.0182","854","28","0","912","51733","0","0000-00-00","0","YES","182","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("239","159","26034.1477","905","28","0","629","51734","0","0000-00-00","0","YES","183","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("240","159","23667.4070","861","28","0","629","51734","0","0000-00-00","0","YES","183","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("241","159","80027.6864","903","28","0","701","51735","0","0000-00-00","0","YES","184","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("242","159","72752.4422","859","28","0","701","51735","0","0000-00-00","0","YES","184","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("243","159","108661.507","892","28","0","835","51736","0","0000-00-00","0","YES","185","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("244","159","85980.1583","849","28","0","835","51736","0","0000-00-00","0","YES","185","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("245","51","29361.89","727","28","141","913","0","731","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("246","51","13981.85","642","28","141","913","0","731","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("249","51","11376.71","701","28","141","979","0","731","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("250","51","42511.28","925","28","141","1173","0","731","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("251","51","20243.47","887","28","141","1173","0","731","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("252","146","1596","890","31","16","1101","0","732","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("253","144","42000","928","28","141","897","51737","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("254","144","318000","882","28","141","897","51737","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("255","144","180000","776","28","141","897","51737","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("256","144","60000","608","28","141","897","51737","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("257","144","367800","928","28","141","897","0","735","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("258","218","746.2917","763","28","0","758","51744","0","0000-00-00","0","YES","186","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("259","218","678.447","682","28","0","758","51744","0","0000-00-00","0","YES","186","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("260","218","616.77","595","28","0","758","51744","0","0000-00-00","0","YES","186","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("261","218","560.7","509","28","0","758","51744","0","0000-00-00","0","YES","186","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("262","218","5607","384","28","0","758","51744","0","0000-00-00","0","YES","186","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("263","157","1860.13905","924","28","0","771","51745","0","0000-00-00","0","YES","187","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("264","157","1691.0355","886","28","0","771","51745","0","0000-00-00","0","YES","187","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("265","157","1537.305","842","28","0","771","51745","0","0000-00-00","0","YES","187","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("266","157","1397.55","789","28","0","771","51745","0","0000-00-00","0","YES","187","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("267","157","1270.5","698","28","0","771","51745","0","0000-00-00","0","YES","187","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("268","157","1155","531","28","0","771","51745","0","0000-00-00","0","YES","187","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("269","157","1050","456","28","0","771","51745","0","0000-00-00","0","YES","187","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("270","157","10500","391","28","0","771","51745","0","0000-00-00","0","YES","187","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("271","197","380.666","784","28","0","664","51746","0","0000-00-00","0","YES","188","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("272","197","346.06","693","28","0","664","51746","0","0000-00-00","0","YES","188","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("273","197","314.6","526","28","0","664","51746","0","0000-00-00","0","YES","188","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("274","197","286","451","28","0","664","51746","0","0000-00-00","0","YES","188","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("275","197","260","378","28","0","664","51746","0","0000-00-00","0","YES","188","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("276","197","2600","325","28","0","664","51746","0","0000-00-00","0","YES","188","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("277","118","6752.30475","921","28","0","483","51747","0","0000-00-00","0","YES","189","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("278","118","6138.45886","880","28","0","483","51747","0","0000-00-00","0","YES","189","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("279","118","5580.41715","839","28","0","483","51747","0","0000-00-00","0","YES","189","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("285","136","423.610340","930","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("286","136","385.100309","893","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("287","136","350.091190","850","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("288","136","318.264718","798","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("289","136","289.331562","712","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("290","136","263.028692","623","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("291","136","239.116993","540","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("292","136","217.379085","465","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("293","136","197.61735","337","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("294","136","1035.1385","83","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("295","136","941.035","27","28","0","373","51752","0","0000-00-00","0","YES","190","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("296","196","12911.63","699","28","141","662","0","738","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("297","137","33850","345","28","141","469","51756","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("298","137","34650","93","28","141","469","51756","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("299","137","31500","37","28","141","469","51756","0","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("300","31","3.25","144","28","141","568","0","755","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("301","240","63066","943","28","141","1342","0","756","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("302","261","4750","937","28","141","1143","0","762","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("303","272","59","952","29","0","1172","51851","0","0000-00-00","0","YES","197","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("304","284","3577.92533","953","29","0","1263","51852","0","0000-00-00","0","YES","198","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("305","88","113092.955","959","28","0","1366","51860","0","0000-00-00","0","YES","199","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("433","98","12466.67","73","28","141","244","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("434","98","11333.33","19","28","141","244","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("435","113","27370.62","736","28","141","288","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("436","113","24882.38","652","28","141","288","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("437","113","22620.35","567","28","141","288","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("438","113","20563.95","486","28","141","288","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("439","113","18694.5","333","28","141","288","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("440","113","16995","77","28","141","288","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("441","113","15450","23","28","141","288","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("442","79","21254.75","81","28","141","360","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("443","79","19322.5","25","28","141","360","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("444","143","7943.21","720","28","141","387","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("445","143","7221.1","635","28","141","387","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("446","143","6564.64","552","28","141","387","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("447","143","5967.85","476","28","141","387","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("448","143","5425.32","342","28","141","387","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("449","143","4932.11","89","28","141","387","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("450","143","4483.74","33","28","141","387","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("451","118","10868.61","719","28","141","385","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("452","118","9880.55","634","28","141","385","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("453","118","8982.32","551","28","141","385","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("454","118","8165.74","475","28","141","385","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("455","118","7423.4","341","28","141","385","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("456","118","6748.55","88","28","141","385","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("457","118","6135.05","32","28","141","385","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("458","118","5073.11","769","28","141","483","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("459","118","4611.92","602","28","141","483","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("460","118","4192.65","515","28","141","483","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("461","118","3811.5","395","28","141","483","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("462","118","3465","99","28","141","483","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("463","118","3150","43","28","141","483","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("464","139","169103.55","675","28","141","366","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("465","139","153730.5","589","28","141","366","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("466","139","139755","503","28","141","366","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("467","139","127050","336","28","141","366","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("468","139","115500","82","28","141","366","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("469","139","105000","26","28","141","366","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("470","139","169103.55","672","28","141","433","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("471","139","153730.5","586","28","141","433","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("472","139","139755","500","28","141","433","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("473","139","127050","344","28","141","433","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("474","139","115500","92","28","141","433","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("475","139","105000","36","28","141","433","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("476","139","169103.55","644","28","141","493","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("477","139","153730.5","559","28","141","493","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("478","139","139755","481","28","141","493","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("479","139","127050","328","28","141","493","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("480","139","115500","105","28","141","493","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("481","139","105000","50","28","141","493","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("482","139","153528.83","664","28","141","585","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("483","139","139571.67","577","28","141","585","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("484","139","126883.33","496","28","141","585","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("485","139","80500","370","28","141","585","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("486","139","38333.33","318","28","141","585","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("487","142","55804.17","757","28","141","380","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("488","142","50731.07","676","28","141","380","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("489","142","46119.15","590","28","141","380","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("490","142","41926.5","504","28","141","380","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("491","142","38115","339","28","141","380","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("492","142","34650","86","28","141","380","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("493","142","31500","30","28","141","380","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("494","156","3720.28","782","28","141","488","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("495","156","3382.07","691","28","141","488","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("496","156","3074.61","523","28","141","488","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("497","156","2795.1","448","28","141","488","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("498","156","2541","396","28","141","488","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("499","156","2310","103","28","141","488","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("500","156","2100","47","28","141","488","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("501","158","27138.42","709","28","141","492","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("502","158","24671.3","620","28","141","492","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("503","158","22428.45","537","28","141","492","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("504","158","20389.5","462","28","141","492","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("505","158","14445","327","28","141","492","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("506","158","4950","104","28","141","492","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("507","158","4500","49","28","141","492","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("508","168","172143.43","908","28","141","633","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("509","168","156494.03","865","28","141","633","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("510","168","142267.3","825","28","141","633","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("511","168","129333.91","748","28","141","633","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("512","168","117576.28","665","28","141","633","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("513","168","106887.53","578","28","141","633","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("514","168","97170.48","497","28","141","633","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("515","168","88336.8","371","28","141","633","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("516","168","33488","319","28","141","633","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("517","194","8270.26","770","28","141","651","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("518","194","7518.42","603","28","141","651","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("519","194","5362.2","516","28","141","651","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("520","194","3402","375","28","141","651","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("521","194","1620","323","28","141","651","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("522","205","34297.42","931","28","141","694","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("523","205","31179.47","894","28","141","694","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("524","205","28344.98","851","28","141","694","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("525","205","25768.16","801","28","141","694","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("526","205","23425.6","715","28","141","694","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("527","205","21296","630","28","141","694","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("528","205","19360","547","28","141","694","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("529","205","17600","471","28","141","694","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("530","205","6000","361","28","141","694","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("531","204","33820.71","805","28","141","693","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("532","204","30746.1","721","28","141","693","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("533","204","27951","636","28","141","693","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("534","204","25410","553","28","141","693","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("535","204","23100","477","28","141","693","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("536","204","21000","360","28","141","693","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("537","207","53930.75","906","28","141","719","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("538","207","49027.95","862","28","141","719","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("539","207","44570.86","820","28","141","719","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("540","207","40518.97","741","28","141","719","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("541","207","36835.43","657","28","141","719","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("542","207","33486.75","572","28","141","719","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("543","207","30442.5","491","28","141","719","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("544","207","11925","364","28","141","719","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("545","193","2582.67","747","28","141","734","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("546","193","2347.88","663","28","141","734","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("547","193","2134.44","576","28","141","734","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("548","193","1940.4","495","28","141","734","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("549","193","1764","379","28","141","734","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("550","197","27951","754","28","141","753","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("551","197","25410","671","28","141","753","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("552","197","23100","585","28","141","753","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("553","197","11000","381","28","141","753","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("554","220","15516.47","785","28","141","767","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("555","220","14105.88","694","28","141","767","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("556","220","12823.53","527","28","141","767","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("557","220","6382.75","452","28","141","767","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("558","220","5802.5","388","28","141","767","0","808","0000-00-00","0","","0","0");
INSERT INTO loan_repayment_other_charges_copy2 VALUES("559","222","23059.58","794","28","141","774","0","808","0000-00-00","0","","0","0");



DROP TABLE loan_repayment_other_charges_old;

CREATE TABLE `loan_repayment_other_charges_old` (
  `loan_repayment_other_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `other_amount_repaid` varchar(10) NOT NULL,
  `rep_introduced_loan_charges_id` int(11) NOT NULL,
  `rep_loan_product_charge_id` int(11) NOT NULL,
  `other_account_credited` int(11) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `multiple_loan_payment_code_id` int(11) NOT NULL,
  PRIMARY KEY (`loan_repayment_other_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE loan_schedule;

CREATE TABLE `loan_schedule` (
  `loan_schedule_id` int(10) NOT NULL AUTO_INCREMENT,
  `schedule_date` date NOT NULL,
  `loan_id` int(11) NOT NULL,
  `principle_installment` varchar(100) NOT NULL,
  `interest_installment` longtext NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `journal_user_id` int(11) NOT NULL,
  `schedule_status` int(1) NOT NULL,
  `reversed` int(11) NOT NULL,
  PRIMARY KEY (`loan_schedule_id`)
) ENGINE=MyISAM AUTO_INCREMENT=712 DEFAULT CHARSET=latin1;

INSERT INTO loan_schedule VALUES("1","2024-10-02","1","24885.623466742","250","","0","0","0");
INSERT INTO loan_schedule VALUES("2","2024-11-02","1","24906.361486297","229.26198044438","","0","0","0");
INSERT INTO loan_schedule VALUES("3","2024-12-02","1","24927.116787536","208.5066792058","","0","0","0");
INSERT INTO loan_schedule VALUES("4","2025-01-02","1","24947.889384859","187.73408188285","","0","0","0");
INSERT INTO loan_schedule VALUES("5","2025-02-02","1","24968.679292679","166.94417406214","","0","0","0");
INSERT INTO loan_schedule VALUES("6","2025-03-02","1","24989.486525423","146.13694131824","","0","0","0");
INSERT INTO loan_schedule VALUES("7","2025-04-02","1","25010.311097528","125.31236921372","","0","0","0");
INSERT INTO loan_schedule VALUES("8","2025-05-02","1","25031.153023442","104.47044329911","","0","0","0");
INSERT INTO loan_schedule VALUES("9","2025-06-02","1","25052.012317629","83.611149112911","","0","0","0");
INSERT INTO loan_schedule VALUES("10","2025-07-02","1","25072.88899456","62.734472181554","","0","0","0");
INSERT INTO loan_schedule VALUES("11","2025-08-02","1","25093.783068722","41.840398019421","","0","0","0");
INSERT INTO loan_schedule VALUES("12","2025-09-02","1","25114.694554613","20.928912128819","","0","0","0");
INSERT INTO loan_schedule VALUES("13","2024-09-30","2","371418.72301902","7500","","0","0","0");
INSERT INTO loan_schedule VALUES("14","2024-10-30","2","371728.23862153","7190.4843974842","","0","0","0");
INSERT INTO loan_schedule VALUES("15","2024-11-30","2","372038.01215372","6880.7108652995","","0","0","0");
INSERT INTO loan_schedule VALUES("16","2024-12-30","2","372348.04383051","6570.6791885048","","0","0","0");
INSERT INTO loan_schedule VALUES("17","2025-01-30","2","372658.33386704","6260.3891519793","","0","0","0");
INSERT INTO loan_schedule VALUES("18","2025-02-28","2","372968.8824786","5949.8405404235","","0","0","0");
INSERT INTO loan_schedule VALUES("19","2025-03-30","2","373279.68988066","5639.033138358","","0","0","0");
INSERT INTO loan_schedule VALUES("20","2025-04-30","2","373590.75628889","5327.9667301241","","0","0","0");
INSERT INTO loan_schedule VALUES("21","2025-05-30","2","373902.08191914","5016.6410998834","","0","0","0");
INSERT INTO loan_schedule VALUES("22","2025-06-30","2","374213.6669874","4705.0560316174","","0","0","0");
INSERT INTO loan_schedule VALUES("23","2025-07-30","2","374525.51170989","4393.2113091279","","0","0","0");
INSERT INTO loan_schedule VALUES("24","2025-08-30","2","374837.61630298","4081.1067160363","","0","0","0");
INSERT INTO loan_schedule VALUES("25","2025-09-30","2","375149.98098324","3768.7420357838","","0","0","0");
INSERT INTO loan_schedule VALUES("26","2025-10-30","2","375462.60596739","3456.1170516311","","0","0","0");
INSERT INTO loan_schedule VALUES("27","2025-11-30","2","375775.49147236","3143.2315466583","","0","0","0");
INSERT INTO loan_schedule VALUES("28","2025-12-30","2","376088.63771525","2830.0853037647","","0","0","0");
INSERT INTO loan_schedule VALUES("29","2026-01-30","2","376402.04491335","2516.6781056686","","0","0","0");
INSERT INTO loan_schedule VALUES("30","2026-02-28","2","376715.71328411","2203.0097349075","","0","0","0");
INSERT INTO loan_schedule VALUES("31","2026-03-30","2","377029.64304518","1889.0799738374","","0","0","0");
INSERT INTO loan_schedule VALUES("32","2026-04-30","2","377343.83441439","1574.8886046331","","0","0","0");
INSERT INTO loan_schedule VALUES("33","2026-05-30","2","377658.28760973","1260.4354092878","","0","0","0");
INSERT INTO loan_schedule VALUES("34","2026-06-30","2","377973.00284941","945.72016961301","","0","0","0");
INSERT INTO loan_schedule VALUES("35","2026-07-30","2","378287.98035178","630.74266723851","","0","0","0");
INSERT INTO loan_schedule VALUES("36","2026-08-30","2","378603.22033541","315.50268361202","","0","0","0");
INSERT INTO loan_schedule VALUES("37","2024-09-30","3","52434.444471097","6650","","0","0","0");
INSERT INTO loan_schedule VALUES("38","2024-10-30","3","52958.788915808","6125.655555289","","0","0","0");
INSERT INTO loan_schedule VALUES("39","2024-11-30","3","53488.376804966","5596.0676661309","","0","0","0");
INSERT INTO loan_schedule VALUES("40","2024-12-30","3","54023.260573016","5061.1838980813","","0","0","0");
INSERT INTO loan_schedule VALUES("41","2025-01-30","3","54563.493178746","4520.9512923511","","0","0","0");
INSERT INTO loan_schedule VALUES("42","2025-02-28","3","55109.128110534","3975.3163605637","","0","0","0");
INSERT INTO loan_schedule VALUES("43","2025-03-30","3","55660.219391639","3424.2250794583","","0","0","0");
INSERT INTO loan_schedule VALUES("44","2025-04-30","3","56216.821585555","2867.6228855419","","0","0","0");
INSERT INTO loan_schedule VALUES("45","2025-05-30","3","56778.989801411","2305.4546696864","","0","0","0");
INSERT INTO loan_schedule VALUES("46","2025-06-30","3","57346.779699425","1737.6647716723","","0","0","0");
INSERT INTO loan_schedule VALUES("47","2025-07-30","3","57920.247496419","1164.196974678","","0","0","0");
INSERT INTO loan_schedule VALUES("48","2025-08-30","3","58499.449971383","584.99449971384","","0","0","0");
INSERT INTO loan_schedule VALUES("49","2024-09-30","4","47309.273207005","6000","","0","0","0");
INSERT INTO loan_schedule VALUES("50","2024-10-30","4","47782.365939075","5526.9072679299","","0","0","0");
INSERT INTO loan_schedule VALUES("51","2024-11-30","4","48260.189598466","5049.0836085392","","0","0","0");
INSERT INTO loan_schedule VALUES("52","2024-12-30","4","48742.79149445","4566.4817125545","","0","0","0");
INSERT INTO loan_schedule VALUES("53","2025-01-30","4","49230.219409395","4079.05379761","","0","0","0");
INSERT INTO loan_schedule VALUES("54","2025-02-28","4","49722.521603489","3586.7516035161","","0","0","0");
INSERT INTO loan_schedule VALUES("55","2025-03-30","4","50219.746819524","3089.5263874812","","0","0","0");
INSERT INTO loan_schedule VALUES("56","2025-04-30","4","50721.944287719","2587.328919286","","0","0","0");
INSERT INTO loan_schedule VALUES("57","2025-05-30","4","51229.163730596","2080.1094764088","","0","0","0");
INSERT INTO loan_schedule VALUES("58","2025-06-30","4","51741.455367902","1567.8178391028","","0","0","0");
INSERT INTO loan_schedule VALUES("59","2025-07-30","4","52258.869921581","1050.4032854238","","0","0","0");
INSERT INTO loan_schedule VALUES("60","2025-08-30","4","52781.458620797","527.81458620797","","0","0","0");
INSERT INTO loan_schedule VALUES("108","2025-09-30","5","11699.889994277","116.99889994277","","0","0","0");
INSERT INTO loan_schedule VALUES("107","2025-08-30","5","11584.049499284","232.83939493561","","0","0","0");
INSERT INTO loan_schedule VALUES("106","2025-07-30","5","11469.355939885","347.53295433446","","0","0","0");
INSERT INTO loan_schedule VALUES("105","2025-06-30","5","11355.797960282","461.09093393728","","0","0","0");
INSERT INTO loan_schedule VALUES("104","2025-05-30","5","11243.364317111","573.52457710839","","0","0","0");
INSERT INTO loan_schedule VALUES("103","2025-04-30","5","11132.043878328","684.84501589167","","0","0","0");
INSERT INTO loan_schedule VALUES("102","2025-03-30","5","11021.825622107","795.06327211273","","0","0","0");
INSERT INTO loan_schedule VALUES("101","2025-02-28","5","10912.698635749","904.19025847022","","0","0","0");
INSERT INTO loan_schedule VALUES("100","2025-01-30","5","10804.652114603","1012.2367796163","","0","0","0");
INSERT INTO loan_schedule VALUES("99","2024-12-30","5","10697.675360993","1119.2135332262","","0","0","0");
INSERT INTO loan_schedule VALUES("97","2024-10-30","5","10486.888894219","1330","","0","0","0");
INSERT INTO loan_schedule VALUES("98","2024-11-30","5","10591.757783162","1225.1311110578","","0","0","0");
INSERT INTO loan_schedule VALUES("109","2024-09-03","6","4977.1246933483","50","","0","0","0");
INSERT INTO loan_schedule VALUES("110","2024-10-03","6","4981.2722972594","45.852396088876","","0","0","0");
INSERT INTO loan_schedule VALUES("111","2024-11-03","6","4985.4233575072","41.70133584116","","0","0","0");
INSERT INTO loan_schedule VALUES("112","2024-12-03","6","4989.5778769717","37.546816376571","","0","0","0");
INSERT INTO loan_schedule VALUES("113","2025-01-03","6","4993.7358585359","33.388834812428","","0","0","0");
INSERT INTO loan_schedule VALUES("114","2025-02-03","6","4997.8973050847","29.227388263648","","0","0","0");
INSERT INTO loan_schedule VALUES("115","2025-03-03","6","5002.0622195056","25.062473842744","","0","0","0");
INSERT INTO loan_schedule VALUES("116","2025-04-03","6","5006.2306046885","20.894088659823","","0","0","0");
INSERT INTO loan_schedule VALUES("117","2025-05-03","6","5010.4024635257","16.722229822582","","0","0","0");
INSERT INTO loan_schedule VALUES("118","2025-06-03","6","5014.577798912","12.546894436311","","0","0","0");
INSERT INTO loan_schedule VALUES("119","2025-07-03","6","5018.7566137444","8.3680796038841","","0","0","0");
INSERT INTO loan_schedule VALUES("120","2025-08-03","6","5022.9389109226","4.1857824257638","","0","0","0");
INSERT INTO loan_schedule VALUES("121","2024-09-06","7","414760.39111236","4166.6666666667","","0","0","0");
INSERT INTO loan_schedule VALUES("122","2024-10-06","7","415106.02477162","3821.0330074064","","0","0","0");
INSERT INTO loan_schedule VALUES("123","2024-11-06","7","415451.94645893","3475.1113200967","","0","0","0");
INSERT INTO loan_schedule VALUES("124","2024-12-06","7","415798.15641431","3128.9013647142","","0","0","0");
INSERT INTO loan_schedule VALUES("125","2025-01-06","7","416144.65487799","2782.4029010356","","0","0","0");
INSERT INTO loan_schedule VALUES("126","2025-02-06","7","416491.44209039","2435.6156886373","","0","0","0");
INSERT INTO loan_schedule VALUES("127","2025-03-06","7","416838.51829213","2088.5394868953","","0","0","0");
INSERT INTO loan_schedule VALUES("128","2025-04-06","7","417185.88372404","1741.1740549852","","0","0","0");
INSERT INTO loan_schedule VALUES("129","2025-05-06","7","417533.53862714","1393.5191518819","","0","0","0");
INSERT INTO loan_schedule VALUES("130","2025-06-06","7","417881.48324267","1045.5745363592","","0","0","0");
INSERT INTO loan_schedule VALUES("131","2025-07-06","7","418229.71781204","697.33996699035","","0","0","0");
INSERT INTO loan_schedule VALUES("132","2025-08-06","7","418578.24257688","348.81520214698","","0","0","0");
INSERT INTO loan_schedule VALUES("133","2024-09-27","8","33180.831288989","333.33333333333","","0","0","0");
INSERT INTO loan_schedule VALUES("134","2024-10-27","8","33208.48198173","305.68264059251","","0","0","0");
INSERT INTO loan_schedule VALUES("135","2024-11-27","8","33236.155716714","278.00890560773","","0","0","0");
INSERT INTO loan_schedule VALUES("136","2024-12-27","8","33263.852513145","250.31210917714","","0","0","0");
INSERT INTO loan_schedule VALUES("137","2025-01-27","8","33291.572390239","222.59223208285","","0","0","0");
INSERT INTO loan_schedule VALUES("138","2025-02-27","8","33319.315367231","194.84925509099","","0","0","0");
INSERT INTO loan_schedule VALUES("139","2025-03-27","8","33347.08146337","167.08315895163","","0","0","0");
INSERT INTO loan_schedule VALUES("140","2025-04-27","8","33374.870697923","139.29392439882","","0","0","0");
INSERT INTO loan_schedule VALUES("141","2025-05-27","8","33402.683090172","111.48153215055","","0","0","0");
INSERT INTO loan_schedule VALUES("142","2025-06-27","8","33430.518659413","83.645962908739","","0","0","0");
INSERT INTO loan_schedule VALUES("143","2025-07-27","8","33458.377424963","55.787197359228","","0","0","0");
INSERT INTO loan_schedule VALUES("144","2025-08-27","8","33486.25940615","27.905216171759","","0","0","0");
INSERT INTO loan_schedule VALUES("145","2024-09-27","9","33263.95637618","166.66666666667","","0","0","0");
INSERT INTO loan_schedule VALUES("146","2024-10-27","9","33291.676339827","138.94670301985","","0","0","0");
INSERT INTO loan_schedule VALUES("147","2024-11-27","9","33319.419403443","111.20363940333","","0","0","0");
INSERT INTO loan_schedule VALUES("148","2024-12-27","9","33347.18558628","83.437456567125","","0","0","0");
INSERT INTO loan_schedule VALUES("149","2025-01-27","9","33374.974907602","55.648135245225","","0","0","0");
INSERT INTO loan_schedule VALUES("150","2025-02-27","9","33402.787386691","27.835656155557","","0","0","0");
INSERT INTO loan_schedule VALUES("151","2024-09-27","10","191623.36209028","5833.3333333333","","0","0","0");
INSERT INTO loan_schedule VALUES("152","2024-10-27","10","191783.04822535","5673.6471982581","","0","0","0");
INSERT INTO loan_schedule VALUES("153","2024-11-27","10","191942.86743221","5513.8279914036","","0","0","0");
INSERT INTO loan_schedule VALUES("154","2024-12-27","10","192102.81982173","5353.8756018768","","0","0","0");
INSERT INTO loan_schedule VALUES("155","2025-01-27","10","192262.90550492","5193.789918692","","0","0","0");
INSERT INTO loan_schedule VALUES("156","2025-02-27","10","192423.12459284","5033.5708307713","","0","0","0");
INSERT INTO loan_schedule VALUES("157","2025-03-27","10","192583.47719667","4873.2182269439","","0","0","0");
INSERT INTO loan_schedule VALUES("158","2025-04-27","10","192743.96342766","4712.7319959467","","0","0","0");
INSERT INTO loan_schedule VALUES("159","2025-05-27","10","192904.58339719","4552.1120264236","","0","0","0");
INSERT INTO loan_schedule VALUES("160","2025-06-27","10","193065.33721669","4391.358206926","","0","0","0");
INSERT INTO loan_schedule VALUES("161","2025-07-27","10","193226.2249977","4230.470425912","","0","0","0");
INSERT INTO loan_schedule VALUES("162","2025-08-27","10","193387.24685186","4069.4485717473","","0","0","0");
INSERT INTO loan_schedule VALUES("163","2025-09-27","10","193548.40289091","3908.2925327041","","0","0","0");
INSERT INTO loan_schedule VALUES("164","2025-10-27","10","193709.69322665","3747.0021969617","","0","0","0");
INSERT INTO loan_schedule VALUES("165","2025-11-27","10","193871.11797101","3585.5774526061","","0","0","0");
INSERT INTO loan_schedule VALUES("166","2025-12-27","10","194032.67723598","3424.0181876303","","0","0","0");
INSERT INTO loan_schedule VALUES("167","2026-01-27","10","194194.37113368","3262.3242899336","","0","0","0");
INSERT INTO loan_schedule VALUES("168","2026-02-27","10","194356.19977629","3100.4956473222","","0","0","0");
INSERT INTO loan_schedule VALUES("169","2026-03-27","10","194518.1632761","2938.5321475087","","0","0","0");
INSERT INTO loan_schedule VALUES("170","2026-04-27","10","194680.2617455","2776.4336781119","","0","0","0");
INSERT INTO loan_schedule VALUES("171","2026-05-27","10","194842.49529695","2614.2001266573","","0","0","0");
INSERT INTO loan_schedule VALUES("172","2026-06-27","10","195004.86404303","2451.8313805765","","0","0","0");
INSERT INTO loan_schedule VALUES("173","2026-07-27","10","195167.3680964","2289.3273272073","","0","0","0");
INSERT INTO loan_schedule VALUES("174","2026-08-27","10","195330.00756982","2126.6878537937","","0","0","0");
INSERT INTO loan_schedule VALUES("175","2026-09-27","10","195492.78257613","1963.9128474855","","0","0","0");
INSERT INTO loan_schedule VALUES("176","2026-10-27","10","195655.69322827","1801.0021953387","","0","0","0");
INSERT INTO loan_schedule VALUES("177","2026-11-27","10","195818.7396393","1637.9557843151","","0","0","0");
INSERT INTO loan_schedule VALUES("178","2026-12-27","10","195981.92192233","1474.7735012824","","0","0","0");
INSERT INTO loan_schedule VALUES("179","2027-01-27","10","196145.2401906","1311.4552330138","","0","0","0");
INSERT INTO loan_schedule VALUES("180","2027-02-27","10","196308.69455742","1148.0008661883","","0","0","0");
INSERT INTO loan_schedule VALUES("181","2027-03-27","10","196472.28513622","984.41028739044","","0","0","0");
INSERT INTO loan_schedule VALUES("182","2027-04-27","10","196636.0120405","820.68338311026","","0","0","0");
INSERT INTO loan_schedule VALUES("183","2027-05-27","10","196799.87538387","656.82003974317","","0","0","0");
INSERT INTO loan_schedule VALUES("184","2027-06-27","10","196963.87528002","492.82014358995","","0","0","0");
INSERT INTO loan_schedule VALUES("185","2027-07-27","10","197128.01184275","328.6835808566","","0","0","0");
INSERT INTO loan_schedule VALUES("186","2027-08-27","10","197292.28518596","164.4102376543","","0","0","0");
INSERT INTO loan_schedule VALUES("187","2024-09-27","11","33180.831288989","333.33333333333","","0","0","0");
INSERT INTO loan_schedule VALUES("188","2024-10-27","11","33208.48198173","305.68264059251","","0","0","0");
INSERT INTO loan_schedule VALUES("189","2024-11-27","11","33236.155716714","278.00890560773","","0","0","0");
INSERT INTO loan_schedule VALUES("190","2024-12-27","11","33263.852513145","250.31210917714","","0","0","0");
INSERT INTO loan_schedule VALUES("191","2025-01-27","11","33291.572390239","222.59223208285","","0","0","0");
INSERT INTO loan_schedule VALUES("192","2025-02-27","11","33319.315367231","194.84925509099","","0","0","0");
INSERT INTO loan_schedule VALUES("193","2025-03-27","11","33347.08146337","167.08315895163","","0","0","0");
INSERT INTO loan_schedule VALUES("194","2025-04-27","11","33374.870697923","139.29392439882","","0","0","0");
INSERT INTO loan_schedule VALUES("195","2025-05-27","11","33402.683090172","111.48153215055","","0","0","0");
INSERT INTO loan_schedule VALUES("196","2025-06-27","11","33430.518659413","83.645962908739","","0","0","0");
INSERT INTO loan_schedule VALUES("197","2025-07-27","11","33458.377424963","55.787197359228","","0","0","0");
INSERT INTO loan_schedule VALUES("198","2025-08-27","11","33486.25940615","27.905216171759","","0","0","0");
INSERT INTO loan_schedule VALUES("199","2024-09-02","12","306421.83846192","12500","","0","0","0");
INSERT INTO loan_schedule VALUES("200","2024-10-02","12","306677.18999397","12244.648467948","","0","0","0");
INSERT INTO loan_schedule VALUES("201","2024-11-02","12","306932.75431897","11989.084142953","","0","0","0");
INSERT INTO loan_schedule VALUES("202","2024-12-02","12","307188.53161423","11733.306847688","","0","0","0");
INSERT INTO loan_schedule VALUES("203","2025-01-02","12","307444.52205725","11477.316404676","","0","0","0");
INSERT INTO loan_schedule VALUES("204","2025-02-02","12","307700.72582563","11221.112636295","","0","0","0");
INSERT INTO loan_schedule VALUES("205","2025-03-02","12","307957.14309715","10964.695364773","","0","0","0");
INSERT INTO loan_schedule VALUES("206","2025-04-02","12","308213.77404973","10708.064412192","","0","0","0");
INSERT INTO loan_schedule VALUES("207","2025-05-02","12","308470.61886144","10451.219600484","","0","0","0");
INSERT INTO loan_schedule VALUES("208","2025-06-02","12","308727.67771049","10194.160751433","","0","0","0");
INSERT INTO loan_schedule VALUES("209","2025-07-02","12","308984.95077525","9936.8876866744","","0","0","0");
INSERT INTO loan_schedule VALUES("210","2025-08-02","12","309242.43823423","9679.400227695","","0","0","0");
INSERT INTO loan_schedule VALUES("211","2025-09-02","12","309500.14026609","9421.6981958331","","0","0","0");
INSERT INTO loan_schedule VALUES("212","2025-10-02","12","309758.05704964","9163.7814122781","","0","0","0");
INSERT INTO loan_schedule VALUES("213","2025-11-02","12","310016.18876385","8905.64969807","","0","0","0");
INSERT INTO loan_schedule VALUES("214","2025-12-02","12","310274.53558782","8647.3028741001","","0","0","0");
INSERT INTO loan_schedule VALUES("215","2026-01-02","12","310533.09770081","8388.7407611103","","0","0","0");
INSERT INTO loan_schedule VALUES("216","2026-02-02","12","310791.87528223","8129.9631796929","","0","0","0");
INSERT INTO loan_schedule VALUES("217","2026-03-02","12","311050.86851163","7870.9699502911","","0","0","0");
INSERT INTO loan_schedule VALUES("218","2026-04-02","12","311310.07756872","7611.7608931981","","0","0","0");
INSERT INTO loan_schedule VALUES("219","2026-05-02","12","311569.50263336","7352.3358285575","","0","0","0");
INSERT INTO loan_schedule VALUES("220","2026-06-02","12","311829.14388556","7092.694576363","","0","0","0");
INSERT INTO loan_schedule VALUES("221","2026-07-02","12","312089.00150546","6832.8369564584","","0","0","0");
INSERT INTO loan_schedule VALUES("222","2026-08-02","12","312349.07567338","6572.7627885371","","0","0","0");
INSERT INTO loan_schedule VALUES("223","2026-09-02","12","312609.36656978","6312.4718921427","","0","0","0");
INSERT INTO loan_schedule VALUES("224","2026-10-02","12","312869.87437525","6051.9640866678","","0","0","0");
INSERT INTO loan_schedule VALUES("225","2026-11-02","12","313130.59927057","5791.2391913551","","0","0","0");
INSERT INTO loan_schedule VALUES("226","2026-12-02","12","313391.54143663","5530.2970252963","","0","0","0");
INSERT INTO loan_schedule VALUES("227","2027-01-02","12","313652.70105449","5269.1374074325","","0","0","0");
INSERT INTO loan_schedule VALUES("228","2027-02-02","12","313914.07830537","5007.7601565537","","0","0","0");
INSERT INTO loan_schedule VALUES("229","2027-03-02","12","314175.67337062","4746.1650912993","","0","0","0");
INSERT INTO loan_schedule VALUES("230","2027-04-02","12","314437.48643176","4484.3520301571","","0","0","0");
INSERT INTO loan_schedule VALUES("231","2027-05-02","12","314699.51767046","4222.3207914639","","0","0","0");
INSERT INTO loan_schedule VALUES("232","2027-06-02","12","314961.76726852","3960.0711934052","","0","0","0");
INSERT INTO loan_schedule VALUES("233","2027-07-02","12","315224.23540791","3697.6030540148","","0","0","0");
INSERT INTO loan_schedule VALUES("234","2027-08-02","12","315486.92227075","3434.9161911749","","0","0","0");
INSERT INTO loan_schedule VALUES("235","2027-09-02","12","315749.82803931","3172.0104226159","","0","0","0");
INSERT INTO loan_schedule VALUES("236","2027-10-02","12","316012.952896","2908.8855659165","","0","0","0");
INSERT INTO loan_schedule VALUES("237","2027-11-02","12","316276.29702342","2645.5414385032","","0","0","0");
INSERT INTO loan_schedule VALUES("238","2027-12-02","12","316539.86060427","2381.9778576503","","0","0","0");
INSERT INTO loan_schedule VALUES("239","2028-01-02","12","316803.64382144","2118.1946404801","","0","0","0");
INSERT INTO loan_schedule VALUES("240","2028-02-02","12","317067.64685796","1854.1916039622","","0","0","0");
INSERT INTO loan_schedule VALUES("241","2028-03-02","12","317331.86989701","1589.9685649139","","0","0","0");
INSERT INTO loan_schedule VALUES("242","2028-04-02","12","317596.31312192","1325.5253399997","","0","0","0");
INSERT INTO loan_schedule VALUES("243","2028-05-02","12","317860.97671619","1060.8617457315","","0","0","0");
INSERT INTO loan_schedule VALUES("244","2028-06-02","12","318125.86086345","795.97759846798","","0","0","0");
INSERT INTO loan_schedule VALUES("245","2028-07-02","12","318390.96574751","530.8727144151","","0","0","0");
INSERT INTO loan_schedule VALUES("246","2028-08-02","12","318656.2915523","265.54690962551","","0","0","0");
INSERT INTO loan_schedule VALUES("247","2024-09-02","13","273747.66012897","8333.3333333333","","0","0","0");
INSERT INTO loan_schedule VALUES("248","2024-10-02","13","273975.78317908","8105.2102832259","","0","0","0");
INSERT INTO loan_schedule VALUES("249","2024-11-02","13","274204.09633173","7876.8971305766","","0","0","0");
INSERT INTO loan_schedule VALUES("250","2024-12-02","13","274432.59974534","7648.3937169669","","0","0","0");
INSERT INTO loan_schedule VALUES("251","2025-01-02","13","274661.29357846","7419.6998838457","","0","0","0");
INSERT INTO loan_schedule VALUES("252","2025-02-02","13","274890.17798977","7190.8154725304","","0","0","0");
INSERT INTO loan_schedule VALUES("253","2025-03-02","13","275119.2531381","6961.7403242056","","0","0","0");
INSERT INTO loan_schedule VALUES("254","2025-04-02","13","275348.51918238","6732.4742799238","","0","0","0");
INSERT INTO loan_schedule VALUES("255","2025-05-02","13","275577.9762817","6503.0171806052","","0","0","0");
INSERT INTO loan_schedule VALUES("256","2025-06-02","13","275807.62459526","6273.3688670371","","0","0","0");
INSERT INTO loan_schedule VALUES("257","2025-07-02","13","276037.46428243","6043.5291798744","","0","0","0");
INSERT INTO loan_schedule VALUES("258","2025-08-02","13","276267.49550266","5813.497959639","","0","0","0");
INSERT INTO loan_schedule VALUES("259","2025-09-02","13","276497.71841558","5583.2750467201","","0","0","0");
INSERT INTO loan_schedule VALUES("260","2025-10-02","13","276728.13318093","5352.8602813738","","0","0","0");
INSERT INTO loan_schedule VALUES("261","2025-11-02","13","276958.73995858","5122.253503723","","0","0","0");
INSERT INTO loan_schedule VALUES("262","2025-12-02","13","277189.53890854","4891.4545537575","","0","0","0");
INSERT INTO loan_schedule VALUES("263","2026-01-02","13","277420.53019097","4660.4632713338","","0","0","0");
INSERT INTO loan_schedule VALUES("264","2026-02-02","13","277651.71396613","4429.2794961746","","0","0","0");
INSERT INTO loan_schedule VALUES("265","2026-03-02","13","277883.09039443","4197.9030678695","","0","0","0");
INSERT INTO loan_schedule VALUES("266","2026-04-02","13","278114.65963643","3966.3338258741","","0","0","0");
INSERT INTO loan_schedule VALUES("267","2026-05-02","13","278346.42185279","3734.5716095105","","0","0","0");
INSERT INTO loan_schedule VALUES("268","2026-06-02","13","278578.37720434","3502.6162579665","","0","0","0");
INSERT INTO loan_schedule VALUES("269","2026-07-02","13","278810.52585201","3270.4676102962","","0","0","0");
INSERT INTO loan_schedule VALUES("270","2026-08-02","13","279042.86795688","3038.1255054195","","0","0","0");
INSERT INTO loan_schedule VALUES("271","2026-09-02","13","279275.40368018","2805.5897821221","","0","0","0");
INSERT INTO loan_schedule VALUES("272","2026-10-02","13","279508.13318325","2572.8602790553","","0","0","0");
INSERT INTO loan_schedule VALUES("273","2026-11-02","13","279741.05662757","2339.9368347359","","0","0","0");
INSERT INTO loan_schedule VALUES("274","2026-12-02","13","279974.17417476","2106.8192875463","","0","0","0");
INSERT INTO loan_schedule VALUES("275","2027-01-02","13","280207.48598657","1873.507475734","","0","0","0");
INSERT INTO loan_schedule VALUES("276","2027-02-02","13","280440.99222489","1640.0012374118","","0","0","0");
INSERT INTO loan_schedule VALUES("277","2027-03-02","13","280674.69305174","1406.3004105578","","0","0","0");
INSERT INTO loan_schedule VALUES("278","2027-04-02","13","280908.58862929","1172.4048330147","","0","0","0");
INSERT INTO loan_schedule VALUES("279","2027-05-02","13","281142.67911981","938.31434249025","","0","0","0");
INSERT INTO loan_schedule VALUES("280","2027-06-02","13","281376.96468574","704.02877655707","","0","0","0");
INSERT INTO loan_schedule VALUES("281","2027-07-02","13","281611.44548965","469.54797265228","","0","0","0");
INSERT INTO loan_schedule VALUES("282","2027-08-02","13","281846.12169422","234.87176807758","","0","0","0");
INSERT INTO loan_schedule VALUES("283","2024-09-02","14","82952.078222472","833.33333333333","","0","0","0");
INSERT INTO loan_schedule VALUES("284","2024-10-02","14","83021.204954324","764.20660148127","","0","0","0");
INSERT INTO loan_schedule VALUES("285","2024-11-02","14","83090.389291786","695.02226401934","","0","0","0");
INSERT INTO loan_schedule VALUES("286","2024-12-02","14","83159.631282862","625.78027294285","","0","0","0");
INSERT INTO loan_schedule VALUES("287","2025-01-02","14","83228.930975598","556.48058020713","","0","0","0");
INSERT INTO loan_schedule VALUES("288","2025-02-02","14","83298.288418078","487.12313772746","","0","0","0");
INSERT INTO loan_schedule VALUES("289","2025-03-02","14","83367.703658426","417.70789737907","","0","0","0");
INSERT INTO loan_schedule VALUES("290","2025-04-02","14","83437.176744808","348.23481099704","","0","0","0");
INSERT INTO loan_schedule VALUES("291","2025-05-02","14","83506.707725429","278.70383037637","","0","0","0");
INSERT INTO loan_schedule VALUES("292","2025-06-02","14","83576.296648533","209.11490727185","","0","0","0");
INSERT INTO loan_schedule VALUES("293","2025-07-02","14","83645.943562407","139.46799339807","","0","0","0");
INSERT INTO loan_schedule VALUES("294","2025-08-02","14","83715.648515376","69.763040429396","","0","0","0");
INSERT INTO loan_schedule VALUES("295","2024-09-02","15","414760.39111236","4166.6666666667","","0","0","0");
INSERT INTO loan_schedule VALUES("296","2024-10-02","15","415106.02477162","3821.0330074064","","0","0","0");
INSERT INTO loan_schedule VALUES("297","2024-11-02","15","415451.94645893","3475.1113200967","","0","0","0");
INSERT INTO loan_schedule VALUES("298","2024-12-02","15","415798.15641431","3128.9013647142","","0","0","0");
INSERT INTO loan_schedule VALUES("299","2025-01-02","15","416144.65487799","2782.4029010356","","0","0","0");
INSERT INTO loan_schedule VALUES("300","2025-02-02","15","416491.44209039","2435.6156886373","","0","0","0");
INSERT INTO loan_schedule VALUES("301","2025-03-02","15","416838.51829213","2088.5394868953","","0","0","0");
INSERT INTO loan_schedule VALUES("302","2025-04-02","15","417185.88372404","1741.1740549852","","0","0","0");
INSERT INTO loan_schedule VALUES("303","2025-05-02","15","417533.53862714","1393.5191518819","","0","0","0");
INSERT INTO loan_schedule VALUES("304","2025-06-02","15","417881.48324267","1045.5745363592","","0","0","0");
INSERT INTO loan_schedule VALUES("305","2025-07-02","15","418229.71781204","697.33996699035","","0","0","0");
INSERT INTO loan_schedule VALUES("306","2025-08-02","15","418578.24257688","348.81520214698","","0","0","0");
INSERT INTO loan_schedule VALUES("307","2024-09-02","16","116423.84731663","583.33333333333","","0","0","0");
INSERT INTO loan_schedule VALUES("308","2024-10-02","16","116520.86718939","486.31346056947","","0","0","0");
INSERT INTO loan_schedule VALUES("309","2024-11-02","16","116617.96791205","389.21273791165","","0","0","0");
INSERT INTO loan_schedule VALUES("310","2024-12-02","16","116715.14955198","292.03109798494","","0","0","0");
INSERT INTO loan_schedule VALUES("311","2025-01-02","16","116812.41217661","194.76847335829","","0","0","0");
INSERT INTO loan_schedule VALUES("312","2025-02-02","16","116909.75585342","97.424796544449","","0","0","0");
INSERT INTO loan_schedule VALUES("313","2024-09-02","17","165904.15644494","1666.6666666667","","0","0","0");
INSERT INTO loan_schedule VALUES("314","2024-10-02","17","166042.40990865","1528.4132029625","","0","0","0");
INSERT INTO loan_schedule VALUES("315","2024-11-02","17","166180.77858357","1390.0445280387","","0","0","0");
INSERT INTO loan_schedule VALUES("316","2024-12-02","17","166319.26256572","1251.5605458857","","0","0","0");
INSERT INTO loan_schedule VALUES("317","2025-01-02","17","166457.8619512","1112.9611604143","","0","0","0");
INSERT INTO loan_schedule VALUES("318","2025-02-02","17","166596.57683616","974.24627545493","","0","0","0");
INSERT INTO loan_schedule VALUES("319","2025-03-02","17","166735.40731685","835.41579475813","","0","0","0");
INSERT INTO loan_schedule VALUES("320","2025-04-02","17","166874.35348962","696.46962199409","","0","0","0");
INSERT INTO loan_schedule VALUES("321","2025-05-02","17","167013.41545086","557.40766075274","","0","0","0");
INSERT INTO loan_schedule VALUES("322","2025-06-02","17","167152.59329707","418.22981454369","","0","0","0");
INSERT INTO loan_schedule VALUES("323","2025-07-02","17","167291.88712481","278.93598679614","","0","0","0");
INSERT INTO loan_schedule VALUES("324","2025-08-02","17","167431.29703075","139.52608085879","","0","0","0");
INSERT INTO loan_schedule VALUES("363","2024-12-02","18","166805.51697534","139.00459747939","","0","0","0");
INSERT INTO loan_schedule VALUES("362","2024-11-02","18","166666.62811858","277.89345424487","","0","0","0");
INSERT INTO loan_schedule VALUES("361","2024-10-02","18","166527.85490616","416.66666666667","","0","0","0");
INSERT INTO loan_schedule VALUES("328","2024-09-02","19","206343.73501057","4166.6666666667","","0","0","0");
INSERT INTO loan_schedule VALUES("329","2024-10-02","19","206515.68812307","3994.7135541579","","0","0","0");
INSERT INTO loan_schedule VALUES("330","2024-11-02","19","206687.78452984","3822.6171473886","","0","0","0");
INSERT INTO loan_schedule VALUES("331","2024-12-02","19","206860.02435029","3650.3773269471","","0","0","0");
INSERT INTO loan_schedule VALUES("332","2025-01-02","19","207032.40770391","3477.9939733219","","0","0","0");
INSERT INTO loan_schedule VALUES("333","2025-02-02","19","207204.93471033","3305.4669669019","","0","0","0");
INSERT INTO loan_schedule VALUES("334","2025-03-02","19","207377.60548926","3132.7961879767","","0","0","0");
INSERT INTO loan_schedule VALUES("335","2025-04-02","19","207550.4201605","2959.9815167356","","0","0","0");
INSERT INTO loan_schedule VALUES("336","2025-05-02","19","207723.37884396","2787.0228332685","","0","0","0");
INSERT INTO loan_schedule VALUES("337","2025-06-02","19","207896.48165967","2613.9200175652","","0","0","0");
INSERT INTO loan_schedule VALUES("338","2025-07-02","19","208069.72872772","2440.6729495155","","0","0","0");
INSERT INTO loan_schedule VALUES("339","2025-08-02","19","208243.12016832","2267.2815089091","","0","0","0");
INSERT INTO loan_schedule VALUES("340","2025-09-02","19","208416.6561018","2093.7455754355","","0","0","0");
INSERT INTO loan_schedule VALUES("341","2025-10-02","19","208590.33664855","1920.065028684","","0","0","0");
INSERT INTO loan_schedule VALUES("342","2025-11-02","19","208764.16192909","1746.2397481435","","0","0","0");
INSERT INTO loan_schedule VALUES("343","2025-12-02","19","208938.13206403","1572.2696132026","","0","0","0");
INSERT INTO loan_schedule VALUES("344","2026-01-02","19","209112.24717408","1398.1545031492","","0","0","0");
INSERT INTO loan_schedule VALUES("345","2026-02-02","19","209286.50738006","1223.8942971708","","0","0","0");
INSERT INTO loan_schedule VALUES("346","2026-03-02","19","209460.91280288","1049.4888743541","","0","0","0");
INSERT INTO loan_schedule VALUES("347","2026-04-02","19","209635.46356355","874.93811368506","","0","0","0");
INSERT INTO loan_schedule VALUES("348","2026-05-02","19","209810.15978318","700.24189404877","","0","0","0");
INSERT INTO loan_schedule VALUES("349","2026-06-02","19","209985.001583","525.40009422945","","0","0","0");
INSERT INTO loan_schedule VALUES("350","2026-07-02","19","210159.98908432","350.41259291028","","0","0","0");
INSERT INTO loan_schedule VALUES("351","2026-08-02","19","210335.12240856","175.27926867335","","0","0","0");
INSERT INTO loan_schedule VALUES("399","2026-02-19","20","83715.648515376","69.763040429396","0","0","0","0");
INSERT INTO loan_schedule VALUES("398","2026-01-19","20","83645.943562407","139.46799339807","0","0","0","0");
INSERT INTO loan_schedule VALUES("397","2025-12-19","20","83576.296648533","209.11490727185","0","0","0","0");
INSERT INTO loan_schedule VALUES("396","2025-11-19","20","83506.707725429","278.70383037637","0","0","0","0");
INSERT INTO loan_schedule VALUES("395","2025-10-19","20","83437.176744808","348.23481099704","0","0","0","0");
INSERT INTO loan_schedule VALUES("394","2025-09-19","20","83367.703658426","417.70789737907","0","0","0","0");
INSERT INTO loan_schedule VALUES("393","2025-08-19","20","83298.288418078","487.12313772746","0","0","0","0");
INSERT INTO loan_schedule VALUES("392","2025-07-19","20","83228.930975598","556.48058020713","0","0","0","0");
INSERT INTO loan_schedule VALUES("391","2025-06-19","20","83159.631282862","625.78027294285","0","0","0","0");
INSERT INTO loan_schedule VALUES("390","2025-05-19","20","83090.389291786","695.02226401934","0","0","0","0");
INSERT INTO loan_schedule VALUES("389","2025-04-19","20","83021.204954324","764.20660148127","0","0","0","0");
INSERT INTO loan_schedule VALUES("388","2025-03-19","20","82952.078222472","833.33333333333","0","0","0","0");
INSERT INTO loan_schedule VALUES("423","2026-02-19","21","33486.25940615","27.905216171759","0","0","0","0");
INSERT INTO loan_schedule VALUES("422","2026-01-19","21","33458.377424963","55.787197359228","0","0","0","0");
INSERT INTO loan_schedule VALUES("421","2025-12-19","21","33430.518659413","83.645962908739","0","0","0","0");
INSERT INTO loan_schedule VALUES("420","2025-11-19","21","33402.683090172","111.48153215055","0","0","0","0");
INSERT INTO loan_schedule VALUES("419","2025-10-19","21","33374.870697923","139.29392439882","0","0","0","0");
INSERT INTO loan_schedule VALUES("418","2025-09-19","21","33347.08146337","167.08315895163","0","0","0","0");
INSERT INTO loan_schedule VALUES("417","2025-08-19","21","33319.315367231","194.84925509099","0","0","0","0");
INSERT INTO loan_schedule VALUES("416","2025-07-19","21","33291.572390239","222.59223208285","0","0","0","0");
INSERT INTO loan_schedule VALUES("415","2025-06-19","21","33263.852513145","250.31210917714","0","0","0","0");
INSERT INTO loan_schedule VALUES("414","2025-05-19","21","33236.155716714","278.00890560773","0","0","0","0");
INSERT INTO loan_schedule VALUES("413","2025-04-19","21","33208.48198173","305.68264059251","0","0","0","0");
INSERT INTO loan_schedule VALUES("412","2025-03-19","21","33180.831288989","333.33333333333","0","0","0","0");
INSERT INTO loan_schedule VALUES("527","2027-04-21","22","59817.039792728","174.46636606215","","0","0","0");
INSERT INTO loan_schedule VALUES("526","2027-03-21","22","59643.080807041","348.42535174935","","0","0","0");
INSERT INTO loan_schedule VALUES("525","2027-02-21","22","59469.627726173","521.87843261735","","0","0","0");
INSERT INTO loan_schedule VALUES("524","2027-01-21","22","59296.679078859","694.82707993069","","0","0","0");
INSERT INTO loan_schedule VALUES("523","2026-12-21","22","59124.233398115","867.27276067519","","0","0","0");
INSERT INTO loan_schedule VALUES("522","2026-11-21","22","58952.28922122","1039.2169375704","","0","0","0");
INSERT INTO loan_schedule VALUES("521","2026-10-21","22","58780.845089708","1210.6610690821","","0","0","0");
INSERT INTO loan_schedule VALUES("520","2026-09-21","22","58609.899549356","1381.6066094344","","0","0","0");
INSERT INTO loan_schedule VALUES("519","2026-08-21","22","58439.451150168","1552.0550086223","","0","0","0");
INSERT INTO loan_schedule VALUES("518","2026-07-21","22","58269.498446366","1722.0077124242","","0","0","0");
INSERT INTO loan_schedule VALUES("517","2026-06-21","22","58100.039996376","1891.4661624137","","0","0","0");
INSERT INTO loan_schedule VALUES("515","2026-04-21","22","57762.60011249","2228.9060463","","0","0","0");
INSERT INTO loan_schedule VALUES("516","2026-05-21","22","57931.074362818","2060.4317959719","","0","0","0");
INSERT INTO loan_schedule VALUES("514","2026-03-21","22","57594.615816359","2396.890342431","","0","0","0");
INSERT INTO loan_schedule VALUES("513","2026-02-21","22","57427.120049548","2564.3861092422","","0","0","0");
INSERT INTO loan_schedule VALUES("512","2026-01-21","22","57260.111391323","2731.3947674669","","0","0","0");
INSERT INTO loan_schedule VALUES("511","2025-12-21","22","57093.588425083","2897.9177337067","","0","0","0");
INSERT INTO loan_schedule VALUES("510","2025-11-21","22","56927.549738346","3063.9564204436","","0","0","0");
INSERT INTO loan_schedule VALUES("509","2025-10-21","22","56761.993922738","3229.5122360516","","0","0","0");
INSERT INTO loan_schedule VALUES("508","2025-09-21","22","56596.919573981","3394.586584809","","0","0","0");
INSERT INTO loan_schedule VALUES("507","2025-08-21","22","56432.32529188","3559.1808669103","","0","0","0");
INSERT INTO loan_schedule VALUES("506","2025-07-21","22","56268.209680312","3723.2964784779","","0","0","0");
INSERT INTO loan_schedule VALUES("505","2025-06-21","22","56104.571347216","3886.934811574","","0","0","0");
INSERT INTO loan_schedule VALUES("504","2025-05-21","22","55941.408904578","4050.0972542123","","0","0","0");
INSERT INTO loan_schedule VALUES("503","2025-04-21","22","55778.72096842","4212.7851903702","","0","0","0");
INSERT INTO loan_schedule VALUES("502","2025-03-21","22","55616.50615879","4375","","0","0","0");
INSERT INTO loan_schedule VALUES("528","2025-02-19","23","36308.09450487","52500","","0","0","0");
INSERT INTO loan_schedule VALUES("529","2025-03-19","23","37578.87781254","51229.21669233","","0","0","0");
INSERT INTO loan_schedule VALUES("530","2025-04-19","23","38894.138535979","49913.955968891","","0","0","0");
INSERT INTO loan_schedule VALUES("531","2025-05-19","23","40255.433384738","48552.661120131","","0","0","0");
INSERT INTO loan_schedule VALUES("532","2025-06-19","23","41664.373553204","47143.720951666","","0","0","0");
INSERT INTO loan_schedule VALUES("533","2025-07-19","23","43122.626627566","45685.467877303","","0","0","0");
INSERT INTO loan_schedule VALUES("534","2025-08-19","23","44631.918559531","44176.175945339","","0","0","0");
INSERT INTO loan_schedule VALUES("535","2025-09-19","23","46194.035709115","42614.058795755","","0","0","0");
INSERT INTO loan_schedule VALUES("536","2025-10-19","23","47810.826958934","40997.267545936","","0","0","0");
INSERT INTO loan_schedule VALUES("537","2025-11-19","23","49484.205902497","39323.888602373","","0","0","0");
INSERT INTO loan_schedule VALUES("538","2025-12-19","23","51216.153109084","37591.941395786","","0","0","0");
INSERT INTO loan_schedule VALUES("539","2026-01-19","23","53008.718467902","35799.376036968","","0","0","0");
INSERT INTO loan_schedule VALUES("540","2026-02-19","23","54864.023614278","33944.070890591","","0","0","0");
INSERT INTO loan_schedule VALUES("541","2026-03-19","23","56784.264440778","32023.830064092","","0","0","0");
INSERT INTO loan_schedule VALUES("542","2026-04-19","23","58771.713696205","30036.380808664","","0","0","0");
INSERT INTO loan_schedule VALUES("543","2026-05-19","23","60828.723675573","27979.370829297","","0","0","0");
INSERT INTO loan_schedule VALUES("544","2026-06-19","23","62957.729004218","25850.365500652","","0","0","0");
INSERT INTO loan_schedule VALUES("545","2026-07-19","23","65161.249519365","23646.844985505","","0","0","0");
INSERT INTO loan_schedule VALUES("546","2026-08-19","23","67441.893252543","21366.201252327","","0","0","0");
INSERT INTO loan_schedule VALUES("547","2026-09-19","23","69802.359516382","19005.734988488","","0","0","0");
INSERT INTO loan_schedule VALUES("548","2026-10-19","23","72245.442099456","16562.652405414","","0","0","0");
INSERT INTO loan_schedule VALUES("549","2026-11-19","23","74774.032572936","14034.061931933","","0","0","0");
INSERT INTO loan_schedule VALUES("550","2026-12-19","23","77391.123712989","11416.970791881","","0","0","0");
INSERT INTO loan_schedule VALUES("551","2027-01-19","23","80099.813042944","8708.281461926","","0","0","0");
INSERT INTO loan_schedule VALUES("552","2027-02-19","23","82903.306499447","5904.788005423","","0","0","0");
INSERT INTO loan_schedule VALUES("553","2027-03-19","23","85804.922226928","3003.1722779423","","0","0","0");
INSERT INTO loan_schedule VALUES("554","2025-02-19","24","229002.31299798","52500","","0","0","0");
INSERT INTO loan_schedule VALUES("555","2025-03-19","24","237017.39395291","44484.919045071","","0","0","0");
INSERT INTO loan_schedule VALUES("556","2025-04-19","24","245313.00274126","36189.310256719","","0","0","0");
INSERT INTO loan_schedule VALUES("557","2025-05-19","24","253898.9578372","27603.355160775","","0","0","0");
INSERT INTO loan_schedule VALUES("558","2025-06-19","24","262785.4213615","18716.891636473","","0","0","0");
INSERT INTO loan_schedule VALUES("559","2025-07-19","24","271982.91110916","9519.4018888203","","0","0","0");
INSERT INTO loan_schedule VALUES("560","2025-02-19","25","36308.09450487","52500","","0","0","0");
INSERT INTO loan_schedule VALUES("561","2025-03-19","25","37578.87781254","51229.21669233","","0","0","0");
INSERT INTO loan_schedule VALUES("562","2025-04-19","25","38894.138535979","49913.955968891","","0","0","0");
INSERT INTO loan_schedule VALUES("563","2025-05-19","25","40255.433384738","48552.661120131","","0","0","0");
INSERT INTO loan_schedule VALUES("564","2025-06-19","25","41664.373553204","47143.720951666","","0","0","0");
INSERT INTO loan_schedule VALUES("565","2025-07-19","25","43122.626627566","45685.467877303","","0","0","0");
INSERT INTO loan_schedule VALUES("566","2025-08-19","25","44631.918559531","44176.175945339","","0","0","0");
INSERT INTO loan_schedule VALUES("567","2025-09-19","25","46194.035709115","42614.058795755","","0","0","0");
INSERT INTO loan_schedule VALUES("568","2025-10-19","25","47810.826958934","40997.267545936","","0","0","0");
INSERT INTO loan_schedule VALUES("569","2025-11-19","25","49484.205902497","39323.888602373","","0","0","0");
INSERT INTO loan_schedule VALUES("570","2025-12-19","25","51216.153109084","37591.941395786","","0","0","0");
INSERT INTO loan_schedule VALUES("571","2026-01-19","25","53008.718467902","35799.376036968","","0","0","0");
INSERT INTO loan_schedule VALUES("572","2026-02-19","25","54864.023614278","33944.070890591","","0","0","0");
INSERT INTO loan_schedule VALUES("573","2026-03-19","25","56784.264440778","32023.830064092","","0","0","0");
INSERT INTO loan_schedule VALUES("574","2026-04-19","25","58771.713696205","30036.380808664","","0","0","0");
INSERT INTO loan_schedule VALUES("575","2026-05-19","25","60828.723675573","27979.370829297","","0","0","0");
INSERT INTO loan_schedule VALUES("576","2026-06-19","25","62957.729004218","25850.365500652","","0","0","0");
INSERT INTO loan_schedule VALUES("577","2026-07-19","25","65161.249519365","23646.844985505","","0","0","0");
INSERT INTO loan_schedule VALUES("578","2026-08-19","25","67441.893252543","21366.201252327","","0","0","0");
INSERT INTO loan_schedule VALUES("579","2026-09-19","25","69802.359516382","19005.734988488","","0","0","0");
INSERT INTO loan_schedule VALUES("580","2026-10-19","25","72245.442099456","16562.652405414","","0","0","0");
INSERT INTO loan_schedule VALUES("581","2026-11-19","25","74774.032572936","14034.061931933","","0","0","0");
INSERT INTO loan_schedule VALUES("582","2026-12-19","25","77391.123712989","11416.970791881","","0","0","0");
INSERT INTO loan_schedule VALUES("583","2027-01-19","25","80099.813042944","8708.281461926","","0","0","0");
INSERT INTO loan_schedule VALUES("584","2027-02-19","25","82903.306499447","5904.788005423","","0","0","0");
INSERT INTO loan_schedule VALUES("585","2027-03-19","25","85804.922226928","3003.1722779423","","0","0","0");
INSERT INTO loan_schedule VALUES("586","2024-12-02","26","229002.31299798","52500","","0","0","0");
INSERT INTO loan_schedule VALUES("587","2025-01-02","26","237017.39395291","44484.919045071","","0","0","0");
INSERT INTO loan_schedule VALUES("588","2025-02-02","26","245313.00274126","36189.310256719","","0","0","0");
INSERT INTO loan_schedule VALUES("589","2025-03-02","26","253898.9578372","27603.355160775","","0","0","0");
INSERT INTO loan_schedule VALUES("590","2025-04-02","26","262785.4213615","18716.891636473","","0","0","0");
INSERT INTO loan_schedule VALUES("591","2025-05-02","26","271982.91110916","9519.4018888203","","0","0","0");
INSERT INTO loan_schedule VALUES("592","2024-10-01","27","248183.2772528","4375","","0","0","0");
INSERT INTO loan_schedule VALUES("593","2024-11-01","27","248907.14514478","3651.1321080127","","0","0","0");
INSERT INTO loan_schedule VALUES("594","2024-12-01","27","249633.12431812","2925.1529346737","","0","0","0");
INSERT INTO loan_schedule VALUES("595","2025-01-01","27","250361.22093072","2197.0563220792","","0","0","0");
INSERT INTO loan_schedule VALUES("596","2025-02-01","27","251091.44115843","1466.8360943646","","0","0","0");
INSERT INTO loan_schedule VALUES("597","2025-03-01","27","251823.79119514","734.48605765253","","0","0","0");
INSERT INTO loan_schedule VALUES("621","2025-03-02","28","251823.79119514","734.48605765253","","0","0","0");
INSERT INTO loan_schedule VALUES("620","2025-02-02","28","251091.44115843","1466.8360943646","","0","0","0");
INSERT INTO loan_schedule VALUES("619","2025-01-02","28","250361.22093072","2197.0563220792","","0","0","0");
INSERT INTO loan_schedule VALUES("618","2024-12-02","28","249633.12431812","2925.1529346737","","0","0","0");
INSERT INTO loan_schedule VALUES("616","2024-10-02","28","248183.2772528","4375","","0","0","0");
INSERT INTO loan_schedule VALUES("617","2024-11-02","28","248907.14514478","3651.1321080127","","0","0","0");
INSERT INTO loan_schedule VALUES("645","2024-08-31","29","271982.91110916","9519.4018888203","","0","0","0");
INSERT INTO loan_schedule VALUES("644","2024-07-31","29","262785.4213615","18716.891636473","","0","0","0");
INSERT INTO loan_schedule VALUES("643","2024-06-30","29","253898.9578372","27603.355160775","","0","0","0");
INSERT INTO loan_schedule VALUES("642","2024-05-31","29","245313.00274126","36189.310256719","","0","0","0");
INSERT INTO loan_schedule VALUES("640","2024-03-31","29","229002.31299798","52500","","0","0","0");
INSERT INTO loan_schedule VALUES("641","2024-04-30","29","237017.39395291","44484.919045071","","0","0","0");
INSERT INTO loan_schedule VALUES("710","1970-05-01","30","262785.4213615","18716.891636473","0","0","0","0");
INSERT INTO loan_schedule VALUES("709","1970-04-01","30","253898.9578372","27603.355160775","0","0","0","0");
INSERT INTO loan_schedule VALUES("708","1970-03-02","30","245313.00274126","36189.310256719","0","0","0","0");
INSERT INTO loan_schedule VALUES("707","1970-01-31","30","237017.39395291","44484.919045071","0","0","0","0");
INSERT INTO loan_schedule VALUES("706","1970-01-01","30","229002.31299798","52500","0","0","0","0");
INSERT INTO loan_schedule VALUES("687","2025-07-01","31","271982.91110916","9519.4018888203","","0","0","0");
INSERT INTO loan_schedule VALUES("686","2025-06-01","31","262785.4213615","18716.891636473","","0","0","0");
INSERT INTO loan_schedule VALUES("685","2025-05-01","31","253898.9578372","27603.355160775","","0","0","0");
INSERT INTO loan_schedule VALUES("684","2025-04-01","31","245313.00274126","36189.310256719","","0","0","0");
INSERT INTO loan_schedule VALUES("683","2025-03-01","31","237017.39395291","44484.919045071","","0","0","0");
INSERT INTO loan_schedule VALUES("682","2025-02-01","31","229002.31299798","52500","","0","0","0");
INSERT INTO loan_schedule VALUES("711","1970-05-31","30","271982.91110916","9519.4018888203","0","0","0","0");
INSERT INTO loan_schedule VALUES("694","2025-03-17","32","166319.7818809","833.33333333333","","0","0","0");
INSERT INTO loan_schedule VALUES("695","2025-04-17","32","166458.38169913","694.73351509925","","0","0","0");
INSERT INTO loan_schedule VALUES("696","2025-05-17","32","166597.09701722","556.01819701664","","0","0","0");
INSERT INTO loan_schedule VALUES("697","2025-06-17","32","166735.9279314","417.18728283562","","0","0","0");
INSERT INTO loan_schedule VALUES("698","2025-07-17","32","166874.87453801","278.24067622612","","0","0","0");
INSERT INTO loan_schedule VALUES("699","2025-08-17","32","167013.93693346","139.17828077778","","0","0","0");
INSERT INTO loan_schedule VALUES("700","2025-03-31","33","166666.66666667","10000","","0","0","0");
INSERT INTO loan_schedule VALUES("701","2025-04-30","33","166666.66666667","10000","","0","0","0");
INSERT INTO loan_schedule VALUES("702","2025-05-31","33","166666.66666667","10000","","0","0","0");
INSERT INTO loan_schedule VALUES("703","2025-06-30","33","166666.66666667","10000","","0","0","0");
INSERT INTO loan_schedule VALUES("704","2025-07-31","33","166666.66666667","10000","","0","0","0");
INSERT INTO loan_schedule VALUES("705","2025-08-31","33","166666.66666667","10000","","0","0","0");



DROP TABLE loan_schedule_backup_before125;

CREATE TABLE `loan_schedule_backup_before125` (
  `loan_schedule_id` int(10) NOT NULL AUTO_INCREMENT,
  `schedule_date` date NOT NULL,
  `loan_id` int(11) NOT NULL,
  `principle_installment` varchar(100) NOT NULL,
  `interest_installment` longtext NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `journal_user_id` int(11) NOT NULL,
  `schedule_status` int(1) NOT NULL,
  `reversed` int(11) NOT NULL,
  PRIMARY KEY (`loan_schedule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE loan_schedule_be4_due_dates_changed;

CREATE TABLE `loan_schedule_be4_due_dates_changed` (
  `loan_schedule_id` int(10) NOT NULL AUTO_INCREMENT,
  `schedule_date` date NOT NULL,
  `loan_id` int(11) NOT NULL,
  `principle_installment` varchar(100) NOT NULL,
  `interest_installment` longtext NOT NULL,
  `proc_fees` varchar(100) NOT NULL,
  `journal_user_id` int(11) NOT NULL,
  `schedule_status` int(1) NOT NULL,
  `reversed` int(11) NOT NULL,
  PRIMARY KEY (`loan_schedule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE loan_types;

CREATE TABLE `loan_types` (
  `loan_type_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_name` varchar(150) NOT NULL,
  `loan_type_code` varchar(50) NOT NULL,
  `loan_description` longtext NOT NULL,
  `rate` varchar(11) NOT NULL,
  `intr_mode` varchar(1) NOT NULL,
  `rate_amount` varchar(50) NOT NULL,
  `intr_mor_period` varchar(11) NOT NULL DEFAULT 'NO',
  `prnc_mor_period` varchar(11) NOT NULL DEFAULT 'NO',
  `min_principle_amount` varchar(100) NOT NULL,
  `max_principle_amount` varchar(100) NOT NULL,
  `shares` varchar(100) NOT NULL,
  `share_cost` varchar(100) NOT NULL,
  `shares_value` varchar(100) NOT NULL,
  `ins_type` varchar(50) NOT NULL,
  `insurance` varchar(50) NOT NULL,
  `ins_mode` varchar(50) NOT NULL,
  `origin_perc` varchar(50) NOT NULL,
  `origination_fee` varchar(100) NOT NULL,
  `procc_fee_type` varchar(20) NOT NULL,
  `processing_fee` varchar(100) NOT NULL,
  `procc_mode` varchar(1) NOT NULL,
  `penalty` varchar(100) NOT NULL,
  `penalty_mode` varchar(100) NOT NULL,
  `payment_period` varchar(100) NOT NULL,
  `other_info` longtext NOT NULL,
  `savings` varchar(100) NOT NULL,
  `points` varchar(10) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `date_updated` datetime NOT NULL,
  `status1` int(11) NOT NULL,
  `status2` int(11) NOT NULL,
  `status3` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `updated_user_id` int(11) NOT NULL,
  `loan_security_fund` varchar(100) NOT NULL,
  `cash_collateral` varchar(100) NOT NULL,
  `collat_needed` int(11) NOT NULL,
  `calc_mode_lt` varchar(1) NOT NULL,
  `grace_period_days` int(11) NOT NULL,
  `loan_revenue_account_id` int(11) NOT NULL,
  `loan_asset_account_id` int(11) NOT NULL,
  `principle_amount` int(11) NOT NULL,
  PRIMARY KEY (`loan_type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO loan_types VALUES("1","DEVELOPMENT LOANS","DVLP","d","1","M","","","","0","0","","","","","","","","","","","","","","Monthly","","","","2024-05-19 03:26:31","2025-03-17 20:57:39","0","0","0","100","100","","","0","S","0","15","2","0");
INSERT INTO loan_types VALUES("3","MKOPO WA DHARURA","MWD","","1","M","","NO","NO","1000","2000000","","","","","","","","0","","","","","","Monthly","","","","2024-05-29 20:23:42","2024-07-15 05:28:01","0","0","0","100","100","","","0","R","0","16","2","0");
INSERT INTO loan_types VALUES("4","Jazz Microfinance","4557","TRTR","42","Y","","NO","NO","0","0","","","","","","","","0","","","","","","Weekly","","","","2025-02-19 13:37:00","2025-02-19 13:48:27","0","0","0","100","100","","","0","R","0","16","2","0");
INSERT INTO loan_types VALUES("5","jazz loan","786","fcvcv","42","Y","","NO","NO","0","0","","","","","","","","0","","","","","","Monthly","","","","2025-02-19 14:16:08","2025-02-19 14:18:55","0","0","0","100","100","","","0","R","0","16","2","0");
INSERT INTO loan_types VALUES("6","foresight loan","564324","","42","Y","","NO","NO","0","0","","","","","","","","0","","","","","","Monthly","","","","2025-02-24 16:20:32","2025-02-28 15:40:29","0","0","0","100","100","","","0","R","0","15","2","0");
INSERT INTO loan_types VALUES("7","LAWI","TY6","","42","Y","","NO","NO","0","0","","","","","","","","0","","","","","","Monthly","","","","2025-03-09 11:59:43","0000-00-00 00:00:00","0","0","0","100","0","","","0","R","0","15","2","0");
INSERT INTO loan_types VALUES("8","Weekly","","","42","M","","","","0","0","","","","","","","","0","","","","","","Weekly","","","","2025-03-17 21:17:12","0000-00-00 00:00:00","0","0","0","100","0","","","0","R","0","16","2","0");



DROP TABLE loan_types_old;

CREATE TABLE `loan_types_old` (
  `loan_type_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_name` varchar(150) NOT NULL,
  `loan_description` longtext NOT NULL,
  `rate` varchar(11) NOT NULL,
  `intr_mode` varchar(1) NOT NULL,
  `rate_amount` varchar(50) NOT NULL,
  `principle_amount` varchar(10) NOT NULL,
  `shares` varchar(100) NOT NULL,
  `share_cost` varchar(100) NOT NULL,
  `shares_value` varchar(100) NOT NULL,
  `origin_perc` varchar(50) NOT NULL,
  `origination_fee` varchar(100) NOT NULL,
  `processing_fee` varchar(100) NOT NULL,
  `procc_mode` varchar(1) NOT NULL,
  `payment_period` varchar(100) NOT NULL,
  `other_info` longtext NOT NULL,
  `savings` varchar(100) NOT NULL,
  `points` varchar(10) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `status1` int(11) NOT NULL,
  `status2` int(11) NOT NULL,
  `status3` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_collateral` varchar(100) NOT NULL,
  `collat_needed` int(11) NOT NULL,
  `calc_mode` varchar(1) NOT NULL,
  `grace_period_days` int(11) NOT NULL,
  PRIMARY KEY (`loan_type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO loan_types_old VALUES("1","Salary Advance","salary advance loans","5","M","","0","","","","","0","0","U","Monthly","","","","2021-12-01 17:02:58","0","0","0","100","","0","S","0");
INSERT INTO loan_types_old VALUES("2","Salary Loan","loans given to employees","12","M","","300000","","","","","0","1000","U","Monthly","","","","2021-12-02 11:58:26","0","0","0","100","","0","S","30");
INSERT INTO loan_types_old VALUES("3","Cooperae Loan","test loan","15","Y","","10000000","","","","","","50000","U","Monthly","","","","2021-12-02 13:45:40","0","0","0","100","","0","R","0");



DROP TABLE loanofficer;

CREATE TABLE `loanofficer` (
  `officer_id` int(11) NOT NULL AUTO_INCREMENT,
  `f_name` varchar(100) NOT NULL,
  `m_name` varchar(100) NOT NULL,
  `l_name` varchar(100) NOT NULL,
  `city` varchar(50) NOT NULL,
  `county` varchar(50) NOT NULL,
  `dob` date NOT NULL,
  `no_of_children` varchar(3) NOT NULL,
  `division` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `sub_location` varchar(100) NOT NULL,
  `address` varchar(100) NOT NULL,
  `employer` int(11) NOT NULL,
  `member_branch_id` int(11) NOT NULL,
  `department` varchar(200) NOT NULL,
  `employment_terms_id` int(11) NOT NULL,
  `payroll_no` varchar(15) NOT NULL,
  `member_no` varchar(100) NOT NULL,
  `member_fname` longtext NOT NULL,
  `member_pre_phone` varchar(50) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `member_email` varchar(50) NOT NULL,
  `member_title` mediumtext NOT NULL,
  `national_id` varchar(20) NOT NULL,
  `date_enrolled` date NOT NULL,
  `monthly_contributions` varchar(100) NOT NULL,
  `m_date_recorded` date NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `gender` varchar(10) NOT NULL,
  `marital_status_id` int(10) NOT NULL,
  `kin_fname` varchar(100) NOT NULL,
  `kin_phone` varchar(100) NOT NULL,
  `kin_email` varchar(100) NOT NULL,
  `kin_relation` varchar(300) NOT NULL,
  `ref_fname` varchar(400) NOT NULL,
  `ref_phone` varchar(100) NOT NULL,
  `ref_relation` varchar(100) NOT NULL,
  `workmate_ref_fname` varchar(400) NOT NULL,
  `workmate_ref_phone` varchar(100) NOT NULL,
  `member_bank_id` int(11) NOT NULL,
  `member_bank_branch_id` int(11) NOT NULL,
  `bank_account_name` varchar(500) NOT NULL,
  `bank_account_no` varchar(100) NOT NULL,
  `business_type` varchar(250) NOT NULL,
  `business_location` varchar(250) NOT NULL,
  `cont_person_fname` varchar(200) NOT NULL,
  `cont_person_phone` varchar(100) NOT NULL,
  `cont_person_title` varchar(100) NOT NULL,
  `photo` longtext NOT NULL,
  `work` varchar(70) NOT NULL,
  `work_location` varchar(100) NOT NULL,
  `business_ward` varchar(50) NOT NULL,
  `business_city` varchar(50) NOT NULL,
  `garantor_fname` varchar(45) NOT NULL,
  `garantor_email` varchar(45) NOT NULL,
  `garantor_relation` varchar(50) NOT NULL,
  `garantor_phone` varchar(50) NOT NULL,
  PRIMARY KEY (`officer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO loanofficer VALUES("1","MICHOMA","PETER","KUKU","3456","","2025-03-31","","","","","TYHH","0","0","","0","","1","MICHOMA PETER KUKU","3467788","2553467788","lulu@gmail.com","","234623467","0000-00-00","","2025-03-31","100","0","M","0","","","","","","","","","","0","0","","","","","","","","","","","","","","","","");
INSERT INTO loanofficer VALUES("2","LULU","HASSAN","MICHOMA","","","0000-00-00","","","","","","0","0","","0","","2","LULU HASSAN MICHOMA","326772434","255326772434","","","3267","0000-00-00","","2025-03-31","100","0","M","0","","","","","","","","","","0","0","","","","","","","","","","","","","","","","");



DROP TABLE main_account_category;

CREATE TABLE `main_account_category` (
  `main_account_cat_id` int(10) NOT NULL AUTO_INCREMENT,
  `account_cat_id` int(11) NOT NULL,
  `pre_main_account_cat_id` int(11) NOT NULL,
  `account_cat_code` varchar(100) NOT NULL,
  `main_account_uniq_code` varchar(100) NOT NULL,
  `main_account_cat_name` varchar(100) NOT NULL,
  `main_account_cat_desc` varchar(100) NOT NULL,
  `main_account_cat_code` varchar(100) NOT NULL,
  `main_account_cat_bal_type` varchar(2) NOT NULL,
  PRIMARY KEY (`main_account_cat_id`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=latin1;

INSERT INTO main_account_category VALUES("2","2","1","101000","100","Bank Balances","","101100","D");
INSERT INTO main_account_category VALUES("3","2","1","101000","200","Mobile Money Balances","","101200","D");
INSERT INTO main_account_category VALUES("4","2","1","101300","0","Short Term Deposits with Banks","","101300","D");
INSERT INTO main_account_category VALUES("5","2","1","101000","400","Government Securities Deposites","","101400","D");
INSERT INTO main_account_category VALUES("6","2","1","101000","500","Advances and Loans to Customers","","101500","D");
INSERT INTO main_account_category VALUES("7","2","1","101000","600","Due from Related Organisations","","101600","D");
INSERT INTO main_account_category VALUES("8","2","1","101000","700","Other Receivables","","101700","D");
INSERT INTO main_account_category VALUES("9","2","1","101000","800","Prepayments","","101800","D");
INSERT INTO main_account_category VALUES("10","1","10","102000","100","Property Plant and Equipment","","102100","D");
INSERT INTO main_account_category VALUES("11","1","10","102000","200","Buildings","","102200","D");
INSERT INTO main_account_category VALUES("12","1","10","102000","300","Plant and Equipment","","102300","D");
INSERT INTO main_account_category VALUES("13","1","10","102000","400","Computers and I.T Equipments","","102400","D");
INSERT INTO main_account_category VALUES("14","1","10","102000","500","Office Equipments","","102500","D");
INSERT INTO main_account_category VALUES("15","1","10","102000","600","Furniture and Fixtures","","102600","D");
INSERT INTO main_account_category VALUES("16","1","10","102000","700","Motor Vehicles","","102700","D");
INSERT INTO main_account_category VALUES("17","1","10","102000","800","Intangible Assets","","102800","D");
INSERT INTO main_account_category VALUES("18","3","3","103000","100","Borrowings","","103100","C");
INSERT INTO main_account_category VALUES("19","3","11","104000","200","Due To Related Companies","","104200","C");
INSERT INTO main_account_category VALUES("20","3","11","104000","300","Other Liabilities","","104300","C");
INSERT INTO main_account_category VALUES("21","4","4","105000","100","Share Capital ","","105100","C");
INSERT INTO main_account_category VALUES("22","4","4","105000","200","Share Premiums","","105200","C");
INSERT INTO main_account_category VALUES("23","4","4","105000","300","Contributions by Share Holders","","105300","C");
INSERT INTO main_account_category VALUES("24","4","4","105000","400","Retained earnings","","105400","C");
INSERT INTO main_account_category VALUES("25","4","4","105000","500","Statutory Reserves","","105500","C");
INSERT INTO main_account_category VALUES("26","7","5","201000","100","Income- Interest on Loans Portfolio","","201100","C");
INSERT INTO main_account_category VALUES("27","7","5","201000","200","Fees and Commissions","","201200","C");
INSERT INTO main_account_category VALUES("28","7","5","201000","300","Income from Other Investments","","201300","C");
INSERT INTO main_account_category VALUES("29","7","5","201000","400","Other Operating Income","","201400","C");
INSERT INTO main_account_category VALUES("30","7","5","201000","500","Non Operating Income","","201500","C");
INSERT INTO main_account_category VALUES("31","6","6","301000","100","Interest and fees expenses","","301100","D");
INSERT INTO main_account_category VALUES("32","6","6","301000","200","Loan Impairements","","301200","D");
INSERT INTO main_account_category VALUES("33","6","6","301000","300","Auctioneers and Loan Recovery Expenses","","301300","D");
INSERT INTO main_account_category VALUES("34","6","6","301000","400","Legal fees","","301400","D");
INSERT INTO main_account_category VALUES("35","6","6","301000","500","Staff Costs","","301500","D");
INSERT INTO main_account_category VALUES("36","6","6","301000","600","Administration Costs","","301600","D");
INSERT INTO main_account_category VALUES("37","6","6","301000","700","Depreciation and Amortisation Expenses","","301700","D");
INSERT INTO main_account_category VALUES("38","6","6","301000","800","Sales and Marketing Expenses","","301800","D");
INSERT INTO main_account_category VALUES("39","6","6","301000","900","Finance Costs","","301900","D");
INSERT INTO main_account_category VALUES("40","2","1","101150","0","Petty Cash Balances","","101150","D");
INSERT INTO main_account_category VALUES("42","3","11","104000","100","Current Liabilities","","104100","C");
INSERT INTO main_account_category VALUES("43","2","1","101000","550","Provision For Bad Debts (BS)","","101550","C");



DROP TABLE marital_status;

CREATE TABLE `marital_status` (
  `marital_status_id` int(10) NOT NULL AUTO_INCREMENT,
  `marital_status_name` varchar(300) NOT NULL,
  PRIMARY KEY (`marital_status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO marital_status VALUES("1","Married");
INSERT INTO marital_status VALUES("2","Single");
INSERT INTO marital_status VALUES("3","Divorced");
INSERT INTO marital_status VALUES("4","Widowed");



DROP TABLE member_photos;

CREATE TABLE `member_photos` (
  `member_photo_id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_name` varchar(200) NOT NULL,
  `member_id` int(11) NOT NULL,
  `time_uploaded` datetime NOT NULL,
  `file_name` longtext NOT NULL,
  `file_path` longtext NOT NULL,
  `file_type` varchar(1) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `status1` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`member_photo_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO member_photos VALUES("2","","50","0000-00-00 00:00:00","48af265ppt2.jpg","","","","0","0");
INSERT INTO member_photos VALUES("3","","1","0000-00-00 00:00:00","1faa48fBrochure Front Side.jpg","","","","0","0");
INSERT INTO member_photos VALUES("4","","3","0000-00-00 00:00:00","340f2a3How to Implement Routes.PNG","","","","0","0");
INSERT INTO member_photos VALUES("5","","6","0000-00-00 00:00:00","fab6ccdKIBU PS.jpg","","","","0","0");
INSERT INTO member_photos VALUES("6","","8","0000-00-00 00:00:00","e78eb29KIBU PS.jpg","","","","0","0");
INSERT INTO member_photos VALUES("7","","7","0000-00-00 00:00:00","acc2577passport.jpg","","","","0","0");
INSERT INTO member_photos VALUES("8","","11","0000-00-00 00:00:00","6e2b806Dan Passport.jpg","","","","0","0");
INSERT INTO member_photos VALUES("9","","13","0000-00-00 00:00:00","44b1a0eKIBU PS.jpg","","","","0","0");
INSERT INTO member_photos VALUES("10","","18","0000-00-00 00:00:00","5915852KIBU PS.jpg","","","","0","0");
INSERT INTO member_photos VALUES("11","","31","0000-00-00 00:00:00","f0d525bDan Passport.jpg","","","","0","0");
INSERT INTO member_photos VALUES("12","","33","0000-00-00 00:00:00","cc22586giraffe.webp","","","","0","0");
INSERT INTO member_photos VALUES("13","","36","0000-00-00 00:00:00","dfdfab9How to Implement Routes.PNG","","","","0","0");



DROP TABLE member_transactions;

CREATE TABLE `member_transactions` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `member_id` int(10) NOT NULL,
  `loan_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `transaction` longtext NOT NULL,
  `amount` varchar(100) NOT NULL,
  `debit` varchar(50) NOT NULL,
  `credit` varchar(50) NOT NULL,
  `currency` int(11) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `transaction_date` date NOT NULL,
  `date_recorded` datetime NOT NULL,
  `transaction_code` varchar(100) NOT NULL,
  `status` int(11) NOT NULL,
  `status2` int(11) NOT NULL,
  `status3` int(11) NOT NULL,
  `transaction_type` varchar(200) NOT NULL,
  `l_day` varchar(10) NOT NULL,
  `l_month` varchar(10) NOT NULL,
  `l_year` year(4) NOT NULL,
  `transaction_user_id` int(11) NOT NULL,
  `receipt_code_id` int(11) NOT NULL,
  `receipt_transaction_type_id` int(11) NOT NULL,
  `financial_year_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=InnoDB AUTO_INCREMENT=186 DEFAULT CHARSET=latin1;

INSERT INTO member_transactions VALUES("1","3","0","0","Payment Received For Shares received from <a href=\"home.php?receipt_payments&sales_id=29&sub_module_id=176\">02001 ALLY  SALIM MRUTU Ref No : 000546, Receipt No :000546 </a><i>(shares)</i>","560000","","560000","7","1","2024-10-08","0000-00-00 00:00:00","cr-recpt72","0","0","0","OTHER-RECPT","","","0000","100","0","1","1","5");
INSERT INTO member_transactions VALUES("2","3","0","0","Payment Made For Shares To <a href=\"home.php?receipt_payments&sales_id=30&sub_module_id=176\">02001 ALLY  SALIM MRUTU Ref No : 00546, Receipt No :00546 </a><i>(withdrawal of shares)</i>","-200000","200000","","7","1","2024-10-08","0000-00-00 00:00:00","cr-recpt73","0","0","0","OTHER-PYMNT","","","0000","100","0","1","1","5");
INSERT INTO member_transactions VALUES("3","12","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=1&sub_module_id=116\">loan ID DVLP-INVST01</a>","250","250","","0","","2024-10-02","2024-10-08 16:26:06","intr1-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("4","22","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=2&sub_module_id=116\">loan ID DVLP-INVST02</a>","7500","7500","","0","","2024-09-30","2024-10-08 16:26:06","intr2-2024-09-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("5","27","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=3&sub_module_id=116\">loan ID DVLP-INVST03</a>","6650","6650","","0","","2024-09-30","2024-10-08 16:26:06","intr3-2024-09-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("6","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=4&sub_module_id=116\">loan ID DVLP-INVST04</a>","6000","6000","","0","","2024-09-30","2024-10-08 16:26:06","intr4-2024-09-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("7","3","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=6&sub_module_id=116\">loan ID DVLP-INVST06</a>","50","50","","0","","2024-09-03","2024-10-08 16:26:06","intr6-2024-09-03","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("8","3","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=6&sub_module_id=116\">loan ID DVLP-INVST06</a>","45.852396088876","45.852396088876","","0","","2024-10-03","2024-10-08 16:26:06","intr6-2024-10-03","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("9","1","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=7&sub_module_id=116\">loan ID DVLP-INVST07</a>","4166.6666666667","4166.6666666667","","0","","2024-09-06","2024-10-08 16:26:06","intr7-2024-09-06","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("10","1","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=7&sub_module_id=116\">loan ID DVLP-INVST07</a>","3821.0330074064","3821.0330074064","","0","","2024-10-06","2024-10-08 16:26:06","intr7-2024-10-06","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("11","6","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=8&sub_module_id=116\">loan ID DVLP-INVST08</a>","333.33333333333","333.33333333333","","0","","2024-09-27","2024-10-08 16:26:06","intr8-2024-09-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("12","8","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=9&sub_module_id=116\">loan ID MWD-INVST09</a>","166.66666666667","166.66666666667","","0","","2024-09-27","2024-10-08 16:26:06","intr9-2024-09-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("13","13","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=10&sub_module_id=116\">loan ID DVLP-INVST10</a>","5833.3333333333","5833.3333333333","","0","","2024-09-27","2024-10-08 16:26:06","intr10-2024-09-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("14","18","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=11&sub_module_id=116\">loan ID DVLP-INVST11</a>","333.33333333333","333.33333333333","","0","","2024-09-27","2024-10-08 16:26:06","intr11-2024-09-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("15","7","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=12&sub_module_id=116\">loan ID DVLP-INVST12</a>","12500","12500","","0","","2024-09-02","2024-10-08 16:26:06","intr12-2024-09-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("16","7","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=12&sub_module_id=116\">loan ID DVLP-INVST12</a>","12244.648467948","12244.648467948","","0","","2024-10-02","2024-10-08 16:26:06","intr12-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("17","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=13&sub_module_id=116\">loan ID DVLP-INVST13</a>","8333.3333333333","8333.3333333333","","0","","2024-09-02","2024-10-08 16:26:06","intr13-2024-09-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("18","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=13&sub_module_id=116\">loan ID DVLP-INVST13</a>","8105.2102832259","8105.2102832259","","0","","2024-10-02","2024-10-08 16:26:06","intr13-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("19","16","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=14&sub_module_id=116\">loan ID DVLP-INVST14</a>","833.33333333333","833.33333333333","","0","","2024-09-02","2024-10-08 16:26:06","intr14-2024-09-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("20","16","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=14&sub_module_id=116\">loan ID DVLP-INVST14</a>","764.20660148127","764.20660148127","","0","","2024-10-02","2024-10-08 16:26:06","intr14-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("21","19","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=15&sub_module_id=116\">loan ID DVLP-INVST15</a>","4166.6666666667","4166.6666666667","","0","","2024-09-02","2024-10-08 16:26:06","intr15-2024-09-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("22","19","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=15&sub_module_id=116\">loan ID DVLP-INVST15</a>","3821.0330074064","3821.0330074064","","0","","2024-10-02","2024-10-08 16:26:06","intr15-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("23","21","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=16&sub_module_id=116\">loan ID DVLP-INVST16</a>","583.33333333333","583.33333333333","","0","","2024-09-02","2024-10-08 16:26:06","intr16-2024-09-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("24","21","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=16&sub_module_id=116\">loan ID DVLP-INVST16</a>","486.31346056947","486.31346056947","","0","","2024-10-02","2024-10-08 16:26:06","intr16-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("25","20","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=17&sub_module_id=116\">loan ID DVLP-INVST17</a>","1666.6666666667","1666.6666666667","","0","","2024-09-02","2024-10-08 16:26:06","intr17-2024-09-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("26","20","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=17&sub_module_id=116\">loan ID DVLP-INVST17</a>","1528.4132029625","1528.4132029625","","0","","2024-10-02","2024-10-08 16:26:06","intr17-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("27","26","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=18&sub_module_id=116\">loan ID MWD-LN18</a>","416.66666666667","416.66666666667","","0","","2024-10-02","2024-10-08 16:26:06","intr18-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("28","25","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=19&sub_module_id=116\">loan ID DVLP-INVST19</a>","4166.6666666667","4166.6666666667","","0","","2024-09-02","2024-10-08 16:26:06","intr19-2024-09-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("29","25","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=19&sub_module_id=116\">loan ID DVLP-INVST19</a>","3994.7135541579","3994.7135541579","","0","","2024-10-02","2024-10-08 16:26:06","intr19-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("30","26","18","0","Loan repayment for the loan . Loan Ref No. MWD-LN18 received from customer ANNETE  CLOUTAS DJUING","-166944.52","","166944.52","7","1","2024-10-10","2024-10-10 10:50:44","drlnrep18","0","0","0","LOAN-REP","10","10","2024","100","0","7","0","0");
INSERT INTO member_transactions VALUES("31","26","18","0","Principle repayment for the loan . Loan Ref No. MWD-LN18 whose due date was 2024-10-02 received from customer ANNETE  CLOUTAS DJUING","-166527.85","","166527.85","7","1","2024-10-10","2024-10-10 10:50:44","crprncrep8","0","0","0","PRNC-LOAN-REP","10","10","2024","100","0","9","0","0");
INSERT INTO member_transactions VALUES("32","26","18","0","Interest repayment for the loan . Loan Ref No. MWD-LN18 whose due date was 2024-10-02 received from customer ANNETE  CLOUTAS DJUING","-416.67","","416.67","7","1","2024-10-10","2024-10-10 10:50:44","crintrep8","0","0","0","INTR-LOAN-REP","10","10","2024","100","0","8","0","0");
INSERT INTO member_transactions VALUES("33","12","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=1&sub_module_id=116\">loan ID DVLP-INVST01</a>","229.26198044438","229.26198044438","","0","","2024-11-02","2024-11-16 11:47:46","intr1-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("34","22","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=2&sub_module_id=116\">loan ID DVLP-INVST02</a>","7190.4843974842","7190.4843974842","","0","","2024-10-30","2024-11-16 11:47:46","intr2-2024-10-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("35","27","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=3&sub_module_id=116\">loan ID DVLP-INVST03</a>","6125.655555289","6125.655555289","","0","","2024-10-30","2024-11-16 11:47:46","intr3-2024-10-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("36","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=4&sub_module_id=116\">loan ID DVLP-INVST04</a>","5526.9072679299","5526.9072679299","","0","","2024-10-30","2024-11-16 11:47:46","intr4-2024-10-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("37","31","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=5&sub_module_id=116\">loan ID DVLP-LN5</a>","1330","1330","","0","","2024-10-30","2024-11-16 11:47:46","intr5-2024-10-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("38","3","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=6&sub_module_id=116\">loan ID DVLP-INVST06</a>","41.70133584116","41.70133584116","","0","","2024-11-03","2024-11-16 11:47:46","intr6-2024-11-03","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("39","1","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=7&sub_module_id=116\">loan ID DVLP-INVST07</a>","3475.1113200967","3475.1113200967","","0","","2024-11-06","2024-11-16 11:47:46","intr7-2024-11-06","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("40","6","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=8&sub_module_id=116\">loan ID DVLP-INVST08</a>","305.68264059251","305.68264059251","","0","","2024-10-27","2024-11-16 11:47:46","intr8-2024-10-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("41","8","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=9&sub_module_id=116\">loan ID MWD-INVST09</a>","138.94670301985","138.94670301985","","0","","2024-10-27","2024-11-16 11:47:46","intr9-2024-10-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("42","13","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=10&sub_module_id=116\">loan ID DVLP-INVST10</a>","5673.6471982581","5673.6471982581","","0","","2024-10-27","2024-11-16 11:47:46","intr10-2024-10-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("43","18","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=11&sub_module_id=116\">loan ID DVLP-INVST11</a>","305.68264059251","305.68264059251","","0","","2024-10-27","2024-11-16 11:47:46","intr11-2024-10-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("44","7","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=12&sub_module_id=116\">loan ID DVLP-INVST12</a>","11989.084142953","11989.084142953","","0","","2024-11-02","2024-11-16 11:47:46","intr12-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("45","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=13&sub_module_id=116\">loan ID DVLP-INVST13</a>","7876.8971305766","7876.8971305766","","0","","2024-11-02","2024-11-16 11:47:46","intr13-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("46","16","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=14&sub_module_id=116\">loan ID DVLP-INVST14</a>","695.02226401934","695.02226401934","","0","","2024-11-02","2024-11-16 11:47:46","intr14-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("47","19","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=15&sub_module_id=116\">loan ID DVLP-INVST15</a>","3475.1113200967","3475.1113200967","","0","","2024-11-02","2024-11-16 11:47:46","intr15-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("48","21","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=16&sub_module_id=116\">loan ID DVLP-INVST16</a>","389.21273791165","389.21273791165","","0","","2024-11-02","2024-11-16 11:47:46","intr16-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("49","20","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=17&sub_module_id=116\">loan ID DVLP-INVST17</a>","1390.0445280387","1390.0445280387","","0","","2024-11-02","2024-11-16 11:47:46","intr17-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("50","26","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=18&sub_module_id=116\">loan ID MWD-LN18</a>","277.89345424487","277.89345424487","","0","","2024-11-02","2024-11-16 11:47:46","intr18-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("51","25","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=19&sub_module_id=116\">loan ID DVLP-INVST19</a>","3822.6171473886","3822.6171473886","","0","","2024-11-02","2024-11-16 11:47:46","intr19-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("52","26","0","0","Payment Received For Savings received from <a href=\"home.php?receipt_payments&sales_id=31&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : 9, Receipt No :9 </a><i>(ddd)</i>","670000","","670000","7","1","2024-11-16","0000-00-00 00:00:00","cr-recpt74","0","0","0","OTHER-RECPT","","","0000","100","0","2","1","5");
INSERT INTO member_transactions VALUES("53","26","0","0","Payment Received For Savings received from <a href=\"home.php?receipt_payments&sales_id=32&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : nnn, Receipt No :nnn </a><i>(nn)</i>","50000","","50000","7","1","2024-11-18","0000-00-00 00:00:00","cr-recpt75","0","0","0","OTHER-RECPT","","","0000","100","0","2","1","5");
INSERT INTO member_transactions VALUES("54","26","0","0","Payment Received For Shares received from <a href=\"home.php?receipt_payments&sales_id=32&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : nnn, Receipt No :nnn </a><i>(mm)</i>","50000","","50000","7","1","2024-11-18","0000-00-00 00:00:00","cr-recpt76","0","0","0","OTHER-RECPT","","","0000","100","0","1","1","5");
INSERT INTO member_transactions VALUES("55","26","0","0","Payment Received For Deposit received from <a href=\"home.php?receipt_payments&sales_id=32&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : nnn, Receipt No :nnn </a><i>(mmm)</i>","50000","","50000","7","1","2024-11-18","0000-00-00 00:00:00","cr-recpt77","0","0","0","OTHER-RECPT","","","0000","100","0","3","1","5");
INSERT INTO member_transactions VALUES("56","12","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=1&sub_module_id=116\">loan ID DVLP-INVST01</a>","208.5066792058","208.5066792058","","0","","2024-12-02","2024-12-22 11:32:52","intr1-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("57","22","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=2&sub_module_id=116\">loan ID DVLP-INVST02</a>","6880.7108652995","6880.7108652995","","0","","2024-11-30","2024-12-22 11:32:52","intr2-2024-11-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("58","27","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=3&sub_module_id=116\">loan ID DVLP-INVST03</a>","5596.0676661309","5596.0676661309","","0","","2024-11-30","2024-12-22 11:32:52","intr3-2024-11-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("59","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=4&sub_module_id=116\">loan ID DVLP-INVST04</a>","5049.0836085392","5049.0836085392","","0","","2024-11-30","2024-12-22 11:32:52","intr4-2024-11-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("60","31","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=5&sub_module_id=116\">loan ID DVLP-LN5</a>","1225.1311110578","1225.1311110578","","0","","2024-11-30","2024-12-22 11:32:52","intr5-2024-11-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("61","3","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=6&sub_module_id=116\">loan ID DVLP-INVST06</a>","37.546816376571","37.546816376571","","0","","2024-12-03","2024-12-22 11:32:52","intr6-2024-12-03","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("62","1","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=7&sub_module_id=116\">loan ID DVLP-INVST07</a>","3128.9013647142","3128.9013647142","","0","","2024-12-06","2024-12-22 11:32:52","intr7-2024-12-06","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("63","6","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=8&sub_module_id=116\">loan ID DVLP-INVST08</a>","278.00890560773","278.00890560773","","0","","2024-11-27","2024-12-22 11:32:52","intr8-2024-11-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("64","8","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=9&sub_module_id=116\">loan ID MWD-INVST09</a>","111.20363940333","111.20363940333","","0","","2024-11-27","2024-12-22 11:32:52","intr9-2024-11-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("65","13","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=10&sub_module_id=116\">loan ID DVLP-INVST10</a>","5513.8279914036","5513.8279914036","","0","","2024-11-27","2024-12-22 11:32:52","intr10-2024-11-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("66","18","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=11&sub_module_id=116\">loan ID DVLP-INVST11</a>","278.00890560773","278.00890560773","","0","","2024-11-27","2024-12-22 11:32:52","intr11-2024-11-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("67","7","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=12&sub_module_id=116\">loan ID DVLP-INVST12</a>","11733.306847688","11733.306847688","","0","","2024-12-02","2024-12-22 11:32:52","intr12-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("68","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=13&sub_module_id=116\">loan ID DVLP-INVST13</a>","7648.3937169669","7648.3937169669","","0","","2024-12-02","2024-12-22 11:32:52","intr13-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("69","16","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=14&sub_module_id=116\">loan ID DVLP-INVST14</a>","625.78027294285","625.78027294285","","0","","2024-12-02","2024-12-22 11:32:52","intr14-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("70","19","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=15&sub_module_id=116\">loan ID DVLP-INVST15</a>","3128.9013647142","3128.9013647142","","0","","2024-12-02","2024-12-22 11:32:52","intr15-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("71","21","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=16&sub_module_id=116\">loan ID DVLP-INVST16</a>","292.03109798494","292.03109798494","","0","","2024-12-02","2024-12-22 11:32:52","intr16-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("72","20","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=17&sub_module_id=116\">loan ID DVLP-INVST17</a>","1251.5605458857","1251.5605458857","","0","","2024-12-02","2024-12-22 11:32:52","intr17-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("73","26","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=18&sub_module_id=116\">loan ID MWD-LN18</a>","139.00459747939","139.00459747939","","0","","2024-12-02","2024-12-22 11:32:52","intr18-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("74","25","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=19&sub_module_id=116\">loan ID DVLP-INVST19</a>","3650.3773269471","3650.3773269471","","0","","2024-12-02","2024-12-22 11:32:52","intr19-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("75","22","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=2&sub_module_id=116\">loan ID DVLP-INVST02</a>","6570.6791885048","6570.6791885048","","0","","2024-12-30","2024-12-31 11:45:41","intr2-2024-12-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("76","27","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=3&sub_module_id=116\">loan ID DVLP-INVST03</a>","5061.1838980813","5061.1838980813","","0","","2024-12-30","2024-12-31 11:45:41","intr3-2024-12-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("77","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=4&sub_module_id=116\">loan ID DVLP-INVST04</a>","4566.4817125545","4566.4817125545","","0","","2024-12-30","2024-12-31 11:45:41","intr4-2024-12-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("78","31","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=5&sub_module_id=116\">loan ID DVLP-LN5</a>","1119.2135332262","1119.2135332262","","0","","2024-12-30","2024-12-31 11:45:41","intr5-2024-12-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("79","6","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=8&sub_module_id=116\">loan ID DVLP-INVST08</a>","250.31210917714","250.31210917714","","0","","2024-12-27","2024-12-31 11:45:41","intr8-2024-12-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("80","8","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=9&sub_module_id=116\">loan ID MWD-INVST09</a>","83.437456567125","83.437456567125","","0","","2024-12-27","2024-12-31 11:45:41","intr9-2024-12-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("81","13","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=10&sub_module_id=116\">loan ID DVLP-INVST10</a>","5353.8756018768","5353.8756018768","","0","","2024-12-27","2024-12-31 11:45:41","intr10-2024-12-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("82","18","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=11&sub_module_id=116\">loan ID DVLP-INVST11</a>","250.31210917714","250.31210917714","","0","","2024-12-27","2024-12-31 11:45:41","intr11-2024-12-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("83","26","0","0","Payment Received For Savings received from <a href=\"home.php?receipt_payments&sales_id=35&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : LJKL, Receipt No :LJKL </a><i>(SHARE)</i>","500000","","500000","7","1","2024-12-31","0000-00-00 00:00:00","cr-recpt78","0","0","0","OTHER-RECPT","","","0000","100","0","2","1","5");
INSERT INTO member_transactions VALUES("84","26","0","0","Payment Received For Shares received from <a href=\"home.php?receipt_payments&sales_id=35&sub_module_id=176\">02020 ANNETE  CLOUTAS DJUING Ref No : LJKL, Receipt No :LJKL </a><i>(SHARE)</i>","200000","","200000","7","1","2024-12-31","0000-00-00 00:00:00","cr-recpt79","0","0","0","OTHER-RECPT","","","0000","100","0","1","1","5");
INSERT INTO member_transactions VALUES("85","12","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=1&sub_module_id=116\">loan ID DVLP-INVST01</a>","187.73408188285","187.73408188285","","0","","2025-01-02","2025-01-03 13:54:05","intr1-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("86","3","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=6&sub_module_id=116\">loan ID DVLP-INVST06</a>","33.388834812428","33.388834812428","","0","","2025-01-03","2025-01-03 13:54:05","intr6-2025-01-03","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("87","7","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=12&sub_module_id=116\">loan ID DVLP-INVST12</a>","11477.316404676","11477.316404676","","0","","2025-01-02","2025-01-03 13:54:05","intr12-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("88","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=13&sub_module_id=116\">loan ID DVLP-INVST13</a>","7419.6998838457","7419.6998838457","","0","","2025-01-02","2025-01-03 13:54:05","intr13-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("89","16","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=14&sub_module_id=116\">loan ID DVLP-INVST14</a>","556.48058020713","556.48058020713","","0","","2025-01-02","2025-01-03 13:54:05","intr14-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("90","19","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=15&sub_module_id=116\">loan ID DVLP-INVST15</a>","2782.4029010356","2782.4029010356","","0","","2025-01-02","2025-01-03 13:54:05","intr15-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("91","21","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=16&sub_module_id=116\">loan ID DVLP-INVST16</a>","194.76847335829","194.76847335829","","0","","2025-01-02","2025-01-03 13:54:05","intr16-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("92","20","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=17&sub_module_id=116\">loan ID DVLP-INVST17</a>","1112.9611604143","1112.9611604143","","0","","2025-01-02","2025-01-03 13:54:05","intr17-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("93","25","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=19&sub_module_id=116\">loan ID DVLP-INVST19</a>","3477.9939733219","3477.9939733219","","0","","2025-01-02","2025-01-03 13:54:05","intr19-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("94","1","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=7&sub_module_id=116\">loan ID DVLP-INVST07</a>","2782.4029010356","2782.4029010356","","0","","2025-01-06","2025-01-28 14:35:14","intr7-2025-01-06","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("95","6","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=8&sub_module_id=116\">loan ID DVLP-INVST08</a>","222.59223208285","222.59223208285","","0","","2025-01-27","2025-01-28 14:35:14","intr8-2025-01-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("96","8","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=9&sub_module_id=116\">loan ID MWD-INVST09</a>","55.648135245225","55.648135245225","","0","","2025-01-27","2025-01-28 14:35:14","intr9-2025-01-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("97","13","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=10&sub_module_id=116\">loan ID DVLP-INVST10</a>","5193.789918692","5193.789918692","","0","","2025-01-27","2025-01-28 14:35:14","intr10-2025-01-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("98","18","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=11&sub_module_id=116\">loan ID DVLP-INVST11</a>","222.59223208285","222.59223208285","","0","","2025-01-27","2025-01-28 14:35:14","intr11-2025-01-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("99","22","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=2&sub_module_id=116\">loan ID DVLP-INVST02</a>","6260.3891519793","6260.3891519793","","0","","2025-01-30","2025-01-30 10:04:50","intr2-2025-01-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("100","27","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=3&sub_module_id=116\">loan ID DVLP-INVST03</a>","4520.9512923511","4520.9512923511","","0","","2025-01-30","2025-01-30 10:04:50","intr3-2025-01-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("101","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=4&sub_module_id=116\">loan ID DVLP-INVST04</a>","4079.05379761","4079.05379761","","0","","2025-01-30","2025-01-30 10:04:50","intr4-2025-01-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("102","31","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=5&sub_module_id=116\">loan ID DVLP-LN5</a>","1012.2367796163","1012.2367796163","","0","","2025-01-30","2025-01-30 10:04:50","intr5-2025-01-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("103","12","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=1&sub_module_id=116\">loan ID DVLP-INVST01</a>","166.94417406214","166.94417406214","","0","","2025-02-02","2025-02-09 14:35:47","intr1-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("104","3","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=6&sub_module_id=116\">loan ID DVLP-INVST06</a>","29.227388263648","29.227388263648","","0","","2025-02-03","2025-02-09 14:35:47","intr6-2025-02-03","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("105","1","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=7&sub_module_id=116\">loan ID DVLP-INVST07</a>","2435.6156886373","2435.6156886373","","0","","2025-02-06","2025-02-09 14:35:47","intr7-2025-02-06","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("106","7","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=12&sub_module_id=116\">loan ID DVLP-INVST12</a>","11221.112636295","11221.112636295","","0","","2025-02-02","2025-02-09 14:35:47","intr12-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("107","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=13&sub_module_id=116\">loan ID DVLP-INVST13</a>","7190.8154725304","7190.8154725304","","0","","2025-02-02","2025-02-09 14:35:47","intr13-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("108","16","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=14&sub_module_id=116\">loan ID DVLP-INVST14</a>","487.12313772746","487.12313772746","","0","","2025-02-02","2025-02-09 14:35:47","intr14-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("109","19","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=15&sub_module_id=116\">loan ID DVLP-INVST15</a>","2435.6156886373","2435.6156886373","","0","","2025-02-02","2025-02-09 14:35:47","intr15-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("110","21","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=16&sub_module_id=116\">loan ID DVLP-INVST16</a>","97.424796544449","97.424796544449","","0","","2025-02-02","2025-02-09 14:35:47","intr16-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("111","20","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=17&sub_module_id=116\">loan ID DVLP-INVST17</a>","974.24627545493","974.24627545493","","0","","2025-02-02","2025-02-09 14:35:47","intr17-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("112","25","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=19&sub_module_id=116\">loan ID DVLP-INVST19</a>","3305.4669669019","3305.4669669019","","0","","2025-02-02","2025-02-09 14:35:47","intr19-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("113","10","22","0","Total Loan Value. <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=22&sub_module_id=116\">Loan ID 4557-LN22</a>","1559779.1601285","1559779.1601285","","7","1","2025-02-19","0000-00-00 00:00:00","lnis22","0","0","0","LOANVALUE","19","02","2025","100","0","6","0","0");
INSERT INTO member_transactions VALUES("114","10","22","0","Loan Principal. <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=22&sub_module_id=116\">Loan ID 4557-LN22</a>","1500000","1500000","","7","1","2025-02-19","0000-00-00 00:00:00","lnprnc22","0","0","0","LN-PRNC","19","02","2025","100","0","10","0","0");
INSERT INTO member_transactions VALUES("115","10","22","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=22&sub_module_id=116\">Loan ID 4557-LN22</a>","59779.16012854944","59779.16012854944","","7","1","2025-02-19","0000-00-00 00:00:00","ttlnintr22","0","0","0","TTL-LN-INTR","19","02","2025","100","0","11","0","0");
INSERT INTO member_transactions VALUES("116","30","23","0","Disbursement Of Loan Type  Jazz Microfinance 
To Member EVANCE  CHARLES THOMAS <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=23&sub_module_id=116\">Loan Ref No 4557-INVST23</a>","1500000","1500000","","7","1","2025-02-19","0000-00-00 00:00:00","cr-or23","0","0","0","LOANVALUE","19","02","2025","100","0","10","0","0");
INSERT INTO member_transactions VALUES("117","30","23","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=23&sub_module_id=116\">Loan ID 4557-INVST23</a>","809010.4571266132","809010.4571266132","","7","1","2025-02-19","0000-00-00 00:00:00","cr-intr-sale23","0","0","0","TTL-LN-INTR","19","02","2025","100","0","11","0","0");
INSERT INTO member_transactions VALUES("118","10","24","0","Disbursement Of Loan Type  Jazz Microfinance 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=24&sub_module_id=116\">Loan Ref No 4557-INVST24</a>","1500000","1500000","","7","1","2025-02-19","0000-00-00 00:00:00","cr-or24","0","0","0","LOANVALUE","19","02","2025","100","0","10","0","0");
INSERT INTO member_transactions VALUES("119","10","24","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=24&sub_module_id=116\">Loan ID 4557-INVST24</a>","189013.87798785834","189013.87798785834","","7","1","2025-02-19","0000-00-00 00:00:00","cr-intr-sale24","0","0","0","TTL-LN-INTR","19","02","2025","100","0","11","0","0");
INSERT INTO member_transactions VALUES("120","10","25","0","Disbursement Of Loan Type  Jazz Microfinance 
To Member VICENT KIGOSI GIGANTE <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=25&sub_module_id=116\">Loan Ref No 4557-INVST25</a>","1500000","1500000","","7","1","2025-02-19","0000-00-00 00:00:00","cr-or25","0","0","0","LOANVALUE","19","02","2025","100","0","10","0","0");
INSERT INTO member_transactions VALUES("121","10","25","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=25&sub_module_id=116\">Loan ID 4557-INVST25</a>","809010.4571266132","809010.4571266132","","7","1","2025-02-19","0000-00-00 00:00:00","cr-intr-sale25","0","0","0","TTL-LN-INTR","19","02","2025","100","0","11","0","0");
INSERT INTO member_transactions VALUES("122","15","26","0","Disbursement Of Loan Type  jazz loan 
To Member DANIEL  P URASSA <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=26&sub_module_id=116\">Loan Ref No 786-INVST26</a>","1500000","1500000","","7","1","2024-12-02","0000-00-00 00:00:00","cr-or26","0","0","0","LOANVALUE","02","12","2024","100","0","10","0","0");
INSERT INTO member_transactions VALUES("123","15","26","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=26&sub_module_id=116\">Loan ID 786-INVST26</a>","189013.87798785834","189013.87798785834","","7","1","2024-12-02","0000-00-00 00:00:00","cr-intr-sale26","0","0","0","TTL-LN-INTR","02","12","2024","100","0","11","0","0");
INSERT INTO member_transactions VALUES("124","30","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=23&sub_module_id=116\">loan ID 4557-INVST23</a>","52500","52500","","0","","2025-02-19","2025-02-20 08:34:05","intr23-2025-02-19","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("125","10","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=24&sub_module_id=116\">loan ID 4557-INVST24</a>","52500","52500","","0","","2025-02-19","2025-02-20 08:34:05","intr24-2025-02-19","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("126","10","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=25&sub_module_id=116\">loan ID 4557-INVST25</a>","52500","52500","","0","","2025-02-19","2025-02-20 08:34:05","intr25-2025-02-19","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("127","15","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=26&sub_module_id=116\">loan ID 786-INVST26</a>","52500","52500","","0","","2024-12-02","2025-02-20 08:34:05","intr26-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("128","15","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=26&sub_module_id=116\">loan ID 786-INVST26</a>","44484.919045071","44484.919045071","","0","","2025-01-02","2025-02-20 08:34:05","intr26-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("129","15","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=26&sub_module_id=116\">loan ID 786-INVST26</a>","36189.310256719","36189.310256719","","0","","2025-02-02","2025-02-20 08:34:05","intr26-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("130","5","27","0","Disbursement Of Loan Type  foesight loan 
To Member NOLLO TIMOTH TIMOTH <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=27&sub_module_id=116\">Loan Ref No 564324-INVST27</a>","1500000","1500000","","7","1","2024-10-01","0000-00-00 00:00:00","cr-or27","0","0","0","LOANVALUE","01","10","2024","100","0","10","0","0");
INSERT INTO member_transactions VALUES("131","5","27","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=27&sub_module_id=116\">Loan ID 564324-INVST27</a>","15349.663516782732","15349.663516782732","","7","1","2024-10-01","0000-00-00 00:00:00","cr-intr-sale27","0","0","0","TTL-LN-INTR","01","10","2024","100","0","11","0","0");
INSERT INTO member_transactions VALUES("132","29","28","0","Total Loan Value. <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=28&sub_module_id=116\">Loan ID 564324-LN28</a>","1515349.6635168","1515349.6635168","","7","1","2024-09-02","0000-00-00 00:00:00","lnis28","0","0","0","LOANVALUE","02","09","2024","100","0","6","0","0");
INSERT INTO member_transactions VALUES("133","29","28","0","Loan Principal. <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=28&sub_module_id=116\">Loan ID 564324-LN28</a>","1500000","1500000","","7","1","2024-09-02","0000-00-00 00:00:00","lnprnc28","0","0","0","LN-PRNC","02","09","2024","100","0","10","0","0");
INSERT INTO member_transactions VALUES("134","29","28","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=28&sub_module_id=116\">Loan ID 564324-LN28</a>","15349.66351678273","15349.66351678273","","7","1","2024-09-02","0000-00-00 00:00:00","ttlnintr28","0","0","0","TTL-LN-INTR","02","09","2024","100","0","11","0","0");
INSERT INTO member_transactions VALUES("135","22","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=2&sub_module_id=116\">loan ID DVLP-INVST02</a>","5949.8405404235","5949.8405404235","","0","","2025-02-28","2025-02-28 15:31:56","intr2-2025-02-28","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("136","27","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=3&sub_module_id=116\">loan ID DVLP-INVST03</a>","3975.3163605637","3975.3163605637","","0","","2025-02-28","2025-02-28 15:31:56","intr3-2025-02-28","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("137","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=4&sub_module_id=116\">loan ID DVLP-INVST04</a>","3586.7516035161","3586.7516035161","","0","","2025-02-28","2025-02-28 15:31:56","intr4-2025-02-28","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("138","31","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=5&sub_module_id=116\">loan ID DVLP-LN5</a>","904.19025847022","904.19025847022","","0","","2025-02-28","2025-02-28 15:31:56","intr5-2025-02-28","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("139","6","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=8&sub_module_id=116\">loan ID DVLP-INVST08</a>","194.84925509099","194.84925509099","","0","","2025-02-27","2025-02-28 15:31:56","intr8-2025-02-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("140","13","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=10&sub_module_id=116\">loan ID DVLP-INVST10</a>","5033.5708307713","5033.5708307713","","0","","2025-02-27","2025-02-28 15:31:56","intr10-2025-02-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("141","18","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=11&sub_module_id=116\">loan ID DVLP-INVST11</a>","194.84925509099","194.84925509099","","0","","2025-02-27","2025-02-28 15:31:56","intr11-2025-02-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("142","8","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=9&sub_module_id=116\">loan ID MWD-INVST09</a>","27.835656155557","27.835656155557","","0","","2025-02-27","2025-02-28 15:31:56","intr9-2025-02-27","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("143","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=27&sub_module_id=116\">loan ID 564324-INVST27</a>","4375","4375","","0","","2024-10-01","2025-02-28 15:31:56","intr27-2024-10-01","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("144","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=27&sub_module_id=116\">loan ID 564324-INVST27</a>","3651.1321080127","3651.1321080127","","0","","2024-11-01","2025-02-28 15:31:56","intr27-2024-11-01","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("145","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=27&sub_module_id=116\">loan ID 564324-INVST27</a>","2925.1529346737","2925.1529346737","","0","","2024-12-01","2025-02-28 15:31:56","intr27-2024-12-01","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("146","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=27&sub_module_id=116\">loan ID 564324-INVST27</a>","2197.0563220792","2197.0563220792","","0","","2025-01-01","2025-02-28 15:31:56","intr27-2025-01-01","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("147","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=27&sub_module_id=116\">loan ID 564324-INVST27</a>","1466.8360943646","1466.8360943646","","0","","2025-02-01","2025-02-28 15:31:56","intr27-2025-02-01","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("148","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=28&sub_module_id=116\">loan ID 564324-LN28</a>","1466.8360943646","1466.8360943646","","0","","2025-02-02","2025-02-28 15:31:56","intr28-2025-02-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("149","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=28&sub_module_id=116\">loan ID 564324-LN28</a>","2197.0563220792","2197.0563220792","","0","","2025-01-02","2025-02-28 15:31:56","intr28-2025-01-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("150","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=28&sub_module_id=116\">loan ID 564324-LN28</a>","2925.1529346737","2925.1529346737","","0","","2024-12-02","2025-02-28 15:31:56","intr28-2024-12-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("151","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=28&sub_module_id=116\">loan ID 564324-LN28</a>","4375","4375","","0","","2024-10-02","2025-02-28 15:31:56","intr28-2024-10-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("152","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=28&sub_module_id=116\">loan ID 564324-LN28</a>","3651.1321080127","3651.1321080127","","0","","2024-11-02","2025-02-28 15:31:56","intr28-2024-11-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("153","10","29","0","Total Loan Value. <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=29&sub_module_id=116\">Loan ID 564324-LN29</a>","1689013.8779879","1689013.8779879","","7","1","2024-03-01","0000-00-00 00:00:00","lnis29","0","0","0","LOANVALUE","01","03","2024","100","0","6","0","0");
INSERT INTO member_transactions VALUES("154","10","29","0","Loan Principal. <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=29&sub_module_id=116\">Loan ID 564324-LN29</a>","1500000","1500000","","7","1","2024-03-01","0000-00-00 00:00:00","lnprnc29","0","0","0","LN-PRNC","01","03","2024","100","0","10","0","0");
INSERT INTO member_transactions VALUES("155","10","29","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=29&sub_module_id=116\">Loan ID 564324-LN29</a>","189013.87798785832","189013.87798785832","","7","1","2024-03-01","0000-00-00 00:00:00","ttlnintr29","0","0","0","TTL-LN-INTR","01","03","2024","100","0","11","0","0");
INSERT INTO member_transactions VALUES("156","12","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=1&sub_module_id=116\">loan ID DVLP-INVST01</a>","146.13694131824","146.13694131824","","0","","2025-03-02","2025-03-03 14:23:04","intr1-2025-03-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("157","3","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=6&sub_module_id=116\">loan ID DVLP-INVST06</a>","25.062473842744","25.062473842744","","0","","2025-03-03","2025-03-03 14:23:04","intr6-2025-03-03","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("158","7","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=12&sub_module_id=116\">loan ID DVLP-INVST12</a>","10964.695364773","10964.695364773","","0","","2025-03-02","2025-03-03 14:23:04","intr12-2025-03-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("159","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=13&sub_module_id=116\">loan ID DVLP-INVST13</a>","6961.7403242056","6961.7403242056","","0","","2025-03-02","2025-03-03 14:23:04","intr13-2025-03-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("160","16","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=14&sub_module_id=116\">loan ID DVLP-INVST14</a>","417.70789737907","417.70789737907","","0","","2025-03-02","2025-03-03 14:23:04","intr14-2025-03-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("161","19","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=15&sub_module_id=116\">loan ID DVLP-INVST15</a>","2088.5394868953","2088.5394868953","","0","","2025-03-02","2025-03-03 14:23:04","intr15-2025-03-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("162","20","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=17&sub_module_id=116\">loan ID DVLP-INVST17</a>","835.41579475813","835.41579475813","","0","","2025-03-02","2025-03-03 14:23:04","intr17-2025-03-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("163","25","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=19&sub_module_id=116\">loan ID DVLP-INVST19</a>","3132.7961879767","3132.7961879767","","0","","2025-03-02","2025-03-03 14:23:04","intr19-2025-03-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("164","15","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=26&sub_module_id=116\">loan ID 786-INVST26</a>","27603.355160775","27603.355160775","","0","","2025-03-02","2025-03-03 14:23:04","intr26-2025-03-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("165","5","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=27&sub_module_id=116\">loan ID 564324-INVST27</a>","734.48605765253","734.48605765253","","0","","2025-03-01","2025-03-03 14:23:04","intr27-2025-03-01","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("166","29","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=28&sub_module_id=116\">loan ID 564324-LN28</a>","734.48605765253","734.48605765253","","0","","2025-03-02","2025-03-03 14:23:04","intr28-2025-03-02","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("167","10","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=29&sub_module_id=116\">loan ID 564324-LN29</a>","9519.4018888203","9519.4018888203","","0","","2024-08-31","2025-03-03 14:23:04","intr29-2024-08-31","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("168","10","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=29&sub_module_id=116\">loan ID 564324-LN29</a>","18716.891636473","18716.891636473","","0","","2024-07-31","2025-03-03 14:23:04","intr29-2024-07-31","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("169","10","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=29&sub_module_id=116\">loan ID 564324-LN29</a>","27603.355160775","27603.355160775","","0","","2024-06-30","2025-03-03 14:23:04","intr29-2024-06-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("170","10","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=29&sub_module_id=116\">loan ID 564324-LN29</a>","36189.310256719","36189.310256719","","0","","2024-05-31","2025-03-03 14:23:04","intr29-2024-05-31","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("171","10","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=29&sub_module_id=116\">loan ID 564324-LN29</a>","52500","52500","","0","","2024-03-31","2025-03-03 14:23:04","intr29-2024-03-31","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("172","10","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=29&sub_module_id=116\">loan ID 564324-LN29</a>","44484.919045071","44484.919045071","","0","","2024-04-30","2025-03-03 14:23:04","intr29-2024-04-30","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("173","1","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=7&sub_module_id=116\">loan ID DVLP-INVST07</a>","2088.5394868953","2088.5394868953","","0","","2025-03-06","2025-03-07 11:55:16","intr7-2025-03-06","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("174","33","31","0","Total Loan Value. <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=31&sub_module_id=116\">Loan ID TY6-LN31</a>","1689013.8779879","1689013.8779879","","7","1","2025-01-02","0000-00-00 00:00:00","lnis31","0","0","0","LOANVALUE","02","01","2025","100","0","6","0","0");
INSERT INTO member_transactions VALUES("175","33","31","0","Loan Principal. <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=31&sub_module_id=116\">Loan ID TY6-LN31</a>","1500000","1500000","","7","1","2025-01-02","0000-00-00 00:00:00","lnprnc31","0","0","0","LN-PRNC","02","01","2025","100","0","10","0","0");
INSERT INTO member_transactions VALUES("176","33","31","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=31&sub_module_id=116\">Loan ID TY6-LN31</a>","189013.87798785832","189013.87798785832","","7","1","2025-01-02","0000-00-00 00:00:00","ttlnintr31","0","0","0","TTL-LN-INTR","02","01","2025","100","0","11","0","0");
INSERT INTO member_transactions VALUES("177","33","31","0","Loan repayment for the loan . Loan Ref No. TY6-LN31 received from customer LAWIN LEWIN LIWIN","-281502.31","","281502.31","7","1","2025-03-09","2025-03-09 12:56:51","drlnrep19","0","0","0","LOAN-REP","09","03","2025","100","0","7","0","0");
INSERT INTO member_transactions VALUES("178","33","31","0","Principle repayment for the loan . Loan Ref No. TY6-LN31 whose due date was 2025-02-01 received from customer LAWIN LEWIN LIWIN","-229002.31","","229002.31","7","1","2025-03-09","2025-03-09 12:56:51","crprncrep9","0","0","0","PRNC-LOAN-REP","09","03","2025","100","0","9","0","0");
INSERT INTO member_transactions VALUES("179","33","31","0","Interest repayment for the loan . Loan Ref No. TY6-LN31 whose due date was 2025-02-01 received from customer LAWIN LEWIN LIWIN","-52500","","52500","7","1","2025-03-09","2025-03-09 12:56:51","crintrep9","0","0","0","INTR-LOAN-REP","09","03","2025","100","0","8","0","0");
INSERT INTO member_transactions VALUES("180","33","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=31&sub_module_id=116\">loan ID TY6-LN31</a>","44484.919045071","44484.919045071","","0","","2025-03-01","2025-03-09 16:34:26","intr31-2025-03-01","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("181","33","0","0","Due Interest On <a href=\"home.php?loan_schedule_details=loan_schedule_details
&loan_id=31&sub_module_id=116\">loan ID TY6-LN31</a>","52500","52500","","0","","2025-02-01","2025-03-09 16:34:26","intr31-2025-02-01","0","0","0","LN-INT","","","0000","100","0","0","0","0");
INSERT INTO member_transactions VALUES("182","18","32","0","Disbursement Of Loan Type  DEVELOPMENT LOANS 
To Member SABA NAEL KIBU <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=32&sub_module_id=116\">Loan Ref No DVLP-INVST32</a>","1000000","1000000","","7","1","2025-03-17","0000-00-00 00:00:00","cr-or32","0","0","0","LOANVALUE","17","03","2025","100","0","10","0","0");
INSERT INTO member_transactions VALUES("183","18","32","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=32&sub_module_id=116\">Loan ID DVLP-INVST32</a>","2918.69128528874","2918.69128528874","","7","1","2025-03-17","0000-00-00 00:00:00","cr-intr-sale32","0","0","0","TTL-LN-INTR","17","03","2025","100","0","11","0","0");
INSERT INTO member_transactions VALUES("184","1","33","0","Disbursement Of Loan Type  DEVELOPMENT LOANS 
To Member PROSPER JOSEPH SAKU <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=33&sub_module_id=116\">Loan Ref No DVLP-INVST33</a>","1000000","1000000","","7","1","2025-03-01","0000-00-00 00:00:00","cr-or33","0","0","0","LOANVALUE","01","03","2025","100","0","10","0","0");
INSERT INTO member_transactions VALUES("185","1","33","0","Total Interest On . <a href=\"home.php?loan_schedule_details=loan_schedule_details&loan_id=33&sub_module_id=116\">Loan ID DVLP-INVST33</a>","60000","60000","","7","1","2025-03-01","0000-00-00 00:00:00","cr-intr-sale33","0","0","0","TTL-LN-INTR","01","03","2025","100","0","11","0","0");



DROP TABLE members;

CREATE TABLE `members` (
  `member_id` int(11) NOT NULL AUTO_INCREMENT,
  `f_name` varchar(100) NOT NULL,
  `m_name` varchar(100) NOT NULL,
  `l_name` varchar(100) NOT NULL,
  `city` varchar(50) NOT NULL,
  `county` varchar(50) NOT NULL,
  `dob` date NOT NULL,
  `no_of_children` varchar(3) NOT NULL,
  `division` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `sub_location` varchar(100) NOT NULL,
  `address` varchar(100) NOT NULL,
  `employer` int(11) NOT NULL,
  `member_branch_id` int(11) NOT NULL,
  `department` varchar(200) NOT NULL,
  `employment_terms_id` int(11) NOT NULL,
  `payroll_no` varchar(15) NOT NULL,
  `member_no` varchar(100) NOT NULL,
  `member_fname` longtext NOT NULL,
  `member_pre_phone` varchar(50) NOT NULL,
  `member_phone` varchar(100) NOT NULL,
  `member_email` varchar(50) NOT NULL,
  `member_title` mediumtext NOT NULL,
  `national_id` varchar(20) NOT NULL,
  `date_enrolled` date NOT NULL,
  `monthly_contributions` varchar(100) NOT NULL,
  `m_date_recorded` date NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `gender` varchar(10) NOT NULL,
  `marital_status_id` int(10) NOT NULL,
  `kin_fname` varchar(100) NOT NULL,
  `kin_phone` varchar(100) NOT NULL,
  `kin_email` varchar(100) NOT NULL,
  `kin_relation` varchar(300) NOT NULL,
  `ref_fname` varchar(400) NOT NULL,
  `ref_phone` varchar(100) NOT NULL,
  `ref_relation` varchar(100) NOT NULL,
  `workmate_ref_fname` varchar(400) NOT NULL,
  `workmate_ref_phone` varchar(100) NOT NULL,
  `member_bank_id` int(11) NOT NULL,
  `member_bank_branch_id` int(11) NOT NULL,
  `bank_account_name` varchar(500) NOT NULL,
  `bank_account_no` varchar(100) NOT NULL,
  `business_type` varchar(250) NOT NULL,
  `business_location` varchar(250) NOT NULL,
  `cont_person_fname` varchar(200) NOT NULL,
  `cont_person_phone` varchar(100) NOT NULL,
  `cont_person_title` varchar(100) NOT NULL,
  `photo` longtext NOT NULL,
  `work` varchar(70) NOT NULL,
  `work_location` varchar(100) NOT NULL,
  `business_ward` varchar(50) NOT NULL,
  `business_city` varchar(50) NOT NULL,
  `garantor_fname` varchar(45) NOT NULL,
  `garantor_email` varchar(45) NOT NULL,
  `garantor_relation` varchar(50) NOT NULL,
  `garantor_phone` varchar(50) NOT NULL,
  `spouse_photo` longtext NOT NULL,
  `loan_officer` varchar(200) NOT NULL,
  PRIMARY KEY (`member_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=latin1;

INSERT INTO members VALUES("1","PROSPER","JOSEPH","SAKU","ARUSHA","","2000-07-02","","","ARUSHA","","ARUSHA","2","0","","0","","02026","PROSPER JOSEPH SAKU","764239920","255764239920","einothraphaely@gmail.com","","199050000000000023","0000-00-00","","2024-10-02","100","0","M","0","XAS","0764239920","einothraphaely@gmail.com","","","","","","","0","0","","","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("2","CHRISTINA ","ASAA","KIMARO ","ARUSHA","","2024-05-24","","TAARAFA/KATA","","","ARUSHA","2","1","","0","","02027","CHRISTINA  ASAA KIMARO ","764239920","255764239920","einothraphaely@gmail.com","","199050000000000056","0000-00-00","","2024-10-02","100","0","F","0","","","","","","","","","","19","0","","52356891111112","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("3","ALLY ","SALIM","MRUTU","ARUSHA","","2000-10-01","","SAME","SAME","","NJIRO, ARUSHA","0","0","","0","","02001","ALLY  SALIM MRUTU","766912782","255766912782","thi@gmail.com","","5344444444443544","0000-00-00","","2024-10-02","100","1","M","0","VICENT MASSAWE","0766912782","nollo@gmail.com","FATHER","","","","","","18","0","","015634568789","","","","","","","","","","            ","JOE DOE","JOE@GMAIL.COM","","435654748","","");
INSERT INTO members VALUES("4","JESCA","CHARLES","THOMAS","ARUSHA","","2023-06-05","","OLORIEN","NJIRO ROAD","","ARUSHA","2","1","","0","","02021","JESCA CHARLES THOMAS","683659779","255683659779","jescacharles@gmail.com","","2003000000233","0000-00-00","","2024-10-02","100","0","F","0","LIAM MICHAEL","07653231","jescacharles@com","MY CHILD","","","","DANIEL SIKUKUU","0755433356","18","0","","486020320023","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("5","NOLLO","TIMOTH","TIMOTH","","","2001-05-03","","","ARUSHA","","","2","1","","0","","02016","NOLLO TIMOTH TIMOTH","745859621","255745859621","admin@foresight.co.tz","","20010523254000023","0000-00-00","","2024-10-02","100","0","M","0","","","","","","","","","","13","0","","01J2154587563","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("6","DERICK","KIBU","DENIS","ARUSHA","","2000-10-01","","MOSHI","NJIRO, ARUSHA","","NJIRO, ARUSHA","2","1","","0","","02002","DERICK KIBU DENIS","766912782","255766912782","faraji@gmail.com","","767823689792379","0000-00-00","","2024-10-02","100","0","M","0","MASSAWE","0766912782","sjabani@gmail.com","FATHER","","","","","","17","0","","7654345677678","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("7","WILLARD","OSWALD","KISHARU","ARUSHA","","2004-08-09","","MOSHI","MOSHI","","ARUSHA","2","1","","0","","02011","WILLARD OSWALD KISHARU","625639058","255625639058","amcossystem@gmail.com","","2000111020000339","0000-00-00","","2024-10-02","100","0","M","0","TIMOTH NOLLO","0784448180","timothnollo@gmail.com","KAKA","TIMOTH NOLLO","0625639058","KAKA","TIMOTH NOLLO","0784448180","2","0","","519100160212","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("8","PIUS","KISAKA","TOBILAX","ARUSHA","","2000-10-01","","NJIRO","SAME","","NJIRO, ARUSHA","2","1","","0","","02003","PIUS KISAKA TOBILAX","766912782","255766912782","supersonye59@gmail.com","","89645345768789764","0000-00-00","","2024-10-02","100","0","M","0","VICENT MASSAWE","0766912782","nollo@gmail.com","FATHER","","","","","","17","0","","7654345677678","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("9","SIKUKUU","KIMARO ","URASSA","ARUSHA","","1990-05-05","","","ARUSHA","","ARUSHA","2","1","","0","","02006","SIKUKUU KIMARO  URASSA","764239920","255764239920","einothraphaely@gmail.com","","1990500000011110010","0000-00-00","","2024-10-02","100","0","M","0","XAS","0764239920","danielsiikkk@gmail.com","","XAS","0764239920","","XAS","0764239920","13","0","","5891111112","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("10","VICENT","KIGOSI","GIGANTE","ARUSHA","","2002-12-02","","","","","","2","1","","0","","02017","VICENT KIGOSI GIGANTE","742457167","255742457167","admin@foresight.co.tz","","2002236548125","0000-00-00","","2024-10-02","100","0","M","0","","","","","","","","","","14","0","","1458762541","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("11","PROSPER","P","MUSHI","ARUSHA","","1990-05-05","","TAARAFA/KATA","ARUSHA","","ARUSHA","2","0","","0","","02028","PROSPER P MUSHI","764239920","255764239920","einothraphaely@gmail.com","","199050012560000010","0000-00-00","","2024-10-02","100","0","M","0","XAS","0764239920","einothraphaely@gmail.com","","","","","","","0","0","","","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("12","CHRISTINE","ROBERT","MUSHI","ARUSHA","","2024-07-31","","OLORIEN","1232","","1232","2","1","","0","","02007","CHRISTINE ROBERT MUSHI","076288507","255076288507","WHGHJG@GMAIL.COM","","773294242394729347","0000-00-00","","2024-10-02","100","0","F","0","ERNEST SHEDRACK KILENGA","076288507","WHGHJG@GMAIL.COM","HUSBAND","NOELLA ERNEST MSUYA","076288507","FRIEND","ANNETE MERINYO","076288507","28","0","","4081000595686","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("13","ROAN","KIBU","MALIA","ARUSHA","","2000-10-01","","SAME","SAME","","NJIRO, ARUSHA","2","1","","0","","02004","ROAN KIBU MALIA","766912782","255766912782","admin@gmail.com","","767676454512125656","0000-00-00","","2024-10-02","100","0","M","0","VICENT MASSAWE","0766912782","nollo@gmail.com","FATHER","","","","","","10","0","","7654345677678","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("14","JOHN ","CHARLES","THOMAS","ARUSHA","","2023-06-05","","THEMI","NJIRO ROAD","","ARUSHA","2","1","","0","","02022","JOHN  CHARLES THOMAS","356789000","255356789000","john@foresight.co.tz","","19922012500000400","0000-00-00","","2024-10-02","100","0","M","0","LIAM MICHAEL","07653231","jescacharles@com","MY CHILD","","","","DANIEL SIKUKUU","0755433356","13","0","","48602032007","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("15","DANIEL ","P","URASSA","ARUSHA","","2000-07-02","","","","","ARUSHA","2","1","","0","","02029","DANIEL  P URASSA","764239920","255764239920","einothraphaely@gmail.com","","19905000456000023","0000-00-00","","2024-10-02","100","0","M","0","","","","","","","","","","0","0","","","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("16","GAUDANCE","LAURANCE","LICHACHI","ARUSHA","","2004-08-09","","MOSHI","ARUSHA","","ARUSHA","2","0","","0","","02012","GAUDANCE LAURANCE LICHACHI","625639058","255625639058","amcossystem@gmail.com","","1999221122888881112","0000-00-00","","2024-10-02","100","0","M","0","TIMOTH NOLLO","","timothnollo@gmail.com","","TIMOTH NOLLO","0784448180","KAKA","TIMOTH NOLLO","0784448180","7","0","","519100160822","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("17","ELIAS","NEYMAR","JUNIOR","ARUSHA","","2003-12-14","","","MAJENGO","","","2","1","","0","","02018","ELIAS NEYMAR JUNIOR","077454783","255077454783","admin@foresight.co.tz","","200325154786","0000-00-00","","2024-10-02","100","0","M","0","","","","","","","","","","13","0","","01J23548721","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("18","SABA","NAEL","KIBU","ARUSHA","","2000-10-01","","MOSHI","NJIRO, ARUSHA","","NJIRO, ARUSHA","2","1","","0","","02005","SABA NAEL KIBU","766912782","255766912782","supersonye59@gmail.com","","8765435678998765","0000-00-00","","2024-10-02","100","0","M","0","MASSAWE","0766912782","nollo@gmail.com","FATHER","","","","","","11","0","","015634568789","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("19","JOSEPH","M","KIMARO ","ARUSHA","","2024-05-24","","TAARAFA/KATA","ARUSHA","","ARUSHA","2","1","","0","","02030","JOSEPH M KIMARO ","764239920","255764239920","einothraphaely@gmail.com","","19905000124560010","0000-00-00","","2024-10-02","100","0","F","0","XAS","0764239920","einothraphaely@gmail.com","","XAS","0764239920","XXXX","","","18","0","","52356891111112","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("20","SHABANI","MALOGO","MANENO","ARUSHA","","2004-08-12","","MOSHI","ARUSHA","","ARUSHA","2","0","","0","","02013","SHABANI MALOGO MANENO","784448180","255784448180","afrinaturegemsandsafari@gmail.com","","199922112288888113","0000-00-00","","2024-10-02","100","0","M","0","TIMOTH NOLLO","0784448180","timothnollo@gmail.com","KAKA","AFRIGEMS SAFARI","0784448180","KAKA","TIMOTH NOLLO","0784448180","28","0","","51910016086","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("21","OMEGA","THOMSON","SEYONGWE","ARUSHA","","2004-08-09","","MOSHI","ARUSHA","","ARUSHA","1","0","","0","","02014","OMEGA THOMSON SEYONGWE","625639058","255625639058","amcossystem@gmail.com","","19992211228888811","0000-00-00","","2024-10-02","100","0","M","0","TIMOTH NOLLO","0784448180","timothnollo@gmail.com","KAKA","TIMOTH NOLLO","0784448180","KAKA","TIMOTH NOLLO","0784448180","28","0","","51910016086","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("22","JESCA","JONAS","MALLYA","ARUSHA","","2024-07-31","","OLORIEN","1232","","1232","2","1","","0","","02008","JESCA JONAS MALLYA","076288507","255076288507","WHGHJG@GMAIL.COM","","787888888898977","0000-00-00","","2024-10-02","100","0","F","0","ERNEST SHEDRACK KILENGA","076288507","WHGHJG@GMAIL.COM","HUSBAND","ANNETH MERINYO","076288507","FRIEND","ANNETE MERINYO","076288507","28","0","","4081000595686","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("23","KHALID","MAX","AUCHO","ARUSHA","","2004-05-05","","","KIJENGE","","","2","1","","0","","02019","KHALID MAX AUCHO","621066209","255621066209","admin@foresight.co.tz","","2004363529254158","0000-00-00","","2024-10-02","100","0","M","0","","","","","","","","","","17","0","","06723584175","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("24","DEBORAH","CHARLES","SHAYO","ARUSHA","","0000-00-00","","","NJIRO ROAD","","ARUSHA","2","1","","0","","02023","DEBORAH CHARLES SHAYO","685845634","255685845634","DEBORAH@foresight.co.tz","","19990998774456","0000-00-00","","2024-10-02","100","0","F","0","LIAM MICHAEL","07653231","jescacharles@com","MY CHILD","DANIEL SIKUKUU","0765423456","","DANIEL SIKUKUU","0755433356","31","0","","48602032600","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("25","VICENT ","MASAWE","MASAWE","ARUSHA","","2004-08-12","","MOSHI","ARUSHA","","ARUSHA","2","0","","0","","02015","VICENT  MASAWE MASAWE","784448180","255784448180","afrinaturegemsandsafari@gmail.com","","2345678234567","0000-00-00","","2024-10-02","100","0","M","0","TIMOTH NOLLO","0784448180","timothnollo@gmail.com","KAKA","TIMOTH NOLLO","0784448180","KAKA","TIMOTH NOLLO","0784448180","25","0","","519100160844","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("26","ANNETE ","CLOUTAS","DJUING","ARUSHA","","2005-06-30","","","OLORIENI","","","2","1","","0","","02020","ANNETE  CLOUTAS DJUING","783293710","255783293710","admin@foresight.co.tz","","2005252448987452","0000-00-00","","2024-10-02","100","0","F","0","","","","","","","","","","13","0","","15J326598741","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("27","NOELLA","ERNEST","MSUYA","ARUSHA","","2024-07-31","","OLORIEN","1232","","1232","2","1","","0","","02009","NOELLA ERNEST MSUYA","076288507","255076288507","WHGHJG@GMAIL.COM","","18900000000000000000","0000-00-00","","2024-10-02","100","0","F","0","ANNETE MERINYO","076288507","WHGHJG@GMAIL.COM","RELATIVE","ANNETE MERINYO","076288507","FRIEND","ANNETE MERINYO","076288507","28","0","","4081000595686","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("28","DIANA ROSE","CHARLES","SHAYO","ARUSHA","","2023-06-05","","THEMI","ARUSHA","","ARUSHA","2","1","","0","","02024","DIANA ROSE CHARLES SHAYO","064457876","255064457876","Stevenstephene@gmail.com","","2001122050000200","0000-00-00","","2024-10-02","100","0","F","0","LIAM MICHAEL","064457876","Stevenstephene@gmail.com","MY CHILD","DANIEL SIKUKUU","064457876","","","","10","0","","48602032007","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("29","NOREEN","ERNEST","MSUYA","ARUSHA","","2024-07-31","","OLORIEN","1232","","1232","2","1","","0","","02010","NOREEN ERNEST MSUYA","076288507","255076288507","WHGHJG@GMAIL.COM","","18900000000000000000","0000-00-00","","2024-10-02","100","0","F","0","ANNETE MERINYO","076288507","WHGHJG@GMAIL.COM","","ANNETE MERINYO","076288507","DAUGHTER","ANNETE MERINYO","076288507","28","0","","","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("30","EVANCE ","CHARLES","THOMAS","ARUSHA","","2023-06-05","","","ARUSHA","","ARUSHA","2","0","","0","","02025","EVANCE  CHARLES THOMAS","064457876","255064457876","Stevenstephene@gmail.com","","20011220500002076","0000-00-00","","2024-10-02","100","0","M","0","DANIEL SIKUKUU","064457876","Stevenstephene@gmail.com","","","","","DANIEL SIKUKUU","064457876","6","0","","486020320024","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("31","DAMAS","KIWELU","MAUA","ARUSHA","","2024-07-31","","OLORIEN","1232","","1232","2","1","","0","","02031","DAMAS KIWELU MAUA","076288507","255076288507","WHGHJG@GMAIL.COM","","18900000000000000000","0000-00-00","","2024-10-02","100","0","M","0","ANNETE MERINYO","076288507","WHGHJG@GMAIL.COM","RELATIVE","ANNETE MERINYO","076288507","FRIEND","ANNETE MERINYO","076288507","28","0","","4081000595686","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("32","HUMPHREY","BRUNO","MERINYO","ARUSHA","","2002-11-25","","","","","","2","1","","0","","bs012","HUMPHREY BRUNO MERINYO","062107730","255062107730","annete@foresight.co.tz","","876543098765","0000-00-00","","2024-11-25","100","0","M","0","","","","","","","","","","2","0","","07865432","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("33","LAWIN","LEWIN","LIWIN","ARUSHA","","2003-03-03","","JHG","MJU","","SAG","1","1","","0","","678","LAWIN LEWIN LIWIN","786543789","255786543789","leiw@gmail.com","","154328765468965","0000-00-00","","2025-03-09","100","0","M","0","LWEN","0786543456","lwen@gmail.com","UNCLE","LWN","0987675645","DADY","NONE","09875675757","13","0","","098765567898","","","","","","","","","","","","","","","","");
INSERT INTO members VALUES("34","LULU","LULU","LULU","","","0000-00-00","","","","","","2","0","","0","","78op","LULU LULU LULU","076545454","255076545454","","","465889365","0000-00-00","","2025-03-18","100","0","","0","","","","","","","","","","0","0","","","","","","","","","BESPOKE","BESPOKE SYSTEMS","","","","","","","","");
INSERT INTO members VALUES("35","NALIA","ALIA","MALIA","ARUSHA","","1998-03-18","","ARUSHA","ARUSHA","","ARUSHA","0","0","","0","","123","NALIA ALIA MALIA","123456789","255123456789","malia@gmail.com","","1234565544223545","0000-00-00","","2025-03-31","100","0","M","0","DFGFG","ghghc","jhjcjycgytj fj","JJGCGJCJCGJYUT","YTIIFYTUUUK","IFIYYUI","YUIFIUFYIF","","","32","0","","97867678585685","SOFTWARE","VIENNA","","","","6e69d4cAgatha projections.PNG","FIYUFIUIYU","IFIYUIFYU","","","FIYUIYUYUI","FIYUIUYIYU","","IFYUIFIFYU","","");
INSERT INTO members VALUES("36","COLLLINS ","MICHOMA","MOKAYA","NAIROBI","","0000-00-00","","","","","","0","0","","0","","24524","COLLLINS  MICHOMA MOKAYA","432675547","255432675547","","","4567556858","0000-00-00","","2025-04-06","100","0","M","0","","","","","","","","","","0","0","","","","","","","","","","","","","","","","","12ae3f8giraffe.webp","100");
INSERT INTO members VALUES("37","OZARK","STARSHIP","KINDLE","GHK,","","2025-04-06","","","","","","0","0","","0","","5678","OZARK STARSHIP KINDLE","54676997","25554676997","","","4236347346","0000-00-00","","2025-04-06","100","0","M","0","","","","","","","","","","34","0","","","","","","","","","","",""," ","","","","","8466f9aGlory Projections.PNG","");



DROP TABLE members_backup;

CREATE TABLE `members_backup` (
  `member_id` int(11) NOT NULL AUTO_INCREMENT,
  `f_name` varchar(100) NOT NULL,
  `m_name` varchar(100) NOT NULL,
  `l_name` varchar(100) NOT NULL,
  `city` varchar(50) NOT NULL,
  `county` varchar(50) NOT NULL,
  `dob` date NOT NULL,
  `district` varchar(100) NOT NULL,
  `division` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `sub_location` varchar(100) NOT NULL,
  `address` varchar(100) NOT NULL,
  `emerg_fname1` varchar(100) NOT NULL,
  `emerg_phone1` varchar(100) NOT NULL,
  `emerg_fname2` varchar(15) NOT NULL,
  `emerg_phone2` varchar(15) NOT NULL,
  `member_no` varchar(100) NOT NULL,
  `member_fname` longtext NOT NULL,
  `member_phone` varchar(10) NOT NULL,
  `member_email` varchar(50) NOT NULL,
  `member_physical_address` varchar(50) NOT NULL,
  `national_id` varchar(20) NOT NULL,
  `date_enrolled` date NOT NULL,
  `m_date_recorded` date NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `gender` varchar(10) NOT NULL,
  `savings_day` varchar(10) NOT NULL,
  `kin_fname` varchar(100) NOT NULL,
  `kin_phone` varchar(100) NOT NULL,
  `kin_email` varchar(100) NOT NULL,
  PRIMARY KEY (`member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE members_banks;

CREATE TABLE `members_banks` (
  `bank_id` int(10) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`bank_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;




DROP TABLE members_groups;

CREATE TABLE `members_groups` (
  `members_group_id` int(10) NOT NULL AUTO_INCREMENT,
  `members_group_name` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `members_group_desc` longtext COLLATE latin1_general_ci,
  PRIMARY KEY (`members_group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO members_groups VALUES("1","A to Z Company Limited","");
INSERT INTO members_groups VALUES("2","COMPTER RESOURCES LTD","NEWS");



DROP TABLE members_old;

CREATE TABLE `members_old` (
  `member_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_no` varchar(100) NOT NULL,
  `member_fname` longtext NOT NULL,
  `member_phone` varchar(10) NOT NULL,
  `member_email` varchar(50) NOT NULL,
  `member_physical_address` varchar(50) NOT NULL,
  `national_id` varchar(20) NOT NULL,
  `date_enrolled` date NOT NULL,
  `date_recorded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `gender` varchar(10) NOT NULL,
  `savings_day` varchar(10) NOT NULL,
  PRIMARY KEY (`member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE modules;

CREATE TABLE `modules` (
  `module_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(100) NOT NULL,
  `sort_order` int(10) NOT NULL,
  `link` longtext NOT NULL,
  `description` varchar(250) NOT NULL,
  `status` int(10) NOT NULL,
  `icon` mediumtext NOT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=latin1;

INSERT INTO modules VALUES("1","Home","1","home.php?dash_board=dash_board","Home","0","");
INSERT INTO modules VALUES("3","Customer Registration","3","home.php?viewconference=viewconference&sub_module_id=79","Members Management","0","settings.png");
INSERT INTO modules VALUES("4","Access","2","home.php?viewusergroupsm=viewusergroupsm&user_group_id=15&sub_module_id=39","Manage access levels","0","users_process.png");
INSERT INTO modules VALUES("13","Audit Trails","100","home.php?audittrails=audittrails&sub_module_id=86","","0","");
INSERT INTO modules VALUES("23","Reports","68","home.php?petty=petty","Petty Cash Requisition","0","");
INSERT INTO modules VALUES("25","Loans Setup","6","home.php?viewlocation=viewlocation&sub_module_id=112","Loans Setup","0","loan_icon.png");
INSERT INTO modules VALUES("26","Receipt/Payment Voucher","62","home.php?document=document","","0","");
INSERT INTO modules VALUES("28","Accounting","19","home.php?document=document","","0","");
INSERT INTO modules VALUES("29","System Settings","2","home.php?settings=settings","","0","");
INSERT INTO modules VALUES("31","Loan Applications","8","home.php?assignprojectsettlement=assignprojectsettlement&sub_module_id=112","","0","loan_application.png");
INSERT INTO modules VALUES("32","Loan Approval","9","home.php?addcompetency=addcompetency&sub_module_id=113","","0","approve_loan.png");
INSERT INTO modules VALUES("33","Loan Disbursement","10","home.php?addhouse=addhouse&sub_module_id=114","","0","loan_disbursement.png");
INSERT INTO modules VALUES("34","Loan Repayment","11","home.php?assignsubprojectlocation=assignsubprojectlocation&sub_module_id=105","","0","repay.png");
INSERT INTO modules VALUES("39","Approve Payments","66","home.php?document=document","","0","");
INSERT INTO modules VALUES("41","Banking","20","#","","0","");



DROP TABLE modules_submodules;

CREATE TABLE `modules_submodules` (
  `modules_submodules_id` int(10) NOT NULL AUTO_INCREMENT,
  `module_id` int(10) NOT NULL,
  `sub_module_id` int(10) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`modules_submodules_id`)
) ENGINE=MyISAM AUTO_INCREMENT=343 DEFAULT CHARSET=latin1;

INSERT INTO modules_submodules VALUES("232","3","134","0");
INSERT INTO modules_submodules VALUES("167","11","3","0");
INSERT INTO modules_submodules VALUES("16","3","2","0");
INSERT INTO modules_submodules VALUES("150","16","12","0");
INSERT INTO modules_submodules VALUES("7","4","7","0");
INSERT INTO modules_submodules VALUES("9","4","9","0");
INSERT INTO modules_submodules VALUES("10","4","10","0");
INSERT INTO modules_submodules VALUES("141","6","62","0");
INSERT INTO modules_submodules VALUES("38","7","21","0");
INSERT INTO modules_submodules VALUES("39","7","22","0");
INSERT INTO modules_submodules VALUES("59","7","34","0");
INSERT INTO modules_submodules VALUES("61","9","36","0");
INSERT INTO modules_submodules VALUES("47","9","33","0");
INSERT INTO modules_submodules VALUES("50","9","30","0");
INSERT INTO modules_submodules VALUES("51","9","31","0");
INSERT INTO modules_submodules VALUES("52","9","32","0");
INSERT INTO modules_submodules VALUES("64","9","38","0");
INSERT INTO modules_submodules VALUES("63","9","37","0");
INSERT INTO modules_submodules VALUES("65","9","26","0");
INSERT INTO modules_submodules VALUES("66","4","39","0");
INSERT INTO modules_submodules VALUES("151","16","49","0");
INSERT INTO modules_submodules VALUES("169","8","16","0");
INSERT INTO modules_submodules VALUES("140","3","73","0");
INSERT INTO modules_submodules VALUES("123","5","67","0");
INSERT INTO modules_submodules VALUES("129","6","34","0");
INSERT INTO modules_submodules VALUES("148","16","73","0");
INSERT INTO modules_submodules VALUES("147","16","5","0");
INSERT INTO modules_submodules VALUES("126","11","65","0");
INSERT INTO modules_submodules VALUES("121","4","45","0");
INSERT INTO modules_submodules VALUES("139","17","70","0");
INSERT INTO modules_submodules VALUES("136","17","72","0");
INSERT INTO modules_submodules VALUES("157","3","47","0");
INSERT INTO modules_submodules VALUES("158","3","76","0");
INSERT INTO modules_submodules VALUES("162","3","78","0");
INSERT INTO modules_submodules VALUES("248","31","112","0");
INSERT INTO modules_submodules VALUES("168","8","30","0");
INSERT INTO modules_submodules VALUES("165","3","81","0");
INSERT INTO modules_submodules VALUES("166","3","82","0");
INSERT INTO modules_submodules VALUES("170","20","67","0");
INSERT INTO modules_submodules VALUES("171","20","60","0");
INSERT INTO modules_submodules VALUES("172","20","25","0");
INSERT INTO modules_submodules VALUES("173","8","1","0");
INSERT INTO modules_submodules VALUES("174","3","74","0");
INSERT INTO modules_submodules VALUES("175","4","84","0");
INSERT INTO modules_submodules VALUES("176","6","85","0");
INSERT INTO modules_submodules VALUES("177","13","86","0");
INSERT INTO modules_submodules VALUES("179","4","8","0");
INSERT INTO modules_submodules VALUES("181","6","90","0");
INSERT INTO modules_submodules VALUES("182","6","91","0");
INSERT INTO modules_submodules VALUES("183","6","92","0");
INSERT INTO modules_submodules VALUES("184","1","93","0");
INSERT INTO modules_submodules VALUES("292","23","95","0");
INSERT INTO modules_submodules VALUES("187","24","96","0");
INSERT INTO modules_submodules VALUES("191","24","100","0");
INSERT INTO modules_submodules VALUES("258","35","147","0");
INSERT INTO modules_submodules VALUES("207","27","115","0");
INSERT INTO modules_submodules VALUES("278","34","160","0");
INSERT INTO modules_submodules VALUES("203","25","111","0");
INSERT INTO modules_submodules VALUES("201","26","109","0");
INSERT INTO modules_submodules VALUES("234","4","135","0");
INSERT INTO modules_submodules VALUES("211","6","108","0");
INSERT INTO modules_submodules VALUES("213","23","116","0");
INSERT INTO modules_submodules VALUES("228","28","131","0");
INSERT INTO modules_submodules VALUES("235","3","136","0");
INSERT INTO modules_submodules VALUES("216","28","119","0");
INSERT INTO modules_submodules VALUES("217","28","120","0");
INSERT INTO modules_submodules VALUES("218","28","121","0");
INSERT INTO modules_submodules VALUES("219","28","122","0");
INSERT INTO modules_submodules VALUES("220","23","123","0");
INSERT INTO modules_submodules VALUES("312","39","188","0");
INSERT INTO modules_submodules VALUES("223","23","126","0");
INSERT INTO modules_submodules VALUES("293","39","173","0");
INSERT INTO modules_submodules VALUES("257","35","146","0");
INSERT INTO modules_submodules VALUES("229","29","132","0");
INSERT INTO modules_submodules VALUES("231","23","134","0");
INSERT INTO modules_submodules VALUES("270","31","153","0");
INSERT INTO modules_submodules VALUES("255","3","79","0");
INSERT INTO modules_submodules VALUES("238","23","139","0");
INSERT INTO modules_submodules VALUES("239","23","140","0");
INSERT INTO modules_submodules VALUES("256","35","145","0");
INSERT INTO modules_submodules VALUES("266","23","150","0");
INSERT INTO modules_submodules VALUES("268","34","152","0");
INSERT INTO modules_submodules VALUES("325","26","196","0");
INSERT INTO modules_submodules VALUES("247","30","144","0");
INSERT INTO modules_submodules VALUES("249","31","137","0");
INSERT INTO modules_submodules VALUES("250","31","141","0");
INSERT INTO modules_submodules VALUES("251","32","113","0");
INSERT INTO modules_submodules VALUES("252","33","114","0");
INSERT INTO modules_submodules VALUES("259","23","148","0");
INSERT INTO modules_submodules VALUES("264","23","128","0");
INSERT INTO modules_submodules VALUES("265","36","149","0");
INSERT INTO modules_submodules VALUES("311","31","187","0");
INSERT INTO modules_submodules VALUES("272","23","155","0");
INSERT INTO modules_submodules VALUES("273","37","156","0");
INSERT INTO modules_submodules VALUES("275","36","157","0");
INSERT INTO modules_submodules VALUES("276","36","158","0");
INSERT INTO modules_submodules VALUES("277","36","159","0");
INSERT INTO modules_submodules VALUES("279","36","161","0");
INSERT INTO modules_submodules VALUES("280","33","162","0");
INSERT INTO modules_submodules VALUES("282","33","163","0");
INSERT INTO modules_submodules VALUES("283","4","164","0");
INSERT INTO modules_submodules VALUES("329","28","197","0");
INSERT INTO modules_submodules VALUES("285","33","166","0");
INSERT INTO modules_submodules VALUES("330","26","198","0");
INSERT INTO modules_submodules VALUES("288","31","169","0");
INSERT INTO modules_submodules VALUES("290","38","171","0");
INSERT INTO modules_submodules VALUES("291","38","172","0");
INSERT INTO modules_submodules VALUES("298","26","176","0");
INSERT INTO modules_submodules VALUES("299","37","174","0");
INSERT INTO modules_submodules VALUES("297","39","175","0");
INSERT INTO modules_submodules VALUES("300","40","177","0");
INSERT INTO modules_submodules VALUES("301","41","178","0");
INSERT INTO modules_submodules VALUES("302","41","179","0");
INSERT INTO modules_submodules VALUES("303","40","162","0");
INSERT INTO modules_submodules VALUES("304","31","180","0");
INSERT INTO modules_submodules VALUES("305","31","181","0");
INSERT INTO modules_submodules VALUES("306","32","182","0");
INSERT INTO modules_submodules VALUES("307","32","183","0");
INSERT INTO modules_submodules VALUES("308","32","184","0");
INSERT INTO modules_submodules VALUES("309","39","185","0");
INSERT INTO modules_submodules VALUES("310","23","186","0");
INSERT INTO modules_submodules VALUES("313","31","189","0");
INSERT INTO modules_submodules VALUES("314","32","190","0");
INSERT INTO modules_submodules VALUES("315","23","187","0");
INSERT INTO modules_submodules VALUES("316","33","191","0");
INSERT INTO modules_submodules VALUES("317","33","192","0");
INSERT INTO modules_submodules VALUES("318","23","193","0");
INSERT INTO modules_submodules VALUES("319","23","194","0");
INSERT INTO modules_submodules VALUES("320","34","195","0");
INSERT INTO modules_submodules VALUES("321","3","144","0");
INSERT INTO modules_submodules VALUES("322","32","177","0");
INSERT INTO modules_submodules VALUES("323","28","171","0");
INSERT INTO modules_submodules VALUES("324","28","172","0");
INSERT INTO modules_submodules VALUES("331","28","199","0");
INSERT INTO modules_submodules VALUES("332","34","200","0");
INSERT INTO modules_submodules VALUES("333","33","200","0");
INSERT INTO modules_submodules VALUES("334","28","201","0");
INSERT INTO modules_submodules VALUES("335","28","202","0");
INSERT INTO modules_submodules VALUES("336","41","203","0");
INSERT INTO modules_submodules VALUES("337","28","204","0");
INSERT INTO modules_submodules VALUES("338","28","205","0");
INSERT INTO modules_submodules VALUES("339","28","206","0");
INSERT INTO modules_submodules VALUES("340","28","207","0");
INSERT INTO modules_submodules VALUES("341","23","208","0");
INSERT INTO modules_submodules VALUES("342","3","209","0");



DROP TABLE mop;

CREATE TABLE `mop` (
  `mop_id` int(11) NOT NULL AUTO_INCREMENT,
  `mop_name` varchar(100) NOT NULL,
  PRIMARY KEY (`mop_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO mop VALUES("2","MPESA");
INSERT INTO mop VALUES("3","CHEQUE");
INSERT INTO mop VALUES("4","ELECTRONIC TRANSFER");
INSERT INTO mop VALUES("5","MPESA PORTAL");
INSERT INTO mop VALUES("6","CHECK-OFF");
INSERT INTO mop VALUES("7","CASH");
INSERT INTO mop VALUES("9","BANK CASH DEPOSIT");



DROP TABLE mop_old;

CREATE TABLE `mop_old` (
  `mop_id` int(11) NOT NULL AUTO_INCREMENT,
  `mop_name` varchar(100) NOT NULL,
  PRIMARY KEY (`mop_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE mpesa;

CREATE TABLE `mpesa` (
  `mpesa_id` int(11) NOT NULL AUTO_INCREMENT,
  `payee_name` varchar(200) NOT NULL,
  `payee_phone_no` varchar(30) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `transaction_number` varchar(250) NOT NULL,
  `datetime_paid` varchar(100) NOT NULL,
  `datetime_paid2` varchar(100) NOT NULL,
  `conversation_id` varchar(150) NOT NULL,
  `results_code` varchar(100) NOT NULL,
  `results_description` mediumtext NOT NULL,
  `utility_balance` varchar(100) NOT NULL,
  `capital_balance` varchar(100) NOT NULL,
  PRIMARY KEY (`mpesa_id`)
) ENGINE=MyISAM AUTO_INCREMENT=88 DEFAULT CHARSET=latin1;

INSERT INTO mpesa VALUES("1","254723411943 - JOSEPH MOGENI OSERO","","10","QAF7MPVCW5","15.01.2022 11:12:57","0000-00-00 00:00:00","AG_20220115_20501242bd37bf100bda","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"6347-10248228-1\",\"ConversationID\":\"AG_20220115_20501242bd37bf100bda\",\"TransactionID\":\"QAF7MPVCW5\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAF7MPVCW5\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.01.2022 11:12:57\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75749.32},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75749.32","0");
INSERT INTO mpesa VALUES("2","254723411943 - JOSEPH MOGENI OSERO","","10","QAF5MS6JPF","15.01.2022 11:51:30","0000-00-00 00:00:00","AG_20220115_203068afc9db8faad4c7","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"22846-19920200-1\",\"ConversationID\":\"AG_20220115_203068afc9db8faad4c7\",\"TransactionID\":\"QAF5MS6JPF\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAF5MS6JPF\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.01.2022 11:51:30\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75724.05},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75724.05","0");
INSERT INTO mpesa VALUES("3","254723411943 - JOSEPH MOGENI OSERO","","10","QAF7N1319F","15.01.2022 14:13:02","0000-00-00 00:00:00","AG_20220115_20304ae47c207f9860ed","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"119778-23025293-1\",\"ConversationID\":\"AG_20220115_20304ae47c207f9860ed\",\"TransactionID\":\"QAF7N1319F\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAF7N1319F\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.01.2022 14:13:02\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75648.24},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75648.24","0");
INSERT INTO mpesa VALUES("4","254723411943 - JOSEPH MOGENI OSERO","","10","QAF0N1P0AQ","15.01.2022 14:22:04","0000-00-00 00:00:00","AG_20220115_201030e514b18615bc4e","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"10469-20160483-1\",\"ConversationID\":\"AG_20220115_201030e514b18615bc4e\",\"TransactionID\":\"QAF0N1P0AQ\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAF0N1P0AQ\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.01.2022 14:22:04\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75622.97},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75622.97","0");
INSERT INTO mpesa VALUES("5","254723411943 - JOSEPH MOGENI OSERO","","10","QAF3N243ZB","15.01.2022 14:28:40","0000-00-00 00:00:00","AG_20220115_203002c8d663bef52bf6","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"10467-20177867-1\",\"ConversationID\":\"AG_20220115_203002c8d663bef52bf6\",\"TransactionID\":\"QAF3N243ZB\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAF3N243ZB\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.01.2022 14:28:40\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75597.70},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75597.7","0");
INSERT INTO mpesa VALUES("6","254723411943 - JOSEPH MOGENI OSERO","","10","QAF7N33DIR","15.01.2022 14:43:30","0000-00-00 00:00:00","AG_20220115_20403cd9163391fddae8","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"104304-8335941-1\",\"ConversationID\":\"AG_20220115_20403cd9163391fddae8\",\"TransactionID\":\"QAF7N33DIR\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAF7N33DIR\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.01.2022 14:43:30\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75521.89},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75521.89","0");
INSERT INTO mpesa VALUES("7","254723411943 - JOSEPH MOGENI OSERO","","10","QAF6N39PH4","15.01.2022 14:46:21","0000-00-00 00:00:00","AG_20220115_20506650da734c049fb9","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"104297-8343511-1\",\"ConversationID\":\"AG_20220115_20506650da734c049fb9\",\"TransactionID\":\"QAF6N39PH4\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAF6N39PH4\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.01.2022 14:46:21\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75446.08},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75446.08","0");
INSERT INTO mpesa VALUES("8","254723411943 - JOSEPH MOGENI OSERO","","10","QAF7N3CGW1","15.01.2022 14:47:31","0000-00-00 00:00:00","AG_20220115_20507f1a0b4f1b9790d6","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"10470-20227636-1\",\"ConversationID\":\"AG_20220115_20507f1a0b4f1b9790d6\",\"TransactionID\":\"QAF7N3CGW1\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAF7N3CGW1\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.01.2022 14:47:31\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75420.81},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75420.81","0");
INSERT INTO mpesa VALUES("9","254723411943 - JOSEPH MOGENI OSERO","","10","QAH0Q0S9UC","17.01.2022 11:22:23","0000-00-00 00:00:00","AG_20220117_20406a1a191d2b62b521","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"23186-14723220-1\",\"ConversationID\":\"AG_20220117_20406a1a191d2b62b521\",\"TransactionID\":\"QAH0Q0S9UC\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAH0Q0S9UC\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"17.01.2022 11:22:23\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75370.27},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75370.27","0");
INSERT INTO mpesa VALUES("10","254723411943 - JOSEPH MOGENI OSERO","","10","QAI5R9VOTP","18.01.2022 03:04:09","2022-01-18 03:04:09","AG_20220118_205013e07c95c7166a42","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"16834-12105330-1\",\"ConversationID\":\"AG_20220118_205013e07c95c7166a42\",\"TransactionID\":\"QAI5R9VOTP\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAI5R9VOTP\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"18.01.2022 03:04:09\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":75058.30},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","75058.3","0");
INSERT INTO mpesa VALUES("11","254703741928 - PHILIS MUTENYO WASIKHUYU","","4545","QAJ4TYQC4Y","19.01.2022 17:54:01","2022-01-19 17:54:01","AG_20220119_204033ec2bb425809d78","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"111285-32912644-1\",\"ConversationID\":\"AG_20220119_204033ec2bb425809d78\",\"TransactionID\":\"QAJ4TYQC4Y\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":4545.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAJ4TYQC4Y\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254703741928 - PHILIS MUTENYO WASIKHUYU\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"19.01.2022 17:54:01\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":110251.10},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","110251.1","0");
INSERT INTO mpesa VALUES("12","254703309196 - leonard simiyu wakhura","","4545","QAJ8TZM7RI","19.01.2022 18:05:11","2022-01-19 18:05:11","AG_20220119_20203dd953e98e56ca32","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"119778-33221705-1\",\"ConversationID\":\"AG_20220119_20203dd953e98e56ca32\",\"TransactionID\":\"QAJ8TZM7RI\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":4545.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAJ8TZM7RI\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254703309196 - leonard simiyu wakhura\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"19.01.2022 18:05:11\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":105683.70},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","105683.7","0");
INSERT INTO mpesa VALUES("13","254721165483 - JOSPHAT IMBALO ANAYA","","2709","QAJ5TZRCAH","19.01.2022 18:07:00","2022-01-19 18:07:00","AG_20220119_203051a7b5063b6e0033","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"119776-33227060-1\",\"ConversationID\":\"AG_20220119_203051a7b5063b6e0033\",\"TransactionID\":\"QAJ5TZRCAH\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":2709.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAJ5TZRCAH\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254721165483 - JOSPHAT IMBALO ANAYA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"19.01.2022 18:07:00\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":102952.30},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","102952.3","0");
INSERT INTO mpesa VALUES("14","254793000592 - lorine adhiambo ouma","","2709","QAJ7TZUYHH","19.01.2022 18:08:12","2022-01-19 18:08:12","AG_20220119_20502744a49e31c5aaa3","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"6356-20861705-1\",\"ConversationID\":\"AG_20220119_20502744a49e31c5aaa3\",\"TransactionID\":\"QAJ7TZUYHH\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":2709.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAJ7TZUYHH\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254793000592 - lorine adhiambo ouma\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"19.01.2022 18:08:12\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":100220.90},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","100220.9","0");
INSERT INTO mpesa VALUES("15","254719326695 - DEYDORCE KATANA KITSAO","","6365","QAJ7U09WP1","19.01.2022 18:13:12","2022-01-19 18:13:12","AG_20220119_2050251ada6170a11485","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"10482-30145364-1\",\"ConversationID\":\"AG_20220119_2050251ada6170a11485\",\"TransactionID\":\"QAJ7U09WP1\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":6365.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAJ7U09WP1\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254719326695 - DEYDORCE KATANA KITSAO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"19.01.2022 18:13:12\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":93833.50},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","93833.5","0");
INSERT INTO mpesa VALUES("16","254706684056 - ZAMZAM MIRUKA","","2709","QAJ7U0G3X5","19.01.2022 18:15:24","2022-01-19 18:15:24","AG_20220119_205005c8f4a5c8c547be","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"16838-16153665-1\",\"ConversationID\":\"AG_20220119_205005c8f4a5c8c547be\",\"TransactionID\":\"QAJ7U0G3X5\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":2709.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAJ7U0G3X5\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254706684056 - ZAMZAM MIRUKA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"19.01.2022 18:15:24\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":91102.10},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","91102.1","0");
INSERT INTO mpesa VALUES("17","254721619331 - WICKLYFE OTIENO ODONGO","","5445","QAJ0U0IY3K","19.01.2022 18:16:27","2022-01-19 18:16:27","AG_20220119_20103dce11b78b43a275","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"22863-30304319-1\",\"ConversationID\":\"AG_20220119_20103dce11b78b43a275\",\"TransactionID\":\"QAJ0U0IY3K\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":5445.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAJ0U0IY3K\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254721619331 - WICKLYFE OTIENO ODONGO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"19.01.2022 18:16:27\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":85634.70},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","85634.7","0");
INSERT INTO mpesa VALUES("18","254769897090 - collins mango okwiri","","2709","QAJ6U0LMU8","19.01.2022 18:17:12","2022-01-19 18:17:12","AG_20220119_203039dec6421656e65f","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"23194-20486978-1\",\"ConversationID\":\"AG_20220119_203039dec6421656e65f\",\"TransactionID\":\"QAJ6U0LMU8\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":2709.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAJ6U0LMU8\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254769897090 - collins mango okwiri\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"19.01.2022 18:17:12\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":82903.30},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","82903.3","0");
INSERT INTO mpesa VALUES("19","254703979224 - COLLINCE OKOTH OGINGA","","10023","QAK1VO7G7B","20.01.2022 18:05:31","2022-01-20 18:05:31","AG_20220120_20302f1c0df9b4fb0700","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"10473-32531871-1\",\"ConversationID\":\"AG_20220120_20302f1c0df9b4fb0700\",\"TransactionID\":\"QAK1VO7G7B\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10023.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAK1VO7G7B\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254703979224 - COLLINCE OKOTH OGINGA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"20.01.2022 18:05:31\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":72857.90},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","72857.9","0");
INSERT INTO mpesa VALUES("20","254729836614 - JOHN KIBUI","","26135","QAV6FHFVEE","31.01.2022 17:42:52","2022-01-31 17:42:52","AG_20220131_202074ce641456ff6831","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"31600-18068128-1\",\"ConversationID\":\"AG_20220131_202074ce641456ff6831\",\"TransactionID\":\"QAV6FHFVEE\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":26135.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QAV6FHFVEE\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254729836614 - JOHN KIBUI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"31.01.2022 17:42:52\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":178235.70},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","178235.7","0");
INSERT INTO mpesa VALUES("21","254722710688 - OGOLA DANIEL OWITI","","25655","QBA8XEY3TA","10.02.2022 13:19:38","2022-02-10 13:19:38","AG_20220210_20505e6576adf1f58168","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"9748-7349823-1\",\"ConversationID\":\"AG_20220210_20505e6576adf1f58168\",\"TransactionID\":\"QBA8XEY3TA\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":25655.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBA8XEY3TA\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254722710688 - OGOLA DANIEL OWITI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"10.02.2022 13:19:38\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":197408.23},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","197408.23","0");
INSERT INTO mpesa VALUES("22","254701574744 - Vincent onyango ondiek","","28045","QBC01VK6X4","12.02.2022 10:45:11","2022-02-12 10:45:11","AG_20220212_20505363dbec6e9cc73b","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"10424-12877279-1\",\"ConversationID\":\"AG_20220212_20505363dbec6e9cc73b\",\"TransactionID\":\"QBC01VK6X4\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":28045.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBC01VK6X4\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254701574744 - Vincent onyango ondiek\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"12.02.2022 10:45:11\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":110856.03},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","110856.03","0");
INSERT INTO mpesa VALUES("23","254703741928 - PHILIS MUTENYO WASIKHUYU","","47145","QBC01ZUQK8","12.02.2022 11:53:31","2022-02-12 11:53:31","AG_20220212_2050023c017a903f62f8","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"8487-12745085-1\",\"ConversationID\":\"AG_20220212_2050023c017a903f62f8\",\"TransactionID\":\"QBC01ZUQK8\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":47145.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBC01ZUQK8\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254703741928 - PHILIS MUTENYO WASIKHUYU\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"12.02.2022 11:53:31\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":63688.63},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","63688.63","0");
INSERT INTO mpesa VALUES("24","254728776647 - HARON KIMTAI KIRUI","","47145","QBC1203DV7","12.02.2022 11:57:06","2022-02-12 11:57:06","AG_20220212_20406cc643895bade98a","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"10158-12683449-1\",\"ConversationID\":\"AG_20220212_20406cc643895bade98a\",\"TransactionID\":\"QBC1203DV7\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":47145.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBC1203DV7\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254728776647 - HARON KIMTAI KIRUI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"12.02.2022 11:57:06\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":16521.23},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","16521.23","0");
INSERT INTO mpesa VALUES("25","254726988125 - COLLINS ONYANGO ADWAR","","56695","QBF17KJKDH","15.02.2022 13:37:24","2022-02-15 13:37:24","AG_20220215_205066b0bccadbeb9bd0","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"16403-21763633-1\",\"ConversationID\":\"AG_20220215_205066b0bccadbeb9bd0\",\"TransactionID\":\"QBF17KJKDH\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":56695.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBF17KJKDH\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254726988125 - COLLINS ONYANGO ADWAR\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.02.2022 13:37:24\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":150281.43},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","150281.43","0");
INSERT INTO mpesa VALUES("26","254725727158 - MICHAEL MBARU GICHOHI","","18298","QBF27KNVNS","15.02.2022 13:39:21","2022-02-15 13:39:21","AG_20220215_20202084ce10237330f1","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"16380-21768996-1\",\"ConversationID\":\"AG_20220215_20202084ce10237330f1\",\"TransactionID\":\"QBF27KNVNS\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":18298.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBF27KNVNS\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254725727158 - MICHAEL MBARU GICHOHI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.02.2022 13:39:21\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":131961.03},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","131961.03","0");
INSERT INTO mpesa VALUES("27","0796286083 - HENRY OCHIENG OLANGO","","6271","QBF97KQOL1","15.02.2022 13:40:30","2022-02-15 13:40:30","AG_20220215_20504929100ea32c4552","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"80782-21231729-1\",\"ConversationID\":\"AG_20220215_20504929100ea32c4552\",\"TransactionID\":\"QBF97KQOL1\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":6271.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBF97KQOL1\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0796286083 - HENRY OCHIENG OLANGO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.02.2022 13:40:30\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":125667.63},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","125667.63","0");
INSERT INTO mpesa VALUES("28","254721497089 - ERICK ATINGA","","4079","QBF37KV71R","15.02.2022 13:42:18","2022-02-15 13:42:18","AG_20220215_20101d69e0d8dc90835b","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"107641-21827521-1\",\"ConversationID\":\"AG_20220215_20101d69e0d8dc90835b\",\"TransactionID\":\"QBF37KV71R\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":4079.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBF37KV71R\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254721497089 - ERICK ATINGA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.02.2022 13:42:18\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":121566.23},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","121566.23","0");
INSERT INTO mpesa VALUES("29","254769897090 - collins mango okwiri","","2704","QBF47L5YES","15.02.2022 13:46:54","2022-02-15 13:46:54","AG_20220215_20506f3ca76b69363812","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"29920-21182491-1\",\"ConversationID\":\"AG_20220215_20506f3ca76b69363812\",\"TransactionID\":\"QBF47L5YES\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":2704.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBF47L5YES\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254769897090 - collins mango okwiri\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.02.2022 13:46:54\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":111084.43},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","111084.43","0");
INSERT INTO mpesa VALUES("30","254798237005 - DUNCAN BETT","","3619","QBF27LB774","15.02.2022 13:49:22","2022-02-15 13:49:22","AG_20220215_20206be56885dcdb8e1b","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"29941-21189109-1\",\"ConversationID\":\"AG_20220215_20206be56885dcdb8e1b\",\"TransactionID\":\"QBF27LB774\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":3619.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBF27LB774\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254798237005 - DUNCAN BETT\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.02.2022 13:49:22\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":107443.03},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","107443.03","0");
INSERT INTO mpesa VALUES("31","254721619331 - WICKLYFE OTIENO ODONGO","","5443","QBF17LDKN7","15.02.2022 13:50:19","2022-02-15 13:50:19","AG_20220215_20303693d2cc4343c30f","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"87018-21272959-1\",\"ConversationID\":\"AG_20220215_20303693d2cc4343c30f\",\"TransactionID\":\"QBF17LDKN7\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":5443.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBF17LDKN7\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254721619331 - WICKLYFE OTIENO ODONGO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.02.2022 13:50:19\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":101977.63},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","101977.63","0");
INSERT INTO mpesa VALUES("32","254713624279 - JOSEPH ONYANGO","","9021","QBG39OVCCZ","16.02.2022 16:26:17","2022-02-16 16:26:17","AG_20220216_202023d981fe125d0103","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"12873-24380084-1\",\"ConversationID\":\"AG_20220216_202023d981fe125d0103\",\"TransactionID\":\"QBG39OVCCZ\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":9021.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBG39OVCCZ\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254713624279 - JOSEPH ONYANGO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"16.02.2022 16:26:17\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":88226.83},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","88226.83","0");
INSERT INTO mpesa VALUES("33","254798321508 - Sarah Kariuki","","5443","QBG69P1W4U","16.02.2022 16:28:54","2022-02-16 16:28:54","AG_20220216_2020608289de43f9b1d1","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"16400-25035586-1\",\"ConversationID\":\"AG_20220216_2020608289de43f9b1d1\",\"TransactionID\":\"QBG69P1W4U\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":5443.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBG69P1W4U\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254798321508 - Sarah Kariuki\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"16.02.2022 16:28:54\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":82761.43},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","82761.43","0");
INSERT INTO mpesa VALUES("34","254728889859 - MERCY ACHIENG OKOTH","","6363","QBG79QI5G3","16.02.2022 16:50:21","2022-02-16 16:50:21","AG_20220216_20301761ee7fdb464a05","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"16404-25092157-1\",\"ConversationID\":\"AG_20220216_20301761ee7fdb464a05\",\"TransactionID\":\"QBG79QI5G3\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":6363.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBG79QI5G3\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254728889859 - MERCY ACHIENG OKOTH\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"16.02.2022 16:50:21\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":76376.03},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","76376.03","0");
INSERT INTO mpesa VALUES("35","254725375953 - LINDA SAGIDE","","15538","QBG79R7F0T","16.02.2022 17:00:21","2022-02-16 17:00:21","AG_20220216_205012174ea47aa32db2","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"12880-24469992-1\",\"ConversationID\":\"AG_20220216_205012174ea47aa32db2\",\"TransactionID\":\"QBG79R7F0T\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":15538.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBG79R7F0T\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254725375953 - LINDA SAGIDE\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"16.02.2022 17:00:21\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":60815.63},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","60815.63","0");
INSERT INTO mpesa VALUES("36","254703979224 - COLLINCE OKOTH OGINGA","","9113","QBH0BK4OYM","17.02.2022 16:36:35","2022-02-17 16:36:35","AG_20220217_20203f97b182fff3c9d3","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"12902-27141415-1\",\"ConversationID\":\"AG_20220217_20203f97b182fff3c9d3\",\"TransactionID\":\"QBH0BK4OYM\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":9113.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QBH0BK4OYM\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254703979224 - COLLINCE OKOTH OGINGA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"17.02.2022 16:36:35\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":51680.23},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","51680.23","0");
INSERT INTO mpesa VALUES("37","","","","QF353V6NG1","","1970-01-01 03:00:00","AG_20220603_20206abd5b99cc07773f","2001","{\"Result\":{\"ResultType\":0,\"ResultCode\":2001,\"ResultDesc\":\"The initiator information is invalid.\",\"OriginatorConversationID\":\"65091-32910596-1\",\"ConversationID\":\"AG_20220603_20206abd5b99cc07773f\",\"TransactionID\":\"QF353V6NG1\",\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","","");
INSERT INTO mpesa VALUES("38","254723411943 - JOSEPH MOGENI OSERO","","10","QF353VIGLV","03.06.2022 15:00:15","2022-06-03 15:00:15","AG_20220603_204031a4a94b46499dee","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"25899-28214075-1\",\"ConversationID\":\"AG_20220603_204031a4a94b46499dee\",\"TransactionID\":\"QF353VIGLV\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF353VIGLV\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723411943 - JOSEPH MOGENI OSERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"03.06.2022 15:00:15\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":68518.95},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","68518.95","0");
INSERT INTO mpesa VALUES("39","254720426724 - CARROLINE OTIENO","","10","QF313VYKHB","03.06.2022 15:06:21","2022-06-03 15:06:21","AG_20220603_202059a7711fede0d9e5","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"97168-44864573-1\",\"ConversationID\":\"AG_20220603_202059a7711fede0d9e5\",\"TransactionID\":\"QF313VYKHB\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF313VYKHB\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254720426724 - CARROLINE OTIENO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"03.06.2022 15:06:21\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":68493.68},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","68493.68","0");
INSERT INTO mpesa VALUES("40","254706722798 - NELSON MIGUNA","","19260","QF62A77QXY","06.06.2022 17:26:31","2022-06-06 17:26:31","AG_20220606_20503d934c2c5e764c78","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"82110-96838439-1\",\"ConversationID\":\"AG_20220606_20503d934c2c5e764c78\",\"TransactionID\":\"QF62A77QXY\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":19260.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF62A77QXY\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254706722798 - NELSON MIGUNA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"06.06.2022 17:26:31\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":37613.54},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","37613.54","0");
INSERT INTO mpesa VALUES("41","254701574744 - Vincent onyango ondiek","","5000","QF74CAPYQM","07.06.2022 17:55:10","2022-06-07 17:55:10","AG_20220607_2030525bf2b511c6addf","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"53782-103907873-1\",\"ConversationID\":\"AG_20220607_2030525bf2b511c6addf\",\"TransactionID\":\"QF74CAPYQM\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":5000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF74CAPYQM\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254701574744 - Vincent onyango ondiek\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"07.06.2022 17:55:10\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":223568.74},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","223568.74","0");
INSERT INTO mpesa VALUES("42","254798321508 - Sarah Kariuki","","6000","QF76CASXCG","07.06.2022 17:56:04","2022-06-07 17:56:04","AG_20220607_201070826ce449fa623e","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"50241-99293078-1\",\"ConversationID\":\"AG_20220607_201070826ce449fa623e\",\"TransactionID\":\"QF76CASXCG\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":6000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF76CASXCG\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254798321508 - Sarah Kariuki\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"07.06.2022 17:56:04\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":217546.34},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","217546.34","0");
INSERT INTO mpesa VALUES("43","254797275574 - PIUS ODHIAMBO","","5500","QF77CAXIRR","07.06.2022 17:57:17","2022-06-07 17:57:17","AG_20220607_20200f1134cfced94fc9","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"82109-99304959-1\",\"ConversationID\":\"AG_20220607_20200f1134cfced94fc9\",\"TransactionID\":\"QF77CAXIRR\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":5500.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF77CAXIRR\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254797275574 - PIUS ODHIAMBO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"07.06.2022 17:57:17\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":212023.94},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","212023.94","0");
INSERT INTO mpesa VALUES("44","254723924825 - DAVIS OCHIENG ODERO","","8000","QF79CB11T5","07.06.2022 17:58:27","2022-06-07 17:58:27","AG_20220607_20202f54981a1bf22f7b","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"57074-104044778-1\",\"ConversationID\":\"AG_20220607_20202f54981a1bf22f7b\",\"TransactionID\":\"QF79CB11T5\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":8000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF79CB11T5\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723924825 - DAVIS OCHIENG ODERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"07.06.2022 17:58:27\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":204001.54},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","204001.54","0");
INSERT INTO mpesa VALUES("45","254724432395 - PATIENCE NDIRANGU","","10000","QF74CB6JRE","07.06.2022 17:59:56","2022-06-07 17:59:56","AG_20220607_20102860a4bc2c403543","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"28830-6180897-1\",\"ConversationID\":\"AG_20220607_20102860a4bc2c403543\",\"TransactionID\":\"QF74CB6JRE\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF74CB6JRE\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254724432395 - PATIENCE NDIRANGU\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"07.06.2022 17:59:56\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":193979.14},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","193979.14","0");
INSERT INTO mpesa VALUES("46","254715936245 - Sylvia Lasoha","","3000","QF79CBFX7V","07.06.2022 18:02:44","2022-06-07 18:02:44","AG_20220607_205061ee6b4be2eca64d","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"86355-44887105-1\",\"ConversationID\":\"AG_20220607_205061ee6b4be2eca64d\",\"TransactionID\":\"QF79CBFX7V\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":3000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF79CBFX7V\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254715936245 - Sylvia Lasoha\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"07.06.2022 18:02:44\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":190956.74},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","190956.74","0");
INSERT INTO mpesa VALUES("47","254722710688 - OGOLA DANIEL OWITI","","30000","QF74CBN5T4","07.06.2022 18:04:45","2022-06-07 18:04:45","AG_20220607_20405e1a743f6a11a13f","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"50234-99315721-1\",\"ConversationID\":\"AG_20220607_20405e1a743f6a11a13f\",\"TransactionID\":\"QF74CBN5T4\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":30000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF74CBN5T4\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254722710688 - OGOLA DANIEL OWITI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"07.06.2022 18:04:45\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":160934.34},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","160934.34","0");
INSERT INTO mpesa VALUES("48","254728513038 - MILLICENT ATIENO OPIYO","","10000","QF95G9FDV1","09.06.2022 17:44:18","2022-06-09 17:44:18","AG_20220609_20300908e828cd1ebe29","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"11398-60431535-1\",\"ConversationID\":\"AG_20220609_20300908e828cd1ebe29\",\"TransactionID\":\"QF95G9FDV1\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF95G9FDV1\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254728513038 - MILLICENT ATIENO OPIYO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"09.06.2022 17:44:18\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":142889.54},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","142889.54","0");
INSERT INTO mpesa VALUES("49","254728776647 - HARON KIMTAI KIRUI","","6800","QF90G9I1JW","09.06.2022 17:45:06","2022-06-09 17:45:06","AG_20220609_20501c8c123e9f6679fe","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"41160-44960943-1\",\"ConversationID\":\"AG_20220609_20501c8c123e9f6679fe\",\"TransactionID\":\"QF90G9I1JW\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":6800.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF90G9I1JW\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254728776647 - HARON KIMTAI KIRUI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"09.06.2022 17:45:06\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":136067.14},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","136067.14","0");
INSERT INTO mpesa VALUES("50","0768240754 - Luciah Njoki Kariuki","","10000","QF92G9L1J6","09.06.2022 17:45:59","2022-06-09 17:45:59","AG_20220609_203037f499527be0edaf","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"19158-48760775-1\",\"ConversationID\":\"AG_20220609_203037f499527be0edaf\",\"TransactionID\":\"QF92G9L1J6\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QF92G9L1J6\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0768240754 - Luciah Njoki Kariuki\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"09.06.2022 17:45:59\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":126044.74},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","126044.74","0");
INSERT INTO mpesa VALUES("51","254790128731 - shalon oduor","","8000","QFA5I8CVGF","10.06.2022 17:14:50","2022-06-10 17:14:50","AG_20220610_2050122746b7e67bf2ba","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"82122-106353193-1\",\"ConversationID\":\"AG_20220610_2050122746b7e67bf2ba\",\"TransactionID\":\"QFA5I8CVGF\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":8000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFA5I8CVGF\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254790128731 - shalon oduor\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"10.06.2022 17:14:50\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":118022.34},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","118022.34","0");
INSERT INTO mpesa VALUES("52","254726965339 - PAUL OGAYE NYAGUTI","","15000","QFB3JIP9CZ","11.06.2022 10:49:33","2022-06-11 10:49:33","AG_20220611_201036c7a844731b6e3a","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"82119-108224478-1\",\"ConversationID\":\"AG_20220611_201036c7a844731b6e3a\",\"TransactionID\":\"QFB3JIP9CZ\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":15000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFB3JIP9CZ\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254726965339 - PAUL OGAYE NYAGUTI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"11.06.2022 10:49:33\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":102999.94},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","102999.94","0");
INSERT INTO mpesa VALUES("53","254795420828 - KEVIN SANYA","","4000","QFD9O555RN","13.06.2022 17:36:55","2022-06-13 17:36:55","AG_20220613_202064bd0cc04b8f86ad","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"19160-58794995-1\",\"ConversationID\":\"AG_20220613_202064bd0cc04b8f86ad\",\"TransactionID\":\"QFD9O555RN\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":4000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFD9O555RN\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254795420828 - KEVIN SANYA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"13.06.2022 17:36:55\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":98977.54},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","98977.54","0");
INSERT INTO mpesa VALUES("54","254726587084 - FRANCIS OUMA ODHIAMBO","","7000","QFD5O5FISF","13.06.2022 17:40:16","2022-06-13 17:40:16","AG_20220613_2010223da3a44ebda2c0","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"28850-21643567-1\",\"ConversationID\":\"AG_20220613_2010223da3a44ebda2c0\",\"TransactionID\":\"QFD5O5FISF\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":7000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFD5O5FISF\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254726587084 - FRANCIS OUMA ODHIAMBO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"13.06.2022 17:40:16\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":91955.14},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","91955.14","0");
INSERT INTO mpesa VALUES("55","254721783732 - DAVID ODUOR","","4800","QFD8O5JM62","13.06.2022 17:41:31","2022-06-13 17:41:31","AG_20220613_20507aca00159313ec0d","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"50240-113563396-1\",\"ConversationID\":\"AG_20220613_20507aca00159313ec0d\",\"TransactionID\":\"QFD8O5JM62\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":4800.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFD8O5JM62\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254721783732 - DAVID ODUOR\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"13.06.2022 17:41:31\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":87132.74},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","87132.74","0");
INSERT INTO mpesa VALUES("56","254792783513 - KIYAKA ODERA","","7000","QFE0Q8WTSW","14.06.2022 18:31:16","2022-06-14 18:31:16","AG_20220614_205065b5c6c7ca8182b5","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"41157-58000990-1\",\"ConversationID\":\"AG_20220614_205065b5c6c7ca8182b5\",\"TransactionID\":\"QFE0Q8WTSW\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":7000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFE0Q8WTSW\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254792783513 - KIYAKA ODERA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"14.06.2022 18:31:16\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":72087.94},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","72087.94","0");
INSERT INTO mpesa VALUES("57","0796286083 - HENRY OCHIENG OLANGO","","8000","QFE5Q8ZC63","14.06.2022 18:31:57","2022-06-14 18:31:57","AG_20220614_202078d9a7b2829a838a","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"82126-116074873-1\",\"ConversationID\":\"AG_20220614_202078d9a7b2829a838a\",\"TransactionID\":\"QFE5Q8ZC63\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":8000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFE5Q8ZC63\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0796286083 - HENRY OCHIENG OLANGO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"14.06.2022 18:31:57\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":64065.54},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","64065.54","0");
INSERT INTO mpesa VALUES("58","0740824838 - Stephen Omondi Otieno","","5000","QFE3Q93QNB","14.06.2022 18:33:13","2022-06-14 18:33:13","AG_20220614_20204262a2bdedb04f43","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"41155-58006760-1\",\"ConversationID\":\"AG_20220614_20204262a2bdedb04f43\",\"TransactionID\":\"QFE3Q93QNB\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":5000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFE3Q93QNB\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0740824838 - Stephen Omondi Otieno\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"14.06.2022 18:33:13\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":59043.14},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","59043.14","0");
INSERT INTO mpesa VALUES("59","254727721097 - Tonny Blaire","","29130","QFF3S4M801","15.06.2022 17:37:50","2022-06-15 17:37:50","AG_20220615_2050707d89d04cc6b8a1","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"82121-118585095-1\",\"ConversationID\":\"AG_20220615_2050707d89d04cc6b8a1\",\"TransactionID\":\"QFF3S4M801\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":29130.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFF3S4M801\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254727721097 - Tonny Blaire\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.06.2022 17:37:50\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":29890.74},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","29890.74","0");
INSERT INTO mpesa VALUES("60","254720281995 - OBONYO ODIWOUR STANLEY","","3000","QFF7S4OYR5","15.06.2022 17:38:39","2022-06-15 17:38:39","AG_20220615_20502d000ba29a6fc169","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"19152-64335799-1\",\"ConversationID\":\"AG_20220615_20502d000ba29a6fc169\",\"TransactionID\":\"QFF7S4OYR5\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":3000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFF7S4OYR5\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254720281995 - OBONYO ODIWOUR STANLEY\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.06.2022 17:38:39\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":26868.34},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","26868.34","0");
INSERT INTO mpesa VALUES("61","254706684056 - ZAMZAM MIRUKA","","3000","QFG6U3KTZE","16.06.2022 17:21:06","2022-06-16 17:21:06","AG_20220616_204071a614040d7e1636","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"21150-66559052-1\",\"ConversationID\":\"AG_20220616_204071a614040d7e1636\",\"TransactionID\":\"QFG6U3KTZE\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":3000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFG6U3KTZE\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254706684056 - ZAMZAM MIRUKA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"16.06.2022 17:21:06\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":23845.94},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","23845.94","0");
INSERT INTO mpesa VALUES("62","254769897090 - collins mango okwiri","","3000","QFG5U3NQIF","16.06.2022 17:22:09","2022-06-16 17:22:09","AG_20220616_2010712422511d2e6703","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"57071-126990200-1\",\"ConversationID\":\"AG_20220616_2010712422511d2e6703\",\"TransactionID\":\"QFG5U3NQIF\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":3000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFG5U3NQIF\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254769897090 - collins mango okwiri\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"16.06.2022 17:22:09\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":20823.54},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","20823.54","0");
INSERT INTO mpesa VALUES("63","254721497089 - ERICK ATINGA","","3000","QFG4U3PUEC","16.06.2022 17:22:56","2022-06-16 17:22:56","AG_20220616_2030691fa09ce4343e83","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"21150-66563853-1\",\"ConversationID\":\"AG_20220616_2030691fa09ce4343e83\",\"TransactionID\":\"QFG4U3PUEC\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":3000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFG4U3PUEC\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254721497089 - ERICK ATINGA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"16.06.2022 17:22:56\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":17801.14},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","17801.14","0");
INSERT INTO mpesa VALUES("64","0740040290 - BERYL ACHIENG OMONDI","","6000","QFI3XGI7C7","18.06.2022 11:51:04","2022-06-18 11:51:04","AG_20220618_205029960972ff2f448e","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"41159-68091782-1\",\"ConversationID\":\"AG_20220618_205029960972ff2f448e\",\"TransactionID\":\"QFI3XGI7C7\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":6000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFI3XGI7C7\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0740040290 - BERYL ACHIENG OMONDI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"18.06.2022 11:51:04\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":711.54},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","711.54","0");
INSERT INTO mpesa VALUES("65","254726403810 - KIMUTAI MOSONIK","","10000","QFM76ZLDJ3","22.06.2022 18:41:07","2022-06-22 18:41:07","AG_20220622_20307670f4161296b661","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"90653-6413885-1\",\"ConversationID\":\"AG_20220622_20307670f4161296b661\",\"TransactionID\":\"QFM76ZLDJ3\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFM76ZLDJ3\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254726403810 - KIMUTAI MOSONIK\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"22.06.2022 18:41:07\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":190689.14},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","190689.14","0");
INSERT INTO mpesa VALUES("66","254719657933 - SHEILA ACHIENG NYAKINDA","","11000","QFM26ZMN88","22.06.2022 18:41:31","2022-06-22 18:41:31","AG_20220622_205016ddaae6668d704c","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"41144-79660023-1\",\"ConversationID\":\"AG_20220622_205016ddaae6668d704c\",\"TransactionID\":\"QFM26ZMN88\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":11000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFM26ZMN88\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254719657933 - SHEILA ACHIENG NYAKINDA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"22.06.2022 18:41:31\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":179666.74},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","179666.74","0");
INSERT INTO mpesa VALUES("67","254722383756 - JANE TAKA MAGIO","","16008","QFN08FLOFM","23.06.2022 14:59:24","2022-06-23 14:59:24","AG_20220623_20504935b1887dd3f538","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"41159-81582211-1\",\"ConversationID\":\"AG_20220623_20504935b1887dd3f538\",\"TransactionID\":\"QFN08FLOFM\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":16008.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFN08FLOFM\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254722383756 - JANE TAKA MAGIO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"23.06.2022 14:59:24\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":163636.34},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","163636.34","0");
INSERT INTO mpesa VALUES("68","254792349873 - ZACCHAEUS MARTIN OKOTH NGOLO","","23075","QFP6C3F2A4","25.06.2022 12:38:03","2022-06-25 12:38:03","AG_20220625_2010573384c5b33650b3","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"97167-99281660-1\",\"ConversationID\":\"AG_20220625_2010573384c5b33650b3\",\"TransactionID\":\"QFP6C3F2A4\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":23075.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QFP6C3F2A4\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254792349873 - ZACCHAEUS MARTIN OKOTH NGOLO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"25.06.2022 12:38:03\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":140538.94},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","140538.94","0");
INSERT INTO mpesa VALUES("69","0740040290 - BERYL ACHIENG OMONDI","","26042","QG22Q2ZALI","02.07.2022 11:33:31","2022-07-02 11:33:31","AG_20220702_202048a1ab3f1604a094","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"4789-31208667-1\",\"ConversationID\":\"AG_20220702_202048a1ab3f1604a094\",\"TransactionID\":\"QG22Q2ZALI\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":26042.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QG22Q2ZALI\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0740040290 - BERYL ACHIENG OMONDI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"02.07.2022 11:33:31\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":32839.13},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","32839.13","0");
INSERT INTO mpesa VALUES("70","254726403810 - KIMUTAI MOSONIK","","15000","QGF3IV1WXD","15.07.2022 18:44:44","2022-07-15 18:44:44","AG_20220715_2010429abfc11ba6447f","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"111253-61498669-1\",\"ConversationID\":\"AG_20220715_2010429abfc11ba6447f\",\"TransactionID\":\"QGF3IV1WXD\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":15000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF3IV1WXD\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254726403810 - KIMUTAI MOSONIK\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:44:44\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":125749.53},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","125749.53","0");
INSERT INTO mpesa VALUES("71","0796286083 - HENRY OCHIENG OLANGO","","7500","QGF8IV68V4","15.07.2022 18:45:51","2022-07-15 18:45:51","AG_20220715_205046e7ecfd6f3854ba","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"36233-21391714-1\",\"ConversationID\":\"AG_20220715_205046e7ecfd6f3854ba\",\"TransactionID\":\"QGF8IV68V4\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":7500.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF8IV68V4\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0796286083 - HENRY OCHIENG OLANGO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:45:51\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":118227.13},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","118227.13","0");
INSERT INTO mpesa VALUES("72","254726988125 - COLLINS ONYANGO ADWAR","","6000","QGF8IVBMVU","15.07.2022 18:47:06","2022-07-15 18:47:06","AG_20220715_20403eb36d71de101835","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"29581-28382022-1\",\"ConversationID\":\"AG_20220715_20403eb36d71de101835\",\"TransactionID\":\"QGF8IVBMVU\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":6000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF8IVBMVU\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254726988125 - COLLINS ONYANGO ADWAR\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:47:06\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":112204.73},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","112204.73","0");
INSERT INTO mpesa VALUES("73","254726587084 - FRANCIS OUMA ODHIAMBO","","10000","QGF7IVFQ11","15.07.2022 18:48:03","2022-07-15 18:48:03","AG_20220715_20201c427103efd6e8fa","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"10726-16161923-1\",\"ConversationID\":\"AG_20220715_20201c427103efd6e8fa\",\"TransactionID\":\"QGF7IVFQ11\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF7IVFQ11\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254726587084 - FRANCIS OUMA ODHIAMBO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:48:03\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":102182.33},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","102182.33","0");
INSERT INTO mpesa VALUES("74","254795420828 - KEVIN SANYA","","5000","QGF5IVJL8D","15.07.2022 18:49:06","2022-07-15 18:49:06","AG_20220715_2050419e961777d32c76","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"61143-65561581-1\",\"ConversationID\":\"AG_20220715_2050419e961777d32c76\",\"TransactionID\":\"QGF5IVJL8D\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":5000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF5IVJL8D\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254795420828 - KEVIN SANYA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:49:06\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":97159.93},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","97159.93","0");
INSERT INTO mpesa VALUES("75","254723268777 - CAROLYNE OTHIENO","","7800","QGF3IVO7SZ","15.07.2022 18:50:14","2022-07-15 18:50:14","AG_20220715_20206a9842662246e49c","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"19972-15678248-1\",\"ConversationID\":\"AG_20220715_20206a9842662246e49c\",\"TransactionID\":\"QGF3IVO7SZ\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":7800.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF3IVO7SZ\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723268777 - CAROLYNE OTHIENO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:50:14\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":89337.53},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","89337.53","0");
INSERT INTO mpesa VALUES("76","254728513038 - MILLICENT ATIENO OPIYO","","10000","QGF2IVRD9Y","15.07.2022 18:51:01","2022-07-15 18:51:01","AG_20220715_20501ab24211b656a389","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"36216-21407219-1\",\"ConversationID\":\"AG_20220715_20501ab24211b656a389\",\"TransactionID\":\"QGF2IVRD9Y\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF2IVRD9Y\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254728513038 - MILLICENT ATIENO OPIYO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:51:01\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":79315.13},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","79315.13","0");
INSERT INTO mpesa VALUES("77","0799402166 - Samwel Otieno Oruath","","8000","QGF2IVUCR4","15.07.2022 18:51:50","2022-07-15 18:51:50","AG_20220715_2020314cda5fbe088eab","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"19980-15682834-1\",\"ConversationID\":\"AG_20220715_2020314cda5fbe088eab\",\"TransactionID\":\"QGF2IVUCR4\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":8000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF2IVUCR4\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0799402166 - Samwel Otieno Oruath\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:51:50\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":71292.73},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","71292.73","0");
INSERT INTO mpesa VALUES("78","0740824838 - Stephen Omondi Otieno","","4000","QGF8IVY4IS","15.07.2022 18:52:44","2022-07-15 18:52:44","AG_20220715_20400361930556b11f86","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"15281-16121080-1\",\"ConversationID\":\"AG_20220715_20400361930556b11f86\",\"TransactionID\":\"QGF8IVY4IS\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":4000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF8IVY4IS\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0740824838 - Stephen Omondi Otieno\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:52:44\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":67270.33},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","67270.33","0");
INSERT INTO mpesa VALUES("79","0740040290 - BERYL ACHIENG OMONDI","","11500","QGF1IW1DYD","15.07.2022 18:53:35","2022-07-15 18:53:35","AG_20220715_20107a7f207d82e25798","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"29567-28401657-1\",\"ConversationID\":\"AG_20220715_20107a7f207d82e25798\",\"TransactionID\":\"QGF1IW1DYD\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":11500.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF1IW1DYD\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"0740040290 - BERYL ACHIENG OMONDI\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:53:35\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":55747.93},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","55747.93","0");
INSERT INTO mpesa VALUES("80","254790128731 - shalon oduor","","5000","QGF9IW6CBZ","15.07.2022 18:54:38","2022-07-15 18:54:38","AG_20220715_2020024d93129dd3198a","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"43403-20292676-1\",\"ConversationID\":\"AG_20220715_2020024d93129dd3198a\",\"TransactionID\":\"QGF9IW6CBZ\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":5000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF9IW6CBZ\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254790128731 - shalon oduor\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:54:38\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":50725.53},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","50725.53","0");
INSERT INTO mpesa VALUES("81","254701574744 - Vincent onyango ondiek","","5000","QGF9IWADAB","15.07.2022 18:55:46","2022-07-15 18:55:46","AG_20220715_20401674f5a7a81bc988","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"9181-21234657-1\",\"ConversationID\":\"AG_20220715_20401674f5a7a81bc988\",\"TransactionID\":\"QGF9IWADAB\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":5000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF9IWADAB\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254701574744 - Vincent onyango ondiek\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:55:46\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":45703.13},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","45703.13","0");
INSERT INTO mpesa VALUES("82","254723924825 - DAVIS OCHIENG ODERO","","10000","QGF8IWDV9U","15.07.2022 18:56:28","2022-07-15 18:56:28","AG_20220715_2030332705f4bf322282","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"36251-21424178-1\",\"ConversationID\":\"AG_20220715_2030332705f4bf322282\",\"TransactionID\":\"QGF8IWDV9U\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF8IWDV9U\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254723924825 - DAVIS OCHIENG ODERO\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:56:28\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":35680.73},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","35680.73","0");
INSERT INTO mpesa VALUES("83","254721265452 - CHARLES ONDIEK","","6000","QGF2IWHLZO","15.07.2022 18:57:29","2022-07-15 18:57:29","AG_20220715_20303006b9635ef6032c","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"7766-18902429-1\",\"ConversationID\":\"AG_20220715_20303006b9635ef6032c\",\"TransactionID\":\"QGF2IWHLZO\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":6000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF2IWHLZO\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254721265452 - CHARLES ONDIEK\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:57:29\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":29658.33},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","29658.33","0");
INSERT INTO mpesa VALUES("84","254706722798 - NELSON MIGUNA","","10500","QGF1IWMGOJ","15.07.2022 18:58:32","2022-07-15 18:58:32","AG_20220715_2020462ac9e9d3f5439c","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"12417-16164734-1\",\"ConversationID\":\"AG_20220715_2020462ac9e9d3f5439c\",\"TransactionID\":\"QGF1IWMGOJ\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":10500.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF1IWMGOJ\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254706722798 - NELSON MIGUNA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:58:32\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":19135.93},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","19135.93","0");
INSERT INTO mpesa VALUES("85","254706684056 - ZAMZAM MIRUKA","","3000","QGF6IWOX18","15.07.2022 18:59:12","2022-07-15 18:59:12","AG_20220715_203046696e6c67d2e522","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"4612-17796671-1\",\"ConversationID\":\"AG_20220715_203046696e6c67d2e522\",\"TransactionID\":\"QGF6IWOX18\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":3000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF6IWOX18\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254706684056 - ZAMZAM MIRUKA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 18:59:12\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":16113.53},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","16113.53","0");
INSERT INTO mpesa VALUES("86","254769897090 - collins mango okwiri","","3000","QGF7IWSXP1","15.07.2022 19:00:04","2022-07-15 19:00:04","AG_20220715_201046343896560ff4da","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"29587-28421594-1\",\"ConversationID\":\"AG_20220715_201046343896560ff4da\",\"TransactionID\":\"QGF7IWSXP1\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":3000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF7IWSXP1\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254769897090 - collins mango okwiri\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 19:00:04\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":13091.13},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","13091.13","0");
INSERT INTO mpesa VALUES("87","254721497089 - ERICK ATINGA","","3000","QGF8IWVIOU","15.07.2022 19:00:48","2022-07-15 19:00:48","AG_20220715_20103ad5f8e1b136f249","0","{\"Result\":{\"ResultType\":0,\"ResultCode\":0,\"ResultDesc\":\"The service request is processed successfully.\",\"OriginatorConversationID\":\"9190-21250644-1\",\"ConversationID\":\"AG_20220715_20103ad5f8e1b136f249\",\"TransactionID\":\"QGF8IWVIOU\",\"ResultParameters\":{\"ResultParameter\":[{\"Key\":\"TransactionAmount\",\"Value\":3000.00},{\"Key\":\"TransactionReceipt\",\"Value\":\"QGF8IWVIOU\"},{\"Key\":\"ReceiverPartyPublicName\",\"Value\":\"254721497089 - ERICK ATINGA\"},{\"Key\":\"TransactionCompletedDateTime\",\"Value\":\"15.07.2022 19:00:48\"},{\"Key\":\"B2CUtilityAccountAvailableFunds\",\"Value\":10068.73},{\"Key\":\"B2CWorkingAccountAvailableFunds\",\"Value\":0.00},{\"Key\":\"B2CRecipientIsRegisteredCustomer\",\"Value\":\"Y\"},{\"Key\":\"B2CChargesPaidAccountAvailableFunds\",\"Value\":0.00}]},\"ReferenceData\":{\"ReferenceItem\":{\"Key\":\"QueueTimeoutURL\",\"Value\":\"http://internalapi.safaricom.co.ke/mpesa/b2cresults/v1/submit\"}}}}","10068.73","0");



DROP TABLE mpesa_balance;

CREATE TABLE `mpesa_balance` (
  `mpesa_balance_id` int(11) NOT NULL AUTO_INCREMENT,
  `working_balance` varchar(100) NOT NULL,
  `utility_balance` varchar(100) NOT NULL,
  `datetime_recorded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`mpesa_balance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO mpesa_balance VALUES("1","","","2022-08-31 17:02:06");



DROP TABLE mulembe;

CREATE TABLE `mulembe` (
  `contact_id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_name` varchar(100) NOT NULL,
  PRIMARY KEY (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE mulembe2;

CREATE TABLE `mulembe2` (
  `contact_id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_name` varchar(100) NOT NULL,
  `f_name` varchar(100) NOT NULL,
  PRIMARY KEY (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE multiple_loan_payments_code;

CREATE TABLE `multiple_loan_payments_code` (
  `multiple_loan_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `employer_id` int(11) NOT NULL,
  `rep_recorded_by` int(11) NOT NULL,
  `rep_amount_received` varchar(100) NOT NULL,
  `rep_description` longtext NOT NULL,
  `rep_receipt_no` varchar(100) NOT NULL,
  `rep_cheque_no` varchar(100) NOT NULL,
  `currency_code` varchar(100) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `rep_mop` varchar(11) NOT NULL,
  `recov_mode` varchar(1) NOT NULL,
  `rep_date_paid` date NOT NULL,
  `rep_date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rep_account_to_debit` int(11) NOT NULL,
  `our_bank_account_id` int(11) NOT NULL,
  PRIMARY KEY (`multiple_loan_payment_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE notice_board;

CREATE TABLE `notice_board` (
  `notice_id` int(10) NOT NULL AUTO_INCREMENT,
  `notice_title` varchar(200) NOT NULL,
  `notice_details` longtext NOT NULL,
  `user_id` int(11) NOT NULL,
  `u_group_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(11) NOT NULL,
  `date_posted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`notice_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE notice_uploads;

CREATE TABLE `notice_uploads` (
  `notice_upload_id` int(11) NOT NULL AUTO_INCREMENT,
  `notice_id` int(100) NOT NULL,
  `user_id` int(11) NOT NULL,
  `time_uploaded` datetime NOT NULL,
  `file_name` longtext NOT NULL,
  `file_type` varchar(1) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `status1` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`notice_upload_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE officer_commission;

CREATE TABLE `officer_commission` (
  `officer_commision_id` int(11) NOT NULL AUTO_INCREMENT,
  `officer_id` int(100) NOT NULL,
  `officer_comm_perc` varchar(11) NOT NULL,
  PRIMARY KEY (`officer_commision_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO officer_commission VALUES("9","137","0");



DROP TABLE our_banks;

CREATE TABLE `our_banks` (
  `bank_id` int(10) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `branch_name` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `account_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `account_number` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `swift_code` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `debit_account_id` int(11) NOT NULL,
  PRIMARY KEY (`bank_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO our_banks VALUES("3","NMB","CLOCK TOWER","Computer Resources Lmtd","1290963444","KCBLKENX","19");
INSERT INTO our_banks VALUES("19","CASH","CASH","-","-","-","17");
INSERT INTO our_banks VALUES("20","CRDB","CLOCK TOWER","456544","FORESIGHT","WQEQW","18");



DROP TABLE payment_days;

CREATE TABLE `payment_days` (
  `payment_day_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_phone` varchar(50) NOT NULL,
  `pay_day` varchar(50) NOT NULL,
  PRIMARY KEY (`payment_day_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE payment_points;

CREATE TABLE `payment_points` (
  `payment_points_id` int(10) NOT NULL AUTO_INCREMENT,
  `date_paid` date NOT NULL,
  `day_paid` varchar(10) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `description` longtext NOT NULL,
  `member_id` varchar(100) NOT NULL,
  `payment_id` int(11) NOT NULL,
  `amount_paid` varchar(10) NOT NULL,
  `points` varchar(100) NOT NULL,
  `points_awarded` varchar(11) NOT NULL,
  `points_deducted` varchar(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`payment_points_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE payment_types;

CREATE TABLE `payment_types` (
  `payment_type_id` int(10) NOT NULL AUTO_INCREMENT,
  `payment_type_name` varchar(100) NOT NULL,
  `payment_type_abbrev` varchar(100) NOT NULL,
  PRIMARY KEY (`payment_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE payments;

CREATE TABLE `payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(10) NOT NULL,
  `member_no` varchar(50) NOT NULL,
  `member_phone` varchar(50) NOT NULL,
  `payment_type` varchar(10) NOT NULL,
  `account` varchar(20) NOT NULL,
  `amount_paid` varchar(50) NOT NULL,
  `mop` varchar(10) NOT NULL,
  `date_paid` date NOT NULL,
  `day_paid` varchar(20) NOT NULL,
  `points` varchar(10) NOT NULL,
  `ref_no` varchar(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `approve_status` int(11) NOT NULL,
  `approved_by` int(1) NOT NULL DEFAULT '0',
  `date_approved` datetime NOT NULL,
  `status3` int(10) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE payments_backup;

CREATE TABLE `payments_backup` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(10) NOT NULL,
  `member_no` varchar(50) NOT NULL,
  `member_phone` varchar(50) NOT NULL,
  `payment_type` varchar(10) NOT NULL,
  `account` varchar(20) NOT NULL,
  `amount_paid` varchar(50) NOT NULL,
  `mop` varchar(10) NOT NULL,
  `date_paid` date NOT NULL,
  `day_paid` varchar(20) NOT NULL,
  `points` varchar(10) NOT NULL,
  `ref_no` varchar(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `approve_status` int(11) NOT NULL,
  `approved_by` int(1) NOT NULL DEFAULT '0',
  `date_approved` datetime NOT NULL,
  `status3` int(10) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE payments_backup2;

CREATE TABLE `payments_backup2` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(10) NOT NULL,
  `member_no` varchar(50) NOT NULL,
  `member_phone` varchar(50) NOT NULL,
  `payment_type` varchar(10) NOT NULL,
  `account` varchar(20) NOT NULL,
  `amount_paid` varchar(50) NOT NULL,
  `mop` varchar(10) NOT NULL,
  `date_paid` date NOT NULL,
  `day_paid` varchar(20) NOT NULL,
  `points` varchar(10) NOT NULL,
  `ref_no` varchar(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `approve_status` int(11) NOT NULL,
  `approved_by` int(1) NOT NULL DEFAULT '0',
  `date_approved` datetime NOT NULL,
  `status3` int(10) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE payments_backup3;

CREATE TABLE `payments_backup3` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(10) NOT NULL,
  `member_no` varchar(50) NOT NULL,
  `member_phone` varchar(50) NOT NULL,
  `payment_type` varchar(10) NOT NULL,
  `account` varchar(20) NOT NULL,
  `amount_paid` varchar(50) NOT NULL,
  `mop` varchar(10) NOT NULL,
  `date_paid` date NOT NULL,
  `day_paid` varchar(20) NOT NULL,
  `points` varchar(10) NOT NULL,
  `ref_no` varchar(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  `approve_status` int(11) NOT NULL,
  `approved_by` int(1) NOT NULL DEFAULT '0',
  `date_approved` datetime NOT NULL,
  `status3` int(10) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE payments_old;

CREATE TABLE `payments_old` (
  `payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `invoice_no` varchar(150) NOT NULL,
  `description` longtext NOT NULL,
  `payment_perc` varchar(50) NOT NULL,
  `work_done` varchar(50) NOT NULL,
  `client` varchar(50) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date_recorded` datetime NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE petty_cash_ledger;

CREATE TABLE `petty_cash_ledger` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `transactions` varchar(100) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `debit` varchar(100) NOT NULL,
  `credit` varchar(100) NOT NULL,
  `transaction_date` date NOT NULL,
  `order_code` varchar(100) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE phone_call;

CREATE TABLE `phone_call` (
  `call_id` int(11) NOT NULL AUTO_INCREMENT,
  `call_type` int(1) NOT NULL,
  `received_date` date NOT NULL,
  `conversation_type` varchar(100) NOT NULL,
  `source` varchar(100) NOT NULL,
  `comments` longtext NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `date_recorded` datetime NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(11) NOT NULL,
  PRIMARY KEY (`call_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE pre_main_account_category;

CREATE TABLE `pre_main_account_category` (
  `pre_main_account_cat_id` int(10) NOT NULL AUTO_INCREMENT,
  `account_cat_id` int(11) NOT NULL,
  `pre_main_account_cat_code` varchar(100) NOT NULL,
  `pre_main_account_cat_name` varchar(100) NOT NULL,
  `pre_main_account_cat_bal_type` varchar(2) NOT NULL,
  PRIMARY KEY (`pre_main_account_cat_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO pre_main_account_category VALUES("1","2","101000","Current Assets","D");
INSERT INTO pre_main_account_category VALUES("3","3","103000","Long Term Liabilities","C");
INSERT INTO pre_main_account_category VALUES("4","4","105000","Share Capital and Reserves","C");
INSERT INTO pre_main_account_category VALUES("5","7","201000","Income","C");
INSERT INTO pre_main_account_category VALUES("6","6","301000
","Expenses","D");
INSERT INTO pre_main_account_category VALUES("8","2","101500","Advances and Loans To Customers","D");
INSERT INTO pre_main_account_category VALUES("10","1","102000","Fixed Assets","D");
INSERT INTO pre_main_account_category VALUES("11","3","104000","Short Term Liabilities","C");



DROP TABLE premiums;

CREATE TABLE `premiums` (
  `exp_cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_category_name` varchar(100) NOT NULL,
  `expense_category_desc` varchar(200) NOT NULL,
  PRIMARY KEY (`exp_cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE receipt_code;

CREATE TABLE `receipt_code` (
  `receipt_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `payee` int(200) NOT NULL,
  `sup_invoice_description` longtext NOT NULL,
  `sup_invoice_currency` int(11) NOT NULL,
  `sup_invoice_curr_rate` int(11) NOT NULL,
  `sup_invoice_receipt_no` varchar(100) NOT NULL,
  `sup_invoice_voucher_no` varchar(100) NOT NULL,
  `sup_invoice_vat` varchar(11) NOT NULL,
  `sup_invoice_date` date NOT NULL,
  `sup_invoice_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sup_invoice_status` int(11) NOT NULL,
  `sup_invoice_recorded_by` int(11) NOT NULL,
  `sup_invoice_account_to_debit` int(11) NOT NULL,
  `sup_invoice_bank_id` int(11) NOT NULL,
  `sup_invoice_amount_credited` varchar(100) NOT NULL,
  `journal_type` varchar(2) NOT NULL,
  `financial_year_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `cust_mop_id` int(11) NOT NULL,
  `sup_inv_submited_status` int(11) NOT NULL,
  `sup_transaction_section` varchar(5) NOT NULL,
  PRIMARY KEY (`receipt_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

INSERT INTO receipt_code VALUES("1","14","mawekezo","7","1","2312","RCT0001","3","2024-09-30","0000-00-00 00:00:00","0","100","18","20","205000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("2","3","MAPATO","7","1","122334","RCT0002","3","2024-09-30","0000-00-00 00:00:00","0","100","19","3","158657","","1","5","0","1","");
INSERT INTO receipt_code VALUES("3","5","MAPATO","7","1","213","RCT0003","3","2024-09-30","0000-00-00 00:00:00","0","100","17","19","105000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("4","6","MAPATO","7","1","457689","RCT0004","3","2024-09-30","0000-00-00 00:00:00","0","100","17","19","205000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("5","4","mawekezo","7","1","2111","RCT0005","3","2024-09-30","0000-00-00 00:00:00","0","100","17","19","125000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("6","10","MAPATO","7","1","132","RCT0006","3","2024-09-30","0000-00-00 00:00:00","0","100","18","20","55000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("7","8","MAPATO","7","1","2345768","RCT0007","3","2024-09-30","0000-00-00 00:00:00","0","100","0","20","","","1","5","0","0","");
INSERT INTO receipt_code VALUES("8","8","MAPATO","7","1","2345768","RCT0008","3","2024-09-30","0000-00-00 00:00:00","0","100","18","20","35000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("9","23","MAPATO","7","1","987","RCT0009","3","2024-09-30","0000-00-00 00:00:00","0","100","18","20","55000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("10","24","mawekezo","7","1","45643","RCT0010","3","2024-09-30","0000-00-00 00:00:00","0","100","19","3","135000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("11","13","MAPATO","7","1","56445","RCT0011","3","2024-09-30","0000-00-00 00:00:00","0","100","19","3","55000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("12","26","MAPATO","7","1","654","RCT0012","3","2024-09-30","0000-00-00 00:00:00","0","100","17","19","205000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("13","18","MAPATO","7","1","56445","RCT0013","3","2024-09-30","0000-00-00 00:00:00","0","100","19","3","35000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("14","7","MAPATO","7","1","344","RCT0014","3","2024-09-30","0000-00-00 00:00:00","0","100","17","19","105000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("15","28","mawekezo","7","1","3456","RCT0015","3","2024-09-30","0000-00-00 00:00:00","0","100","18","20","105000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("16","16","MAPATO","7","1","349","RCT0016","3","2024-09-30","0000-00-00 00:00:00","0","100","17","19","205000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("18","30","mawekezo","7","1","1234","RCT0018","3","2024-09-30","0000-00-00 00:00:00","0","100","19","3","140000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("22","21","MAPATO","7","1","399","RCT0022","3","2024-09-30","0000-00-00 00:00:00","0","100","19","3","105000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("21","21","MAPATO","7","1","399","RCT0021","3","2024-09-30","0000-00-00 00:00:00","0","100","0","3","","","1","5","0","0","");
INSERT INTO receipt_code VALUES("20","20","MAPATO","7","1","366","RCT0020","3","2024-09-30","0000-00-00 00:00:00","0","100","17","19","105000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("23","25","MAPATO","7","1","346","RCT0023","3","2024-09-30","0000-00-00 00:00:00","0","100","0","3","","","1","5","0","0","");
INSERT INTO receipt_code VALUES("24","25","MAPATO","7","1","346","RCT0024","3","2024-09-30","0000-00-00 00:00:00","0","100","19","3","55000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("25","12","deposit","7","1","1566","RCT0025","3","2024-10-03","0000-00-00 00:00:00","0","100","0","3","","","1","5","0","0","");
INSERT INTO receipt_code VALUES("26","12","AKIBA","7","1","56892","RCT0026","3","2024-10-03","0000-00-00 00:00:00","0","100","0","20","","","1","5","0","0","");
INSERT INTO receipt_code VALUES("27","15","AKIBA","7","1","1566","RCT0027","3","2024-10-03","0000-00-00 00:00:00","0","100","19","3","252000","","1","5","0","1","");
INSERT INTO receipt_code VALUES("28","26","ggggggggggggg","7","1","000546","RCT0028","3","2024-10-08","0000-00-00 00:00:00","0","100","17","19","4500000","","1","5","0","1","P");
INSERT INTO receipt_code VALUES("29","3","ggggggggggggg","7","1","000546","RCT0029","3","2024-10-08","0000-00-00 00:00:00","0","100","17","19","560000","","1","5","0","1","R");
INSERT INTO receipt_code VALUES("30","3","food","7","1","00546","RCT0030","3","2024-10-08","0000-00-00 00:00:00","0","100","17","19","200000","","1","5","0","1","P");
INSERT INTO receipt_code VALUES("31","26","h","7","1","9","RCT0031","3","2024-11-16","0000-00-00 00:00:00","0","100","18","20","670000","","1","5","0","1","R");
INSERT INTO receipt_code VALUES("32","26","mm","7","1","nnn","RCT0032","3","2024-11-18","0000-00-00 00:00:00","0","100","18","20","150000","","1","5","0","1","R");
INSERT INTO receipt_code VALUES("35","26","DEPOSIT","7","1","LJKL","RCT0035","3","2024-12-31","0000-00-00 00:00:00","0","100","19","3","700000","","1","5","0","1","R");



DROP TABLE receipt_code_olddd;

CREATE TABLE `receipt_code_olddd` (
  `receipt_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `received_from` varchar(300) NOT NULL,
  `cust_receipt_description` varchar(100) NOT NULL,
  `cust_receipt_currency` int(11) NOT NULL,
  `cust_receipt_curr_rate` int(11) NOT NULL,
  `cust_receipt_no` varchar(100) NOT NULL,
  `cust_mop_id` int(11) NOT NULL,
  `cust_receipt_voucher_no` varchar(100) NOT NULL,
  `cust_receipt_date` date NOT NULL,
  `cust_receipt_datetime` datetime NOT NULL,
  `cust_receipt_status` int(11) NOT NULL,
  `cust_receipt_recorded_by` int(11) NOT NULL,
  `cust_receipt_bank_id` int(11) NOT NULL,
  `cust_receipt_account_to_debit` int(11) NOT NULL,
  `cust_receipt_amount_debited` varchar(100) NOT NULL,
  `journal_type` varchar(2) NOT NULL,
  PRIMARY KEY (`receipt_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO receipt_code_olddd VALUES("1","","Amount received for shares","7","1","0097","9","RCT00001","2024-05-20","0000-00-00 00:00:00","0","100","3","3","400000","");
INSERT INTO receipt_code_olddd VALUES("2","","fdfd","7","1","0999","9","RCT00002","2024-05-07","0000-00-00 00:00:00","0","91","3","3","4000000","");



DROP TABLE receipt_wromg;

CREATE TABLE `receipt_wromg` (
  `receipt_id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_receipt_vat_account` int(11) NOT NULL,
  `customer_receipt_vat_value` varchar(100) NOT NULL,
  `customer_receipt_vat` varchar(100) NOT NULL,
  `customer_receipt_code_id` int(11) NOT NULL,
  `customer_receipt_amount_received` varchar(100) NOT NULL,
  `customer_receipt_account_to_credit` int(11) NOT NULL,
  PRIMARY KEY (`receipt_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO receipt_wromg VALUES("1","0","0","3","1","400000","199");
INSERT INTO receipt_wromg VALUES("2","0","0","3","2","4000000","56");



DROP TABLE receipts;

CREATE TABLE `receipts` (
  `supplier_invoice_id` int(10) NOT NULL AUTO_INCREMENT,
  `supplier_invoice_vat_account` int(11) NOT NULL,
  `supplier_invoice_vat_value` varchar(100) NOT NULL,
  `supplier_invoice_vat` varchar(100) NOT NULL,
  `receipt_code_id` int(11) NOT NULL,
  `real_price` varchar(100) NOT NULL,
  `quantity` varchar(10) NOT NULL,
  `sup_desc` varchar(400) NOT NULL,
  `supplier_invoice_amount_received` varchar(100) NOT NULL,
  `supplier_invoice_account_to_credit` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `department_code` varchar(100) NOT NULL,
  `transaction_type_id` int(11) NOT NULL,
  PRIMARY KEY (`supplier_invoice_id`)
) ENGINE=MyISAM AUTO_INCREMENT=80 DEFAULT CHARSET=latin1;

INSERT INTO receipts VALUES("1","0","","3","2","118657","1","Kuweka Akiba","118657","7","0","","2");
INSERT INTO receipts VALUES("2","0","","3","1","165000","1","kuweka akiba","165000","7","0","","2");
INSERT INTO receipts VALUES("3","0","","3","2","20000","1","Kuweka Hisa","20000","6","0","","1");
INSERT INTO receipts VALUES("4","0","","3","1","20000","1","kuweka hisa","20000","6","0","","1");
INSERT INTO receipts VALUES("5","0","","3","2","20000","1","Kuweka amana","20000","8","0","","3");
INSERT INTO receipts VALUES("6","0","","3","3","65000","1","AKIBA","65000","7","0","","2");
INSERT INTO receipts VALUES("7","0","","3","1","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("8","0","","3","3","20000","1","Hisa","20000","6","0","","1");
INSERT INTO receipts VALUES("9","0","","3","3","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("10","0","","3","4","165000","1","Kuweka Akiba","165000","7","0","","2");
INSERT INTO receipts VALUES("11","0","","3","4","20000","1","Kuweka Hisa","20000","6","0","","1");
INSERT INTO receipts VALUES("12","0","","3","4","20000","1","Kuweka amana","20000","8","0","","3");
INSERT INTO receipts VALUES("13","0","","3","5","85000","1","AKIBA","85000","7","0","","2");
INSERT INTO receipts VALUES("14","0","","3","6","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("15","0","","3","5","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("16","0","","3","6","15000","1","AKIBA","15000","7","0","","2");
INSERT INTO receipts VALUES("17","0","","3","6","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("21","0","","3","8","10000","1","Kuweka Akiba","10000","7","0","","2");
INSERT INTO receipts VALUES("20","0","","3","5","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("22","0","","3","8","20000","1","Kuweka Hisa","20000","6","0","","1");
INSERT INTO receipts VALUES("23","0","","3","8","5000","1","Kuweka amana","5000","8","0","","3");
INSERT INTO receipts VALUES("24","0","","3","9","15000","1","AKIBA","15000","7","0","","2");
INSERT INTO receipts VALUES("25","0","","3","9","20000","1","Hisa","20000","6","0","","1");
INSERT INTO receipts VALUES("26","0","","3","10","85000","1","AKIBA","85000","7","0","","2");
INSERT INTO receipts VALUES("27","0","","3","9","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("28","0","","3","11","15000","1","Kuweka Akiba","15000","7","0","","2");
INSERT INTO receipts VALUES("29","0","","3","10","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("30","0","","3","11","20000","1","Kuweka Hisa","20000","6","0","","1");
INSERT INTO receipts VALUES("31","0","","3","10","30000","1","AMANA","30000","8","0","","3");
INSERT INTO receipts VALUES("32","0","","3","11","20000","1","Kuweka amana","20000","8","0","","3");
INSERT INTO receipts VALUES("33","0","","3","12","165000","1","AKIBA","165000","7","0","","2");
INSERT INTO receipts VALUES("34","0","","3","12","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("35","0","","3","13","10000","1","Kuweka Akiba","10000","7","0","","2");
INSERT INTO receipts VALUES("38","0","","3","12","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("39","0","","3","13","20000","1","Kuweka Hisa","20000","6","0","","1");
INSERT INTO receipts VALUES("40","0","","3","13","5000","1","Kuweka amana","5000","8","0","","3");
INSERT INTO receipts VALUES("41","0","","3","14","65000","1","AKIBA","65000","7","0","","2");
INSERT INTO receipts VALUES("42","0","","3","14","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("43","0","","3","15","65000","1","AKIBA","65000","7","0","","2");
INSERT INTO receipts VALUES("44","0","","3","14","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("45","0","","3","15","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("46","0","","3","15","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("65","0","","3","24","15000","1","15000","15000","7","0","","2");
INSERT INTO receipts VALUES("48","0","","3","16","165000","1","AKIBA","165000","7","0","","2");
INSERT INTO receipts VALUES("61","0","","3","20","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("50","0","","3","18","70000","1","AKIBA","70000","7","0","","2");
INSERT INTO receipts VALUES("51","0","","3","16","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("60","0","","3","20","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("53","0","","3","16","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("54","0","","3","18","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("55","0","","3","18","50000","1","AMANA","50000","8","0","","3");
INSERT INTO receipts VALUES("64","0","","3","22","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("63","0","","3","22","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("62","0","","3","22","65000","1","AKIBA","65000","7","0","","2");
INSERT INTO receipts VALUES("59","0","","3","20","65000","1","AKIBA","65000","7","0","","2");
INSERT INTO receipts VALUES("66","0","","3","24","20000","1","HISA","20000","6","0","","1");
INSERT INTO receipts VALUES("67","0","","3","24","20000","1","AMANA","20000","8","0","","3");
INSERT INTO receipts VALUES("68","0","","3","27","200000","1","YES","200000","8","0","","3");
INSERT INTO receipts VALUES("69","0","","3","27","50000","1","TE","50000","7","0","","2");
INSERT INTO receipts VALUES("70","0","","3","27","2000","1","DD","2000","6","0","","1");
INSERT INTO receipts VALUES("71","0","","3","28","4500000","1","withdrawal of shares","4500000","6","0","","1");
INSERT INTO receipts VALUES("72","0","","3","29","560000","1","shares","560000","6","0","","1");
INSERT INTO receipts VALUES("73","0","","3","30","200000","1","withdrawal of shares","200000","6","0","","1");
INSERT INTO receipts VALUES("78","0","","3","35","500000","1","SHARE","500000","7","0","","2");
INSERT INTO receipts VALUES("79","0","","3","35","200000","1","SHARE","200000","6","0","","1");



DROP TABLE reconcilled_transactions;

CREATE TABLE `reconcilled_transactions` (
  `reconcilled_transactions_id` int(11) NOT NULL AUTO_INCREMENT,
  `reconcilled_chart_transaction_id` int(11) NOT NULL,
  `reconcilled_statement_transaction_id` int(11) NOT NULL,
  `reconcilled_transactio_ref_no` varchar(300) NOT NULL,
  `reconcilled_transaction_code_id` int(11) NOT NULL,
  PRIMARY KEY (`reconcilled_transactions_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE reconcilled_transactions_code;

CREATE TABLE `reconcilled_transactions_code` (
  `reconcilled_transactions_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `date_reconcilled` date NOT NULL,
  `datetime_reconcilled` datetime NOT NULL,
  `reconciled_by` int(11) NOT NULL,
  `statement_code_id` int(11) NOT NULL,
  PRIMARY KEY (`reconcilled_transactions_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE reconcilled_transactions_old34;

CREATE TABLE `reconcilled_transactions_old34` (
  `reconcilled_transactions_id` int(11) NOT NULL AUTO_INCREMENT,
  `reconcilled_chart_transaction_id` int(11) NOT NULL,
  `reconcilled_statement_transaction_id` int(11) NOT NULL,
  `reconcilled_transactio_ref_no` varchar(300) NOT NULL,
  `reconcilled_transaction_code_id` int(11) NOT NULL,
  PRIMARY KEY (`reconcilled_transactions_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE rescheduled_loan_schedule;

CREATE TABLE `rescheduled_loan_schedule` (
  `top_up_repayment_id` int(11) NOT NULL AUTO_INCREMENT,
  `top_up_id` int(11) NOT NULL,
  `principle_repaid` varchar(100) NOT NULL,
  `interest_repaid` varchar(100) NOT NULL,
  `non_ded_repaid` varchar(100) NOT NULL,
  `loan_schedule_id` int(11) NOT NULL,
  `loan_id` int(10) NOT NULL,
  PRIMARY KEY (`top_up_repayment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE rescheduled_loans;

CREATE TABLE `rescheduled_loans` (
  `reschedule_loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NOT NULL,
  `loan_id` int(11) NOT NULL,
  `loan_type_id` int(11) NOT NULL,
  `loan_asset_account_id` int(11) NOT NULL,
  `reschedule_amount` varchar(100) NOT NULL,
  `loan_balance_amount` varchar(100) NOT NULL,
  `reschedule_date` date NOT NULL,
  `rechedule_reason` mediumtext NOT NULL,
  `reschedule_user_id` int(11) NOT NULL,
  PRIMARY KEY (`reschedule_loan_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE reverse_supplier_payments_code;

CREATE TABLE `reverse_supplier_payments_code` (
  `supplier_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `order_code_id` int(11) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `amount_received` varchar(100) NOT NULL,
  `description` longtext NOT NULL,
  `cheque_no` varchar(11) NOT NULL,
  `currency_code` varchar(100) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `mop` varchar(11) NOT NULL,
  `date_paid` date NOT NULL,
  `date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `account_to_credit` int(11) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(11) NOT NULL,
  `approval_comments` varchar(300) NOT NULL,
  `date_approved` date NOT NULL,
  `datetime_approved` datetime NOT NULL,
  PRIMARY KEY (`supplier_payment_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=82 DEFAULT CHARSET=latin1;

INSERT INTO reverse_supplier_payments_code VALUES("81","0","179","146","96250","Being 65% of (Invoice No TSCL-7289  ksh137,500)  final payment for system and website development Nov 2022","000088","7","1","3","2022-11-14","0000-00-00 00:00:00","134","127","1","137","ok","2022-11-08","2022-11-14 10:57:24");



DROP TABLE reversed_loan_payments_code;

CREATE TABLE `reversed_loan_payments_code` (
  `reversed_loan_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_id` int(11) NOT NULL,
  `member_id` int(11) NOT NULL,
  `rep_recorded_by` int(11) NOT NULL,
  `rep_amount_received` varchar(100) NOT NULL,
  `rep_procc_fees` varchar(100) NOT NULL,
  `rep_description` longtext NOT NULL,
  `rep_receipt_no` varchar(100) NOT NULL,
  `rep_cheque_no` varchar(10) NOT NULL,
  `currency_code` varchar(100) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `rep_mop` varchar(11) NOT NULL,
  `rep_date_paid` date NOT NULL,
  `rep_date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rep_account_to_debit` int(11) NOT NULL,
  `account_paid_to` int(11) NOT NULL,
  `canceled_loan_code_id` int(11) NOT NULL,
  PRIMARY KEY (`reversed_loan_payment_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO reversed_loan_payments_code VALUES("1","880","31","137","105000","","","00001","000042","7","1","","2023-04-20","2023-04-20 16:17:11","3","3","0");
INSERT INTO reversed_loan_payments_code VALUES("2","206","88","100","332153","","","00002","EFT-FT2213","7","1","","2023-05-05","2023-05-08 10:43:34","3","3","0");



DROP TABLE reversed_loan_repayment;

CREATE TABLE `reversed_loan_repayment` (
  `reversed_loan_repayment_id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_repayment_id` int(11) NOT NULL,
  `member_id` int(100) NOT NULL,
  `principle_repaid_amount` varchar(10) NOT NULL,
  `principle_credit_account_id` int(11) NOT NULL,
  `interest_paid` varchar(10) NOT NULL,
  `non_ded_charges_paid` varchar(100) NOT NULL,
  `interest_credit_account_id` int(11) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `reversed_multiple_loan_payment_code_id` int(11) NOT NULL,
  `loan_schedule_id` int(11) NOT NULL,
  `ttl_repaid_amount` varchar(100) NOT NULL,
  `date_repaid` date NOT NULL,
  `write_off` int(11) NOT NULL,
  `waiver` varchar(11) NOT NULL,
  `canceled_loan_code_id` int(11) NOT NULL,
  PRIMARY KEY (`reversed_loan_repayment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE reversed_loan_repayment_other_charges;

CREATE TABLE `reversed_loan_repayment_other_charges` (
  `reversed_loan_repayment_other_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `other_amount_repaid` varchar(100) NOT NULL,
  `rep_introduced_loan_charges_id` int(11) NOT NULL,
  `rep_loan_product_charge_id` int(11) NOT NULL,
  `other_account_credited` int(11) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `multiple_loan_payment_code_id` int(11) NOT NULL,
  `loan_repayment_other_charges_date` date NOT NULL,
  `write_off` int(11) NOT NULL,
  `waiver` varchar(10) NOT NULL,
  `canceled_loan_code_id` int(11) NOT NULL,
  `top_up_id` int(11) NOT NULL,
  PRIMARY KEY (`reversed_loan_repayment_other_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE reversed_multiple_loan_payments_code;

CREATE TABLE `reversed_multiple_loan_payments_code` (
  `reversed_multiple_loan_payment_code_id` int(100) NOT NULL AUTO_INCREMENT,
  `multiple_loan_payment_code_id` int(100) NOT NULL,
  `employer_id` int(11) NOT NULL,
  `rep_recorded_by` int(11) NOT NULL,
  `rep_amount_received` varchar(100) NOT NULL,
  `rep_description` longtext NOT NULL,
  `rep_receipt_no` varchar(100) NOT NULL,
  `rep_cheque_no` varchar(10) NOT NULL,
  `currency_code` varchar(100) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `rep_mop` varchar(11) NOT NULL,
  `recov_mode` varchar(1) NOT NULL,
  `rep_date_paid` date NOT NULL,
  `rep_date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rep_account_to_debit` int(11) NOT NULL,
  `our_bank_account_id` int(11) NOT NULL,
  PRIMARY KEY (`reversed_multiple_loan_payment_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE sacco_raw_data;

CREATE TABLE `sacco_raw_data` (
  `raw_data_id` int(10) NOT NULL AUTO_INCREMENT,
  `full_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `first_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `second_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `last_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `gender` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `shares` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `savings` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `loans` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `data_date` date NOT NULL,
  `member_no` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`raw_data_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;




DROP TABLE salary_expenses_ledger;

CREATE TABLE `salary_expenses_ledger` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `transactions` varchar(100) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `debit` varchar(100) NOT NULL,
  `credit` varchar(100) NOT NULL,
  `currency_code` int(10) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `date_recorded` date NOT NULL,
  `order_code` varchar(100) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE shares;

CREATE TABLE `shares` (
  `shares_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `amount` varchar(15) NOT NULL,
  `date_paid` date NOT NULL,
  `date_drawn` date NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `comments` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  PRIMARY KEY (`shares_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE shares_transactions;

CREATE TABLE `shares_transactions` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `member_id` int(10) NOT NULL,
  `member_phone` varchar(15) NOT NULL,
  `transaction` varchar(100) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `credit` varchar(100) NOT NULL,
  `debit` varchar(100) NOT NULL,
  `transaction_date` date NOT NULL,
  `transaction_code` text NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE shop;

CREATE TABLE `shop` (
  `shop_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `account_cat_id` int(11) NOT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `shop_description` longtext,
  `shop_name` varchar(50) DEFAULT NULL,
  `logo_url` varchar(500) NOT NULL,
  `shop_title` varchar(500) NOT NULL,
  `shop_phone` varchar(500) NOT NULL,
  `shop_tin` varchar(500) NOT NULL,
  PRIMARY KEY (`shop_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO shop VALUES("5","0","0","0","HEAD-QUARTERS","HEAD-QUARTERS","http://192.168.1.30:8050/hcl/images/reagan_logo.png","HEAD-QUARTERS","-","-");



DROP TABLE sms_alert_log;

CREATE TABLE `sms_alert_log` (
  `alert_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_id` int(10) NOT NULL,
  `datetime_sent` datetime NOT NULL,
  `sent_to` varchar(100) NOT NULL,
  `message` longtext NOT NULL,
  `section` varchar(100) NOT NULL,
  `sms_response` longtext NOT NULL,
  PRIMARY KEY (`alert_id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;

INSERT INTO sms_alert_log VALUES("1","5","2024-10-02 11:53:11","254723411943","Dear DAMAS KIWELU MAUA, Your loan (DEVELOPMENT LOANS) 
of amount 133,000.00 
you applied has been booked into the system awaiting approval.  
The loan refference no is DVLP-LN5","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("2","5","2024-10-02 11:53:45","254733","Dear General Manager, Then loan (DEVELOPMENT LOANS) of 
amount 133,000.00, Ref No DVLP-LN5","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("3","5","2024-10-02 11:54:28","254720426724","Dear Finance Manager, The loan (DEVELOPMENT LOANS) of 
amount 133,000.00, Ref No DVLP-LN5 
has been approved. Kindly disbursed","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("4","5","2024-10-02 11:56:34","255076288507","Dear DAMAS KIWELU MAUA, Your loan (DEVELOPMENT LOANS) of amount 133,000.00, Ref No DVLP-LN5 has been disbursed successfully through CASH.","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("5","18","2024-10-02 12:25:49","254723411943","Dear ANNETE  CLOUTAS DJUING, Your loan (MKOPO WA DHARURA) 
of amount 500,000.00 
you applied has been booked into the system awaiting approval.  
The loan refference no is MWD-LN18","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("6","18","2024-10-02 13:13:20","254733","Dear General Manager, Then loan (MKOPO WA DHARURA) of 
amount 500,000.00, Ref No MWD-LN18","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("7","18","2024-10-02 13:15:55","254720426724","Dear Finance Manager, The loan (MKOPO WA DHARURA) of 
amount 500,000.00, Ref No MWD-LN18 
has been approved. Kindly disbursed","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("8","18","2024-10-02 13:18:58","255783293710","Dear ANNETE  CLOUTAS DJUING, Your loan (MKOPO WA DHARURA) of amount 300,000.00, Ref No MWD-LN18 has been disbursed successfully through CASH.","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("9","20","2025-02-17 15:39:01","254723411943","Dear ROAN KIBU MALIA, Your loan (DEVELOPMENT LOANS) 
of amount 1,000,000.00 
you applied has been booked into the system awaiting approval.  
The loan refference no is DVLP-LN20","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("10","20","2025-02-17 15:39:59","254733","Dear General Manager, Then loan (DEVELOPMENT LOANS) of 
amount 1,000,000.00, Ref No DVLP-LN20","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("11","20","2025-02-17 15:40:22","254720426724","Dear Finance Manager, The loan (DEVELOPMENT LOANS) of 
amount 1,000,000.00, Ref No DVLP-LN20 
has been approved. Kindly disbursed","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("12","21","2025-02-17 15:51:19","254723411943","Dear DEBORAH CHARLES SHAYO, Your loan (DEVELOPMENT LOANS) 
of amount 400,000.00 
you applied has been booked into the system awaiting approval.  
The loan refference no is DVLP-LN21","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("13","21","2025-02-17 15:52:32","254733","Dear General Manager, Then loan (DEVELOPMENT LOANS) of 
amount 400,000.00, Ref No DVLP-LN21","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("14","22","2025-02-19 13:37:45","254723411943","Dear VICENT KIGOSI GIGANTE, Your loan (Jazz Microfinance) 
of amount 1,500,000.00 
you applied has been booked into the system awaiting approval.  
The loan refference no is 4557-LN22","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("15","22","2025-02-19 13:38:30","254733","Dear General Manager, Then loan (Jazz Microfinance) of 
amount 1,500,000.00, Ref No 4557-LN22","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("16","22","2025-02-19 13:38:50","254720426724","Dear Finance Manager, The loan (Jazz Microfinance) of 
amount 1,500,000.00, Ref No 4557-LN22 
has been approved. Kindly disbursed","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("17","22","2025-02-19 13:39:39","255742457167","Dear VICENT KIGOSI GIGANTE, Your loan (Jazz Microfinance) of amount 1,500,000.00, Ref No 4557-LN22 has been disbursed successfully through CASH.","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("18","28","2025-02-24 16:30:43","254723411943","Dear NOREEN ERNEST MSUYA, Your loan (foesight loan) 
of amount 1,500,000.00 
you applied has been booked into the system awaiting approval.  
The loan refference no is 564324-LN28","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("19","28","2025-02-24 16:31:13","254733","Dear General Manager, Then loan (foesight loan) of 
amount 1,500,000.00, Ref No 564324-LN28","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("20","28","2025-02-24 16:33:18","254720426724","Dear Finance Manager, The loan (foesight loan) of 
amount 1,500,000.00, Ref No 564324-LN28 
has been approved. Kindly disbursed","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("21","28","2025-02-24 16:35:07","255076288507","Dear NOREEN ERNEST MSUYA, Your loan (foesight loan) of amount 1,350,000.00, Ref No 564324-LN28 has been disbursed successfully through BANK CASH DEPOSIT.","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("22","29","2025-02-28 15:41:35","254723411943","Dear VICENT KIGOSI GIGANTE, Your loan (foresight loan) 
of amount 1,500,000.00 
you applied has been booked into the system awaiting approval.  
The loan refference no is 564324-LN29","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("23","29","2025-02-28 15:45:08","254733","Dear General Manager, Then loan (foresight loan) of 
amount 1,500,000.00, Ref No 564324-LN29","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("24","29","2025-02-28 15:47:42","254720426724","Dear Finance Manager, The loan (foresight loan) of 
amount 1,500,000.00, Ref No 564324-LN29 
has been approved. Kindly disbursed","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("25","29","2025-02-28 15:49:04","255742457167","Dear VICENT KIGOSI GIGANTE, Your loan (foresight loan) of amount 1,350,000.00, Ref No 564324-LN29 has been disbursed successfully through BANK CASH DEPOSIT.","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("26","30","2025-03-03 14:36:40","254723411943","Dear JESCA CHARLES THOMAS, Your loan (jazz loan) 
of amount 1,500,000.00 
you applied has been booked into the system awaiting approval.  
The loan refference no is 786-LN30","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("27","31","2025-03-09 00:00:00","254723411943","Dear LAWIN LEWIN LIWIN, Your loan (LAWI) 
of amount 1,500,000.00 
you applied has been booked into the system awaiting approval.  
The loan refference no is TY6-LN31","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("28","31","2025-03-09 12:15:36","254733","Dear General Manager, Then loan (LAWI) of 
amount 1,500,000.00, Ref No TY6-LN31","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("29","31","2025-03-09 12:23:27","254733","Dear General Manager, Then loan (LAWI) of 
amount 1,500,000.00, Ref No TY6-LN31","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("30","31","2025-03-09 12:34:51","254720426724","Dear Finance Manager, The loan (LAWI) of 
amount 1,500,000.00, Ref No TY6-LN31 
has been approved. Kindly disbursed","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("31","31","2025-03-09 12:36:17","255786543789","Dear LAWIN LEWIN LIWIN, Your loan (LAWI) of amount 1,350,000.00, Ref No TY6-LN31 has been disbursed successfully through CASH.","LOANAPPL","");
INSERT INTO sms_alert_log VALUES("32","30","2025-03-18 17:44:11","254733","Dear General Manager, Then loan (jazz loan) of 
amount 1,500,000.00, Ref No 786-LN30","LOANAPPL","");



DROP TABLE staff_task;

CREATE TABLE `staff_task` (
  `staff_task_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(100) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `date_assigned` datetime NOT NULL,
  `user_id` int(10) NOT NULL,
  `status1` int(11) NOT NULL,
  `scheduled` int(100) NOT NULL,
  `over_time_status` int(11) NOT NULL DEFAULT '0',
  `optimum_score_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`staff_task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE stopped_penalty;

CREATE TABLE `stopped_penalty` (
  `stopped_penalty_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_id` int(11) NOT NULL,
  `loan_application_charges_id` int(11) NOT NULL,
  `date_stopped` date NOT NULL,
  `stopped_by` int(11) NOT NULL,
  `datetime_stopped` datetime NOT NULL,
  `penalty_amount` varchar(100) NOT NULL,
  `stoppage_reason` varchar(350) NOT NULL,
  PRIMARY KEY (`stopped_penalty_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO stopped_penalty VALUES("1","27","22","2025-02-24","100","2025-02-24 16:27:50","0","stoped");
INSERT INTO stopped_penalty VALUES("2","29","26","2025-02-28","100","2025-02-28 15:58:13","0","");
INSERT INTO stopped_penalty VALUES("3","31","29","2025-03-09","100","2025-03-09 12:41:34","0","");



DROP TABLE stopped_task;

CREATE TABLE `stopped_task` (
  `stopped_task_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(100) NOT NULL,
  `date_stopped` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int(10) NOT NULL,
  `period_taken` varchar(11) NOT NULL,
  `scores_achieved` varchar(100) NOT NULL,
  `reason` longtext NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `status2` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stopped_task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE sub_module;

CREATE TABLE `sub_module` (
  `sub_module_id` int(10) NOT NULL AUTO_INCREMENT,
  `module_id` int(10) NOT NULL,
  `sub_module_name` varchar(200) NOT NULL,
  `sort_order` int(10) NOT NULL,
  `sublink` longtext NOT NULL,
  `description` varchar(100) NOT NULL,
  `status` int(10) NOT NULL,
  PRIMARY KEY (`sub_module_id`)
) ENGINE=MyISAM AUTO_INCREMENT=210 DEFAULT CHARSET=latin1;

INSERT INTO sub_module VALUES("5","3","Members Financial Statement","2","home.php?edituniversity=edituniversity","Members Financial Statement","0");
INSERT INTO sub_module VALUES("7","4","User Group Management","10","home.php?newusergroup=newusergroup","vbvb","0");
INSERT INTO sub_module VALUES("8","4","Modules and Submodules","11","home.php?modules=modules","","0");
INSERT INTO sub_module VALUES("9","4","Modules User Group Relation","12","home.php?modulesusergroup=modulesusergroup","","0");
INSERT INTO sub_module VALUES("10","4","Users Management","14","home.php?viewusers=viewusers","Users Management","0");
INSERT INTO sub_module VALUES("34","7","View Task Perfomance","22","home.php?submit_biweekly2=submit_biweekly2","View Task Perfomance","0");
INSERT INTO sub_module VALUES("62","6","Members Savings","1","home.php?submit_biweekly2=submit_biweekly2","Members Savings","0");
INSERT INTO sub_module VALUES("79","3","Members Registration","1","home.php?viewconference=viewconference","Members Registration","0");
INSERT INTO sub_module VALUES("86","13","Audit Trails","1","home.php?audittrails=audittrails","home.php?audittrails=audittrails","0");
INSERT INTO sub_module VALUES("84","4","Organization Details","1","home.php?newsponsor=newsponsor&user_group_id=15","Company Setting","0");
INSERT INTO sub_module VALUES("39","4","Assign Access To Users","13","home.php?viewusergroupsm=viewusergroupsm&user_group_id=15","Assign Access To Users","0");
INSERT INTO sub_module VALUES("87","6","Set Up Insurance Premiums","3","home.php?areareport=areareport","Set Up Insurance Premiums","0");
INSERT INTO sub_module VALUES("88","4","Modules and Submodules","11","home.php?modules=modules","","0");
INSERT INTO sub_module VALUES("89","6","Approve Members Payments","5","home.php?subconinvoices=subconinvoices","","0");
INSERT INTO sub_module VALUES("90","6","Task Reports","9","home.php?viewdistrict=viewdistrict","","0");
INSERT INTO sub_module VALUES("91","6","Staff Task Renumeration","100","home.php?editdistrict=editdistrict","Staff Task Renumeration","0");
INSERT INTO sub_module VALUES("92","6","Cash Flow Report","22","home.php?countryreport=countryreport","","0");
INSERT INTO sub_module VALUES("93","1","Home","1","home.php?dash_board=dash_board","Home","0");
INSERT INTO sub_module VALUES("94","23","Request Fund","1","home.php?viewregion=viewregion","","0");
INSERT INTO sub_module VALUES("95","23","Loan Arears/Default report","60","home.php?editsubproject=editsubproject","","0");
INSERT INTO sub_module VALUES("102","25","Record Outgoing Document","2","home.php?assignprojectsettlement=assignprojectsettlement","","0");
INSERT INTO sub_module VALUES("97","23","Request Petty Cash Expense","3","home.php?submission_period=submission_period","Request Petty Cash Expense","0");
INSERT INTO sub_module VALUES("98","23","Approve Petty Cash Expense","4","home.php?viewcountries=viewcountries","","0");
INSERT INTO sub_module VALUES("99","23","Petty Cash Statement","6","home.php?viewsetuptemplate=viewsetuptemplate","","0");
INSERT INTO sub_module VALUES("100","24","Send All Members SMS","1","home.php?setuptemplate1=setuptemplate1","","0");
INSERT INTO sub_module VALUES("101","25","Record Incoming Document","1","home.php?perdm=perdm","","0");
INSERT INTO sub_module VALUES("103","25","Record Incoming Phone Call","3","home.php?addcompetency=addcompetency","addcompetency","0");
INSERT INTO sub_module VALUES("104","25","Record Outgoing Phone Call","4","home.php?addhouse=addhouse","","0");
INSERT INTO sub_module VALUES("105","25","Repay Loan","6","home.php?assignsubprojectlocation=assignsubprojectlocation","","0");
INSERT INTO sub_module VALUES("106","25","Record Incoming Email","5","home.php?assignsubprojectend=assignsubprojectend","","0");
INSERT INTO sub_module VALUES("107","25","Monthly Deduction List","7","home.php?initiateproject=initiateproject","Monthly Deduction List","0");
INSERT INTO sub_module VALUES("108","25","Deposit Withdrawal","8","home.php?savings=savings","","0");
INSERT INTO sub_module VALUES("109","26","Record Expenses","1","home.php?newtribe_approved","Other Transactions
","0");
INSERT INTO sub_module VALUES("110","6","View Non-Member Payments","4","home.php?assignprojectlocation=assignprojectlocation","","0");
INSERT INTO sub_module VALUES("111","25","Loan Products","1","home.php?viewlocation=viewlocation","","0");
INSERT INTO sub_module VALUES("112","25","Apply Loan","2","home.php?viewprojectcountry=viewprojectcountry","","0");
INSERT INTO sub_module VALUES("113","25","Approve Loan","3","home.php?viewsubjects=viewsubjects","","0");
INSERT INTO sub_module VALUES("114","25","Disburse Loan","5","home.php?viewhouse=viewhouse","","0");
INSERT INTO sub_module VALUES("115","27","Members Shares","5","home.php?viewsubprojectcountry=viewsubprojectcountry","","0");
INSERT INTO sub_module VALUES("116","23","Loan Schedule Report","16","home.php?loan_schedule_report=loan_schedule_report","","0");
INSERT INTO sub_module VALUES("117","23","Cash Collateral Reports","15","home.php?cash_collateral_report=cash_collateral_report","","0");
INSERT INTO sub_module VALUES("118","23","Clients Fines Report","18","home.php?client_fines_report=client_fines_report","","0");
INSERT INTO sub_module VALUES("119","28","Chart Of Accounts","1","home.php?chart_of_accounts2","","0");
INSERT INTO sub_module VALUES("120","28","Journal Entry","2","home.php?general_journal=general_journal","","0");
INSERT INTO sub_module VALUES("121","28","Income Statement","3","home.php?pla=pla","","0");
INSERT INTO sub_module VALUES("122","28","Statement of Financial Position","5","home.php?balance_sheet2","","0");
INSERT INTO sub_module VALUES("123","23","Loan Interest Report","33","home.php?loan_interest_report=loan_interest_report","","0");
INSERT INTO sub_module VALUES("124","23","Loans Pending approval","100","home.php?unapproved_loans_report=unapproved_loans_report","","0");
INSERT INTO sub_module VALUES("125","23","Approved Loans Report","45","home.php?approved_loans_report=approved_loans_report","","0");
INSERT INTO sub_module VALUES("126","23","Disbursed Loans Report","46","home.php?disbursed_loan_reports=disbursed_loan_reports","","0");
INSERT INTO sub_module VALUES("127","23","Tax On Interest Report (Summary)","48","home.php?tax_interest_report=tax_interest_report","","0");
INSERT INTO sub_module VALUES("128","23","Periodic Repayment Projections","6","home.php?daily_expected_rapayment=daily_expected_rapayment","","0");
INSERT INTO sub_module VALUES("129","23","Defaulters Report","55","home.php?defaulters_report=defaulters_report","","0");
INSERT INTO sub_module VALUES("130","25","Offset Loan","122","home.php?offset_loan=offset_loan","","0");
INSERT INTO sub_module VALUES("131","28","Trial Balance","56","home.php?trial_balance=trial_balance","","0");
INSERT INTO sub_module VALUES("132","29","System Settings","1","home.php?system_settings=system_settings","","0");
INSERT INTO sub_module VALUES("133","23","Tax On Interest Report (Detailed)","16","home.php?tax_interest_report_det=tax_interest_report_det","","0");
INSERT INTO sub_module VALUES("134","23","Member Statement","12","home.php?statement=statement","","0");
INSERT INTO sub_module VALUES("135","4","Access Control","4","home.php?newsponsor=newsponsor","","0");
INSERT INTO sub_module VALUES("136","3","Member Exit","15","home.php?view_customer_exit","","0");
INSERT INTO sub_module VALUES("137","25","Cancel Loan","22","home.php?cancel_loan","","0");
INSERT INTO sub_module VALUES("138","23","Canceled Loans Report","16","home.php?canceled_loans_report","","0");
INSERT INTO sub_module VALUES("139","23","Loan Portfolio Report","17","home.php?all_loans=all_loans","","0");
INSERT INTO sub_module VALUES("140","23","Loan Aging Analysis Report","133","home.php?loan_aging=loan_aging","","0");
INSERT INTO sub_module VALUES("141","25","Update Loan","566","home.php?update_loan=update_loan","","0");
INSERT INTO sub_module VALUES("142","25","Loan Assets","1","home.php?loan_product=loan_product","","0");
INSERT INTO sub_module VALUES("143","3","Employers Management","1","home.php?members_group","","0");
INSERT INTO sub_module VALUES("144","30","Employers List","1","home.php?members_group","","0");
INSERT INTO sub_module VALUES("145","35","Disbursed Transactions","1","home.php?mpesa_disbursed","","0");
INSERT INTO sub_module VALUES("146","35","Received Transactions","2","home.php?mpesa_received","","0");
INSERT INTO sub_module VALUES("147","35","Mpesa B2C Account Balance","4","home.php?mpesa_b2c_balance","","0");
INSERT INTO sub_module VALUES("148","23","Loan Repayments Report","25","home.php?loan_repayment_report","","0");
INSERT INTO sub_module VALUES("149","36","Suppliers Database Setup","1","home.php?suppliers","","0");
INSERT INTO sub_module VALUES("150","23","Loan Revenue Reports","12","home.php?loan_revenue_report","","0");
INSERT INTO sub_module VALUES("151","25","Loan Officers Commision Setup","5","home.php?loan_commision","","0");
INSERT INTO sub_module VALUES("152","34","Single Customer Loan Repayment","1","home.php?view_single_loan_repayment","","0");
INSERT INTO sub_module VALUES("153","25","Loan Calculator","600","home.php?loan_calculator","","0");
INSERT INTO sub_module VALUES("154","23","Loan Officers Commision Report","78","home.php?commision_report","","0");
INSERT INTO sub_module VALUES("155","23","Other Revenue Reports","66","home.php?other_revenue_report","","0");
INSERT INTO sub_module VALUES("156","37","Record Cash / Cheque Payments","1","home.php?pay_cheque_payment","","0");
INSERT INTO sub_module VALUES("157","36","Receive Supplier Invoice","2","home.php?view_receive_supplier_invoice","","0");
INSERT INTO sub_module VALUES("158","36","Record Supplier Payments","4","home.php?view_supplier_payment","","0");
INSERT INTO sub_module VALUES("159","36","Suppliers Balances","7","home.php?supplier_balances","","0");
INSERT INTO sub_module VALUES("160","34","Multiple Customer Loan Repayment","2","home.php?view_multiple_loan_repayment","","0");
INSERT INTO sub_module VALUES("161","36","Creditors Journal","3","home.php?view_creditors_journal","","0");
INSERT INTO sub_module VALUES("162","33","Introduce Charges To Loan","9","home.php?view_introduced_charges","","0");
INSERT INTO sub_module VALUES("163","3","Record Loans Journal","25","home.php?view_debtors_ledger","","0");
INSERT INTO sub_module VALUES("164","4","System Backup and Restore","16","home.php?system_backup","","0");
INSERT INTO sub_module VALUES("165","3","Receipt Customer (Loanees)","23","home.php?view_receipt_customer","","0");
INSERT INTO sub_module VALUES("166","33","Reverse Disbursed Loan","1222","home.php?reverse_loan","","0");
INSERT INTO sub_module VALUES("167","3","Other Customers","19","home.php?other_customer","","0");
INSERT INTO sub_module VALUES("168","3","Issue Invoice (Other Customers)","29","home.php?issue_invoice","","0");
INSERT INTO sub_module VALUES("169","31","Loan Top Up","144","home.php?top_up_loan","","0");
INSERT INTO sub_module VALUES("170","3","Receive Payments (Other Debtors)","32","home.php?view_receive_customer_payments","","0");
INSERT INTO sub_module VALUES("171","38","Create Budget","1","home.php?create_budget","","0");
INSERT INTO sub_module VALUES("172","38","View Consolidated Budget","2","home.php?view_consolidated_budget","","0");
INSERT INTO sub_module VALUES("173","39","Approve Supplier Payments","1","home.php?approve_supplier_payment","","0");
INSERT INTO sub_module VALUES("174","39","Approve Cash/Cheque Payments","2","home.php?approve_pay_cheque","","0");
INSERT INTO sub_module VALUES("175","26","Approve Cashbook Payments","3","home.php?approve_cash_book_payments","","0");
INSERT INTO sub_module VALUES("176","26","Record Receipts/Payments","3","home.php?view_receipt_payments","","0");
INSERT INTO sub_module VALUES("177","40","Verify Loan","1","home.php?verify_loan","","0");
INSERT INTO sub_module VALUES("178","41","Bank Reconcillation","5","home.php?bank_recon","","0");
INSERT INTO sub_module VALUES("179","41","Bank Reconcillation Reports","10","home.php?bank_rec_reports","","0");
INSERT INTO sub_module VALUES("180","31","Reschedule Loan","145","home.php?reschedule_loan","","0");
INSERT INTO sub_module VALUES("181","31","Stop/Resume Loan Penalties","601","home.php?stop_penalty","","0");
INSERT INTO sub_module VALUES("182","32","Write-Off Loan/Provision for Bad Debts","3","home.php?write_off_loan","","0");
INSERT INTO sub_module VALUES("183","32","Approve Written-Off Loan","60","home.php?approve_write_off_loan","","0");
INSERT INTO sub_module VALUES("184","32","Write Back Written-Off Loans","167","home.php?recover_written_off_loan","","0");
INSERT INTO sub_module VALUES("185","39","Reverse Cash Book Payments","5","home.php?reverse_cash_book_payments","","0");
INSERT INTO sub_module VALUES("186","23","Expected Loan Repayment","120","home.php?expected_loan_repayment","","0");
INSERT INTO sub_module VALUES("187","31","Penalty Stoppage Report","602","home.php?penalty_stoppage_report","","0");
INSERT INTO sub_module VALUES("188","39","Reverse Supplier Payment","122","home.php?reverse_supplier_payment","","0");
INSERT INTO sub_module VALUES("189","31","Waiver Loan","122","home.php?waiver_loan","","0");
INSERT INTO sub_module VALUES("190","32","Approve Waived Loan","168","home.php?approve_waived_loan","","0");
INSERT INTO sub_module VALUES("191","33","Loan Refund","1223","home.php?loan_refund","","0");
INSERT INTO sub_module VALUES("192","33","Approve Loan Refund","1224","home.php?approve_loan_refund","","0");
INSERT INTO sub_module VALUES("193","23","Subsidiary Ledgers (Revenue)","603","home.php?subsidiary_income_interest","","0");
INSERT INTO sub_module VALUES("194","23","Subsidiary Ledgers (Current Assets)","605","home.php?subsidiary_banks","","0");
INSERT INTO sub_module VALUES("195","34","Reverse Loan Repayments","30","home.php?reverse_single_loan_repayment","","0");
INSERT INTO sub_module VALUES("196","26","Daily Collections","55","home.php?daily_collections","","0");
INSERT INTO sub_module VALUES("197","28","Opening Balances","1","home.php?opening_balances","","0");
INSERT INTO sub_module VALUES("198","26","Import Receipts Transactions","200","home.php?import_receipts","","0");
INSERT INTO sub_module VALUES("199","28","General Ledger","25","home.php?general_ledger","","0");
INSERT INTO sub_module VALUES("200","34","Direct LOan Disbursement","15","home.php?direct_disbursement&loan_details=1","","0");
INSERT INTO sub_module VALUES("201","28","Trial Balance Detailed","60","home.php?trial_balance_detailed","","0");
INSERT INTO sub_module VALUES("202","28","Map Transaction Type To Account","40","home.php?transaction_type_account","","0");
INSERT INTO sub_module VALUES("203","41","Bank Transfer","1","home.php?bank_transfer","","0");
INSERT INTO sub_module VALUES("204","28","Financial Year","1","home.php?financial_year","","0");
INSERT INTO sub_module VALUES("205","28","Expenses","1","home.php?cancelpayroll=cancelpayroll","","0");
INSERT INTO sub_module VALUES("206","28","Statement Of Changes In Owners Equity","55","home.php?changes_equity","","0");
INSERT INTO sub_module VALUES("207","28","Cash Flow Analysis","45","home.php?cash_flow","","0");
INSERT INTO sub_module VALUES("208","23","Combined Loan Balances Report","26","home.php?combined_loan_balance_report","","0");
INSERT INTO sub_module VALUES("209","3","Loan Officer","1","home.php?loanconference=loanconference","","0");



DROP TABLE sub_withdrawal;

CREATE TABLE `sub_withdrawal` (
  `shares_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `amount` varchar(15) NOT NULL,
  `date_paid` date NOT NULL,
  `date_drawn` date NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `comments` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  PRIMARY KEY (`shares_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE subscriptions;

CREATE TABLE `subscriptions` (
  `subscription_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `subscription_month` varchar(50) NOT NULL,
  `subscription_month_year` varchar(10) NOT NULL,
  `subscription_year` int(5) NOT NULL,
  `amount` varchar(15) NOT NULL,
  `premium_paid` varchar(10) NOT NULL,
  `date_paid` date NOT NULL,
  `date_drawn` date NOT NULL,
  `date_paid_recorded` datetime NOT NULL,
  `paid_by` int(11) NOT NULL,
  `comments` longtext NOT NULL,
  `mop` int(11) NOT NULL,
  `ref_no` varchar(50) NOT NULL,
  `our_bank` int(11) NOT NULL,
  `client_bank` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_no` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  `status3` int(1) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  `account_to_credit` int(11) NOT NULL,
  PRIMARY KEY (`subscription_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE supplier_invoice;

CREATE TABLE `supplier_invoice` (
  `supplier_invoice_id` int(10) NOT NULL AUTO_INCREMENT,
  `supplier_invoice_vat_account` int(11) NOT NULL,
  `supplier_invoice_vat_value` varchar(100) NOT NULL,
  `supplier_invoice_vat` varchar(100) NOT NULL,
  `supplier_invoice_code_id` int(11) NOT NULL,
  `supplier_invoice_amount_received` varchar(100) NOT NULL,
  `supplier_invoice_account_to_debit` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `department_code` varchar(100) NOT NULL,
  PRIMARY KEY (`supplier_invoice_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE supplier_invoice_code;

CREATE TABLE `supplier_invoice_code` (
  `supplier_invoice_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL,
  `sup_invoice_description` longtext NOT NULL,
  `sup_invoice_currency` int(11) NOT NULL,
  `sup_invoice_curr_rate` int(11) NOT NULL,
  `sup_invoice_receipt_no` varchar(100) NOT NULL,
  `sup_invoice_voucher_no` varchar(100) NOT NULL,
  `sup_invoice_date` date NOT NULL,
  `sup_invoice_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sup_invoice_status` int(11) NOT NULL,
  `sup_invoice_recorded_by` int(11) NOT NULL,
  `sup_invoice_account_to_credit` int(11) NOT NULL,
  `sup_invoice_amount_credited` varchar(100) NOT NULL,
  `journal_type` varchar(2) NOT NULL,
  PRIMARY KEY (`supplier_invoice_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE supplier_payments;

CREATE TABLE `supplier_payments` (
  `supplier_payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `supplier_invoice_code_id` int(11) NOT NULL,
  `supplier_payment_code_id` int(11) NOT NULL,
  `order_amount_received` varchar(100) NOT NULL,
  PRIMARY KEY (`supplier_payment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE supplier_payments_code;

CREATE TABLE `supplier_payments_code` (
  `supplier_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `order_code_id` int(11) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `recorded_by` int(11) NOT NULL,
  `amount_received` varchar(100) NOT NULL,
  `description` longtext NOT NULL,
  `cheque_no` varchar(11) NOT NULL,
  `currency_code` varchar(100) NOT NULL,
  `curr_rate` varchar(100) NOT NULL,
  `mop` varchar(11) NOT NULL,
  `date_paid` date NOT NULL,
  `date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `account_to_credit` int(11) NOT NULL,
  `account_to_debit` int(11) NOT NULL,
  `approval_status` int(11) NOT NULL,
  `approved_by` int(11) NOT NULL,
  `approval_comments` varchar(300) NOT NULL,
  `date_approved` date NOT NULL,
  `datetime_approved` datetime NOT NULL,
  PRIMARY KEY (`supplier_payment_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE supplier_transactions;

CREATE TABLE `supplier_transactions` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(10) NOT NULL,
  `farmer_id` int(11) NOT NULL,
  `order_code` int(10) NOT NULL,
  `transaction` longtext NOT NULL,
  `transaction_section` varchar(100) NOT NULL,
  `currency` int(11) NOT NULL,
  `curr_rate` varchar(11) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `debit` varchar(10) NOT NULL,
  `credit` varchar(10) NOT NULL,
  `transaction_date` date NOT NULL,
  `shop_id` int(11) NOT NULL,
  `status1` int(11) NOT NULL,
  `status2` int(11) NOT NULL,
  `transaction_code` varchar(100) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE suppliers;

CREATE TABLE `suppliers` (
  `supplier_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `supplier_name` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `sup_type` varchar(2) COLLATE latin1_general_ci NOT NULL,
  `sup_code` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `cont_person` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `country` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `postal` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `town` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `phone` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `email` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `date_reg` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `opening_balance` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `supplier_currency` int(11) NOT NULL,
  `supplier_curr_rate` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `opening_balance_date` date NOT NULL,
  `pin` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `supp_bank_id` int(11) NOT NULL,
  `supp_branch_id` int(11) NOT NULL,
  `supp_account_name` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `supp_account_no` varchar(100) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`supplier_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;




DROP TABLE suspended_members;

CREATE TABLE `suspended_members` (
  `suspended_member_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `member_id` int(10) NOT NULL,
  `date_suspended` date NOT NULL,
  `reasons` int(11) NOT NULL,
  `suspend_comments` longtext COLLATE latin1_general_ci NOT NULL,
  `suspended_by` int(10) NOT NULL,
  PRIMARY KEY (`suspended_member_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO suspended_members VALUES("1","3","2024-11-25","13","","100");



DROP TABLE task_comments;

CREATE TABLE `task_comments` (
  `task_comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(100) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `time_sent` datetime NOT NULL,
  `comments` longtext NOT NULL,
  `comment_type` varchar(1) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `status1` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`task_comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE task_logs;

CREATE TABLE `task_logs` (
  `task_log_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(100) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `time_finished` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `scores_achived` varchar(10) NOT NULL,
  `final_comments` longtext NOT NULL,
  `photo` longtext NOT NULL,
  `ip_address` varchar(100) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `status1` int(11) NOT NULL DEFAULT '0',
  `cost_per_min` varchar(100) NOT NULL,
  `cost_per_score` varchar(100) NOT NULL,
  `amount` varchar(100) NOT NULL,
  PRIMARY KEY (`task_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE task_uploads;

CREATE TABLE `task_uploads` (
  `task_upload_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(100) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `time_uploaded` datetime NOT NULL,
  `file_name` longtext NOT NULL,
  `file_type` varchar(1) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `status1` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`task_upload_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE temp_cheque_payments;

CREATE TABLE `temp_cheque_payments` (
  `temp_expenses_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_account_id` int(11) NOT NULL,
  `exp_amount` varchar(100) NOT NULL,
  `exp_user_id` int(11) NOT NULL,
  PRIMARY KEY (`temp_expenses_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE temp_credit_journal_credit_note;

CREATE TABLE `temp_credit_journal_credit_note` (
  `temp_expenses_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_account_id` int(11) NOT NULL,
  `exp_amount` varchar(100) NOT NULL,
  `exp_vat` int(11) NOT NULL,
  `exp_user_id` int(11) NOT NULL,
  PRIMARY KEY (`temp_expenses_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE temp_customer_invoice;

CREATE TABLE `temp_customer_invoice` (
  `temp_expenses_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_account_id` int(11) NOT NULL,
  `exp_amount` varchar(100) NOT NULL,
  `exp_vat` int(11) NOT NULL,
  `exp_user_id` int(11) NOT NULL,
  PRIMARY KEY (`temp_expenses_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;




DROP TABLE temp_expenses;

CREATE TABLE `temp_expenses` (
  `temp_expenses_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_account_id` int(11) NOT NULL,
  `exp_amount` varchar(100) NOT NULL,
  `exp_vat` int(11) NOT NULL,
  `exp_user_id` int(11) NOT NULL,
  PRIMARY KEY (`temp_expenses_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;




DROP TABLE temp_loan_payments;

CREATE TABLE `temp_loan_payments` (
  `temp_loan_payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `temp_loan_payment_code_id` int(11) NOT NULL,
  `temp_loan_schedule_id` int(11) NOT NULL,
  `temp_principle_repayment` varchar(100) NOT NULL,
  `temp_intr_repayment` varchar(100) NOT NULL,
  `temp_non_ded_charges` varchar(100) NOT NULL,
  `write_off` int(11) NOT NULL,
  `temp_writeoff_loan_payment_code_id` int(11) NOT NULL,
  `waiver` varchar(11) NOT NULL,
  `temp_waiver_loan_payment_code_id` int(11) NOT NULL,
  PRIMARY KEY (`temp_loan_payment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=latin1;

INSERT INTO temp_loan_payments VALUES("9","0","109","4977.12","50","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("10","0","110","4981.27","45.85","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("11","0","111","4985.42","41.7","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("12","0","112","4989.58","37.55","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("13","0","113","4993.74","33.39","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("14","0","114","4997.9","29.23","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("15","0","115","5002.06","25.06","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("16","0","116","5006.23","20.89","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("17","0","117","5010.4","16.72","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("18","0","118","5014.58","12.55","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("19","0","119","5018.76","8.37","","0","0","WV","1");
INSERT INTO temp_loan_payments VALUES("20","0","120","5022.94","4.19","","0","0","WV","1");



DROP TABLE temp_loan_payments_code;

CREATE TABLE `temp_loan_payments_code` (
  `temp_loan_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `temp_loan_id` int(11) NOT NULL,
  `temp_member_id` int(11) NOT NULL,
  `temp_rep_recorded_by` int(11) NOT NULL,
  `temp_rep_date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`temp_loan_payment_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO temp_loan_payments_code VALUES("6","6","3","100","2025-03-13 14:41:04");



DROP TABLE temp_loan_repayment_other_charges;

CREATE TABLE `temp_loan_repayment_other_charges` (
  `loan_repayment_other_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(100) NOT NULL,
  `other_amount_repaid` varchar(10) NOT NULL,
  `rep_introduced_loan_charges_id` int(11) NOT NULL,
  `rep_loan_product_charge_id` int(11) NOT NULL,
  `other_account_credited` int(11) NOT NULL,
  `applied_loan_id` int(10) NOT NULL,
  `loan_payment_code_id` int(11) NOT NULL,
  `multiple_loan_payment_code_id` int(11) NOT NULL,
  `write_off` int(11) NOT NULL,
  `temp_writeoff_loan_payment_code_id` int(11) NOT NULL,
  `waiver` varchar(10) NOT NULL,
  `temp_waiver_loan_payment_code_id` int(11) NOT NULL,
  `temp_top_up_id` int(11) NOT NULL,
  PRIMARY KEY (`loan_repayment_other_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE temp_multi_loan_payments;

CREATE TABLE `temp_multi_loan_payments` (
  `temp_loan_payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `temp_loan_payment_code_id` int(11) NOT NULL,
  `temp_loan_schedule_id` int(11) NOT NULL,
  `temp_loan_id` int(11) NOT NULL,
  `temp_member_id` int(11) NOT NULL,
  `temp_principle_repayment` varchar(100) NOT NULL,
  `temp_intr_repayment` varchar(100) NOT NULL,
  `temp_non_ded_charges` varchar(100) NOT NULL,
  PRIMARY KEY (`temp_loan_payment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE temp_multi_loan_payments_code;

CREATE TABLE `temp_multi_loan_payments_code` (
  `temp_loan_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `temp_employer_id` int(11) NOT NULL,
  `temp_loan_id` int(11) NOT NULL,
  `temp_member_id` int(11) NOT NULL,
  `temp_rep_recorded_by` int(11) NOT NULL,
  `temp_rep_date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`temp_loan_payment_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE temp_receipt;

CREATE TABLE `temp_receipt` (
  `temp_expenses_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_account_id` int(11) NOT NULL,
  `exp_amount` varchar(100) NOT NULL,
  `exp_vat` int(11) NOT NULL,
  `exp_user_id` int(11) NOT NULL,
  PRIMARY KEY (`temp_expenses_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO temp_receipt VALUES("6","199","500000","3","100");



DROP TABLE temp_rep_customer_payment;

CREATE TABLE `temp_rep_customer_payment` (
  `temp_rep_customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `temp_rep_customer_payment_code_id` int(11) NOT NULL,
  `temp_rep_payment_amount` varchar(100) NOT NULL,
  `temp_customer_invoice_id` int(11) NOT NULL,
  PRIMARY KEY (`temp_rep_customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE temp_rep_customer_payment_code;

CREATE TABLE `temp_rep_customer_payment_code` (
  `temp_rep_customer_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `temp_rep_customer_id` int(11) NOT NULL,
  `temp_rec_customer_payment_user` int(11) NOT NULL,
  PRIMARY KEY (`temp_rep_customer_payment_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE temp_supplier_invoice;

CREATE TABLE `temp_supplier_invoice` (
  `temp_expenses_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_account_id` int(11) NOT NULL,
  `exp_amount` varchar(100) NOT NULL,
  `exp_vat` int(11) NOT NULL,
  `exp_user_id` int(11) NOT NULL,
  PRIMARY KEY (`temp_expenses_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE temp_waiver_loan_payments_code;

CREATE TABLE `temp_waiver_loan_payments_code` (
  `temp_waiver_loan_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `temp_loan_id` int(11) NOT NULL,
  `temp_member_id` int(11) NOT NULL,
  `temp_rep_recorded_by` int(11) NOT NULL,
  `temp_rep_date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`temp_waiver_loan_payment_code_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO temp_waiver_loan_payments_code VALUES("1","6","3","100","0000-00-00 00:00:00");



DROP TABLE temp_writeoff_loan_payments_code;

CREATE TABLE `temp_writeoff_loan_payments_code` (
  `temp_writeoff_loan_payment_code_id` int(10) NOT NULL AUTO_INCREMENT,
  `temp_loan_id` int(11) NOT NULL,
  `temp_member_id` int(11) NOT NULL,
  `temp_rep_recorded_by` int(11) NOT NULL,
  `temp_rep_date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`temp_writeoff_loan_payment_code_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE tender;

CREATE TABLE `tender` (
  `tender_id` int(10) NOT NULL AUTO_INCREMENT,
  `tender_name` varchar(100) NOT NULL,
  `ref_no` varchar(10) NOT NULL,
  `client_name` varchar(100) NOT NULL,
  `opening_date` date NOT NULL,
  `t_score` varchar(50) NOT NULL,
  `f_score` varchar(50) NOT NULL,
  `comments` longtext NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `date_recorded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status2` int(1) NOT NULL,
  PRIMARY KEY (`tender_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE tender_firms;

CREATE TABLE `tender_firms` (
  `tender_firm_id` int(10) NOT NULL AUTO_INCREMENT,
  `tender_id` int(10) NOT NULL,
  `firm_name` varchar(100) NOT NULL,
  `status` varchar(1) NOT NULL,
  PRIMARY KEY (`tender_firm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE titus_exit_categories;

CREATE TABLE `titus_exit_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(300) NOT NULL,
  `require_clearance` varchar(10) DEFAULT NULL,
  `exit_description` longtext NOT NULL,
  `initiated_by` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO titus_exit_categories VALUES("5","Death","No","Next of kin will be paid pession and gratuity","Administrator");
INSERT INTO titus_exit_categories VALUES("7","Voluntarily","Yes","- 30 days notice
- Pay employee one month gross pay
","Administrator");
INSERT INTO titus_exit_categories VALUES("8","Loan Default","Yes","- 60 years for normal employee
- 65 years for users with disability","Administrator");
INSERT INTO titus_exit_categories VALUES("12","Medical","Yes","Need approval by the board","Administrator");
INSERT INTO titus_exit_categories VALUES("13","Abolition Of Organization","Yes","Need approval by the board","Either");



DROP TABLE tokens;

CREATE TABLE `tokens` (
  `token_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_token_name` varchar(300) NOT NULL,
  `date_generated` datetime NOT NULL,
  PRIMARY KEY (`token_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tokens VALUES("1","LGyiFTh9GADjHiTuB9DwkHlkMddW","2022-08-31 17:00:06");



DROP TABLE tokens_c2b;

CREATE TABLE `tokens_c2b` (
  `token_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_token_name` varchar(300) NOT NULL,
  `date_generated` datetime NOT NULL,
  PRIMARY KEY (`token_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tokens_c2b VALUES("1","3kXwgaGhu2oj3eFzobJ4cQQ7n6nO","2021-09-08 22:30:03");



DROP TABLE top_up_loan;

CREATE TABLE `top_up_loan` (
  `top_up_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NOT NULL,
  `loan_id` int(11) NOT NULL,
  `loan_type_id` int(11) NOT NULL,
  `loan_asset_account_id` int(11) NOT NULL,
  `top_up_amount` varchar(100) NOT NULL,
  `loan_balance_amount` varchar(100) NOT NULL,
  `principle_balance_amount` varchar(100) NOT NULL,
  `interest_balance_amount` varchar(100) NOT NULL,
  `penalty_balance_amount` varchar(100) NOT NULL,
  `top_up_date` date NOT NULL,
  `top_up_reason` mediumtext NOT NULL,
  `top_up_user_id` int(11) NOT NULL,
  PRIMARY KEY (`top_up_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE top_up_repayment;

CREATE TABLE `top_up_repayment` (
  `top_up_repayment_id` int(11) NOT NULL AUTO_INCREMENT,
  `top_up_id` int(11) NOT NULL,
  `principle_repaid` varchar(100) NOT NULL,
  `interest_repaid` varchar(100) NOT NULL,
  `non_ded_repaid` varchar(100) NOT NULL,
  `loan_schedule_id` int(11) NOT NULL,
  `loan_id` int(10) NOT NULL,
  PRIMARY KEY (`top_up_repayment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE transaction_type_account;

CREATE TABLE `transaction_type_account` (
  `transaction_type_account_id` int(10) NOT NULL AUTO_INCREMENT,
  `transaction_type_id` int(10) NOT NULL,
  `account_type_id` int(10) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`transaction_type_account_id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

INSERT INTO transaction_type_account VALUES("1","2","10","0");
INSERT INTO transaction_type_account VALUES("2","2","12","0");
INSERT INTO transaction_type_account VALUES("3","2","10","0");
INSERT INTO transaction_type_account VALUES("4","1","6","0");
INSERT INTO transaction_type_account VALUES("5","2","7","0");
INSERT INTO transaction_type_account VALUES("6","2","7","0");
INSERT INTO transaction_type_account VALUES("7","3","8","0");
INSERT INTO transaction_type_account VALUES("8","9","2","0");
INSERT INTO transaction_type_account VALUES("24","12","25","0");



DROP TABLE transaction_types;

CREATE TABLE `transaction_types` (
  `transaction_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_type_name` varchar(100) NOT NULL,
  `transaction_desc` varchar(100) NOT NULL,
  PRIMARY KEY (`transaction_type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO transaction_types VALUES("1","Shares","");
INSERT INTO transaction_types VALUES("2","Savings","");
INSERT INTO transaction_types VALUES("3","Deposit","");
INSERT INTO transaction_types VALUES("4","Other Receipts","");
INSERT INTO transaction_types VALUES("5","Members Registration","");
INSERT INTO transaction_types VALUES("6","Loan Disbursement","");
INSERT INTO transaction_types VALUES("7","Loan Repayment","");
INSERT INTO transaction_types VALUES("8","Interest Repayment","");
INSERT INTO transaction_types VALUES("9","Principle Repayment","");
INSERT INTO transaction_types VALUES("10","Principle Disbursed","");
INSERT INTO transaction_types VALUES("11","Interest Disbursed","");
INSERT INTO transaction_types VALUES("12","Expenses","");



DROP TABLE unapproved_loan;

CREATE TABLE `unapproved_loan` (
  `unapproved_loan_id` int(10) NOT NULL AUTO_INCREMENT,
  `unapprove_by_id` int(10) NOT NULL,
  `loan_id` int(11) NOT NULL,
  `date_unapproved` date NOT NULL,
  `unapproved_reason` longtext NOT NULL,
  `datetime_unapproved` datetime NOT NULL,
  PRIMARY KEY (`unapproved_loan_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE undisbursed_loan;

CREATE TABLE `undisbursed_loan` (
  `unapproved_loan_id` int(10) NOT NULL AUTO_INCREMENT,
  `unapprove_by_id` int(10) NOT NULL,
  `loan_id` int(11) NOT NULL,
  `trench_id` int(11) NOT NULL,
  `date_unapproved` date NOT NULL,
  `unapproved_reason` longtext NOT NULL,
  `datetime_unapproved` datetime NOT NULL,
  PRIMARY KEY (`unapproved_loan_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO undisbursed_loan VALUES("7","136","55","119","2022-01-20","Term Error","2022-01-20 16:02:56");
INSERT INTO undisbursed_loan VALUES("8","136","55","119","2022-01-20","Repayment Date Error","2022-01-20 16:14:31");
INSERT INTO undisbursed_loan VALUES("9","136","118","120","2022-01-20","term error","2022-01-20 16:28:46");
INSERT INTO undisbursed_loan VALUES("10","100","118","120","2022-01-21","double entered loan","2022-01-21 08:00:58");
INSERT INTO undisbursed_loan VALUES("11","100","962","62079","2023-02-20","Needed rectification","2023-02-20 13:07:28");



DROP TABLE user_group;

CREATE TABLE `user_group` (
  `user_group_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_group_name` varchar(100) NOT NULL,
  `description` varchar(100) NOT NULL,
  `hierachy` int(11) NOT NULL,
  `ug_sort_order` int(11) NOT NULL,
  PRIMARY KEY (`user_group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=latin1;

INSERT INTO user_group VALUES("15","Super Administrator","Main System Administrators","1","1");
INSERT INTO user_group VALUES("57","Credit Officer","","1","6");
INSERT INTO user_group VALUES("69","General Manager","","1","2");
INSERT INTO user_group VALUES("70","Finance Manager","","1","3");
INSERT INTO user_group VALUES("66","ICT Manager","ICT Manager","1","5");
INSERT INTO user_group VALUES("67","Chief Accountant","Fingrow Accountant","1","4");
INSERT INTO user_group VALUES("68","Customer Care","Customer Care","1","8");
INSERT INTO user_group VALUES("71","Accounts Clerk","","1","7");
INSERT INTO user_group VALUES("72","Accounts Clerk 2","","1","9");
INSERT INTO user_group VALUES("73","Loan Officer","","1","2");



DROP TABLE user_group_module;

CREATE TABLE `user_group_module` (
  `user_group_module_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_group_id` int(10) NOT NULL,
  `module_id` int(10) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`user_group_module_id`)
) ENGINE=MyISAM AUTO_INCREMENT=330 DEFAULT CHARSET=latin1;

INSERT INTO user_group_module VALUES("72","21","8","0");
INSERT INTO user_group_module VALUES("74","21","13","0");
INSERT INTO user_group_module VALUES("71","21","7","0");
INSERT INTO user_group_module VALUES("69","21","5","0");
INSERT INTO user_group_module VALUES("65","20","3","0");
INSERT INTO user_group_module VALUES("73","21","9","0");
INSERT INTO user_group_module VALUES("9","1","10","0");
INSERT INTO user_group_module VALUES("68","21","4","0");
INSERT INTO user_group_module VALUES("67","21","3","0");
INSERT INTO user_group_module VALUES("12","2","10","0");
INSERT INTO user_group_module VALUES("64","14","3","0");
INSERT INTO user_group_module VALUES("14","13","10","0");
INSERT INTO user_group_module VALUES("63","13","3","0");
INSERT INTO user_group_module VALUES("26","14","10","0");
INSERT INTO user_group_module VALUES("124","15","1","0");
INSERT INTO user_group_module VALUES("115","15","3","0");
INSERT INTO user_group_module VALUES("19","15","4","0");
INSERT INTO user_group_module VALUES("25","15","10","0");
INSERT INTO user_group_module VALUES("70","21","6","0");
INSERT INTO user_group_module VALUES("62","22","3","0");
INSERT INTO user_group_module VALUES("37","20","1","0");
INSERT INTO user_group_module VALUES("38","20","7","0");
INSERT INTO user_group_module VALUES("39","20","8","0");
INSERT INTO user_group_module VALUES("61","1","1","0");
INSERT INTO user_group_module VALUES("60","22","13","0");
INSERT INTO user_group_module VALUES("59","22","4","0");
INSERT INTO user_group_module VALUES("58","22","1","0");
INSERT INTO user_group_module VALUES("66","21","1","0");
INSERT INTO user_group_module VALUES("56","14","6","0");
INSERT INTO user_group_module VALUES("55","14","1","0");
INSERT INTO user_group_module VALUES("54","13","5","0");
INSERT INTO user_group_module VALUES("53","13","1","0");
INSERT INTO user_group_module VALUES("52","1","7","0");
INSERT INTO user_group_module VALUES("51","1","6","0");
INSERT INTO user_group_module VALUES("75","2","11","0");
INSERT INTO user_group_module VALUES("76","20","14","0");
INSERT INTO user_group_module VALUES("78","24","5","0");
INSERT INTO user_group_module VALUES("122","39","6","0");
INSERT INTO user_group_module VALUES("121","39","4","0");
INSERT INTO user_group_module VALUES("105","35","3","0");
INSERT INTO user_group_module VALUES("83","30","1","0");
INSERT INTO user_group_module VALUES("84","30","6","0");
INSERT INTO user_group_module VALUES("85","33","1","0");
INSERT INTO user_group_module VALUES("86","33","17","0");
INSERT INTO user_group_module VALUES("87","33","18","0");
INSERT INTO user_group_module VALUES("88","24","1","0");
INSERT INTO user_group_module VALUES("89","24","6","0");
INSERT INTO user_group_module VALUES("90","24","17","0");
INSERT INTO user_group_module VALUES("91","24","18","0");
INSERT INTO user_group_module VALUES("92","30","3","0");
INSERT INTO user_group_module VALUES("93","30","17","0");
INSERT INTO user_group_module VALUES("104","35","1","0");
INSERT INTO user_group_module VALUES("120","39","3","0");
INSERT INTO user_group_module VALUES("107","36","1","0");
INSERT INTO user_group_module VALUES("97","34","1","0");
INSERT INTO user_group_module VALUES("98","34","3","0");
INSERT INTO user_group_module VALUES("99","34","6","0");
INSERT INTO user_group_module VALUES("100","34","11","0");
INSERT INTO user_group_module VALUES("101","34","14","0");
INSERT INTO user_group_module VALUES("102","34","16","0");
INSERT INTO user_group_module VALUES("103","34","17","0");
INSERT INTO user_group_module VALUES("108","36","6","0");
INSERT INTO user_group_module VALUES("110","37","1","0");
INSERT INTO user_group_module VALUES("118","38","6","0");
INSERT INTO user_group_module VALUES("112","37","6","0");
INSERT INTO user_group_module VALUES("117","38","1","0");
INSERT INTO user_group_module VALUES("119","39","1","0");
INSERT INTO user_group_module VALUES("125","15","13","0");
INSERT INTO user_group_module VALUES("126","45","1","0");
INSERT INTO user_group_module VALUES("127","45","4","0");
INSERT INTO user_group_module VALUES("128","44","1","0");
INSERT INTO user_group_module VALUES("134","48","1","0");
INSERT INTO user_group_module VALUES("130","45","6","0");
INSERT INTO user_group_module VALUES("131","44","6","0");
INSERT INTO user_group_module VALUES("132","47","1","0");
INSERT INTO user_group_module VALUES("133","47","6","0");
INSERT INTO user_group_module VALUES("135","48","3","0");
INSERT INTO user_group_module VALUES("136","48","6","0");
INSERT INTO user_group_module VALUES("137","0","1","0");
INSERT INTO user_group_module VALUES("138","0","3","0");
INSERT INTO user_group_module VALUES("139","0","6","0");
INSERT INTO user_group_module VALUES("140","49","6","0");
INSERT INTO user_group_module VALUES("141","54","6","0");
INSERT INTO user_group_module VALUES("142","54","1","0");
INSERT INTO user_group_module VALUES("149","15","25","0");
INSERT INTO user_group_module VALUES("150","55","1","0");
INSERT INTO user_group_module VALUES("151","55","25","0");
INSERT INTO user_group_module VALUES("153","55","6","0");
INSERT INTO user_group_module VALUES("154","55","26","0");
INSERT INTO user_group_module VALUES("155","56","1","0");
INSERT INTO user_group_module VALUES("156","56","3","0");
INSERT INTO user_group_module VALUES("157","56","4","0");
INSERT INTO user_group_module VALUES("158","56","6","0");
INSERT INTO user_group_module VALUES("160","55","3","0");
INSERT INTO user_group_module VALUES("162","0","28","0");
INSERT INTO user_group_module VALUES("166","57","1","0");
INSERT INTO user_group_module VALUES("197","57","31","0");
INSERT INTO user_group_module VALUES("168","58","1","0");
INSERT INTO user_group_module VALUES("198","58","31","0");
INSERT INTO user_group_module VALUES("170","59","1","0");
INSERT INTO user_group_module VALUES("185","59","33","0");
INSERT INTO user_group_module VALUES("172","15","23","0");
INSERT INTO user_group_module VALUES("173","15","30","0");
INSERT INTO user_group_module VALUES("174","15","31","0");
INSERT INTO user_group_module VALUES("175","15","32","0");
INSERT INTO user_group_module VALUES("176","15","33","0");
INSERT INTO user_group_module VALUES("177","15","34","0");
INSERT INTO user_group_module VALUES("178","15","35","0");
INSERT INTO user_group_module VALUES("179","60","1","0");
INSERT INTO user_group_module VALUES("180","60","3","0");
INSERT INTO user_group_module VALUES("181","60","25","0");
INSERT INTO user_group_module VALUES("182","60","31","0");
INSERT INTO user_group_module VALUES("183","60","32","0");
INSERT INTO user_group_module VALUES("186","59","35","0");
INSERT INTO user_group_module VALUES("200","59","28","0");
INSERT INTO user_group_module VALUES("188","61","1","0");
INSERT INTO user_group_module VALUES("189","61","3","0");
INSERT INTO user_group_module VALUES("194","61","23","0");
INSERT INTO user_group_module VALUES("191","61","31","0");
INSERT INTO user_group_module VALUES("192","61","32","0");
INSERT INTO user_group_module VALUES("195","15","28","0");
INSERT INTO user_group_module VALUES("196","62","3","0");
INSERT INTO user_group_module VALUES("199","58","32","0");
INSERT INTO user_group_module VALUES("201","57","3","0");
INSERT INTO user_group_module VALUES("202","58","3","0");
INSERT INTO user_group_module VALUES("203","59","3","0");
INSERT INTO user_group_module VALUES("204","63","1","0");
INSERT INTO user_group_module VALUES("205","63","32","0");
INSERT INTO user_group_module VALUES("206","63","33","0");
INSERT INTO user_group_module VALUES("208","15","36","0");
INSERT INTO user_group_module VALUES("248","0","37","0");
INSERT INTO user_group_module VALUES("250","15","37","0");
INSERT INTO user_group_module VALUES("211","59","36","0");
INSERT INTO user_group_module VALUES("212","64","1","0");
INSERT INTO user_group_module VALUES("213","64","3","0");
INSERT INTO user_group_module VALUES("214","64","31","0");
INSERT INTO user_group_module VALUES("215","64","25","0");
INSERT INTO user_group_module VALUES("216","63","25","0");
INSERT INTO user_group_module VALUES("217","58","23","0");
INSERT INTO user_group_module VALUES("218","58","33","0");
INSERT INTO user_group_module VALUES("219","58","34","0");
INSERT INTO user_group_module VALUES("220","57","23","0");
INSERT INTO user_group_module VALUES("271","68","3","0");
INSERT INTO user_group_module VALUES("222","57","33","0");
INSERT INTO user_group_module VALUES("270","68","1","0");
INSERT INTO user_group_module VALUES("224","59","31","0");
INSERT INTO user_group_module VALUES("225","59","32","0");
INSERT INTO user_group_module VALUES("226","59","34","0");
INSERT INTO user_group_module VALUES("227","65","1","0");
INSERT INTO user_group_module VALUES("228","65","3","0");
INSERT INTO user_group_module VALUES("229","65","6","0");
INSERT INTO user_group_module VALUES("230","65","23","0");
INSERT INTO user_group_module VALUES("231","65","25","0");
INSERT INTO user_group_module VALUES("232","65","26","0");
INSERT INTO user_group_module VALUES("233","65","28","0");
INSERT INTO user_group_module VALUES("234","65","30","0");
INSERT INTO user_group_module VALUES("235","65","31","0");
INSERT INTO user_group_module VALUES("236","65","32","0");
INSERT INTO user_group_module VALUES("237","65","33","0");
INSERT INTO user_group_module VALUES("238","65","34","0");
INSERT INTO user_group_module VALUES("239","65","35","0");
INSERT INTO user_group_module VALUES("240","65","36","0");
INSERT INTO user_group_module VALUES("241","65","37","0");
INSERT INTO user_group_module VALUES("249","61","26","0");
INSERT INTO user_group_module VALUES("243","59","23","0");
INSERT INTO user_group_module VALUES("244","15","38","0");
INSERT INTO user_group_module VALUES("245","59","38","0");
INSERT INTO user_group_module VALUES("247","59","26","0");
INSERT INTO user_group_module VALUES("251","69","1","0");
INSERT INTO user_group_module VALUES("252","69","23","0");
INSERT INTO user_group_module VALUES("253","69","31","0");
INSERT INTO user_group_module VALUES("254","69","32","0");
INSERT INTO user_group_module VALUES("255","15","40","0");
INSERT INTO user_group_module VALUES("256","67","1","0");
INSERT INTO user_group_module VALUES("257","67","3","0");
INSERT INTO user_group_module VALUES("258","67","23","0");
INSERT INTO user_group_module VALUES("259","67","26","0");
INSERT INTO user_group_module VALUES("260","67","28","0");
INSERT INTO user_group_module VALUES("322","69","36","0");
INSERT INTO user_group_module VALUES("262","67","34","0");
INSERT INTO user_group_module VALUES("263","67","36","0");
INSERT INTO user_group_module VALUES("264","67","40","0");
INSERT INTO user_group_module VALUES("265","67","38","0");
INSERT INTO user_group_module VALUES("266","66","1","0");
INSERT INTO user_group_module VALUES("267","66","4","0");
INSERT INTO user_group_module VALUES("268","66","13","0");
INSERT INTO user_group_module VALUES("295","66","23","0");
INSERT INTO user_group_module VALUES("272","68","23","0");
INSERT INTO user_group_module VALUES("273","68","31","0");
INSERT INTO user_group_module VALUES("274","70","1","0");
INSERT INTO user_group_module VALUES("275","70","3","0");
INSERT INTO user_group_module VALUES("276","70","23","0");
INSERT INTO user_group_module VALUES("277","70","25","0");
INSERT INTO user_group_module VALUES("278","70","28","0");
INSERT INTO user_group_module VALUES("279","70","33","0");
INSERT INTO user_group_module VALUES("280","70","34","0");
INSERT INTO user_group_module VALUES("281","70","35","0");
INSERT INTO user_group_module VALUES("282","70","36","0");
INSERT INTO user_group_module VALUES("283","70","38","0");
INSERT INTO user_group_module VALUES("284","70","39","0");
INSERT INTO user_group_module VALUES("285","70","31","0");
INSERT INTO user_group_module VALUES("286","71","1","0");
INSERT INTO user_group_module VALUES("287","71","23","0");
INSERT INTO user_group_module VALUES("288","71","26","0");
INSERT INTO user_group_module VALUES("289","71","33","0");
INSERT INTO user_group_module VALUES("290","68","26","0");
INSERT INTO user_group_module VALUES("292","70","41","0");
INSERT INTO user_group_module VALUES("293","67","41","0");
INSERT INTO user_group_module VALUES("294","70","32","0");
INSERT INTO user_group_module VALUES("296","72","1","0");
INSERT INTO user_group_module VALUES("297","72","23","0");
INSERT INTO user_group_module VALUES("298","72","26","0");
INSERT INTO user_group_module VALUES("299","72","40","0");
INSERT INTO user_group_module VALUES("300","72","38","0");
INSERT INTO user_group_module VALUES("301","72","41","0");
INSERT INTO user_group_module VALUES("302","72","34","0");
INSERT INTO user_group_module VALUES("303","72","36","0");
INSERT INTO user_group_module VALUES("304","69","28","0");
INSERT INTO user_group_module VALUES("305","72","28","0");
INSERT INTO user_group_module VALUES("306","70","26","0");
INSERT INTO user_group_module VALUES("321","69","34","0");
INSERT INTO user_group_module VALUES("308","67","13","0");
INSERT INTO user_group_module VALUES("320","69","33","0");
INSERT INTO user_group_module VALUES("315","69","3","0");
INSERT INTO user_group_module VALUES("319","69","30","0");
INSERT INTO user_group_module VALUES("318","69","26","0");
INSERT INTO user_group_module VALUES("317","69","25","0");
INSERT INTO user_group_module VALUES("316","69","13","0");
INSERT INTO user_group_module VALUES("323","69","38","0");
INSERT INTO user_group_module VALUES("324","69","41","0");
INSERT INTO user_group_module VALUES("325","67","33","0");
INSERT INTO user_group_module VALUES("326","70","4","0");
INSERT INTO user_group_module VALUES("327","67","4","0");
INSERT INTO user_group_module VALUES("328","68","36","0");
INSERT INTO user_group_module VALUES("329","68","34","0");



DROP TABLE user_group_submodule;

CREATE TABLE `user_group_submodule` (
  `user_group_sub_module_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_group_id` int(10) NOT NULL,
  `sub_module_id` int(10) NOT NULL,
  `status` int(1) NOT NULL,
  `add` varchar(1) NOT NULL,
  `view` varchar(1) NOT NULL,
  `edit` varchar(1) NOT NULL,
  `delete` varchar(1) NOT NULL,
  PRIMARY KEY (`user_group_sub_module_id`),
  KEY `sub_module_id` (`sub_module_id`),
  KEY `user_group_id` (`user_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14644 DEFAULT CHARSET=latin1;

INSERT INTO user_group_submodule VALUES("436","48","5","0","A","V","","");
INSERT INTO user_group_submodule VALUES("437","48","62","0","A","V","","");
INSERT INTO user_group_submodule VALUES("438","48","10","0","A","V","","");
INSERT INTO user_group_submodule VALUES("439","48","79","0","A","V","","");
INSERT INTO user_group_submodule VALUES("440","48","87","0","A","V","","");
INSERT INTO user_group_submodule VALUES("441","49","62","0","A","V","","");
INSERT INTO user_group_submodule VALUES("442","53","10","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("443","53","79","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("444","53","87","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("727","54","62","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("728","54","93","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("729","54","91","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("730","54","87","0","A","V","","");
INSERT INTO user_group_submodule VALUES("1021","56","93","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1022","56","5","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1023","56","107","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1024","56","79","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1025","56","62","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1026","56","87","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1027","56","109","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1028","55","93","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1029","55","112","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1030","55","105","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1031","55","5","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1032","55","107","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1033","55","79","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("1034","55","87","0","A","V","","");
INSERT INTO user_group_submodule VALUES("1035","55","109","0","A","V","","");
INSERT INTO user_group_submodule VALUES("2623","58","112","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("2624","58","113","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("2625","58","86","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2626","58","134","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2627","58","79","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2628","58","153","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2680","60","112","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("2681","60","113","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("2682","60","79","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2683","60","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2684","60","153","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2685","60","154","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2686","60","111","0","A","V","","");
INSERT INTO user_group_submodule VALUES("2687","60","146","0","A","V","","");
INSERT INTO user_group_submodule VALUES("2898","64","112","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("2899","64","79","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("2900","64","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2901","64","153","0","A","V","","");
INSERT INTO user_group_submodule VALUES("2902","64","111","0","A","V","","");
INSERT INTO user_group_submodule VALUES("2903","63","113","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("2904","63","114","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("2905","63","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("2906","63","153","0","A","V","","");
INSERT INTO user_group_submodule VALUES("2907","63","111","0","","","","");
INSERT INTO user_group_submodule VALUES("3280","65","135","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3281","65","112","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3282","65","113","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3283","65","125","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3284","65","39","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3285","65","122","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3286","65","137","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3287","65","92","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3288","65","119","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3289","65","134","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3290","65","136","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3291","65","79","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3292","65","129","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3293","65","108","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3294","65","114","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3295","65","126","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3296","65","145","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3297","65","144","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3298","65","93","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3299","65","120","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3300","65","140","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3301","65","95","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3302","65","142","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3303","65","153","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3304","65","123","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3305","65","154","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3306","65","151","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3307","65","139","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3308","65","111","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3309","65","148","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3310","65","150","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3311","65","116","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3312","65","5","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3313","65","62","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3314","65","115","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3315","65","147","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3316","65","160","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3317","65","84","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3318","65","155","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3319","65","128","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3320","65","121","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3321","65","157","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3322","65","146","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3323","65","156","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3324","65","109","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3325","65","158","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3326","65","100","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3327","65","152","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3328","65","149","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3329","65","159","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3330","65","131","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("3331","65","141","0","","V","","");
INSERT INTO user_group_submodule VALUES("4962","61","112","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("4963","61","113","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("4964","61","125","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("4965","61","39","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("4966","61","122","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("4967","61","137","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("4968","61","92","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("4969","61","161","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("4970","61","134","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("4971","61","136","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("4972","61","79","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("4973","61","108","0","","V","E","");
INSERT INTO user_group_submodule VALUES("4974","61","114","0","","V","E","");
INSERT INTO user_group_submodule VALUES("4975","61","126","0","","V","","");
INSERT INTO user_group_submodule VALUES("4976","61","145","0","","V","","");
INSERT INTO user_group_submodule VALUES("4977","61","144","0","","V","","");
INSERT INTO user_group_submodule VALUES("4978","61","93","0","","V","","");
INSERT INTO user_group_submodule VALUES("4979","61","162","0","","V","","");
INSERT INTO user_group_submodule VALUES("4980","61","120","0","","V","","");
INSERT INTO user_group_submodule VALUES("4981","61","140","0","","V","","");
INSERT INTO user_group_submodule VALUES("4982","61","95","0","","V","","");
INSERT INTO user_group_submodule VALUES("4983","61","142","0","","V","","");
INSERT INTO user_group_submodule VALUES("4984","61","153","0","","V","","");
INSERT INTO user_group_submodule VALUES("4985","61","123","0","","V","","");
INSERT INTO user_group_submodule VALUES("4986","61","154","0","","V","","");
INSERT INTO user_group_submodule VALUES("4987","61","151","0","","V","","");
INSERT INTO user_group_submodule VALUES("4988","61","139","0","","V","","");
INSERT INTO user_group_submodule VALUES("4989","61","111","0","","V","","");
INSERT INTO user_group_submodule VALUES("4990","61","148","0","","V","","");
INSERT INTO user_group_submodule VALUES("4991","61","150","0","","V","","");
INSERT INTO user_group_submodule VALUES("4992","61","116","0","","V","","");
INSERT INTO user_group_submodule VALUES("4993","61","156","0","","V","","");
INSERT INTO user_group_submodule VALUES("4994","61","109","0","","V","","");
INSERT INTO user_group_submodule VALUES("4995","61","176","0","","V","","");
INSERT INTO user_group_submodule VALUES("5068","59","113","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5069","59","122","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5070","59","119","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5071","59","171","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5072","59","161","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5073","59","134","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5074","59","79","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5075","59","114","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5076","59","126","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5077","59","145","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5078","59","93","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5079","59","162","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5080","59","168","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("5081","59","120","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5082","59","140","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5083","59","95","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5084","59","153","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5085","59","139","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5086","59","148","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5087","59","116","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5088","59","147","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5089","59","160","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5090","59","167","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5091","59","128","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5092","59","121","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5093","59","165","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5094","59","170","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5095","59","157","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5096","59","146","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5097","59","156","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5098","59","163","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5099","59","109","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5100","59","176","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5101","59","158","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5102","59","166","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5103","59","152","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5104","59","149","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5105","59","159","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5106","59","131","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5107","59","172","0","","V","","");
INSERT INTO user_group_submodule VALUES("5965","71","114","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5966","71","126","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5967","71","145","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5968","71","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5969","71","140","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5970","71","95","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5971","71","154","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5972","71","151","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5973","71","139","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5974","71","147","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5975","71","109","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("5976","71","176","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6059","66","86","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6060","66","126","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6061","66","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6062","66","140","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6063","66","95","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6064","66","154","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6065","66","139","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6066","66","116","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6067","66","5","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6068","66","128","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6069","66","164","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6070","66","10","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6071","66","172","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6072","57","112","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6073","57","134","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6074","57","79","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6075","57","126","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6076","57","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("6077","57","162","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6078","57","140","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6079","57","95","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6080","57","142","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6081","57","153","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6082","57","123","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6083","57","154","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6084","57","151","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6085","57","139","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6086","57","116","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6087","57","169","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6088","57","5","0","A","V","","");
INSERT INTO user_group_submodule VALUES("6089","57","128","0","A","V","","");
INSERT INTO user_group_submodule VALUES("10422","72","122","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10423","72","178","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10424","72","179","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10425","72","171","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10426","72","186","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10427","72","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10428","72","140","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10429","72","95","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10430","72","153","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10431","72","139","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10432","72","116","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10433","72","160","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10434","72","187","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10435","72","128","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10436","72","121","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10437","72","157","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10438","72","109","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10439","72","176","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10440","72","158","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10441","72","152","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10442","72","159","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10443","72","131","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10444","72","177","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("10445","72","172","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11664","70","135","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11665","70","112","0","","V","","");
INSERT INTO user_group_submodule VALUES("11666","70","174","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11667","70","175","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11668","70","113","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11669","70","192","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11670","70","173","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11671","70","190","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11672","70","183","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11673","70","86","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11674","70","122","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11675","70","178","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11676","70","179","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11677","70","137","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11678","70","119","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11679","70","171","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11680","70","161","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11681","70","134","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11682","70","79","0","","V","","");
INSERT INTO user_group_submodule VALUES("11683","70","114","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11684","70","126","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11685","70","145","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11686","70","144","0","","V","","");
INSERT INTO user_group_submodule VALUES("11687","70","186","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11688","70","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11689","70","162","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11690","70","168","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11691","70","120","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11692","70","140","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11693","70","95","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11694","70","153","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11695","70","139","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11696","70","111","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11697","70","150","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11698","70","116","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11699","70","169","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11700","70","147","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11701","70","160","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11702","70","84","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11703","70","167","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11704","70","187","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11705","70","128","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11706","70","121","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11707","70","165","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11708","70","170","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11709","70","157","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11710","70","163","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11711","70","109","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11712","70","176","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11713","70","158","0","A","V","","");
INSERT INTO user_group_submodule VALUES("11714","70","185","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11715","70","166","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11716","70","195","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11717","70","188","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11718","70","152","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11719","70","181","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11720","70","194","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11721","70","193","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11722","70","159","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11723","70","149","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11724","70","131","0","","V","","");
INSERT INTO user_group_submodule VALUES("11725","70","172","0","","V","","");
INSERT INTO user_group_submodule VALUES("11726","70","184","0","A","V","","");
INSERT INTO user_group_submodule VALUES("11727","69","112","0","","V","","");
INSERT INTO user_group_submodule VALUES("11728","69","113","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11729","69","86","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11730","69","122","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11731","69","179","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11732","69","137","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11733","69","134","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11734","69","79","0","","V","","");
INSERT INTO user_group_submodule VALUES("11735","69","114","0","","V","","");
INSERT INTO user_group_submodule VALUES("11736","69","144","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11737","69","186","0","","V","","");
INSERT INTO user_group_submodule VALUES("11738","69","162","0","A","V","","");
INSERT INTO user_group_submodule VALUES("11739","69","140","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11740","69","95","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11741","69","153","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11742","69","123","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11743","69","139","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11744","69","111","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11745","69","148","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11746","69","150","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11747","69","116","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11748","69","169","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11749","69","5","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11750","69","160","0","","V","","");
INSERT INTO user_group_submodule VALUES("11751","69","167","0","","V","","");
INSERT INTO user_group_submodule VALUES("11752","69","187","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11753","69","128","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11754","69","121","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11755","69","165","0","","V","","");
INSERT INTO user_group_submodule VALUES("11756","69","170","0","","V","","");
INSERT INTO user_group_submodule VALUES("11757","69","157","0","","V","","");
INSERT INTO user_group_submodule VALUES("11758","69","109","0","","V","","");
INSERT INTO user_group_submodule VALUES("11759","69","176","0","","V","","");
INSERT INTO user_group_submodule VALUES("11760","69","158","0","","V","","");
INSERT INTO user_group_submodule VALUES("11761","69","180","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11762","69","152","0","","V","","");
INSERT INTO user_group_submodule VALUES("11763","69","194","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11764","69","193","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11765","69","159","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11766","69","131","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11767","69","172","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11768","69","189","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11769","69","182","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11842","67","135","0","","V","","");
INSERT INTO user_group_submodule VALUES("11843","67","112","0","","V","","");
INSERT INTO user_group_submodule VALUES("11844","67","174","0","","V","","");
INSERT INTO user_group_submodule VALUES("11845","67","175","0","","V","","");
INSERT INTO user_group_submodule VALUES("11846","67","113","0","","V","","");
INSERT INTO user_group_submodule VALUES("11847","67","173","0","","V","","");
INSERT INTO user_group_submodule VALUES("11848","67","183","0","","V","","");
INSERT INTO user_group_submodule VALUES("11849","67","39","0","","V","","");
INSERT INTO user_group_submodule VALUES("11850","67","86","0","","V","","");
INSERT INTO user_group_submodule VALUES("11851","67","122","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11852","67","178","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11853","67","179","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11854","67","137","0","","","","");
INSERT INTO user_group_submodule VALUES("11855","67","119","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11856","67","171","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11857","67","161","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11858","67","134","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11859","67","79","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11860","67","114","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11861","67","126","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11862","67","186","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11863","67","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11864","67","162","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11865","67","168","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11866","67","120","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11867","67","140","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11868","67","95","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11869","67","142","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11870","67","153","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11871","67","123","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11872","67","151","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11873","67","139","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11874","67","111","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11875","67","191","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11876","67","148","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11877","67","150","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11878","67","116","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11879","67","169","0","","","","");
INSERT INTO user_group_submodule VALUES("11880","67","160","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11881","67","84","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11882","67","167","0","","V","","");
INSERT INTO user_group_submodule VALUES("11883","67","155","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11884","67","187","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11885","67","128","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11886","67","121","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11887","67","165","0","","V","","");
INSERT INTO user_group_submodule VALUES("11888","67","170","0","","V","","");
INSERT INTO user_group_submodule VALUES("11889","67","157","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11890","67","146","0","","V","","");
INSERT INTO user_group_submodule VALUES("11891","67","156","0","","V","","");
INSERT INTO user_group_submodule VALUES("11892","67","163","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11893","67","109","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11894","67","176","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11895","67","158","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11896","67","180","0","A","V","","");
INSERT INTO user_group_submodule VALUES("11897","67","185","0","","","","");
INSERT INTO user_group_submodule VALUES("11898","67","166","0","","V","","");
INSERT INTO user_group_submodule VALUES("11899","67","152","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11900","67","194","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11901","67","193","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11902","67","159","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11903","67","149","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11904","67","164","0","","V","","");
INSERT INTO user_group_submodule VALUES("11905","67","131","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11906","67","141","0","","V","","");
INSERT INTO user_group_submodule VALUES("11907","67","7","0","","V","","");
INSERT INTO user_group_submodule VALUES("11908","67","10","0","","V","","");
INSERT INTO user_group_submodule VALUES("11909","67","177","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11910","67","172","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11911","67","189","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11912","67","184","0","","V","","");
INSERT INTO user_group_submodule VALUES("11913","67","182","0","","V","","");
INSERT INTO user_group_submodule VALUES("11930","68","112","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11931","68","134","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11932","68","79","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11933","68","126","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11934","68","186","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11935","68","93","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11936","68","140","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11937","68","95","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11938","68","153","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11939","68","139","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11940","68","116","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11941","68","160","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11942","68","128","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11943","68","157","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11944","68","109","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11945","68","176","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11946","68","158","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("11947","68","152","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("14572","15","112","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14573","15","174","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14574","15","175","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14575","15","113","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14576","15","173","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14577","15","39","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14578","15","86","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14579","15","178","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14580","15","179","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14581","15","203","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14582","15","137","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14583","15","207","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14584","15","92","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14585","15","119","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14586","15","208","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14587","15","196","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14588","15","200","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14589","15","114","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14590","15","126","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14591","15","145","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14592","15","186","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14593","15","205","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14594","15","204","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14595","15","199","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14596","15","93","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14597","15","198","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14598","15","121","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14599","15","120","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14600","15","140","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14601","15","95","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14602","15","123","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14603","15","209","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14604","15","139","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14605","15","111","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14606","15","148","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14607","15","150","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14608","15","116","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14609","15","136","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14610","15","134","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14611","15","5","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14612","15","79","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14613","15","62","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14614","15","115","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14615","15","8","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14616","15","9","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14617","15","147","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14618","15","160","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14619","15","84","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14620","15","155","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14621","15","128","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14622","15","157","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14623","15","146","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14624","15","156","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14625","15","109","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14626","15","176","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14627","15","158","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14628","15","185","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14629","15","166","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14630","15","195","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14631","15","188","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14632","15","100","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14633","15","152","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14634","15","122","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14635","15","181","0","A","V","E","");
INSERT INTO user_group_submodule VALUES("14636","15","164","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14637","15","132","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14638","15","131","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14639","15","201","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14640","15","141","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14641","15","7","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14642","15","10","0","A","V","E","D");
INSERT INTO user_group_submodule VALUES("14643","15","177","0","A","V","E","D");



DROP TABLE users;

CREATE TABLE `users` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `salary` varchar(10) NOT NULL,
  `f_name` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `id_no` varchar(50) NOT NULL,
  `adm_date` date NOT NULL,
  `gender` varchar(10) NOT NULL,
  `user_group_id` int(10) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `islogged_in` int(1) NOT NULL DEFAULT '1',
  `report_to_user_group_id` int(11) NOT NULL,
  `report_to_hierachy` int(11) NOT NULL,
  `allow_delete` int(11) NOT NULL,
  `suspend` int(11) NOT NULL,
  `area_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=149 DEFAULT CHARSET=latin1;

INSERT INTO users VALUES("100","","Griffins Osero","9888","updateosero@gmail.com","","0000-00-00","","15","sacco","acfa646c41e5611cefe7c59132e0022b","2016-11-04 05:48:59","0","0","0","0","1","0");
INSERT INTO users VALUES("138","","Julius Kingori","","","","0000-00-00","","57","julius.kingori","3c09128b5648bbb3973474938936347c","2021-12-08 11:00:50","0","0","0","0","1","0");
INSERT INTO users VALUES("137","","Carol Anyango","","","","0000-00-00","","73","carol.anyango","bb1505e502c4e92b0acce0a08492ec8a","2021-12-08 10:53:23","0","0","0","0","1","0");
INSERT INTO users VALUES("136","","Charles Mosonik","","","","0000-00-00","","73","charles.mosonik","9de51117942800b7668026595ccdcb97","2021-12-08 10:46:01","0","0","0","0","1","0");
INSERT INTO users VALUES("135","","Stella Nkonge","","","","0000-00-00","","63","stella.nkonge","89cedf145bdbd45c67a923a379bc8f2c","2021-12-08 10:34:07","0","0","0","0","0","0");
INSERT INTO users VALUES("134","","Thomas Atak","0734260109","","","0000-00-00","","66","thomas.atak","dab053d1f76bd1e2dbff6900e46c88e6","2021-12-08 10:18:20","0","0","0","0","0","0");
INSERT INTO users VALUES("139","","Sharon Oduor","","","","0000-00-00","","68","sharon.oduor","d86102fec3b156d7a0809aaa5d839177","2021-12-08 11:05:10","0","0","0","0","1","0");
INSERT INTO users VALUES("140","","Boaz Nyangori","","generalmanager@fingrowcapital.co.ke","","0000-00-00","","65","boaz.nyangori","f2e285ac43c9b17724ac3347f9439d1f","2022-01-19 05:53:52","0","0","0","0","0","0");
INSERT INTO users VALUES("144","","Michael Gichohi","0725727158","mgichohi@kajinaholdings.co.ke","","0000-00-00","","15","michael.gichohi","ccfa21c532875e84d3c8df182d90c156","2022-07-22 09:12:31","0","0","0","0","1","0");
INSERT INTO users VALUES("142","","Charles Osano","0746351601","osanocharles9@gmail.com","","0000-00-00","","73","charles.osano","11dbed8e8666d9c96381aab8d35f6fdc","2022-02-10 09:02:40","0","0","0","0","0","0");
INSERT INTO users VALUES("143","","Paul Nyaguti","254726965339","","","0000-00-00","","69","paul","03f993dc53f351ab5bab5957d6fa7d41","2022-06-04 05:55:46","0","0","0","0","0","0");
INSERT INTO users VALUES("145","","Eric Lango","0723395112","elango@fingrowcapital.co.ke","","0000-00-00","","73","Eric Lango","06aeb3ad3046914d6851dac79425d0f1","2022-08-18 14:48:07","0","0","0","0","1","0");
INSERT INTO users VALUES("146","","Anjela Vusha","0741829343","","","0000-00-00","","73","Anjela.Vusha","0ff499519e78b8945ceaa86e963634d6","2022-08-30 11:54:17","0","0","0","0","0","0");
INSERT INTO users VALUES("147","","Mercy Odhiambo","0704372556","modhiambo@fingrowcapital.co.ke","","0000-00-00","","57","Mercy.Odhiambo","7de3595a8716c0acfbde99f73cdaf9ee","2022-10-01 10:33:38","0","0","0","0","0","0");
INSERT INTO users VALUES("148","","Veridiana Simeon Migosi","0734578667","veridiana@foresight.co.tz","","0000-00-00","","73","veridiana","202cb962ac59075b964b07152d234b70","2024-08-26 15:44:20","0","0","0","0","1","0");



DROP TABLE users_old;

CREATE TABLE `users_old` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `salary` varchar(10) NOT NULL,
  `f_name` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `id_no` varchar(50) NOT NULL,
  `adm_date` date NOT NULL,
  `gender` varchar(10) NOT NULL,
  `user_group_id` int(10) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `islogged_in` int(1) NOT NULL DEFAULT '1',
  `report_to_user_group_id` int(11) NOT NULL,
  `report_to_hierachy` int(11) NOT NULL,
  `allow_delete` int(11) NOT NULL,
  `suspend` int(11) NOT NULL,
  `area_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE users_wrong;

CREATE TABLE `users_wrong` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `salary` varchar(10) NOT NULL,
  `f_name` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `id_no` varchar(50) NOT NULL,
  `adm_date` date NOT NULL,
  `gender` varchar(10) NOT NULL,
  `user_group_id` int(10) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `islogged_in` int(1) NOT NULL DEFAULT '1',
  `report_to_user_group_id` int(11) NOT NULL,
  `report_to_hierachy` int(11) NOT NULL,
  `allow_delete` int(11) NOT NULL,
  `suspend` int(11) NOT NULL,
  `area_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=142 DEFAULT CHARSET=latin1;

INSERT INTO users_wrong VALUES("100","","Griffins Osero","9888","updateosero@gmail.com","","0000-00-00","","15","osero","d97d3a75495b93f3c8ec2e1aea44b31a","2016-11-04 05:48:59","0","0","0","0","1","0");
INSERT INTO users_wrong VALUES("138","","Julius Kingori","","","","0000-00-00","","57","julius.kingori","9e35332e270ac0ec6d7b290a53b1608b","2021-12-08 11:00:50","0","0","0","0","1","0");
INSERT INTO users_wrong VALUES("137","","Carol Anyango","","","","0000-00-00","","59","carol.anyango","bb1505e502c4e92b0acce0a08492ec8a","2021-12-08 10:53:23","0","0","0","0","1","0");
INSERT INTO users_wrong VALUES("136","","Charles Mosonik","","","","0000-00-00","","59","charles.mosonik","9de51117942800b7668026595ccdcb97","2021-12-08 10:46:01","0","0","0","0","1","0");
INSERT INTO users_wrong VALUES("135","","Stella Nkonge","","","","0000-00-00","","63","stella.nkonge","89cedf145bdbd45c67a923a379bc8f2c","2021-12-08 10:34:07","0","0","0","0","0","0");
INSERT INTO users_wrong VALUES("134","","Thomas Atak","0734260109","","","0000-00-00","","15","thomas.atak","dab053d1f76bd1e2dbff6900e46c88e6","2021-12-08 10:18:20","0","0","0","0","1","0");
INSERT INTO users_wrong VALUES("139","","Sharon Oduor","","","","0000-00-00","","61","sharon.oduor","d86102fec3b156d7a0809aaa5d839177","2021-12-08 11:05:10","0","0","0","0","1","0");
INSERT INTO users_wrong VALUES("140","","Boaz Nyangori","","generalmanager@fingrowcapital.co.ke","","0000-00-00","","65","boaz.nyangori","f2e285ac43c9b17724ac3347f9439d1f","2022-01-19 05:53:52","0","0","0","0","1","0");
INSERT INTO users_wrong VALUES("141","","Sheila Achieng","0719657933","","","0000-00-00","","57","sheila.achieng","8bb495466b77d46f74abd5719c131701","2022-01-25 10:18:23","0","0","0","0","1","0");



DROP TABLE vat_option;

CREATE TABLE `vat_option` (
  `vat_option_id` int(11) NOT NULL AUTO_INCREMENT,
  `vat_option_name` varchar(100) NOT NULL,
  `vat_option_desc` varchar(100) NOT NULL,
  PRIMARY KEY (`vat_option_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO vat_option VALUES("1","INCLUSIVE","");
INSERT INTO vat_option VALUES("2","EXCLUSIVE","");
INSERT INTO vat_option VALUES("3","N/A","");



DROP TABLE vat_settings;

CREATE TABLE `vat_settings` (
  `vat_id` int(11) NOT NULL AUTO_INCREMENT,
  `vat_name` varchar(100) NOT NULL,
  `vat_setting_perc` varchar(50) NOT NULL,
  PRIMARY KEY (`vat_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO vat_settings VALUES("1","VAT","16");



DROP TABLE work_plan;

CREATE TABLE `work_plan` (
  `work_plan_id` int(10) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `task_id` int(11) NOT NULL,
  `optimum_score_id` int(11) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `status` int(11) NOT NULL,
  `status1` int(11) NOT NULL,
  `work_order` int(11) NOT NULL,
  `status3` int(11) NOT NULL,
  `date_recorded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`work_plan_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




